/*
 * Decompiled with CFR 0.152.
 */
package org.java.ayatana;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.java.ayatana.AyatanaLibrary;
import org.java.ayatana.DefaultExtraMenuAction;
import org.java.ayatana.ExtraMenuAction;
import org.java.ayatana.GMainLoop;

public final class ApplicationMenu
implements WindowListener,
AWTEventListener,
ContainerListener,
ComponentListener {
    private static boolean initialized = false;
    private JFrame frame;
    private JMenuBar menubar;
    private boolean tryInstalled = false;
    private ExtraMenuAction extraMenuAction;
    private long windowxid = -1L;

    public static boolean tryInstall(JFrame frame) {
        return ApplicationMenu.tryInstall(frame, frame.getJMenuBar(), new DefaultExtraMenuAction());
    }

    public static boolean tryInstall(JFrame frame, JMenuBar menubar) {
        return ApplicationMenu.tryInstall(frame, menubar, new DefaultExtraMenuAction());
    }

    public static boolean tryInstall(JFrame frame, ExtraMenuAction additionalMenuAction) {
        return ApplicationMenu.tryInstall(frame, frame.getJMenuBar(), additionalMenuAction);
    }

    public static boolean tryInstall(JFrame frame, JMenuBar menubar, ExtraMenuAction additionalMenuAction) {
        if (frame == null || menubar == null || additionalMenuAction == null) {
            throw new NullPointerException();
        }
        if (!"libappmenu.so".equals(System.getenv("UBUNTU_MENUPROXY"))) {
            return false;
        }
        if (AyatanaLibrary.load()) {
            new ApplicationMenu(frame, menubar, additionalMenuAction);
            return true;
        }
        return false;
    }

    private static native void nativeInitialize();

    private static native void nativeUninitialize();

    private static void initialize() {
        if (!initialized) {
            GMainLoop.run();
            ApplicationMenu.nativeInitialize();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    ApplicationMenu.nativeUninitialize();
                }
            });
            initialized = true;
        }
    }

    private native void setCurrent(long var1);

    private native long getWindowXID(Window var1);

    private native void registerWatcher(long var1);

    private native void unregisterWatcher(long var1);

    private void addMenu(JMenu menu) {
        if (menu.getText() == null || "".equals(menu.getText())) {
            return;
        }
        this.addMenu(menu.hashCode(), menu.getText(), menu.isEnabled());
    }

    private native void addMenu(int var1, String var2, boolean var3);

    private void removeAllMenus() {
        this.removeAll();
    }

    private native void removeAll();

    private void addMenuItem(JMenuItem menuitem) {
        if (menuitem.getText() == null || "".equals(menuitem.getText())) {
            return;
        }
        int modifiers = -1;
        int keycode = -1;
        if (menuitem.getAccelerator() != null) {
            modifiers = menuitem.getAccelerator().getModifiers();
            keycode = menuitem.getAccelerator().getKeyCode();
        }
        if (menuitem instanceof JMenu) {
            this.addMenu((JMenu)menuitem);
        } else if (menuitem instanceof JRadioButtonMenuItem) {
            this.addMenuItemRadio(menuitem.hashCode(), menuitem.getText(), menuitem.isEnabled(), modifiers, keycode, menuitem.isSelected());
        } else if (menuitem instanceof JCheckBoxMenuItem) {
            this.addMenuItemCheck(menuitem.hashCode(), menuitem.getText(), menuitem.isEnabled(), modifiers, keycode, menuitem.isSelected());
        } else {
            this.addMenuItem(menuitem.hashCode(), menuitem.getText(), menuitem.isEnabled(), modifiers, keycode);
        }
    }

    private native void addMenuItem(int var1, String var2, boolean var3, int var4, int var5);

    private native void addMenuItemRadio(int var1, String var2, boolean var3, int var4, int var5, boolean var6);

    private native void addMenuItemCheck(int var1, String var2, boolean var3, int var4, int var5, boolean var6);

    private void addSeparator() {
        this.addMenuItemSeparator();
    }

    private native void addMenuItemSeparator();

    private ApplicationMenu(JFrame frame, JMenuBar menubar, ExtraMenuAction additionalMenuAction) {
        this.frame = frame;
        this.menubar = menubar;
        this.extraMenuAction = additionalMenuAction;
        frame.addWindowListener(this);
        if (frame.isDisplayable()) {
            this.tryInstall();
        }
    }

    private synchronized void tryInstall() {
        if (this.tryInstalled && this.windowxid > -1L) {
            this.setCurrent(this.windowxid);
        } else if (!this.tryInstalled) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ApplicationMenu.initialize();
                    ApplicationMenu.this.windowxid = ApplicationMenu.this.getWindowXID(ApplicationMenu.this.frame);
                    ApplicationMenu.this.registerWatcher(ApplicationMenu.this.windowxid);
                }
            });
            this.tryInstalled = true;
        }
    }

    private synchronized void tryUninstall() {
        if (this.tryInstalled) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ApplicationMenu.this.unregisterWatcher(ApplicationMenu.this.windowxid);
                    ApplicationMenu.this.frame.removeWindowListener(ApplicationMenu.this);
                }
            });
            this.tryInstalled = false;
        }
    }

    private void buildMenuBar() {
        this.buildMenuBar(false);
    }

    private void buildMenuBar(boolean first) {
        for (Component comp : this.menubar.getComponents()) {
            if (!(comp instanceof JMenu) || !comp.isVisible()) continue;
            this.addMenu((JMenu)comp);
            if (!first) continue;
            ((JMenu)comp).addComponentListener(this);
        }
    }

    private synchronized void install() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        this.buildMenuBar(true);
        this.menubar.setVisible(false);
        this.menubar.addContainerListener(this);
    }

    private synchronized void uninstall() {
        this.menubar.removeContainerListener(this);
        this.menubar.setVisible(true);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
    }

    private JMenuItem getJMenuItem(int hashcode) {
        for (Component comp : this.menubar.getComponents()) {
            JMenuItem item;
            if (!(comp instanceof JMenuItem) || (item = this.getJMenuItem((JMenuItem)comp, hashcode)) == null) continue;
            return item;
        }
        return null;
    }

    private JMenuItem getJMenuItem(JMenuItem menu, int hashcode) {
        if (menu.hashCode() == hashcode) {
            return menu;
        }
        if (menu instanceof JMenu) {
            for (Component comp : ((JMenu)menu).getMenuComponents()) {
                JMenuItem item;
                if (!(comp instanceof JMenuItem) || (item = this.getJMenuItem((JMenuItem)comp, hashcode)) == null) continue;
                return item;
            }
        }
        return null;
    }

    private JMenuItem getJMenuItem(int keycode, int modifiers) {
        for (Component comp : this.menubar.getComponents()) {
            JMenuItem item;
            if (!(comp instanceof JMenuItem) || (item = this.getJMenuItem((JMenuItem)comp, keycode, modifiers)) == null) continue;
            return item;
        }
        return null;
    }

    private JMenuItem getJMenuItem(JMenuItem menu, int keycode, int modifiers) {
        if (menu instanceof JMenu) {
            for (Component comp : ((JMenu)menu).getMenuComponents()) {
                JMenuItem item;
                if (!(comp instanceof JMenuItem) || (item = this.getJMenuItem((JMenuItem)comp, keycode, modifiers)) == null) continue;
                return item;
            }
        } else {
            if (menu.getAccelerator() == null) {
                return null;
            }
            if (menu.getAccelerator().getKeyCode() == keycode && menu.getAccelerator().getModifiers() == modifiers) {
                return menu;
            }
        }
        return null;
    }

    private void itemActivated(int hashcode) {
        this.invokeMenuItem(this.getJMenuItem(hashcode), false);
    }

    private void itemAboutToShow(int hashcode) {
        this.invokeSelectMenu((JMenu)this.getJMenuItem(hashcode));
    }

    private void itemAfterShow(int hashcode) {
        this.invokeDeselectMenu((JMenu)this.getJMenuItem(hashcode));
    }

    private void invokeMenuItem(final JMenuItem menuitem, final boolean shortcut) {
        if (menuitem != null && menuitem.isEnabled() && menuitem.isVisible()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ApplicationMenu.this.extraMenuAction.allowMenuAction(ApplicationMenu.this.frame, ApplicationMenu.this.menubar, menuitem, true, shortcut)) {
                        menuitem.getModel().setArmed(true);
                        menuitem.getModel().setPressed(true);
                        ApplicationMenu.this.extraMenuAction.invokeMenu(ApplicationMenu.this.frame, ApplicationMenu.this.menubar, menuitem, true, shortcut);
                        menuitem.getModel().setPressed(false);
                        menuitem.getModel().setArmed(false);
                    }
                }
            });
        }
    }

    private void invokeSelectMenu(final JMenu menu) {
        if (menu != null && menu.isEnabled() && menu.isVisible()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (ApplicationMenu.this.extraMenuAction.allowMenuAction(ApplicationMenu.this.frame, ApplicationMenu.this.menubar, menu, true, false)) {
                            ApplicationMenu.this.extraMenuAction.beforInvokeMenu(ApplicationMenu.this.frame, ApplicationMenu.this.menubar, menu, true, false);
                            menu.getModel().setSelected(true);
                            JPopupMenu popupMenu = menu.getPopupMenu();
                            PopupMenuEvent pevent = new PopupMenuEvent(popupMenu);
                            for (PopupMenuListener pl : menu.getPopupMenu().getPopupMenuListeners()) {
                                if (pl == null) continue;
                                pl.popupMenuWillBecomeVisible(pevent);
                            }
                            ApplicationMenu.this.extraMenuAction.invokeMenu(ApplicationMenu.this.frame, ApplicationMenu.this.menubar, menu, true, false);
                            for (Component comp : popupMenu.getComponents()) {
                                if (!comp.isVisible()) continue;
                                if (comp instanceof JMenu) {
                                    ApplicationMenu.this.addMenu((JMenu)comp);
                                    continue;
                                }
                                if (comp instanceof JMenuItem) {
                                    ApplicationMenu.this.addMenuItem((JMenuItem)comp);
                                    continue;
                                }
                                if (!(comp instanceof JSeparator)) continue;
                                ApplicationMenu.this.addSeparator();
                            }
                            ApplicationMenu.this.extraMenuAction.afterInvokeMenu(ApplicationMenu.this.frame, ApplicationMenu.this.menubar, menu, true, false);
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void invokeDeselectMenu(final JMenu menu) {
        if (menu != null && menu.isEnabled() && menu.isVisible()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (ApplicationMenu.this.extraMenuAction.allowMenuAction(ApplicationMenu.this.frame, ApplicationMenu.this.menubar, menu, false, false)) {
                            ApplicationMenu.this.extraMenuAction.beforInvokeMenu(ApplicationMenu.this.frame, ApplicationMenu.this.menubar, menu, false, false);
                            ApplicationMenu.this.extraMenuAction.invokeMenu(ApplicationMenu.this.frame, ApplicationMenu.this.menubar, menu, false, false);
                            PopupMenuEvent pevent = new PopupMenuEvent(menu.getPopupMenu());
                            for (PopupMenuListener pl : menu.getPopupMenu().getPopupMenuListeners()) {
                                if (pl == null) continue;
                                pl.popupMenuWillBecomeInvisible(pevent);
                            }
                            menu.getModel().setSelected(false);
                            ApplicationMenu.this.extraMenuAction.afterInvokeMenu(ApplicationMenu.this.frame, ApplicationMenu.this.menubar, menu, false, false);
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void invokeAccelerator(int keycode, int modifiers) {
        this.invokeMenuItem(this.getJMenuItem(keycode, modifiers), true);
    }

    private JFrame getFrame(Component comp) {
        if (comp == null) {
            return null;
        }
        if (comp instanceof JFrame) {
            return (JFrame)comp;
        }
        return this.getFrame(comp.getParent());
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        JFrame currentframe;
        KeyEvent e;
        if (event.getID() == 402 && (e = (KeyEvent)event).getKeyCode() != 18 && e.getKeyCode() != 16 && e.getKeyCode() != 17 && e.getKeyCode() != 157 && e.getKeyCode() != 65406 && this.frame.isActive() && this.frame.equals(currentframe = event.getSource() instanceof Component ? this.getFrame((Component)event.getSource()) : (event.getSource() instanceof JFrame ? (JFrame)event.getSource() : null))) {
            this.invokeAccelerator(e.getKeyCode(), e.getModifiersEx() | e.getModifiers());
        }
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        if (this.extraMenuAction.allowDynamicMenuBar() && e.getChild() instanceof JMenu) {
            ((JMenu)e.getChild()).addComponentListener(this);
            this.removeAllMenus();
            this.buildMenuBar();
        }
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        if (this.extraMenuAction.allowDynamicMenuBar() && e.getChild() instanceof JMenu) {
            ((JMenu)e.getChild()).removeComponentListener(this);
            this.removeAllMenus();
            this.buildMenuBar();
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
        if (this.extraMenuAction.allowDynamicMenuBar() && e.getSource() instanceof JMenu) {
            this.removeAllMenus();
            this.buildMenuBar();
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        if (this.extraMenuAction.allowDynamicMenuBar() && e.getSource() instanceof JMenu) {
            this.removeAllMenus();
            this.buildMenuBar();
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
        this.tryInstall();
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.tryUninstall();
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
        this.tryInstall();
    }
}

