/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import kiyut.sketsa.canvas.CanvasGrid;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.options.CanvasOptions;

public class DefaultCanvasGrid
implements CanvasGrid {
    private VectorCanvas canvas;
    private Paint strokePaint;
    private Stroke stroke;
    private boolean visible = false;

    @Override
    public void paint(Graphics2D g2d) {
        int i;
        Dimension dim = this.canvas.getPreferredSize();
        if (dim == null) {
            return;
        }
        Paint oldPaint = g2d.getPaint();
        Stroke oldStroke = g2d.getStroke();
        CanvasOptions prefs = CanvasOptions.getInstance();
        this.strokePaint = prefs.getGridColor();
        this.stroke = prefs.getGridStroke();
        int gridSize = prefs.getGridSize();
        g2d.setPaint(this.strokePaint);
        g2d.setStroke(this.stroke);
        int startX = gridSize;
        int startY = gridSize;
        int endX = dim.width;
        int endY = dim.height;
        Rectangle clip = g2d.getClipBounds();
        if (clip != null) {
            startX = clip.x / gridSize * gridSize;
            startY = clip.y / gridSize * gridSize;
            endX = clip.x + clip.width;
            endY = clip.y + clip.height;
        }
        for (i = startY; i < endY; i += gridSize) {
            g2d.drawLine(startX, i, endX, i);
        }
        for (i = startX; i < endX; i += gridSize) {
            g2d.drawLine(i, startY, i, endY);
        }
        g2d.setPaint(oldPaint);
        g2d.setStroke(oldStroke);
    }

    @Override
    public void setVectorCanvas(VectorCanvas canvas) {
        this.canvas = canvas;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        this.canvas.repaint();
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public int getGridSize() {
        CanvasOptions prefs = CanvasOptions.getInstance();
        return prefs.getGridSize();
    }
}

