/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import kiyut.sketsa.canvas.CanvasBackground;
import kiyut.sketsa.canvas.CanvasException;
import kiyut.sketsa.canvas.CanvasGrid;
import kiyut.sketsa.canvas.CanvasModel;
import kiyut.sketsa.canvas.CanvasSelection;
import kiyut.sketsa.canvas.CanvasTransferHandler;
import kiyut.sketsa.canvas.DefaultCanvasGrid;
import kiyut.sketsa.canvas.EditorUserAgent;
import kiyut.sketsa.canvas.text.DefaultTextEditor;
import kiyut.sketsa.canvas.text.TextEditor;
import kiyut.sketsa.canvas.tool.TextTool;
import kiyut.sketsa.canvas.tool.Tool;
import kiyut.sketsa.options.CanvasOptions;
import kiyut.sketsa.options.GeneralOptions;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.EmptyTextNodeFilter;
import org.apache.batik.bridge.SVGAnimationEngine;
import org.apache.batik.gvt.renderer.ConcreteImageRendererFactory;
import org.apache.batik.gvt.renderer.ImageRenderer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGGElement;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGTransform;
import org.w3c.dom.svg.SVGTransformList;
import org.w3c.dom.svg.SVGTransformable;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public class VectorCanvas
extends JPanel {
    public static final String TOOL_PROPERTY = "tool";
    public static final String DOCUMENT_PROPERTY = "document";
    protected ImageRenderer renderer;
    protected BufferedImage image;
    protected CanvasModel model;
    protected CanvasSelection canvasSelection;
    protected DefaultCanvasGrid canvasGrid;
    protected CanvasBackground canvasBackground;
    protected TextEditor textEditor;
    protected double zoomFactor = 1.0;
    protected Dimension canvasSize;
    protected Tool tool;
    protected Tool previousTool;
    protected Point dropLocation;
    protected EventListener domListener;
    protected boolean snapToGrid;
    protected DOMUndoManager undoManager;
    protected NodeFilter emptyTextNodeFilter;

    public VectorCanvas() {
        this((TextEditor)null);
    }

    public VectorCanvas(TextEditor textEditor) {
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        MouseHandler mouseHandler = new MouseHandler();
        KeyHandler keyHandler = new KeyHandler();
        FocusHandler focusHandler = new FocusHandler();
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.addKeyListener(keyHandler);
        this.addFocusListener(focusHandler);
        this.model = new CanvasModel(this);
        this.canvasSelection = new CanvasSelection();
        this.canvasSelection.setVectorCanvas(this);
        this.canvasSelection.setEnabledVisible(false, true, false);
        this.canvasGrid = new DefaultCanvasGrid();
        this.canvasGrid.setVectorCanvas(this);
        this.canvasBackground = new CanvasBackground();
        this.canvasBackground.setVectorCanvas(this);
        this.canvasSize = new Dimension(0, 0);
        this.setSize(this.canvasSize);
        this.setPreferredSize(this.canvasSize);
        this.setTransferHandler(new CanvasTransferHandler());
        try {
            this.getDropTarget().addDropTargetListener(new DropTargetAdapter(){

                @Override
                public void dragOver(DropTargetDragEvent evt) {
                    VectorCanvas.this.dropLocation = evt.getLocation();
                }

                @Override
                public void drop(DropTargetDropEvent evt) {
                    VectorCanvas.this.dropLocation = null;
                }
            });
        }
        catch (Exception ex) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.INFO, ex.getMessage(), ex);
        }
        if (textEditor == null) {
            textEditor = new DefaultTextEditor();
        }
        this.textEditor = textEditor;
        this.textEditor.setVectorCanvas(this);
        this.domListener = new EventListener(){

            @Override
            public void handleEvent(Event evt) {
                VectorCanvas.this.domNodeHandleEvent(evt);
            }
        };
        this.undoManager = new DOMUndoManager(GeneralOptions.getInstance().getUndoLimit());
        this.emptyTextNodeFilter = new EmptyTextNodeFilter();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (this.canvasBackground.isVisible()) {
            this.canvasBackground.paint(g2d);
        }
        if (this.image != null) {
            Composite old = g2d.getComposite();
            g2d.setComposite(AlphaComposite.SrcOver);
            Rectangle clip = g.getClipBounds();
            if (clip == null) {
                g2d.drawRenderedImage(this.image, null);
            } else {
                int x2 = clip.x + clip.width;
                int y2 = clip.y + clip.height;
                g2d.drawImage(this.image, clip.x, clip.y, x2, y2, clip.x, clip.y, x2, y2, this);
            }
            g2d.setComposite(old);
        }
        if (this.canvasGrid.isVisible()) {
            this.canvasGrid.paint(g2d);
        }
        this.canvasSelection.paint(g2d);
        if (this.tool != null) {
            if (this.tool instanceof TextTool) {
                this.textEditor.paint(g2d);
            } else {
                this.tool.paint(g2d);
            }
        }
    }

    public void dispose() {
        if (this.previousTool != null) {
            this.previousTool.endTool();
        }
        if (this.tool != null) {
            this.tool.endTool();
        }
        this.getCanvasSelection().clearSelection();
        SVGDocument doc = this.model.getSVGDocument();
        if (doc != null) {
            EventTarget et = (EventTarget)((Object)doc.getDocumentElement());
            et.removeEventListener("DOMAttrModified", this.domListener, false);
            et.removeEventListener("DOMNodeRemoved", this.domListener, false);
        }
        if (this.undoManager != null) {
            this.undoManager.discardAllEdits();
            this.undoManager.setSVGDocument(null);
        }
        if (this.renderer != null) {
            this.renderer.dispose();
        }
        if (this.model != null) {
            this.model.dispose();
        }
        this.previousTool = null;
        this.tool = null;
        this.renderer = null;
        this.image = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSVGDocument(SVGDocument doc) {
        SVGDocument oldDoc = this.model.getSVGDocument();
        try {
            this.dispose();
            ConcreteImageRendererFactory rendererFactory = new ConcreteImageRendererFactory();
            this.renderer = rendererFactory.createDynamicImageRenderer();
            this.renderer.setDoubleBuffered(false);
            this.model.setSVGDocument(doc);
            this.renderer.setTree(this.model.getRoot());
            this.undoManager.setSVGDocument(doc);
            this.zoomFactor = 1.0;
            int w = (int)Math.ceil(this.model.getSVGWidth());
            int h = (int)Math.ceil(this.model.getSVGHeight());
            this.canvasSize.setSize(w, h);
            this.setSize(this.canvasSize);
            this.setPreferredSize(this.canvasSize);
            this.renderer.updateOffScreen(w, h);
            this.refresh();
            if (doc != null) {
                EventTarget et = (EventTarget)((Object)doc.getDocumentElement());
                et.addEventListener("DOMAttrModified", this.domListener, false);
                et.addEventListener("DOMNodeRemoved", this.domListener, false);
            }
            this.revalidate();
            this.repaint();
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.firePropertyChange(DOCUMENT_PROPERTY, oldDoc, doc);
    }

    public SVGDocument getSVGDocument() {
        return this.model.getSVGDocument();
    }

    public EditorUserAgent getEditorUserAgent() {
        return this.model.getEditorUserAgent();
    }

    public DOMUndoManager getUndoManager() {
        return this.undoManager;
    }

    public CanvasBackground getCanvasBackground() {
        return this.canvasBackground;
    }

    public CanvasGrid getCanvasGrid() {
        return this.canvasGrid;
    }

    public void setGridVisible(boolean visible) {
        this.canvasGrid.setVisible(visible);
    }

    public boolean isGridVisible() {
        return this.canvasGrid.isVisible();
    }

    public void setSnapToGrid(boolean snapToGrid) {
        this.snapToGrid = snapToGrid;
    }

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    public SVGAnimationEngine getAnimationEngine() {
        return this.model.getAnimationEngine();
    }

    public synchronized void setZoomFactor(double zoomFactor) {
        if (this.image == null) {
            return;
        }
        if (this.zoomFactor == zoomFactor) {
            return;
        }
        this.zoomFactor = zoomFactor;
        AffineTransform at = AffineTransform.getScaleInstance(zoomFactor, zoomFactor);
        this.renderer.setTransform(at);
        Rectangle2D r = new Rectangle2D.Double(0.0, 0.0, this.model.getSVGWidth(), this.model.getSVGHeight());
        r = at.createTransformedShape(r).getBounds2D();
        int w = (int)Math.ceil(r.getWidth());
        int h = (int)Math.ceil(r.getHeight());
        this.canvasSize.setSize(w, h);
        this.setSize(this.canvasSize);
        this.setPreferredSize(this.canvasSize);
        this.renderer.updateOffScreen(w, h);
        this.refresh();
        this.revalidate();
        this.repaint();
    }

    public double getZoomFactor() {
        return this.zoomFactor;
    }

    public AffineTransform getTransform() {
        return this.getTransform(false);
    }

    public AffineTransform getTransform(boolean includeRootDocTransform) {
        AffineTransform at = new AffineTransform(this.renderer.getTransform());
        if (includeRootDocTransform) {
            AffineTransform rootAt = this.model.getGraphicsNode((SVGElement)this.model.getSVGSVGElement()).getGlobalTransform();
            at.concatenate(rootAt);
        }
        return at;
    }

    public void refresh() {
        Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, this.model.getSVGWidth(), this.model.getSVGHeight());
        this.refresh(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Shape shape) {
        BufferedImage offScreenImage;
        Cursor prevCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        RenderingHints rh = this.renderer.getRenderingHints();
        boolean antiAlias = CanvasOptions.getInstance().isCanvasAntiAliased();
        if (antiAlias) {
            rh.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            rh.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        try {
            this.renderer.repaint(shape);
            this.renderer.flush();
            offScreenImage = this.renderer.getOffScreen();
            if (offScreenImage == null) {
                offScreenImage = this.createEmptyImage();
            }
            this.canvasSelection.updateBorder();
        }
        finally {
            this.setCursor(prevCursor);
        }
        this.image = offScreenImage;
        this.repaint();
    }

    public void refreshSelection() {
        List<SVGElement> l = this.canvasSelection.getSelectionList();
        this.canvasSelection.setSelectionList(l);
        this.canvasSelection.updateBorder();
    }

    private BufferedImage createEmptyImage() {
        AffineTransform at = new AffineTransform();
        at.setToScale(this.zoomFactor, this.zoomFactor);
        Rectangle2D r = new Rectangle2D.Double(0.0, 0.0, this.model.getSVGWidth(), this.model.getSVGHeight());
        r = at.createTransformedShape(r).getBounds2D();
        int w = (int)Math.ceil(r.getWidth());
        int h = (int)Math.ceil(r.getHeight());
        BufferedImage img = new BufferedImage(w, h, 2);
        return img;
    }

    public CanvasModel getModel() {
        return this.model;
    }

    public CanvasSelection getCanvasSelection() {
        return this.canvasSelection;
    }

    public TextEditor getTextEditor() {
        return this.textEditor;
    }

    protected void resetCanvasSelection() {
        this.canvasSelection.setEnabledVisible(false, true, false);
    }

    public void setTool(Tool tool) {
        this.previousTool = this.tool;
        boolean toolChanged = true;
        if (this.previousTool != null) {
            boolean bl = toolChanged = !this.previousTool.equals(tool);
            if (toolChanged) {
                this.previousTool.endTool();
                this.previousTool.setVectorCanvas(null);
            }
        }
        if (toolChanged) {
            this.canvasSelection.setEnabledVisible(false, true, false);
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.tool = tool;
        if (tool != null) {
            tool.setVectorCanvas(this);
            if (toolChanged) {
                tool.startTool();
            }
        }
        if (toolChanged) {
            this.firePropertyChange(TOOL_PROPERTY, this.previousTool, tool);
        }
    }

    public Tool getTool() {
        return this.tool;
    }

    public Tool getPreviousTool() {
        return this.previousTool;
    }

    public Point getDropLocation() {
        return this.dropLocation;
    }

    public void deleteSelection() {
        List<SVGElement> srcList = this.canvasSelection.getSelectionList();
        if (srcList.isEmpty()) {
            return;
        }
        ArrayList<SVGElement> destList = new ArrayList<SVGElement>(srcList);
        this.canvasSelection.clearSelection();
        this.canvasSelection.updateBorder();
        for (int i = 0; i < destList.size(); ++i) {
            SVGElement element = (SVGElement)destList.get(i);
            Node parentNode = element.getParentNode();
            parentNode.removeChild((Node)element);
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void groupSelection() throws CanvasException {
        List<SVGElement> list = this.canvasSelection.getSelectionList();
        ArrayList<SVGElement> newList = new ArrayList<SVGElement>(1);
        if (list.isEmpty()) {
            return;
        }
        Node parent = ((Node)list.get(0)).getParentNode();
        boolean same = true;
        for (int i = 1; i < list.size(); ++i) {
            Node tempParent = ((Node)list.get(i)).getParentNode();
            if (tempParent.equals(parent)) continue;
            same = false;
            break;
        }
        if (!same) {
            throw new CanvasException("Can't make a group of objects that are within different parent");
        }
        Cursor prevCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            SVGDocument doc = this.model.getSVGDocument();
            SVGGElement gElt = (SVGGElement)doc.createElementNS("http://www.w3.org/2000/svg", "g");
            Element root = doc.getDocumentElement();
            root.appendChild((Node)gElt);
            for (int i = list.size() - 1; i >= 0; --i) {
                gElt.appendChild((Node)list.get(i));
            }
            newList.add((SVGElement)gElt);
            this.canvasSelection.setSelectionList(newList);
        }
        finally {
            this.setCursor(prevCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ungroupSelection() {
        List<SVGElement> list = this.canvasSelection.getSelectionList();
        ArrayList<SVGElement> newList = new ArrayList<SVGElement>();
        Cursor prevCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            for (int i = list.size() - 1; i >= 0; --i) {
                Node node = (Node)list.get(i);
                Node nextSibling = node.getNextSibling();
                if (node instanceof SVGGElement) {
                    Element elt = (Element)node;
                    AffineTransform at = new AffineTransform();
                    SVGTransformList transformList = ((SVGTransformable)elt).getTransform().getBaseVal();
                    for (int j = 0; j < transformList.getNumberOfItems(); ++j) {
                        SVGMatrix matrix = transformList.getItem(j).getMatrix();
                        at.concatenate(new AffineTransform(matrix.getA(), matrix.getB(), matrix.getC(), matrix.getD(), matrix.getE(), matrix.getF()));
                    }
                    SVGTransform transform = null;
                    if (!at.isIdentity()) {
                        double[] values = new double[6];
                        at.getMatrix(values);
                        SVGMatrix matrix = this.model.getSVGSVGElement().createSVGMatrix();
                        matrix.setA((float)values[0]);
                        matrix.setB((float)values[1]);
                        matrix.setC((float)values[2]);
                        matrix.setD((float)values[3]);
                        matrix.setE((float)values[4]);
                        matrix.setF((float)values[5]);
                        transform = this.getSVGDocument().getRootElement().createSVGTransformFromMatrix(matrix);
                    }
                    while (elt.hasChildNodes()) {
                        Node child = elt.getFirstChild();
                        if (child instanceof SVGTransformable && transform != null) {
                            SVGTransformList childTransformList = ((SVGTransformable)child).getTransform().getBaseVal();
                            childTransformList.insertItemBefore(transform, 0);
                            childTransformList.consolidate();
                        }
                        if (nextSibling == null) {
                            elt.getParentNode().appendChild(child);
                        } else {
                            elt.getParentNode().insertBefore(child, nextSibling);
                        }
                        newList.add((SVGElement)child);
                    }
                    elt.getParentNode().removeChild(elt);
                    continue;
                }
                newList.add((SVGElement)node);
            }
            this.canvasSelection.setSelectionList(newList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.setCursor(prevCursor);
        }
    }

    public void moveUpSelection() {
        List<SVGElement> list = this.canvasSelection.getSelectionList();
        if (list.isEmpty()) {
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            Node node = (Node)list.get(i);
            Node parent = node.getParentNode();
            DocumentTraversal travelsal = (DocumentTraversal)this.model.getSVGDocument();
            TreeWalker tw = travelsal.createTreeWalker(parent, -1, this.emptyTextNodeFilter, false);
            tw.setCurrentNode(node);
            Node sibling = tw.nextSibling();
            if (sibling == null) continue;
            sibling = tw.nextSibling();
            if (sibling != null) {
                parent.insertBefore(node, sibling);
                continue;
            }
            parent.appendChild(node);
        }
        this.refresh(this.canvasSelection.getSelectionBounds2D());
    }

    public void moveDownSelection() {
        List<SVGElement> list = this.canvasSelection.getSelectionList();
        if (list.isEmpty()) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Node node = (Node)list.get(i);
            Node parent = node.getParentNode();
            DocumentTraversal travelsal = (DocumentTraversal)this.model.getSVGDocument();
            TreeWalker tw = travelsal.createTreeWalker(parent, -1, this.emptyTextNodeFilter, false);
            tw.setCurrentNode(node);
            Node sibling = tw.previousSibling();
            if (sibling == null) continue;
            parent.insertBefore(node, sibling);
        }
        this.refresh(this.canvasSelection.getSelectionBounds2D());
    }

    public void moveTopSelection() {
        List<SVGElement> list = this.canvasSelection.getSelectionList();
        if (list.isEmpty()) {
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            Node parent;
            Node lastChild;
            Node node = (Node)list.get(i);
            if (node.equals(lastChild = (parent = node.getParentNode()).getLastChild())) continue;
            parent.appendChild(node);
        }
        this.refresh(this.canvasSelection.getSelectionBounds2D());
    }

    public void moveBottomSelection() {
        List<SVGElement> list = this.canvasSelection.getSelectionList();
        if (list.isEmpty()) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Node parent;
            Node firstChild;
            Node node = (Node)list.get(i);
            if (node.equals(firstChild = (parent = node.getParentNode()).getFirstChild())) continue;
            parent.insertBefore(node, firstChild);
        }
        this.refresh(this.canvasSelection.getSelectionBounds2D());
    }

    public void moveTopRootSelection() {
        List<SVGElement> list = this.canvasSelection.getSelectionList();
        if (list.isEmpty()) {
            return;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            Node parent;
            Node lastChild;
            Node node = (Node)list.get(i);
            if (node.equals(lastChild = (parent = node.getParentNode()).getLastChild())) continue;
            parent.appendChild(node);
        }
        SVGDocument doc = this.getSVGDocument();
        Element root = doc.getDocumentElement();
        for (int i = list.size() - 1; i >= 0; --i) {
            Node lastChild;
            Node node = (Node)list.get(i);
            Node prevParent = null;
            Node parent = node.getParentNode();
            while (!parent.equals(root)) {
                prevParent = parent;
                parent = node.getParentNode();
                if (!parent.equals(root)) continue;
                prevParent = null;
            }
            if (prevParent == null || prevParent.equals(lastChild = root.getLastChild())) continue;
            root.appendChild(prevParent);
        }
        this.refresh(this.canvasSelection.getSelectionBounds2D());
    }

    public void moveBottomRootSelection() {
        List<SVGElement> list = this.canvasSelection.getSelectionList();
        if (list.isEmpty()) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Node parent;
            Node lastChild;
            Node node = (Node)list.get(i);
            if (node.equals(lastChild = (parent = node.getParentNode()).getLastChild())) continue;
            parent.appendChild(node);
        }
        SVGDocument doc = this.getSVGDocument();
        Element root = doc.getDocumentElement();
        for (int i = 0; i < list.size(); ++i) {
            Node firstChild;
            Node node = (Node)list.get(i);
            Node prevParent = null;
            Node parent = node.getParentNode();
            while (!parent.equals(root)) {
                prevParent = parent;
                parent = node.getParentNode();
                if (!parent.equals(root)) continue;
                prevParent = null;
            }
            if (prevParent == null || prevParent.equals(firstChild = root.getFirstChild())) continue;
            parent.insertBefore(prevParent, firstChild);
        }
        this.refresh(this.canvasSelection.getSelectionBounds2D());
    }

    private void domNodeHandleEvent(Event evt) {
        Node node = (Node)((Object)evt.getTarget());
        if (evt.getType().equals("DOMNodeRemoved")) {
            boolean removed = false;
            List<SVGElement> list = this.canvasSelection.getSelectionList();
            Iterator<SVGElement> it = list.iterator();
            while (it.hasNext()) {
                SVGElement selected = it.next();
                if (!selected.equals(node)) continue;
                it.remove();
                removed = true;
                break;
            }
            if (removed) {
                this.canvasSelection.setSelectionList(list);
            }
        }
        if (!node.equals(this.model.getSVGDocument().getRootElement())) {
            return;
        }
        MutationEvent me = (MutationEvent)evt;
        Attr attr = (Attr)me.getRelatedNode();
        String name = attr.getName();
        if (name.endsWith("width") || name.endsWith("height") || name.endsWith("viewBox")) {
            double factor = this.getZoomFactor();
            this.setZoomFactor(factor);
        }
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (VectorCanvas.this.canvasSelection.isEnabled()) {
                VectorCanvas.this.canvasSelection.keyTyped(e);
            }
            if (VectorCanvas.this.tool != null) {
                VectorCanvas.this.tool.keyTyped(e);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (VectorCanvas.this.canvasSelection.isEnabled()) {
                VectorCanvas.this.canvasSelection.keyPressed(e);
            }
            if (VectorCanvas.this.tool != null) {
                VectorCanvas.this.tool.keyPressed(e);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (VectorCanvas.this.canvasSelection.isEnabled()) {
                VectorCanvas.this.canvasSelection.keyReleased(e);
            }
            if (VectorCanvas.this.tool != null) {
                VectorCanvas.this.tool.keyReleased(e);
            }
        }
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (VectorCanvas.this.canvasSelection.isEnabled()) {
                VectorCanvas.this.canvasSelection.mouseClicked(e);
            }
            if (VectorCanvas.this.tool != null) {
                VectorCanvas.this.tool.mouseClicked(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (VectorCanvas.this.canvasSelection.isEnabled()) {
                VectorCanvas.this.canvasSelection.mousePressed(e);
            }
            if (VectorCanvas.this.tool != null) {
                VectorCanvas.this.tool.mousePressed(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (VectorCanvas.this.canvasSelection.isEnabled()) {
                VectorCanvas.this.canvasSelection.mouseReleased(e);
            }
            if (VectorCanvas.this.tool != null) {
                VectorCanvas.this.tool.mouseReleased(e);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (VectorCanvas.this.canvasSelection.isEnabled()) {
                VectorCanvas.this.canvasSelection.mouseDragged(e);
            }
            if (VectorCanvas.this.tool != null) {
                VectorCanvas.this.tool.mouseDragged(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (VectorCanvas.this.canvasSelection.isEnabled()) {
                VectorCanvas.this.canvasSelection.mouseMoved(e);
            }
            if (VectorCanvas.this.tool != null) {
                VectorCanvas.this.tool.mouseMoved(e);
            }
        }
    }

    private class FocusHandler
    extends FocusAdapter {
        private FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent evt) {
            if (VectorCanvas.this.textEditor.isEditable()) {
                VectorCanvas.this.textEditor.getCaret().setVisible(true);
            }
        }

        @Override
        public void focusLost(FocusEvent evt) {
            VectorCanvas.this.textEditor.getCaret().setVisible(false);
        }
    }
}

