/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.tool;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.tool.AbstractTool;
import kiyut.sketsa.tool.InsertImagePane;

public class ImageTool
extends AbstractTool {
    private VectorCanvas canvas;
    private Rectangle2D rect = new Rectangle2D.Float();
    private Rectangle2D bounds = new Rectangle2D.Double();
    private int newX;
    private int newY;
    private int startX;
    private int startY;

    @Override
    public void paint(Graphics2D g2d) {
        if (this.canvas == null) {
            return;
        }
        Paint oldPaint = g2d.getPaint();
        Stroke oldStroke = g2d.getStroke();
        g2d.setPaint(this.canvas.getCanvasSelection().getStrokePaint());
        g2d.setStroke(this.canvas.getCanvasSelection().getStroke());
        g2d.draw(this.rect);
        g2d.setPaint(oldPaint);
        g2d.setStroke(oldStroke);
    }

    @Override
    public void setVectorCanvas(VectorCanvas canvas) {
        this.canvas = canvas;
    }

    @Override
    public void startTool() {
        this.canvas.getCanvasSelection().setEnabledVisible(false, true, false);
        this.rect.setRect(-1.0, -1.0, -1.0, -1.0);
        this.canvas.setCursor(Cursor.getPredefinedCursor(1));
        this.fireMessageReceived(0, "Click and drag to draw Image bounds");
    }

    protected void updateRect() {
        double rH;
        double rY;
        double rW;
        double rX;
        if (this.newX >= this.startX) {
            rX = this.startX;
            rW = this.newX - this.startX;
        } else {
            rX = this.newX;
            rW = this.startX - this.newX;
        }
        if (this.newY >= this.startY) {
            rY = this.startY;
            rH = this.newY - this.startY;
        } else {
            rY = this.newY;
            rH = this.startY - this.newY;
        }
        this.rect.setRect(rX, rY, rW, rH);
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.newX = evt.getX();
        this.newY = evt.getY();
        if ((evt.getModifiersEx() & 0x40) == 64) {
            int dx = this.newX - this.startX;
            int dy = this.newY - this.startY;
            int d = Math.max(Math.abs(dx), Math.abs(dy));
            this.newX = dx < 0 ? this.startX + d * -1 : this.startX + d;
            this.newY = dy < 0 ? this.startY + d * -1 : this.startY + d;
        }
        if (this.canvas.isSnapToGrid()) {
            int gridSize = this.canvas.getCanvasGrid().getGridSize();
            this.newX = gridSize * Math.round((float)this.newX / (float)gridSize);
            this.newY = gridSize * Math.round((float)this.newY / (float)gridSize);
        }
        this.bounds.setRect(this.rect.getBounds());
        this.updateRect();
        this.bounds = this.bounds.createUnion(this.rect.getBounds());
        this.canvas.repaint((int)this.bounds.getX() - 1, (int)this.bounds.getY() - 1, (int)this.bounds.getWidth() + 2, (int)this.bounds.getHeight() + 2);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.startX = evt.getX();
        this.startY = evt.getY();
        if (this.canvas.isSnapToGrid()) {
            int gridSize = this.canvas.getCanvasGrid().getGridSize();
            this.startX = gridSize * Math.round((float)this.startX / (float)gridSize);
            this.startY = gridSize * Math.round((float)this.startY / (float)gridSize);
        }
        this.newX = this.startX;
        this.newY = this.startY;
        this.rect.setRect(this.startX, this.startY, 0.0, 0.0);
        this.canvas.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.updateRect();
        this.insertImage();
        this.startTool();
    }

    protected void insertImage() {
        Window win = SwingUtilities.getWindowAncestor(this.canvas);
        JFrame mainWin = null;
        if (!(win instanceof JFrame)) {
            return;
        }
        mainWin = (JFrame)win;
        AffineTransform at = this.canvas.getTransform(true);
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            // empty catch block
        }
        Shape shape = at.createTransformedShape(this.rect);
        Rectangle rBounds = shape.getBounds();
        InsertImagePane.showDialog(mainWin, this.canvas, rBounds);
    }
}

