/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.tool;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import kiyut.sketsa.canvas.CanvasModel;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.tool.AbstractTool;
import kiyut.sketsa.options.CanvasOptions;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.ColorConvertion;
import kiyut.sketsa.util.DOMUtilities;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGPointList;
import org.w3c.dom.svg.SVGPolygonElement;
import org.w3c.dom.svg.SVGPolylineElement;
import org.w3c.dom.svg.SVGSVGElement;
import org.w3c.dom.svg.SVGStylable;

public class PolyTool
extends AbstractTool {
    protected VectorCanvas canvas;
    protected Line2D line;
    protected Rectangle2D bounds = new Rectangle2D.Double();
    protected Paint strokePaint;
    protected Paint fillPaint = null;
    protected Stroke stroke = new BasicStroke(this.strokeWidth);
    protected float strokeWidth = 1.0f;
    private int x;
    private int y;
    private int lastX;
    private int lastY;
    private Rectangle2D initHandle;
    private SVGElement element;

    public PolyTool() {
        this.strokePaint = Color.BLACK;
        this.reset();
    }

    @Override
    public void paint(Graphics2D g2d) {
        Paint oldPaint = g2d.getPaint();
        Stroke oldStroke = g2d.getStroke();
        g2d.setPaint(this.strokePaint);
        g2d.setStroke(this.stroke);
        if (this.initHandle != null) {
            g2d.fill(this.initHandle);
        }
        g2d.draw(this.line);
        g2d.setPaint(oldPaint);
        g2d.setStroke(oldStroke);
    }

    @Override
    public void setVectorCanvas(VectorCanvas canvas) {
        this.canvas = canvas;
    }

    public void setStrokePaint(Paint strokePaint) {
        this.strokePaint = strokePaint;
    }

    public void setFillPaint(Paint fillPaint) {
        this.fillPaint = fillPaint;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    @Override
    public void endTool() {
        this.reset();
    }

    @Override
    public void startTool() {
        this.reset();
        this.canvas.getCanvasSelection().setEnabledVisible(false, true, false);
        this.canvas.setCursor(Cursor.getPredefinedCursor(1));
        this.fireMessageReceived(0, "Click and drag to draw polyline. Click on initial point to draw polygon");
    }

    private void reset() {
        this.initHandle = null;
        this.line = new Line2D.Float();
        this.element = null;
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.lastX = this.x;
        this.lastY = this.y;
        this.x = evt.getX();
        this.y = evt.getY();
        if ((evt.getModifiersEx() & 0x40) == 64) {
            int startX = (int)this.line.getX1();
            int startY = (int)this.line.getY1();
            int dx = this.x - startX;
            int dy = this.y - startY;
            double angle = 0.0;
            angle = Math.atan2(this.y - startY, this.x - startX);
            if ((angle = Math.toDegrees(angle)) >= -22.5 && angle < 22.5) {
                this.y = startY;
            } else if (angle >= 22.5 && angle < 67.5) {
                if (angle <= 45.0) {
                    this.x = startX + dx;
                    this.y = startY + dx;
                } else {
                    this.x = startX + dy;
                    this.y = startY + dy;
                }
            } else if (angle >= 67.5 && angle < 112.5) {
                this.x = startX;
            } else if (angle >= 112.5 && angle < 157.5) {
                if (angle <= 135.0) {
                    this.x = startX - dy;
                    this.y = startY + dy;
                } else {
                    this.x = startX + dx;
                    this.y = startY - dx;
                }
            } else if (angle >= 157.5 && angle <= 180.0 || angle >= -180.0 && angle < -157.5) {
                this.x = startX + dx;
                this.y = startY;
            } else if (angle >= -157.5 && angle < -112.5) {
                if (angle <= -135.0) {
                    this.x = startX + dy;
                    this.y = startY + dy;
                } else {
                    this.x = startX + dx;
                    this.y = startY + dx;
                }
            } else if (angle >= -112.5 && angle < -67.5) {
                this.x = startX;
            } else if (angle >= -67.5 && angle < -22.5) {
                if (angle <= -45.0) {
                    this.x = startX - dy;
                    this.y = startY + dy;
                } else {
                    this.x = startX + dx;
                    this.y = startY - dx;
                }
            }
        }
        if (this.canvas.isSnapToGrid()) {
            int gridSize = this.canvas.getCanvasGrid().getGridSize();
            this.x = gridSize * Math.round((float)this.x / (float)gridSize);
            this.y = gridSize * Math.round((float)this.y / (float)gridSize);
        }
        this.bounds.setRect(this.line.getBounds());
        this.line.setLine(this.line.getX1(), this.line.getY1(), this.line.getX2() + (double)this.x - (double)this.lastX, this.line.getY2() + (double)this.y - (double)this.lastY);
        this.bounds = this.bounds.createUnion(this.line.getBounds());
        this.canvas.repaint((int)this.bounds.getX() - 1, (int)this.bounds.getY() - 1, (int)this.bounds.getWidth() + 2, (int)this.bounds.getHeight() + 2);
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        if (evt.getClickCount() >= 2) {
            this.startTool();
            this.canvas.refresh();
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        this.lastX = this.x;
        this.lastY = this.y;
        this.x = evt.getX();
        this.y = evt.getY();
        if (this.canvas.isSnapToGrid()) {
            int gridSize = this.canvas.getCanvasGrid().getGridSize();
            this.x = gridSize * Math.round((float)this.x / (float)gridSize);
            this.y = gridSize * Math.round((float)this.y / (float)gridSize);
        }
        if (this.initHandle == null) {
            CanvasOptions prefs = CanvasOptions.getInstance();
            int handleSize = prefs.getHandleSize() / 2;
            this.initHandle = new Rectangle2D.Float();
            this.initHandle.setFrameFromCenter(this.x, this.y, this.x - handleSize, this.y - handleSize);
            this.line.setLine(this.x, this.y, this.x, this.y);
            this.canvas.getCanvasSelection().setVisible(false, false);
        } else {
            this.line.setLine(this.line.getX2(), this.line.getY2(), this.x, this.y);
        }
        this.canvas.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        if (!this.line.getP1().equals(this.line.getP2())) {
            if (this.initHandle.contains(this.x, this.y)) {
                if (this.element == null) {
                    return;
                }
                DOMUndoManager undoManager = this.canvas.getUndoManager();
                undoManager.start("Close Poly");
                try {
                    this.convertToPolygon();
                }
                finally {
                    undoManager.end();
                }
                ArrayList<SVGElement> selectionList = new ArrayList<SVGElement>(1);
                selectionList.add(this.element);
                this.canvas.getCanvasSelection().setSelectionList(selectionList);
                this.startTool();
            } else {
                if (this.element == null) {
                    this.element = this.createSVGElement();
                    this.addPoint((float)this.line.getX1(), (float)this.line.getY1());
                    CanvasModel model = this.canvas.getModel();
                    DOMUndoManager undoManager = this.canvas.getUndoManager();
                    undoManager.start("Draw Poly");
                    try {
                        model.appendChild((Element)this.element);
                    }
                    finally {
                        undoManager.end();
                    }
                }
                this.addPoint((float)this.line.getX2(), (float)this.line.getY2());
                if (this.element != null) {
                    ArrayList<SVGElement> selectionList = new ArrayList<SVGElement>(1);
                    selectionList.add(this.element);
                    this.canvas.getCanvasSelection().setSelectionList(selectionList);
                }
            }
            this.canvas.refresh();
        }
    }

    protected SVGElement createSVGElement() {
        String str;
        CanvasModel model = this.canvas.getModel();
        SVGDocument svgDocument = model.getSVGDocument();
        String svgNS = "http://www.w3.org/2000/svg";
        SVGElement elt = (SVGElement)svgDocument.createElementNS(svgNS, "polyline");
        SVGStylable stylable = (SVGStylable)elt;
        if (this.strokePaint != null) {
            if (this.strokePaint instanceof Color) {
                str = ColorConvertion.toHexString((Color)this.strokePaint);
                DOMUtilities.updateProperty(stylable, null, "stroke", str);
            }
        } else {
            DOMUtilities.updateProperty(stylable, null, "stroke", "none");
        }
        if (this.fillPaint != null) {
            if (this.fillPaint instanceof Color) {
                str = ColorConvertion.toHexString((Color)this.fillPaint);
                DOMUtilities.updateProperty(stylable, null, "fill", str);
            }
        } else {
            DOMUtilities.updateProperty(stylable, null, "fill", "none");
        }
        return elt;
    }

    private void convertToPolygon() {
        SVGPolylineElement polylineElement = (SVGPolylineElement)this.element;
        CanvasModel model = this.canvas.getModel();
        SVGDocument svgDocument = model.getSVGDocument();
        String svgNS = "http://www.w3.org/2000/svg";
        SVGPolygonElement polygonElement = (SVGPolygonElement)svgDocument.createElementNS(svgNS, "polygon");
        NamedNodeMap map = polylineElement.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            Attr attr = (Attr)map.item(i);
            polygonElement.setAttributeNode((Attr)attr.cloneNode(true));
        }
        Node parent = polylineElement.getParentNode();
        parent.replaceChild((Node)polygonElement, (Node)polylineElement);
        this.element = polygonElement;
    }

    private void addPoint(float x, float y) {
        if (this.element == null) {
            return;
        }
        SVGPointList svgPointList = null;
        svgPointList = this.element instanceof SVGPolylineElement ? ((SVGPolylineElement)this.element).getPoints() : ((SVGPolygonElement)this.element).getPoints();
        CanvasModel model = this.canvas.getModel();
        SVGDocument svgDocument = model.getSVGDocument();
        SVGSVGElement svgElement = svgDocument.getRootElement();
        double[] srcPts = new double[2];
        double[] dstPts = new double[2];
        srcPts[0] = x;
        srcPts[1] = y;
        AffineTransform at = this.canvas.getTransform(true);
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            // empty catch block
        }
        at.transform(srcPts, 0, dstPts, 0, 1);
        SVGPoint svgPoint = svgElement.createSVGPoint();
        svgPoint.setX((float)dstPts[0]);
        svgPoint.setY((float)dstPts[1]);
        svgPointList.appendItem(svgPoint);
    }
}

