/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.canvas.tool.point;

import java.awt.BasicStroke;
import java.awt.Cursor;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import kiyut.sketsa.canvas.CanvasModel;
import kiyut.sketsa.canvas.tool.point.AbstractPointTool;
import kiyut.sketsa.canvas.tool.point.PathSegment;
import kiyut.sketsa.canvas.tool.point.PointShape;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.GeomUtilities;
import org.apache.batik.ext.awt.geom.ExtendedGeneralPath;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.ShapeNode;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGPathElement;
import org.w3c.dom.svg.SVGPathSeg;
import org.w3c.dom.svg.SVGPathSegArcAbs;
import org.w3c.dom.svg.SVGPathSegArcRel;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicSmoothAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicSmoothRel;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticRel;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticSmoothAbs;
import org.w3c.dom.svg.SVGPathSegLinetoAbs;
import org.w3c.dom.svg.SVGPathSegLinetoHorizontalAbs;
import org.w3c.dom.svg.SVGPathSegLinetoHorizontalRel;
import org.w3c.dom.svg.SVGPathSegLinetoRel;
import org.w3c.dom.svg.SVGPathSegLinetoVerticalAbs;
import org.w3c.dom.svg.SVGPathSegLinetoVerticalRel;
import org.w3c.dom.svg.SVGPathSegList;
import org.w3c.dom.svg.SVGPathSegMovetoAbs;
import org.w3c.dom.svg.SVGPathSegMovetoRel;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGPointList;
import org.w3c.dom.svg.SVGPolygonElement;
import org.w3c.dom.svg.SVGPolylineElement;

public class AddPointTool
extends AbstractPointTool {
    @Override
    public void endTool() {
        if (this.canvas != null) {
            this.canvas.getCanvasSelection().setEnabledVisible(true, true, true);
        }
    }

    @Override
    public void startTool() {
        this.canvas.setCursor(Cursor.getPredefinedCursor(1));
        this.canvas.getCanvasSelection().setEnabledVisible(false, false, false);
        this.canvas.repaint();
        this.fireMessageReceived(0, "Click on outline to add point");
    }

    private void addToPath(int x, int y, SVGPathElement svgPath, Stroke stroke) {
        CanvasModel canvasModel = this.canvas.getModel();
        AffineTransform canvasAt = this.canvas.getTransform();
        ExtendedGeneralPath path = new ExtendedGeneralPath();
        int selectedIndex = -1;
        GraphicsNode gn = canvasModel.getGraphicsNode((SVGElement)svgPath);
        ShapeNode sn = (ShapeNode)gn;
        AffineTransform at = (AffineTransform)canvasAt.clone();
        at.concatenate(sn.getGlobalTransform());
        SVGPathSegList svgPathSegList = svgPath.getPathSegList();
        float[] lastPoint = new float[2];
        float[] ctrlPoint = new float[2];
        float[] movePoint = new float[2];
        lastPoint[0] = 0.0f;
        lastPoint[1] = 0.0f;
        ctrlPoint[0] = 0.0f;
        ctrlPoint[1] = 0.0f;
        for (int i = 0; i < svgPathSegList.getNumberOfItems(); ++i) {
            SVGPathSegCurvetoCubicSmoothAbs svgPathSeg;
            path.reset();
            short type = svgPathSegList.getItem(i).getPathSegType();
            if (type == 1) {
                path.moveTo(lastPoint[0], lastPoint[1]);
                path.lineTo(movePoint[0], movePoint[1]);
                lastPoint[0] = 0.0f;
                lastPoint[1] = 0.0f;
            } else if (type == 2) {
                SVGPathSegMovetoAbs svgPathSeg2 = (SVGPathSegMovetoAbs)svgPathSegList.getItem(i);
                lastPoint[0] = svgPathSeg2.getX();
                lastPoint[1] = svgPathSeg2.getY();
                movePoint[0] = lastPoint[0];
                movePoint[1] = lastPoint[1];
            } else if (type == 3) {
                SVGPathSegMovetoRel svgPathSeg3 = (SVGPathSegMovetoRel)svgPathSegList.getItem(i);
                lastPoint[0] = svgPathSeg3.getX() + lastPoint[0];
                lastPoint[1] = svgPathSeg3.getY() + lastPoint[1];
                movePoint[0] = lastPoint[0];
                movePoint[1] = lastPoint[1];
            } else if (type == 10) {
                SVGPathSegArcAbs svgPathSeg4 = (SVGPathSegArcAbs)svgPathSegList.getItem(i);
                path.moveTo(lastPoint[0], lastPoint[1]);
                path.arcTo(svgPathSeg4.getR1(), svgPathSeg4.getR2(), svgPathSeg4.getAngle(), svgPathSeg4.getLargeArcFlag(), svgPathSeg4.getSweepFlag(), svgPathSeg4.getX(), svgPathSeg4.getY());
                lastPoint[0] = svgPathSeg4.getX();
                lastPoint[1] = svgPathSeg4.getY();
            } else if (type == 11) {
                SVGPathSegArcRel svgPathSeg5 = (SVGPathSegArcRel)svgPathSegList.getItem(i);
                path.moveTo(lastPoint[0], lastPoint[1]);
                path.arcTo(svgPathSeg5.getR1(), svgPathSeg5.getR2(), svgPathSeg5.getAngle(), svgPathSeg5.getLargeArcFlag(), svgPathSeg5.getSweepFlag(), svgPathSeg5.getX() + lastPoint[0], svgPathSeg5.getY() + lastPoint[1]);
                lastPoint[0] = svgPathSeg5.getX();
                lastPoint[1] = svgPathSeg5.getY();
            } else if (type == 6) {
                SVGPathSegCurvetoCubicAbs svgPathSeg6 = (SVGPathSegCurvetoCubicAbs)svgPathSegList.getItem(i);
                path.moveTo(lastPoint[0], lastPoint[1]);
                path.curveTo(svgPathSeg6.getX1(), svgPathSeg6.getY1(), svgPathSeg6.getX2(), svgPathSeg6.getY2(), svgPathSeg6.getX(), svgPathSeg6.getY());
                ctrlPoint[0] = svgPathSeg6.getX2();
                ctrlPoint[1] = svgPathSeg6.getY2();
                lastPoint[0] = svgPathSeg6.getX();
                lastPoint[1] = svgPathSeg6.getY();
            } else if (type == 7) {
                SVGPathSegCurvetoCubicAbs svgPathSeg7 = (SVGPathSegCurvetoCubicAbs)svgPathSegList.getItem(i);
                path.moveTo(lastPoint[0], lastPoint[1]);
                path.curveTo(svgPathSeg7.getX1() + lastPoint[0], svgPathSeg7.getY1() + lastPoint[1], svgPathSeg7.getX2() + lastPoint[0], svgPathSeg7.getY2() + lastPoint[1], svgPathSeg7.getX() + lastPoint[0], svgPathSeg7.getY() + lastPoint[1]);
                ctrlPoint[0] = svgPathSeg7.getX2() + lastPoint[0];
                ctrlPoint[1] = svgPathSeg7.getY2() + lastPoint[1];
                lastPoint[0] = svgPathSeg7.getX() + lastPoint[0];
                lastPoint[1] = svgPathSeg7.getY() + lastPoint[1];
            } else if (type == 16) {
                short prevType = svgPathSegList.getItem(i - 1).getPathSegType();
                switch (prevType) {
                    case 6: 
                    case 7: 
                    case 16: 
                    case 17: {
                        ctrlPoint[0] = 2.0f * lastPoint[0] - ctrlPoint[0];
                        ctrlPoint[1] = 2.0f * lastPoint[1] - ctrlPoint[1];
                        break;
                    }
                    default: {
                        ctrlPoint[0] = lastPoint[0];
                        ctrlPoint[1] = lastPoint[1];
                    }
                }
                svgPathSeg = (SVGPathSegCurvetoCubicSmoothAbs)svgPathSegList.getItem(i);
                path.moveTo(lastPoint[0], lastPoint[1]);
                path.curveTo(ctrlPoint[0], ctrlPoint[1], svgPathSeg.getX2(), svgPathSeg.getY2(), svgPathSeg.getX(), svgPathSeg.getY());
                ctrlPoint[0] = svgPathSeg.getX2();
                ctrlPoint[1] = svgPathSeg.getY2();
                lastPoint[0] = svgPathSeg.getX();
                lastPoint[1] = svgPathSeg.getY();
            } else if (type == 17) {
                short prevType = svgPathSegList.getItem(i - 1).getPathSegType();
                switch (prevType) {
                    case 6: 
                    case 7: 
                    case 16: 
                    case 17: {
                        ctrlPoint[0] = 2.0f * lastPoint[0] - ctrlPoint[0];
                        ctrlPoint[1] = 2.0f * lastPoint[1] - ctrlPoint[1];
                        break;
                    }
                    default: {
                        ctrlPoint[0] = lastPoint[0];
                        ctrlPoint[1] = lastPoint[1];
                    }
                }
                svgPathSeg = (SVGPathSegCurvetoCubicSmoothRel)svgPathSegList.getItem(i);
                path.moveTo(lastPoint[0], lastPoint[1]);
                path.curveTo(ctrlPoint[0], ctrlPoint[1], svgPathSeg.getX2() + lastPoint[0], svgPathSeg.getY2() + lastPoint[1], svgPathSeg.getX() + lastPoint[0], svgPathSeg.getY() + lastPoint[1]);
                ctrlPoint[0] = svgPathSeg.getX2() + lastPoint[0];
                ctrlPoint[1] = svgPathSeg.getY2() + lastPoint[1];
                lastPoint[0] = svgPathSeg.getX() + lastPoint[0];
                lastPoint[1] = svgPathSeg.getY() + lastPoint[1];
            } else if (type == 8) {
                SVGPathSegCurvetoQuadraticAbs svgPathSeg8 = (SVGPathSegCurvetoQuadraticAbs)svgPathSegList.getItem(i);
                path.moveTo(lastPoint[0], lastPoint[1]);
                path.quadTo(svgPathSeg8.getX1(), svgPathSeg8.getY1(), svgPathSeg8.getX(), svgPathSeg8.getY());
                ctrlPoint[0] = svgPathSeg8.getX1();
                ctrlPoint[1] = svgPathSeg8.getY1();
                lastPoint[0] = svgPathSeg8.getX();
                lastPoint[1] = svgPathSeg8.getY();
            } else if (type == 9) {
                SVGPathSegCurvetoQuadraticRel svgPathSeg9 = (SVGPathSegCurvetoQuadraticRel)svgPathSegList.getItem(i);
                path.moveTo(lastPoint[0], lastPoint[1]);
                path.quadTo(svgPathSeg9.getX1() + lastPoint[0], svgPathSeg9.getY1() + lastPoint[1], svgPathSeg9.getX() + lastPoint[0], svgPathSeg9.getY() + lastPoint[1]);
                ctrlPoint[0] = svgPathSeg9.getX1() + lastPoint[0];
                ctrlPoint[1] = svgPathSeg9.getY1() + lastPoint[1];
                lastPoint[0] = svgPathSeg9.getX() + lastPoint[0];
                lastPoint[1] = svgPathSeg9.getY() + lastPoint[1];
            } else if (type == 18) {
                short prevType = svgPathSegList.getItem(i - 1).getPathSegType();
                switch (prevType) {
                    case 8: 
                    case 9: 
                    case 18: 
                    case 19: {
                        ctrlPoint[0] = 2.0f * lastPoint[0] - ctrlPoint[0];
                        ctrlPoint[1] = 2.0f * lastPoint[1] - ctrlPoint[1];
                        break;
                    }
                    default: {
                        ctrlPoint[0] = lastPoint[0];
                        ctrlPoint[1] = lastPoint[1];
                    }
                }
                svgPathSeg = (SVGPathSegCurvetoQuadraticSmoothAbs)svgPathSegList.getItem(i);
                path.moveTo(lastPoint[0], lastPoint[1]);
                path.quadTo(ctrlPoint[0], ctrlPoint[1], svgPathSeg.getX(), svgPathSeg.getY());
                lastPoint[0] = svgPathSeg.getX();
                lastPoint[1] = svgPathSeg.getY();
            } else if (type == 19) {
                short prevType = svgPathSegList.getItem(i - 1).getPathSegType();
                switch (prevType) {
                    case 8: 
                    case 9: 
                    case 18: 
                    case 19: {
                        ctrlPoint[0] = 2.0f * lastPoint[0] - ctrlPoint[0];
                        ctrlPoint[1] = 2.0f * lastPoint[1] - ctrlPoint[1];
                        break;
                    }
                    default: {
                        ctrlPoint[0] = lastPoint[0];
                        ctrlPoint[1] = lastPoint[1];
                    }
                }
                svgPathSeg = (SVGPathSegCurvetoQuadraticSmoothAbs)svgPathSegList.getItem(i);
                path.moveTo(lastPoint[0], lastPoint[1]);
                path.quadTo(ctrlPoint[0], ctrlPoint[1], svgPathSeg.getX() + lastPoint[0], svgPathSeg.getY() + lastPoint[1]);
                lastPoint[0] = svgPathSeg.getX() + lastPoint[0];
                lastPoint[1] = svgPathSeg.getY() + lastPoint[1];
            } else if (type == 4) {
                SVGPathSegLinetoAbs svgPathSeg10 = (SVGPathSegLinetoAbs)svgPathSegList.getItem(i);
                path.moveTo(lastPoint[0], lastPoint[1]);
                path.lineTo(svgPathSeg10.getX(), svgPathSeg10.getY());
                lastPoint[0] = svgPathSeg10.getX();
                lastPoint[1] = svgPathSeg10.getY();
            } else if (type == 5) {
                SVGPathSegLinetoRel svgPathSeg11 = (SVGPathSegLinetoRel)svgPathSegList.getItem(i);
                path.moveTo(lastPoint[0], lastPoint[1]);
                path.lineTo(svgPathSeg11.getX() + lastPoint[0], svgPathSeg11.getY() + lastPoint[1]);
                lastPoint[0] = svgPathSeg11.getX() + lastPoint[0];
                lastPoint[1] = svgPathSeg11.getY() + lastPoint[1];
            } else if (type == 12) {
                SVGPathSegLinetoHorizontalAbs svgPathSeg12 = (SVGPathSegLinetoHorizontalAbs)svgPathSegList.getItem(i);
                path.moveTo(lastPoint[0], lastPoint[1]);
                path.lineTo(svgPathSeg12.getX(), lastPoint[1]);
                lastPoint[0] = svgPathSeg12.getX();
                lastPoint[1] = lastPoint[1];
            } else if (type == 13) {
                SVGPathSegLinetoHorizontalRel svgPathSeg13 = (SVGPathSegLinetoHorizontalRel)svgPathSegList.getItem(i);
                path.moveTo(lastPoint[0], lastPoint[1]);
                path.lineTo(svgPathSeg13.getX() + lastPoint[0], lastPoint[1]);
                lastPoint[0] = svgPathSeg13.getX() + lastPoint[0];
                lastPoint[1] = lastPoint[1];
            } else if (type == 14) {
                SVGPathSegLinetoVerticalAbs svgPathSeg14 = (SVGPathSegLinetoVerticalAbs)svgPathSegList.getItem(i);
                path.moveTo(lastPoint[0], lastPoint[1]);
                path.lineTo(lastPoint[0], svgPathSeg14.getY());
                lastPoint[0] = lastPoint[0];
                lastPoint[1] = svgPathSeg14.getY();
            } else if (type == 15) {
                SVGPathSegLinetoVerticalRel svgPathSeg15 = (SVGPathSegLinetoVerticalRel)svgPathSegList.getItem(i);
                path.moveTo(lastPoint[0], lastPoint[1]);
                path.lineTo(lastPoint[0], svgPathSeg15.getY() + lastPoint[1]);
                lastPoint[0] = lastPoint[0];
                lastPoint[1] = svgPathSeg15.getY() + lastPoint[1];
            }
            Shape tShape = at.createTransformedShape((Shape)path);
            tShape = stroke.createStrokedShape(tShape);
            if (!tShape.contains(x, y)) continue;
            selectedIndex = i;
            break;
        }
        if (selectedIndex < 0) {
            return;
        }
        double[] srcPts = new double[6];
        double[] dstPts = new double[6];
        srcPts[0] = x;
        srcPts[1] = y;
        srcPts[2] = x;
        srcPts[3] = y;
        srcPts[4] = x;
        srcPts[5] = y;
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            // empty catch block
        }
        at.transform(srcPts, 0, dstPts, 0, 3);
        SVGPathSegCurvetoCubicAbs svgCubic = svgPath.createSVGPathSegCurvetoCubicAbs((float)dstPts[0], (float)dstPts[1], (float)dstPts[2], (float)dstPts[3], (float)dstPts[4], (float)dstPts[5]);
        svgPath.getPathSegList().insertItemBefore((SVGPathSeg)svgCubic, selectedIndex);
        int indexOf = this.model.indexOf((SVGElement)svgPath);
        this.model.updatePointList(indexOf);
        PathSegment pathSegment = this.model.getPathSegmentList(indexOf).get(selectedIndex);
        PointShape point = (PointShape)pathSegment.getPoint(0);
        this.model.setSelectedPathSegment(pathSegment);
        this.model.setSelectedPoint(point);
    }

    private void addToPoly(int x, int y, SVGElement svgElement, Stroke stroke) {
        Shape tShape;
        CanvasModel canvasModel = this.canvas.getModel();
        AffineTransform canvasAt = this.canvas.getTransform();
        ExtendedGeneralPath path = new ExtendedGeneralPath();
        int selectedIndex = -1;
        GraphicsNode gn = canvasModel.getGraphicsNode(svgElement);
        ShapeNode sn = (ShapeNode)gn;
        AffineTransform at = (AffineTransform)canvasAt.clone();
        at.concatenate(sn.getGlobalTransform());
        SVGPointList svgPointList = null;
        if (svgElement instanceof SVGPolygonElement) {
            svgPointList = ((SVGPolygonElement)svgElement).getPoints();
        } else if (svgElement instanceof SVGPolylineElement) {
            svgPointList = ((SVGPolylineElement)svgElement).getPoints();
        } else {
            return;
        }
        float[] lastPoint = new float[2];
        SVGPoint firstPoint = svgPointList.getItem(0);
        lastPoint[0] = firstPoint.getX();
        lastPoint[1] = firstPoint.getY();
        for (int i = 1; i < svgPointList.getNumberOfItems(); ++i) {
            SVGPoint svgPoint = svgPointList.getItem(i);
            path.reset();
            path.moveTo(lastPoint[0], lastPoint[1]);
            path.lineTo(svgPoint.getX(), svgPoint.getY());
            lastPoint[0] = svgPoint.getX();
            lastPoint[1] = svgPoint.getY();
            tShape = at.createTransformedShape((Shape)path);
            tShape = stroke.createStrokedShape(tShape);
            if (!tShape.contains(x, y)) continue;
            selectedIndex = i;
            break;
        }
        if (svgElement instanceof SVGPolygonElement && selectedIndex < 0) {
            path.reset();
            path.moveTo(lastPoint[0], lastPoint[1]);
            path.lineTo(firstPoint.getX(), firstPoint.getY());
            tShape = at.createTransformedShape((Shape)path);
            tShape = stroke.createStrokedShape(tShape);
            if (tShape.contains(x, y)) {
                selectedIndex = svgPointList.getNumberOfItems();
            }
        }
        if (selectedIndex < 0) {
            return;
        }
        double[] srcPts = new double[2];
        double[] dstPts = new double[2];
        srcPts[0] = x;
        srcPts[1] = y;
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            // empty catch block
        }
        at.transform(srcPts, 0, dstPts, 0, 1);
        SVGPoint newPoint = svgElement.getOwnerSVGElement().createSVGPoint();
        newPoint.setX((float)dstPts[0]);
        newPoint.setY((float)dstPts[1]);
        svgPointList.insertItemBefore(newPoint, selectedIndex);
        int indexOf = this.model.indexOf(svgElement);
        this.model.updatePointList(indexOf);
        PathSegment pathSegment = this.model.getPathSegmentList(indexOf).get(selectedIndex);
        PointShape point = (PointShape)pathSegment.getPoint(0);
        this.model.setSelectedPathSegment(pathSegment);
        this.model.setSelectedPoint(point);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent evt) {
        if (!SwingUtilities.isLeftMouseButton(evt)) {
            return;
        }
        int x = evt.getX();
        int y = evt.getY();
        SVGElement selectedElement = null;
        CanvasModel canvasModel = this.canvas.getModel();
        AffineTransform canvasAt = this.canvas.getTransform();
        BasicStroke curStroke = new BasicStroke(6.0f);
        for (int i = 0; i < this.model.size(); ++i) {
            SVGElement element = this.model.get(i);
            GraphicsNode gn = canvasModel.getGraphicsNode(element);
            if (!(gn instanceof ShapeNode)) continue;
            ShapeNode sn = (ShapeNode)gn;
            AffineTransform at = (AffineTransform)canvasAt.clone();
            at.concatenate(sn.getGlobalTransform());
            Shape shape = at.createTransformedShape(sn.getShape());
            shape = curStroke.createStrokedShape(shape);
            if (!shape.contains(x, y)) continue;
            selectedElement = element;
            break;
        }
        if (selectedElement == null) {
            return;
        }
        ArrayList<Rectangle2D> list = new ArrayList<Rectangle2D>(2);
        GraphicsNode gn = this.canvas.getModel().getGraphicsNode(selectedElement);
        if (gn != null) {
            AffineTransform at = gn.getGlobalTransform();
            Shape shape = gn.getBounds();
            shape = at.createTransformedShape(shape);
            list.add((Rectangle2D)shape);
        }
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Add Point");
        try {
            if (selectedElement instanceof SVGPathElement) {
                this.addToPath(x, y, (SVGPathElement)selectedElement, curStroke);
            } else if (selectedElement instanceof SVGPolygonElement || selectedElement instanceof SVGPolylineElement) {
                this.addToPoly(x, y, selectedElement, curStroke);
            }
        }
        finally {
            undoManager.end();
        }
        gn = this.canvas.getModel().getGraphicsNode(this.model.getSelectedElement());
        if (gn != null) {
            AffineTransform at = gn.getGlobalTransform();
            Shape shape = gn.getBounds();
            shape = at.createTransformedShape(shape);
            list.add((Rectangle2D)shape);
        }
        Rectangle2D bounds = GeomUtilities.getBounds2D(list);
        this.canvas.refresh(bounds);
    }
}

