/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.options;

import java.util.prefs.Preferences;
import kiyut.sketsa.io.DOMTranscoder;
import kiyut.sketsa.options.AbstractOptions;

public class CodeFormatOptions
extends AbstractOptions {
    private static CodeFormatOptions instance = new CodeFormatOptions();
    public static final String TAB_WIDTH_PROPERTY = "tab_width";
    public static final String LINE_WIDTH_PROPERTY = "line_width";
    public static final String LINE_BREAK_PROPERTY = "line_break";
    public static final String STYLING_CSS_PROPERTY = "styling_css";
    private int tabWidth;
    private int lineWidth;
    private String lineBreak;
    private boolean stylingCSS;

    public static CodeFormatOptions getInstance() {
        return instance;
    }

    protected CodeFormatOptions() {
        this.nodeName = "code-format";
        Preferences prefs = this.getPreferences();
        this.tabWidth = prefs.getInt(TAB_WIDTH_PROPERTY, 4);
        this.lineWidth = prefs.getInt(LINE_WIDTH_PROPERTY, 120);
        this.stylingCSS = prefs.getBoolean(STYLING_CSS_PROPERTY, false);
        String defaultLineBreak = System.getProperty("line.separator");
        String osName = System.getProperty("os.name").toUpperCase();
        if (osName.startsWith("WINDOWS")) {
            defaultLineBreak = DOMTranscoder.VALUE_NEWLINE_CR_LF.getValue();
        }
        this.lineBreak = prefs.get(LINE_BREAK_PROPERTY, defaultLineBreak);
    }

    public int getTabWidth() {
        return this.tabWidth;
    }

    public void setTabWidth(int tabWidth) {
        int old = this.tabWidth;
        this.tabWidth = tabWidth;
        this.firePropertyChange(TAB_WIDTH_PROPERTY, old, this.tabWidth);
        this.getPreferences().putInt(TAB_WIDTH_PROPERTY, this.tabWidth);
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(int lineWidth) {
        int old = this.lineWidth;
        this.lineWidth = lineWidth;
        this.firePropertyChange(LINE_WIDTH_PROPERTY, old, this.lineWidth);
        this.getPreferences().putInt(LINE_WIDTH_PROPERTY, this.lineWidth);
    }

    public String getLineBreak() {
        return this.lineBreak;
    }

    public void setLineBreak(String lineBreak) {
        String old = this.lineBreak;
        this.lineBreak = lineBreak;
        this.firePropertyChange(LINE_BREAK_PROPERTY, old, this.lineBreak);
        this.getPreferences().put(LINE_BREAK_PROPERTY, this.lineBreak);
    }

    public boolean isStylingCSS() {
        return this.stylingCSS;
    }

    public void setStylingCSS(boolean stylingCSS) {
        boolean old = this.stylingCSS;
        this.stylingCSS = stylingCSS;
        this.firePropertyChange(STYLING_CSS_PROPERTY, old, this.stylingCSS);
        this.getPreferences().putBoolean(STYLING_CSS_PROPERTY, this.stylingCSS);
    }
}

