/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.options;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import kiyut.sketsa.options.AbstractOptions;

public class SourceEditorOptions
extends AbstractOptions {
    private static SourceEditorOptions instance = new SourceEditorOptions();
    public static final String BOUNDS_PROPERTY = "bounds";
    private static final String X_PROPERTY = "x";
    private static final String Y_PROPERTY = "y";
    private static final String WIDTH_PROPERTY = "width";
    private static final String HEIGHT_PROPERTY = "height";
    private static final String FIND_PROPERTY = "find";
    private static final String REPLACE_PROPERTY = "replace";
    private Rectangle bounds;
    private List<String> findList;
    private List<String> replaceList;
    private int findReplaceMaxSize;

    public static SourceEditorOptions getInstance() {
        return instance;
    }

    protected SourceEditorOptions() {
        this.nodeName = "source-editor";
        Preferences prefs = this.getPreferences();
        int x = prefs.getInt(X_PROPERTY, -1);
        int y = prefs.getInt(Y_PROPERTY, -1);
        int width = prefs.getInt(WIDTH_PROPERTY, 800);
        int height = prefs.getInt(HEIGHT_PROPERTY, 600);
        this.bounds = new Rectangle(x, y, width, height);
        this.validateBounds(this.bounds);
        this.findReplaceMaxSize = 8;
        this.findList = new ArrayList<String>(this.findReplaceMaxSize);
        this.replaceList = new ArrayList<String>(this.findReplaceMaxSize);
        this.retrieveFindReplaceList();
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle rv) {
        Rectangle old = this.bounds;
        if (!old.equals(rv)) {
            this.bounds = rv;
            this.validateBounds(this.bounds);
            this.firePropertyChange(BOUNDS_PROPERTY, old, rv);
            Preferences prefs = this.getPreferences();
            prefs.putInt(X_PROPERTY, this.bounds.x);
            prefs.putInt(Y_PROPERTY, this.bounds.y);
            prefs.putInt(WIDTH_PROPERTY, this.bounds.width);
            prefs.putInt(HEIGHT_PROPERTY, this.bounds.height);
        }
    }

    private void validateBounds(Rectangle rect) {
        if (rect.width < 300) {
            rect.width = 300;
        }
        if (rect.height < 300) {
            rect.height = 300;
        }
        Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
        if (rect.x >= size.width - 48) {
            rect.x = -1;
        }
        if (rect.y >= size.height - 48) {
            rect.y = -1;
        }
        if (rect.width > size.width) {
            rect.width = size.width;
        }
        if (rect.height > size.height) {
            rect.height = size.height;
        }
    }

    public List<String> getFindList() {
        return this.findList;
    }

    public List<String> getReplaceList() {
        return this.replaceList;
    }

    public void setFindReplaceList(List<String> findList, List<String> replaceList) {
        List<String> oldFindList = this.findList;
        List<String> oldReplaceList = this.replaceList;
        this.findList = findList;
        this.replaceList = replaceList;
        this.firePropertyChange(FIND_PROPERTY, oldFindList, findList);
        this.firePropertyChange(REPLACE_PROPERTY, oldReplaceList, replaceList);
        this.storeFindReplaceList();
    }

    private void storeFindReplaceList() {
        String str;
        int i;
        Preferences prefs = this.getPreferences();
        int size = Math.min(this.findList.size(), this.findReplaceMaxSize);
        int clearSize = Math.max(this.findList.size(), this.findReplaceMaxSize);
        for (i = 0; i < size; ++i) {
            str = this.findList.get(i);
            prefs.put(FIND_PROPERTY + i, str);
        }
        for (i = size; i < clearSize; ++i) {
            prefs.remove(FIND_PROPERTY + i);
        }
        size = Math.min(this.replaceList.size(), this.findReplaceMaxSize);
        clearSize = Math.max(this.replaceList.size(), this.findReplaceMaxSize);
        for (i = 0; i < size; ++i) {
            str = this.replaceList.get(i);
            prefs.put(REPLACE_PROPERTY + i, str);
        }
        for (i = size; i < clearSize; ++i) {
            prefs.remove(REPLACE_PROPERTY + i);
        }
    }

    private void retrieveFindReplaceList() {
        String str;
        int i;
        this.findList.clear();
        this.replaceList.clear();
        Preferences prefs = this.getPreferences();
        for (i = 0; i < this.findReplaceMaxSize && (str = prefs.get(FIND_PROPERTY + i, null)) != null; ++i) {
            this.findList.add(str);
        }
        for (i = 0; i < this.findReplaceMaxSize && (str = prefs.get(REPLACE_PROPERTY + i, null)) != null; ++i) {
            this.replaceList.add(str);
        }
    }
}

