/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.registration;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import kiyut.sketsa.Application;
import kiyut.sketsa.registration.RegistrationManager;
import kiyut.swing.dialog.DialogESC;

public class RegisterWindow
extends DialogESC {
    private static ResourceBundle bundle = ResourceBundle.getBundle("kiyut.sketsa.registration.RegisterWindow");
    private boolean registered = false;
    private JPanel buttonPane;
    private JButton cancelButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextArea licenseArea;
    private JTextField nameField;
    private JButton pasteButton;
    private JButton registerButton;

    public RegisterWindow(Frame owner, boolean modal) {
        super(owner, modal);
        this.registerWindowConstructor();
    }

    public RegisterWindow(Dialog owner, boolean modal) {
        super(owner, modal);
        this.registerWindowConstructor();
    }

    private void registerWindowConstructor() {
        this.initComponents();
        this.initCustomComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.nameField = new JTextField();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.pasteButton = new JButton();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.licenseArea = new JTextArea();
        this.buttonPane = new JPanel();
        this.registerButton = new JButton();
        this.cancelButton = new JButton();
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText(bundle.getString("titleLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel1.add((Component)this.nameField, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel3.setText(bundle.getString("serialNoLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 256;
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        this.pasteButton.setText(bundle.getString("pasteButton.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 12;
        gridBagConstraints.anchor = 256;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel2.add((Component)this.pasteButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jLabel2.setText(bundle.getString("nameLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(12, 0, 0, 6);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.licenseArea.setColumns(45);
        this.licenseArea.setRows(5);
        this.jScrollPane1.setViewportView(this.licenseArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.buttonPane.setLayout(new GridLayout(1, 0, 5, 0));
        this.registerButton.setText(bundle.getString("registerButton.text"));
        this.registerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RegisterWindow.this.registerButtonActionPerformed(evt);
            }
        });
        this.buttonPane.add(this.registerButton);
        this.cancelButton.setText(bundle.getString("cancelButton.text"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RegisterWindow.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPane.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.jPanel1.add((Component)this.buttonPane, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "Center");
    }

    private void registerButtonActionPerformed(ActionEvent evt) {
        String name = this.nameField.getText().trim();
        String serialNo = this.licenseArea.getText().trim();
        if (name == null || serialNo == null) {
            JOptionPane.showMessageDialog(this, bundle.getString("message.empty.text"), bundle.getString("message.exception.title"), 0);
            return;
        }
        this.registered = RegistrationManager.getInstance().register(name, serialNo);
        if (!this.registered) {
            JOptionPane.showMessageDialog(this, bundle.getString("message.invalidSerialNo.text"), bundle.getString("message.exception.title"), 0);
        } else {
            JOptionPane.showMessageDialog(this, bundle.getString("message.registerComplete.text"), bundle.getString("message.registerComplete.title"), 1);
            this.setVisible(false);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void initCustomComponents() {
        this.setTitle(bundle.getString("title.text") + " " + Application.getFullName());
        this.setDefaultCloseOperation(2);
        this.getRootPane().setDefaultButton(this.registerButton);
        this.pasteButton.setAction(new PasteAction(this.licenseArea));
        if (!this.pasteButton.isEnabled()) {
            this.pasteButton.setEnabled(true);
        }
        this.licenseArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                this.doPopup(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.doPopup(evt);
            }

            private void doPopup(MouseEvent evt) {
                if (!evt.isPopupTrigger()) {
                    return;
                }
                JPopupMenu menu = new JPopupMenu();
                menu.add(new CutAction(RegisterWindow.this.licenseArea));
                menu.add(new CopyAction(RegisterWindow.this.licenseArea));
                menu.add(new PasteAction(RegisterWindow.this.licenseArea));
                menu.add(new DeleteAction(RegisterWindow.this.licenseArea));
                menu.show(RegisterWindow.this.licenseArea, evt.getX(), evt.getY());
            }
        });
    }

    public boolean isRegistered() {
        return this.registered;
    }

    private class DeleteAction
    extends AbstractAction {
        private JTextComponent comp;

        public DeleteAction(JTextComponent comp) {
            super(bundle.getString("CTL_Delete.text"));
            this.comp = comp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.comp.replaceSelection(null);
        }

        @Override
        public boolean isEnabled() {
            return this.comp.isEditable() && this.comp.isEnabled() && this.comp.getSelectedText() != null;
        }
    }

    private class PasteAction
    extends AbstractAction {
        private JTextComponent comp;

        public PasteAction(JTextComponent comp) {
            super(bundle.getString("CTL_Paste.text"));
            this.comp = comp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.comp.paste();
        }

        @Override
        public boolean isEnabled() {
            if (this.comp.isEditable() && this.comp.isEnabled()) {
                Transferable contents = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
                return contents.isDataFlavorSupported(DataFlavor.stringFlavor);
            }
            return false;
        }
    }

    private class CopyAction
    extends AbstractAction {
        private JTextComponent comp;

        public CopyAction(JTextComponent comp) {
            super(bundle.getString("CTL_Copy.text"));
            this.comp = comp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.comp.copy();
        }

        @Override
        public boolean isEnabled() {
            return this.comp.isEnabled() && this.comp.getSelectedText() != null;
        }
    }

    private class CutAction
    extends AbstractAction {
        private JTextComponent comp;

        public CutAction(JTextComponent comp) {
            super(bundle.getString("CTL_Cut.text"));
            this.comp = comp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.comp.cut();
        }

        @Override
        public boolean isEnabled() {
            return this.comp.isEditable() && this.comp.isEnabled() && this.comp.getSelectedText() != null;
        }
    }
}

