/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.util;

import java.awt.geom.Point2D;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.batik.parser.DefaultPathHandler;
import org.apache.batik.parser.DefaultPointsHandler;
import org.apache.batik.parser.PathHandler;
import org.apache.batik.parser.PathParser;
import org.apache.batik.parser.PointsHandler;
import org.apache.batik.parser.PointsParser;

public class DataTypeUtilities {
    private static final NumberFormat percentFormat = NumberFormat.getPercentInstance();

    public static Number validateInteger(String source) throws ParseException {
        Integer number;
        String tmp = source.trim();
        try {
            number = Integer.valueOf(tmp);
        }
        catch (Exception e) {
            throw new ParseException("Invalid value: \"" + tmp + "\"", -1);
        }
        return number;
    }

    public static Number validateNumber(String source) throws ParseException {
        Float number;
        String tmp = source.trim();
        try {
            number = Float.valueOf(tmp);
        }
        catch (Exception e) {
            throw new ParseException("Invalid value: \"" + tmp + "\"", -1);
        }
        return number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Number validateLength(String source) throws ParseException {
        Number number;
        String tmp = source.trim();
        if (tmp.endsWith("%")) {
            NumberFormat numberFormat = percentFormat;
            synchronized (numberFormat) {
                ParsePosition pos = new ParsePosition(0);
                number = percentFormat.parse(tmp, pos);
                if (pos.getIndex() < tmp.length()) {
                    throw new ParseException("Invalid value: \"" + tmp + "\"", pos.getIndex() + 1);
                }
            }
        }
        String tmp1 = tmp.toLowerCase();
        if (tmp1.endsWith("px") || tmp1.endsWith("cm") || tmp1.endsWith("mm") || tmp1.endsWith("in") || tmp1.endsWith("pt") || tmp1.endsWith("pc") || tmp1.endsWith("em") || tmp1.endsWith("ex")) {
            tmp1 = tmp1.substring(0, tmp1.length() - 2);
        }
        try {
            number = DataTypeUtilities.validateNumber(tmp1);
        }
        catch (ParseException pe) {
            throw new ParseException("Invalid value: \"" + tmp + "\"", pe.getErrorOffset());
        }
        return number;
    }

    public static List<Number> validateLengthList(String source) throws ParseException {
        String s = source.trim();
        ArrayList<Number> l = new ArrayList<Number>();
        StringTokenizer tokens = new StringTokenizer(s, " ,");
        while (tokens.hasMoreTokens()) {
            Number number = DataTypeUtilities.validateLength(tokens.nextToken());
            l.add(number);
        }
        return l;
    }

    public static boolean identicalLength(String source1, String source2) throws ParseException {
        String s2;
        boolean b = false;
        String[] split1 = DataTypeUtilities.splitLength(source1.trim());
        String[] split2 = DataTypeUtilities.splitLength(source2.trim());
        Number n1 = DataTypeUtilities.validateNumber(split1[0]);
        Number n2 = DataTypeUtilities.validateNumber(split2[0]);
        String s1 = n1.doubleValue() + split1[1];
        if (s1.equalsIgnoreCase(s2 = n2.doubleValue() + split2[1])) {
            b = true;
        }
        return b;
    }

    private static String[] splitLength(String length) {
        String[] strs = new String[]{"", ""};
        if (length.endsWith("%")) {
            strs[0] = length.substring(0, length.length() - 1);
            strs[1] = length.substring(length.length() - 1, length.length());
        } else if (length.endsWith("px") || length.endsWith("cm") || length.endsWith("mm") || length.endsWith("in") || length.endsWith("pt") || length.endsWith("pc")) {
            strs[0] = length.substring(0, length.length() - 2);
            strs[1] = length.substring(length.length() - 2, length.length());
        } else if (length.endsWith("ems") || length.endsWith("exs")) {
            strs[0] = length.substring(0, length.length() - 3);
            strs[1] = length.substring(length.length() - 3, length.length());
        } else {
            strs[0] = length;
        }
        return strs;
    }

    public static Number[] validateNumberOptional(String source) throws ParseException {
        String s = source.trim();
        if (s.length() == 0) {
            throw new ParseException("Invalid value: \"" + s + "\"", -1);
        }
        Number[] numbers = new Number[2];
        StringTokenizer tokens = new StringTokenizer(s, " ,");
        Number number = DataTypeUtilities.validateNumber(tokens.nextToken());
        numbers[0] = new Float(number.floatValue());
        if (tokens.hasMoreTokens()) {
            number = DataTypeUtilities.validateNumber(tokens.nextToken());
            numbers[1] = new Float(number.floatValue());
        } else {
            numbers[1] = new Float(numbers[0].floatValue());
        }
        return numbers;
    }

    public static List<Number> validateNumberList(String source) throws ParseException {
        String s = source.trim();
        if (s.length() == 0) {
            throw new ParseException("Invalid value: \"" + s + "\"", -1);
        }
        ArrayList<Number> l = new ArrayList<Number>();
        StringTokenizer tokens = new StringTokenizer(s, " ,");
        while (tokens.hasMoreTokens()) {
            Number number = DataTypeUtilities.validateNumber(tokens.nextToken());
            l.add(number);
        }
        return l;
    }

    public static List<Point2D> validatePointList(String source) throws ParseException {
        DefaultPointsHandler handler = DefaultPointsHandler.INSTANCE;
        PointsParser parser = new PointsParser();
        parser.setPointsHandler((PointsHandler)handler);
        try {
            parser.parse(source);
        }
        catch (Exception ex) {
            throw new ParseException("Invalid points value", -1);
        }
        return null;
    }

    public static List validatePathData(String source) throws ParseException {
        PathHandler handler = DefaultPathHandler.INSTANCE;
        PathParser parser = new PathParser();
        parser.setPathHandler(handler);
        try {
            parser.parse(source);
        }
        catch (Exception ex) {
            throw new ParseException("Invalid Path data value", -1);
        }
        return null;
    }

    public static String[] parseViewBox(String viewBox) {
        String[] strs = viewBox.split("[\\s,]+");
        return strs;
    }
}

