/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.canvas;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.LineBorder;
import javax.swing.event.MouseInputAdapter;
import kiyut.sketsa.canvas.Ruler;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.text.TextEditor;
import kiyut.sketsa.loaders.SVGDataObject;
import kiyut.sketsa.registration.RegistrationManager;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.windows.canvas.CanvasUndoRedo;
import kiyut.sketsa.windows.canvas.TextEditorFactory;
import kiyut.swing.statusbar.StatusBar;
import kiyut.swing.statusbar.StatusBarItem;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.PasteAction;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.awt.UndoRedo;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.BooleanStateAction;
import org.openide.util.actions.CallbackSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.w3c.dom.svg.SVGDocument;

public class CanvasTopComponent
extends TopComponent {
    private static final String PREFERRED_ID = "CanvasTopComponent";
    private static final String POPUP_FOLDER_NAME = "Sketsa/Canvas/Popup";
    private static final String XML_TEXT_EDITOR_FOLDER_NAME = "Sketsa/Canvas/XMLTextEditor";
    private SVGDataObject data;
    private VectorCanvas canvas;
    private CanvasUndoRedo undoRedo;
    private JScrollPane scrollPane;
    private boolean rulerVisible;
    private Ruler horizontalRuler;
    private Ruler verticalRuler;
    private int unitType = 0;
    private JButton unitButton;
    private JComboBox zoomCombo;
    private boolean zoomComboInAction = false;
    private StatusBar statusBar;
    private Point mousePoint;
    private Point canvasPoint;
    private JPopupMenu popupMenu;
    private boolean popupMenuValid = false;
    private AffineTransform lastCanvasAt;
    private Rectangle lastViewRect;
    private Point lastCanvasPoint;

    public CanvasTopComponent() {
        this.initializeCustom();
    }

    protected void initializeCustom() {
        this.canvas = new CanvasView(this.createTextEditor());
        this.canvas.setBackground(Color.WHITE);
        this.canvas.setBorder(new LineBorder(Color.BLACK, 1, false));
        this.setLayout(new BorderLayout());
        JPanel pane = new JPanel();
        pane.setLayout(new GridBagLayout());
        pane.add((Component)this.canvas, new GridBagConstraints());
        pane.setOpaque(false);
        CanvasViewport vp = new CanvasViewport();
        vp.setView(pane);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewport(vp);
        this.unitButton = new JButton(this.unitTypeToString(this.unitType));
        this.unitButton.setFont(new Font("Monospaced", 0, 9));
        this.unitButton.setMargin(new Insets(0, 0, 0, 0));
        this.unitButton.setFocusPainted(false);
        this.unitButton.setFocusable(false);
        this.unitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                int nextUnitType = CanvasTopComponent.this.getNextUnitType();
                CanvasTopComponent.this.unitType = nextUnitType;
                CanvasTopComponent.this.horizontalRuler.setUnitType(CanvasTopComponent.this.unitType);
                CanvasTopComponent.this.verticalRuler.setUnitType(CanvasTopComponent.this.unitType);
                CanvasTopComponent.this.unitButton.setText(CanvasTopComponent.this.unitTypeToString(CanvasTopComponent.this.unitType));
                CanvasTopComponent.this.repaint();
            }
        });
        this.scrollPane.setCorner("UPPER_LEFT_CORNER", this.unitButton);
        this.add(this.scrollPane, "Center");
        String[] zoomValues = new String[]{"900.00%", "800.00%", "600.00%", "500.00%", "400.00%", "300.00%", "200.00%", "150.00%", "100.00%", "66.67%", "50.00%", "33.33%", "25.00%", "16.67%", "12.50%", "6.25%", "4.44%"};
        this.zoomCombo = new JComboBox<String>(zoomValues);
        this.zoomCombo.setPrototypeDisplayValue("999.99% ");
        Dimension dim = this.zoomCombo.getPreferredSize();
        this.zoomCombo.setPreferredSize(dim);
        this.zoomCombo.setMaximumRowCount(zoomValues.length);
        this.zoomCombo.setEditable(true);
        this.zoomCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CanvasTopComponent.this.zoomComboItemStateChanged(evt);
            }
        });
        if (this.zoomCombo.getRenderer() instanceof JLabel) {
            JLabel rend = (JLabel)((Object)this.zoomCombo.getRenderer());
            rend.setHorizontalAlignment(4);
        }
        this.mousePoint = new Point(-1, -1);
        this.canvasPoint = new Point(-1, -1);
        this.statusBar = new StatusBar();
        StatusBarItem statusBarItem = new StatusBarItem(" ", 75, 0);
        this.statusBar.addItem(statusBarItem);
        statusBarItem = new StatusBarItem(" ", 200, 2);
        this.statusBar.addItem(statusBarItem);
        JPanel bottomPane = new JPanel();
        bottomPane.setLayout(new BorderLayout());
        bottomPane.add((Component)this.zoomCombo, "West");
        bottomPane.add((Component)this.statusBar, "Center");
        this.add(bottomPane, "South");
        this.rulerVisible = false;
        MouseInputAdapter mouseHandler = new MouseInputAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                CanvasTopComponent.this.canvasMouseMoved(evt);
            }

            @Override
            public void mouseDragged(MouseEvent evt) {
                CanvasTopComponent.this.canvasMouseDragged(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                CanvasTopComponent.this.requestActive();
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                CanvasTopComponent.this.canvasMouseExited(evt);
            }
        };
        this.canvas.addMouseMotionListener(mouseHandler);
        this.canvas.addMouseListener(mouseHandler);
        this.canvas.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                if (CanvasTopComponent.this.lastViewRect != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CanvasTopComponent.this.canvasResized();
                        }
                    });
                }
                if (CanvasTopComponent.this.scrollPane != null) {
                    int hInc = (int)Math.ceil(CanvasTopComponent.this.canvas.getWidth() / 50);
                    int vInc = (int)Math.ceil(CanvasTopComponent.this.canvas.getHeight() / 50);
                    CanvasTopComponent.this.scrollPane.getHorizontalScrollBar().setUnitIncrement(hInc);
                    CanvasTopComponent.this.scrollPane.getVerticalScrollBar().setUnitIncrement(vInc);
                }
                double zoom = CanvasTopComponent.this.canvas.getZoomFactor();
                NumberFormat nf = NumberFormat.getPercentInstance();
                if (nf instanceof DecimalFormat) {
                    ((DecimalFormat)nf).applyPattern("#,###.00%");
                }
                CanvasTopComponent.this.zoomComboInAction = true;
                CanvasTopComponent.this.zoomCombo.setSelectedItem(nf.format(zoom));
                CanvasTopComponent.this.zoomComboInAction = false;
                CanvasTopComponent.this.repaint();
            }
        });
        this.canvas.addPropertyChangeListener("document", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CanvasTopComponent.this.data.setSVGDocument(CanvasTopComponent.this.canvas.getSVGDocument(), true);
            }
        });
        this.scrollPane.setWheelScrollingEnabled(false);
        this.scrollPane.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                if (evt.getScrollType() != 0) {
                    return;
                }
                int modifiers = evt.getModifiersEx();
                if ((modifiers & 0x80) == 128) {
                    int index;
                    int val = evt.getWheelRotation();
                    if (val > 0) {
                        int index2 = CanvasTopComponent.this.zoomCombo.getSelectedIndex();
                        if (index2 < CanvasTopComponent.this.zoomCombo.getItemCount() - 1) {
                            CanvasTopComponent.this.zoomCombo.setSelectedIndex(++index2);
                        }
                    } else if (val < 0 && (index = CanvasTopComponent.this.zoomCombo.getSelectedIndex()) > 0) {
                        CanvasTopComponent.this.zoomCombo.setSelectedIndex(--index);
                    }
                } else if ((modifiers & 0x40) == 64) {
                    JScrollBar hBar = CanvasTopComponent.this.scrollPane.getHorizontalScrollBar();
                    int totalScrollAmount = evt.getUnitsToScroll() * hBar.getUnitIncrement();
                    hBar.setValue(hBar.getValue() + totalScrollAmount);
                } else {
                    JScrollBar vBar = CanvasTopComponent.this.scrollPane.getVerticalScrollBar();
                    int totalScrollAmount = evt.getUnitsToScroll() * vBar.getUnitIncrement();
                    vBar.setValue(vBar.getValue() + totalScrollAmount);
                }
            }
        });
        ActionMap tcActionMap = this.getActionMap();
        ActionMap editorActionMap = this.canvas.getActionMap();
        tcActionMap.setParent(editorActionMap);
        CallbackSystemAction callCutAction = (CallbackSystemAction)SystemAction.get(CutAction.class);
        editorActionMap.put(callCutAction.getActionMapKey(), new CanvasCutAction());
        CallbackSystemAction callCopyAction = (CallbackSystemAction)SystemAction.get(CopyAction.class);
        editorActionMap.put(callCopyAction.getActionMapKey(), new CanvasCopyAction());
        CallbackSystemAction callPasteAction = (CallbackSystemAction)SystemAction.get(PasteAction.class);
        editorActionMap.put(callPasteAction.getActionMapKey(), new CanvasPasteAction());
        CallbackSystemAction callDeleteAction = (CallbackSystemAction)SystemAction.get(DeleteAction.class);
        editorActionMap.put(callDeleteAction.getActionMapKey(), new CanvasDeleteAction());
        FileObject fo = FileUtil.getConfigRoot().getFileObject(POPUP_FOLDER_NAME);
        fo.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

            public void fileFolderCreated(FileEvent fe) {
                CanvasTopComponent.this.popupMenuValid = false;
            }

            public void fileDataCreated(FileEvent fe) {
                CanvasTopComponent.this.popupMenuValid = false;
            }

            public void fileChanged(FileEvent fe) {
                CanvasTopComponent.this.popupMenuValid = false;
            }

            public void fileDeleted(FileEvent fe) {
                CanvasTopComponent.this.popupMenuValid = false;
            }

            public void fileRenamed(FileRenameEvent fe) {
                CanvasTopComponent.this.popupMenuValid = false;
            }

            public void fileAttributeChanged(FileAttributeEvent fe) {
                CanvasTopComponent.this.popupMenuValid = false;
            }
        });
        if (fo != null) {
            this.createPopupMenu();
        }
        this.canvas.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    this.showPopup(evt);
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    this.showPopup(evt);
                }
            }

            private void showPopup(MouseEvent evt) {
                if (!CanvasTopComponent.this.popupMenuValid) {
                    CanvasTopComponent.this.createPopupMenu();
                }
                if (CanvasTopComponent.this.popupMenu == null) {
                    return;
                }
                CanvasTopComponent.this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        });
    }

    protected TextEditor createTextEditor() {
        TextEditor textEditor = null;
        for (TextEditorFactory instance : Lookups.forPath((String)XML_TEXT_EDITOR_FOLDER_NAME).lookupAll(TextEditorFactory.class)) {
            if (instance == null) continue;
            textEditor = instance.createTextEditor();
            break;
        }
        return textEditor;
    }

    protected void createPopupMenu() {
        this.popupMenuValid = true;
        FileObject fo = FileUtil.getConfigRoot().getFileObject(POPUP_FOLDER_NAME);
        if (fo == null) {
            this.popupMenu = null;
            return;
        }
        this.popupMenu = new JPopupMenu();
        this.buildPopup(fo, this.popupMenu);
        if (this.popupMenu.getComponentCount() <= 0) {
            this.popupMenu = null;
        }
    }

    private void buildPopup(FileObject fo, JComponent comp) {
        DataFolder df = DataFolder.findFolder((FileObject)fo);
        DataObject[] childs = df.getChildren();
        for (int i = 0; i < childs.length; ++i) {
            Object instanceObj;
            DataObject dob = childs[i];
            if (dob.getPrimaryFile().isFolder()) {
                FileObject childFo = childs[i].getPrimaryFile();
                JMenu menu = new JMenu();
                Mnemonics.setLocalizedText((AbstractButton)menu, (String)dob.getNodeDelegate().getDisplayName());
                comp.add(menu);
                this.buildPopup(childFo, menu);
                continue;
            }
            InstanceCookie ck = (InstanceCookie)dob.getCookie(InstanceCookie.class);
            try {
                instanceObj = ck.instanceCreate();
            }
            catch (Exception ex) {
                instanceObj = null;
                Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
            if (instanceObj == null) continue;
            if (instanceObj instanceof JSeparator) {
                comp.add(new JSeparator());
                continue;
            }
            if (instanceObj instanceof BooleanStateAction) {
                comp.add(((BooleanStateAction)instanceObj).getMenuPresenter());
                continue;
            }
            if (!(instanceObj instanceof Action)) continue;
            JMenuItem menuItem = new JMenuItem();
            Actions.connect((JMenuItem)menuItem, (Action)((Action)instanceObj), (boolean)true);
            comp.add(menuItem);
        }
    }

    public int getPersistenceType() {
        return 2;
    }

    public String preferredID() {
        return PREFERRED_ID;
    }

    protected void componentActivated() {
        super.componentActivated();
        if (this.data != null) {
            this.setActivatedNodes(new Node[]{this.data.getNodeDelegate()});
        }
        this.canvas.requestFocusInWindow();
    }

    public boolean canClose() {
        boolean b = super.canClose();
        if (b) {
            CloseCookie cookie = (CloseCookie)this.data.getCookie(CloseCookie.class);
            b = cookie.close();
        }
        return b;
    }

    protected void componentClosed() {
        super.componentClosed();
        this.dispose();
    }

    protected void dispose() {
        this.canvas.dispose();
    }

    public UndoRedo getUndoRedo() {
        if (this.undoRedo == null) {
            return super.getUndoRedo();
        }
        return this.undoRedo;
    }

    public void setSVGDataObject(SVGDataObject data) {
        SVGDataObject old = this.data;
        this.data = data;
        if (old != null) {
            return;
        }
        this.horizontalRuler = new Ruler(this.canvas, 0, this.unitType);
        this.verticalRuler = new Ruler(this.canvas, 1, this.unitType);
        SVGDocument doc = data.getSVGDocument();
        if (doc != null) {
            this.canvas.setSVGDocument(doc);
        }
        this.undoRedo = new CanvasUndoRedo(this.canvas);
    }

    public SVGDataObject getSVGDataObject() {
        return this.data;
    }

    public VectorCanvas getVectorCanvas() {
        return this.canvas;
    }

    public void refresh() {
        if (this.canvas != null) {
            this.canvas.refresh();
        }
        this.repaint();
    }

    public void setStatusText(String text) {
        this.statusBar.getItem(1).setText(text);
    }

    public void setRulerVisible(boolean rulerVisible) {
        this.rulerVisible = rulerVisible;
        if (rulerVisible) {
            this.scrollPane.setColumnHeaderView(this.horizontalRuler);
            this.scrollPane.setRowHeaderView(this.verticalRuler);
        } else {
            this.scrollPane.setColumnHeader(null);
            this.scrollPane.setRowHeader(null);
        }
        this.scrollPane.revalidate();
    }

    public boolean isRulerVisible() {
        return this.rulerVisible;
    }

    JViewport getViewport() {
        return this.scrollPane.getViewport();
    }

    private int getNextUnitType() {
        int nextUnitType;
        switch (this.unitType) {
            case 1: {
                nextUnitType = 0;
                break;
            }
            case 2: {
                nextUnitType = 1;
                break;
            }
            case 3: {
                nextUnitType = 2;
                break;
            }
            default: {
                nextUnitType = 3;
            }
        }
        return nextUnitType;
    }

    private String unitTypeToString(int unitType) {
        String str;
        switch (unitType) {
            case 1: {
                str = "mm";
                break;
            }
            case 2: {
                str = "cm";
                break;
            }
            case 3: {
                str = "in";
                break;
            }
            default: {
                str = "px";
            }
        }
        return str;
    }

    private Point convertMousePoint(Point src, Point dst) {
        double zoom = this.canvas.getZoomFactor();
        dst.setLocation(src.getX() / zoom, src.getY() / zoom);
        return dst;
    }

    private void canvasMouseMoved(MouseEvent evt) {
        this.mousePoint.setLocation(evt.getPoint());
        this.canvasPoint = this.convertMousePoint(evt.getPoint(), this.canvasPoint);
        this.statusBar.getItem(0).setText(this.canvasPoint.x + "," + this.canvasPoint.y);
    }

    private void canvasMouseDragged(MouseEvent evt) {
        this.mousePoint.setLocation(evt.getPoint());
        this.canvasPoint = this.convertMousePoint(evt.getPoint(), this.canvasPoint);
        this.statusBar.getItem(0).setText(this.canvasPoint.x + "," + this.canvasPoint.y);
    }

    private void canvasMouseExited(MouseEvent evt) {
        this.mousePoint.setLocation(-1, -1);
        this.statusBar.getItem(0).setText(" ");
    }

    private void zoomComboItemStateChanged(ItemEvent evt) {
        if (this.zoomComboInAction) {
            return;
        }
        if (evt.getStateChange() == 2) {
            return;
        }
        String value = ((String)this.zoomCombo.getSelectedItem()).trim();
        boolean valid = true;
        double zoom = 1.0;
        if (value.endsWith("%")) {
            try {
                NumberFormat nf = NumberFormat.getPercentInstance();
                Number number = nf.parse(value);
                zoom = number.doubleValue();
            }
            catch (Exception ex) {
                valid = false;
            }
        } else {
            try {
                zoom = Double.parseDouble(value) / 100.0;
            }
            catch (Exception ex) {
                valid = false;
            }
        }
        if (valid && zoom <= 0.0) {
            valid = false;
        }
        if (valid) {
            try {
                this.canvas.setZoomFactor(zoom);
            }
            catch (Exception ex) {
                Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        } else {
            String msg = NbBundle.getMessage(CanvasTopComponent.class, (String)"MSG_InvalidZoomValue.Text");
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
    }

    protected void canvasResized() {
        Rectangle view = new Rectangle(this.lastViewRect);
        AffineTransform at = new AffineTransform(this.lastCanvasAt);
        double zoom = this.canvas.getZoomFactor();
        Dimension canvasSize = this.canvas.getSize();
        if (canvasSize.getWidth() < view.getWidth() && canvasSize.getHeight() < view.getHeight()) {
            return;
        }
        double x = view.getX();
        double y = view.getY();
        double cx = view.getCenterX();
        double cy = view.getCenterY();
        if (this.lastCanvasPoint != null) {
            cx = this.lastCanvasPoint.getX();
            cy = this.lastCanvasPoint.getY();
        }
        double dx = cx - x;
        double dy = cy - y;
        try {
            at = at.createInverse();
        }
        catch (NoninvertibleTransformException ex) {
            // empty catch block
        }
        at.preConcatenate(AffineTransform.getScaleInstance(zoom, zoom));
        double[] pts = new double[]{cx, cy};
        at.transform(pts, 0, pts, 0, 1);
        x = pts[0] - dx;
        y = pts[1] - dy;
        if (this.lastCanvasPoint != null) {
            this.lastCanvasPoint.setLocation(pts[0], pts[1]);
        }
        if (x > 0.0 && y > 0.0) {
            this.scrollPane.getViewport().setViewPosition(new Point((int)x, (int)y));
            this.scrollPane.revalidate();
            this.scrollPane.repaint();
        }
    }

    public class CanvasDeleteAction
    extends AbstractAction {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt) {
            DOMUndoManager undoManager = CanvasTopComponent.this.canvas.getUndoManager();
            String msg = NbBundle.getMessage(CanvasTopComponent.class, (String)"CTL_CanvasDeleteAction");
            undoManager.start(msg);
            try {
                CanvasTopComponent.this.canvas.deleteSelection();
            }
            catch (NullPointerException ex) {
                undoManager.cancel();
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)ex.getMessage(), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            }
            finally {
                undoManager.end();
            }
        }
    }

    public class CanvasPasteAction
    extends AbstractAction {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt) {
            TransferHandler th = CanvasTopComponent.this.canvas.getTransferHandler();
            DOMUndoManager undoManager = CanvasTopComponent.this.canvas.getUndoManager();
            String msg = NbBundle.getMessage(CanvasTopComponent.class, (String)"CTL_CanvasPasteAction");
            undoManager.start(msg);
            try {
                th.importData(CanvasTopComponent.this.canvas, Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null));
            }
            catch (NullPointerException ex) {
                undoManager.cancel();
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)ex.getMessage(), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            }
            finally {
                undoManager.end();
            }
        }
    }

    public class CanvasCopyAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent evt) {
            TransferHandler th = CanvasTopComponent.this.canvas.getTransferHandler();
            try {
                th.exportToClipboard(CanvasTopComponent.this.canvas, Toolkit.getDefaultToolkit().getSystemClipboard(), 1);
            }
            catch (Exception ex) {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)ex.getMessage(), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            }
        }
    }

    public class CanvasCutAction
    extends AbstractAction {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt) {
            TransferHandler th = CanvasTopComponent.this.canvas.getTransferHandler();
            DOMUndoManager undoManager = CanvasTopComponent.this.canvas.getUndoManager();
            String msg = NbBundle.getMessage(CanvasTopComponent.class, (String)"CTL_CanvasCutAction");
            undoManager.start(msg);
            try {
                th.exportToClipboard(CanvasTopComponent.this.canvas, Toolkit.getDefaultToolkit().getSystemClipboard(), 2);
            }
            catch (Exception ex) {
                undoManager.cancel();
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)ex.getMessage(), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            }
            finally {
                undoManager.end();
            }
        }
    }

    private class CanvasView
    extends VectorCanvas {
        public CanvasView(TextEditor textEditor) {
            super(textEditor);
        }

        @Override
        public synchronized void setZoomFactor(double zoomFactor) {
            CanvasTopComponent.this.lastCanvasAt = this.getTransform();
            CanvasTopComponent.this.lastViewRect = CanvasTopComponent.this.scrollPane.getViewport().getViewRect();
            if (CanvasTopComponent.this.mousePoint.getX() > -1.0 && CanvasTopComponent.this.mousePoint.getY() > -1.0) {
                CanvasTopComponent.this.lastCanvasPoint = CanvasTopComponent.this.mousePoint;
            } else {
                CanvasTopComponent.this.lastCanvasPoint = null;
            }
            super.setZoomFactor(zoomFactor);
        }
    }

    private class CanvasViewport
    extends JViewport {
        private CanvasViewport() {
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            RegistrationManager.getInstance().paintUnregisteredImage(this, g);
        }
    }
}

