/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.canvas;

import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.text.TextEditor;
import kiyut.sketsa.undo.DOMUndoManager;
import org.openide.awt.UndoRedo;
import org.openide.util.ChangeSupport;

public class CanvasUndoRedo
implements UndoRedo {
    protected DOMUndoManager undoManager;
    protected VectorCanvas canvas;
    protected ChangeSupport changeSupport;

    public CanvasUndoRedo(VectorCanvas canvas) {
        this.canvas = canvas;
        this.undoManager = canvas.getUndoManager();
        this.changeSupport = new ChangeSupport((Object)this);
        this.undoManager.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                CanvasUndoRedo.this.changeSupport.fireChange();
            }
        });
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public boolean canUndo() {
        return this.undoManager.canUndo();
    }

    public boolean canRedo() {
        return this.undoManager.canRedo();
    }

    public synchronized void undo() throws CannotUndoException {
        this.undoManager.undo();
        TextEditor textEditor = this.canvas.getTextEditor();
        if (textEditor.isEditable()) {
            textEditor.stopEdit();
        }
        this.canvas.getCanvasSelection().clearSelection();
        this.canvas.setTool(this.canvas.getTool());
        this.canvas.refresh();
    }

    public synchronized void redo() throws CannotRedoException {
        this.undoManager.redo();
        if (this.canvas.getTextEditor().isEditable()) {
            this.canvas.getTextEditor().stopEdit();
        }
        this.canvas.getCanvasSelection().clearSelection();
        this.canvas.setTool(this.canvas.getTool());
        this.canvas.refresh();
    }

    public synchronized String getUndoPresentationName() {
        return "";
    }

    public synchronized String getRedoPresentationName() {
        return "";
    }
}

