/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.domeditor;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kiyut.sketsa.canvas.CanvasUtilities;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.canvas.event.CanvasSelectionAdapter;
import kiyut.sketsa.canvas.event.CanvasSelectionEvent;
import kiyut.sketsa.canvas.tool.SelectionTool;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.EmptyTextNodeFilter;
import kiyut.swing.tree.dom.DOMTree;
import kiyut.swing.tree.dom.DOMTreeModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.traversal.NodeFilter;

public class CanvasDOMTree
extends DOMTree {
    protected VectorCanvas canvas;
    protected boolean treeSelectionInProgress = false;
    protected boolean canvasSelectionInProgress = false;
    protected NodeFilter nodeFilter;
    protected boolean emptyTextVisible;

    public CanvasDOMTree(VectorCanvas canvas) {
        this.canvas = canvas;
        canvas.getCanvasSelection().addSelectionListener(new CanvasSelectionAdapter(){

            @Override
            public void valueChanged(CanvasSelectionEvent evt) {
                CanvasDOMTree.this.canvasSelectionValueChanged(evt);
            }
        });
        this.selectionModel = this.getSelectionModel();
        this.selectionModel.setSelectionMode(4);
        this.selectionModel.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                CanvasDOMTree.this.selectionValueChanged(evt);
            }
        });
        this.emptyTextVisible = true;
        this.setEmptyTextVisible(false);
        this.setIdVisible(true);
        this.setDocument((Document)canvas.getSVGDocument());
    }

    public VectorCanvas getVectorCanvas() {
        return this.canvas;
    }

    public void setSVGDocument(SVGDocument doc) {
        this.setDocument((Document)doc);
    }

    public SVGDocument getSVGDocument() {
        return (SVGDocument)this.getDocument();
    }

    public void setEmptyTextVisible(boolean b) {
        if (b == this.emptyTextVisible) {
            return;
        }
        this.emptyTextVisible = b;
        this.nodeFilter = this.emptyTextVisible ? null : new EmptyTextNodeFilter();
        DOMTreeModel model = (DOMTreeModel)this.getModel();
        model.setNodeFilter(this.nodeFilter);
    }

    public boolean isEmptyTextVisible() {
        return this.emptyTextVisible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void canvasSelectionValueChanged(CanvasSelectionEvent evt) {
        if (this.treeSelectionInProgress) {
            return;
        }
        List<SVGElement> list = evt.getSelectionList();
        if (list == null) {
            return;
        }
        if (list.isEmpty()) {
            return;
        }
        TreePath[] treePaths = new TreePath[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Node node = (Node)list.get(i);
            DOMTreeModel domTreeModel = (DOMTreeModel)this.getModel();
            TreeNode treeNode = domTreeModel.getTreeNode(node);
            if (treeNode == null) continue;
            Object[] treeNodes = domTreeModel.getPathToRoot(treeNode);
            treePaths[i] = new TreePath(treeNodes);
        }
        this.canvasSelectionInProgress = true;
        try {
            this.setSelectionPaths(treePaths);
        }
        finally {
            this.canvasSelectionInProgress = false;
        }
        final TreePath lastPath = treePaths[treePaths.length - 1];
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CanvasDOMTree.this.scrollPathToVisible(lastPath);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void selectionValueChanged(TreeSelectionEvent evt) {
        if (this.canvasSelectionInProgress) {
            return;
        }
        ArrayList<SVGElement> list = new ArrayList<SVGElement>();
        TreePath[] treePaths = this.getSelectionPaths();
        if (treePaths == null) {
            return;
        }
        for (int i = 0; i < treePaths.length; ++i) {
            Element elt;
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)treePaths[i].getLastPathComponent();
            Object node = treeNode.getUserObject();
            if (!(node instanceof Element) || !CanvasUtilities.isSelectableElement(elt = (Element)node)) continue;
            list.add((SVGElement)elt);
        }
        this.treeSelectionInProgress = true;
        Collections.reverse(list);
        try {
            this.canvas.getCanvasSelection().setSelectionList(list);
            SelectionTool selectionTool = this.canvas.getCanvasSelection().getSelectionTool();
            if (selectionTool != null) {
                this.canvas.setTool(selectionTool);
            }
        }
        finally {
            this.treeSelectionInProgress = false;
        }
        this.canvas.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveSelectedUp() {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        DOMTreeModel model = (DOMTreeModel)this.getModel();
        if (treeNode.getUserObject() == ((SVGDocument)model.getDocument()).getRootElement()) {
            return;
        }
        if (treeNode.getParent() == treeNode.getRoot()) {
            return;
        }
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Move Node");
        try {
            model.moveNodeUp(treeNode);
        }
        finally {
            undoManager.end();
        }
        Node domNode = (Node)treeNode.getUserObject();
        treeNode = (DefaultMutableTreeNode)model.getTreeNode(domNode);
        final TreePath treePath = new TreePath(treeNode.getPath());
        this.setSelectionPath(treePath);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CanvasDOMTree.this.scrollPathToVisible(treePath);
            }
        });
        this.canvas.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveSelectedDown() {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        DOMTreeModel model = (DOMTreeModel)this.getModel();
        if (treeNode.getUserObject() == ((SVGDocument)model.getDocument()).getRootElement()) {
            return;
        }
        if (treeNode.getParent() == treeNode.getRoot()) {
            return;
        }
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Move Node");
        try {
            model.moveNodeDown(treeNode);
        }
        finally {
            undoManager.end();
        }
        Node domNode = (Node)treeNode.getUserObject();
        treeNode = (DefaultMutableTreeNode)model.getTreeNode(domNode);
        final TreePath treePath = new TreePath(treeNode.getPath());
        this.setSelectionPath(treePath);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CanvasDOMTree.this.scrollPathToVisible(treePath);
            }
        });
        this.canvas.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelected() {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        DOMTreeModel model = (DOMTreeModel)this.getModel();
        if (treeNode.getUserObject() == ((SVGDocument)model.getDocument()).getRootElement()) {
            return;
        }
        if (treeNode.getParent() == treeNode.getRoot()) {
            return;
        }
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Remove Node");
        try {
            model.removeNode(treeNode);
        }
        finally {
            undoManager.end();
        }
        this.canvas.refresh();
    }

    public void addToSelected(Node domNode) throws Exception {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (treeNode != null) {
            Node node = (Node)treeNode.getUserObject();
            DOMUndoManager undoManager = this.canvas.getUndoManager();
            undoManager.start("Add Node");
            try {
                node.appendChild(domNode);
                Exception exception = this.canvas.getEditorUserAgent().getException();
                if (exception != null) {
                    throw exception;
                }
            }
            catch (Exception ex) {
                undoManager.cancel();
                Node parent = domNode.getParentNode();
                if (parent != null) {
                    parent.removeChild(domNode);
                }
                this.canvas.getEditorUserAgent().exceptionHandled();
                throw ex;
            }
            finally {
                undoManager.end();
            }
            DOMTreeModel model = (DOMTreeModel)this.getModel();
            treeNode = (DefaultMutableTreeNode)model.getTreeNode(domNode);
            final TreePath treePath = new TreePath(treeNode.getPath());
            this.setSelectionPath(treePath);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CanvasDOMTree.this.scrollPathToVisible(treePath);
                }
            });
            this.canvas.refresh();
        }
    }

    public void addAboveSelected(Node domNode) throws Exception {
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (treeNode != null) {
            Node node = (Node)treeNode.getUserObject();
            Node parentNode = node.getParentNode();
            if (parentNode != null) {
                DOMUndoManager undoManager = this.canvas.getUndoManager();
                undoManager.start("Add Node");
                try {
                    parentNode.insertBefore(domNode, node);
                    Exception exception = this.canvas.getEditorUserAgent().getException();
                    if (exception != null) {
                        throw exception;
                    }
                }
                catch (Exception ex) {
                    undoManager.cancel();
                    Node parent = domNode.getParentNode();
                    if (parent != null) {
                        parent.removeChild(domNode);
                    }
                    this.canvas.getEditorUserAgent().exceptionHandled();
                    throw ex;
                }
                finally {
                    undoManager.end();
                }
                DOMTreeModel model = (DOMTreeModel)this.getModel();
                treeNode = (DefaultMutableTreeNode)model.getTreeNode(domNode);
                final TreePath treePath = new TreePath(treeNode.getPath());
                this.setSelectionPath(treePath);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CanvasDOMTree.this.scrollPathToVisible(treePath);
                    }
                });
                this.canvas.refresh();
            } else {
                throw new NullPointerException("No parent found");
            }
        }
    }
}

