/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.domeditor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import kiyut.sketsa.canvas.VectorCanvas;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.DataTypeUtilities;
import kiyut.sketsa.windows.domeditor.AttributeEditor;
import kiyut.swing.table.dom.AttributeTable;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.SVGCSSEngine;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.parser.PreserveAspectRatioParser;
import org.apache.batik.parser.TransformListParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGCircleElement;
import org.w3c.dom.svg.SVGEllipseElement;
import org.w3c.dom.svg.SVGForeignObjectElement;
import org.w3c.dom.svg.SVGImageElement;
import org.w3c.dom.svg.SVGLineElement;
import org.w3c.dom.svg.SVGPathElement;
import org.w3c.dom.svg.SVGPolygonElement;
import org.w3c.dom.svg.SVGPolylineElement;
import org.w3c.dom.svg.SVGRectElement;
import org.w3c.dom.svg.SVGSVGElement;
import org.w3c.dom.svg.SVGTransformable;
import org.w3c.dom.svg.SVGUseElement;

public class ElementEditor
extends JPanel {
    public static final int ADD_TYPE = 1;
    public static final int EDIT_TYPE = 2;
    private static final String ADD_ACTION_COMMAND = "Add";
    private static final String EDIT_ACTION_COMMAND = "Edit";
    private static final String REMOVE_ACTION_COMMAND = "Remove";
    private ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getName());
    private AttributeTable attributeTable;
    private Element element;
    private VectorCanvas canvas;
    private JButton addButton;
    private JButton editButton;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JTextField nameField;
    private JButton removeButton;
    private JScrollPane scrollPane;

    public ElementEditor() {
        this.initComponents();
        this.initCustomComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.nameField = new JTextField();
        this.jPanel2 = new JPanel();
        this.scrollPane = new JScrollPane();
        this.jPanel3 = new JPanel();
        this.addButton = new JButton();
        this.editButton = new JButton();
        this.removeButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText(this.bundle.getString("CTL_Name.Text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 15);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.nameField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.nameField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.scrollPane, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.addButton.setText(this.bundle.getString("CTL_Add.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.addButton, gridBagConstraints);
        this.editButton.setText(this.bundle.getString("CTL_Edit.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel3.add((Component)this.editButton, gridBagConstraints);
        this.removeButton.setText(this.bundle.getString("CTL_Remove.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel3.add((Component)this.removeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void initCustomComponents() {
        this.attributeTable = new AttributeTable();
        this.scrollPane.setViewportView(this.attributeTable);
        this.attributeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    ElementEditor.this.editAttribute();
                }
            }
        });
        ActionListener buttonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String command = evt.getActionCommand();
                if (command.equalsIgnoreCase(ElementEditor.ADD_ACTION_COMMAND)) {
                    ElementEditor.this.addAttribute();
                } else if (command.equalsIgnoreCase(ElementEditor.EDIT_ACTION_COMMAND)) {
                    ElementEditor.this.editAttribute();
                } else if (command.equalsIgnoreCase(ElementEditor.REMOVE_ACTION_COMMAND)) {
                    ElementEditor.this.removeAttribute();
                }
            }
        };
        this.addButton.setActionCommand(ADD_ACTION_COMMAND);
        this.addButton.addActionListener(buttonListener);
        this.editButton.setActionCommand(EDIT_ACTION_COMMAND);
        this.editButton.addActionListener(buttonListener);
        this.removeButton.setActionCommand(REMOVE_ACTION_COMMAND);
        this.removeButton.addActionListener(buttonListener);
        this.setPreferredSize(new Dimension(350, 250));
    }

    public void setVectorCanvas(VectorCanvas canvas) {
        this.canvas = canvas;
    }

    public void setElement(Element element) {
        this.element = element;
        this.attributeTable.setElement(element);
        if (element == null) {
            return;
        }
        this.nameField.setText(element.getNodeName());
    }

    public Element getElement() {
        return this.element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void editAttribute(Attr attr) {
        boolean editMode = false;
        if (attr != null) {
            editMode = true;
        } else {
            editMode = false;
            attr = this.element.getOwnerDocument().createAttributeNS(null, "attr_name");
        }
        AttributeEditor editor = new AttributeEditor();
        String ns = attr.getNamespaceURI();
        editor.setNamespaceURIEnabled(false);
        if (ns != null) {
            editor.setNamespaceURI(attr.getNamespaceURI());
            editor.setNamespaceURIEnabled(true);
        }
        editor.setAttributeName(attr.getName());
        editor.setAttributeValue(attr.getValue());
        editor.setEditMode(editMode);
        int choice = JOptionPane.showOptionDialog(this, editor, this.bundle.getString("MSG_EditAttribute.Title"), 2, -1, null, null, null);
        if (choice == 0) {
            DOMUndoManager undoManager = this.canvas.getUndoManager();
            undoManager.start("Change Element Attribute");
            try {
                ns = editor.getNamespaceURI(true);
                String name = editor.getAttributeName();
                String value = editor.getAttributeValue();
                this.validateAttribute(this.element, ns, name, value);
                if (editMode) {
                    attr.setValue(value);
                } else {
                    Attr newAttr = this.element.getOwnerDocument().createAttributeNS(ns, name);
                    newAttr.setValue(value);
                    this.element.setAttributeNodeNS(newAttr);
                    attr = newAttr;
                }
                this.attributeTable.refresh();
                this.attributeTable.setSelectedAttribute(attr);
                Exception exception = this.canvas.getEditorUserAgent().getException();
                if (exception != null) {
                    throw exception;
                }
                if (this.canvas != null) {
                    this.canvas.refresh();
                }
            }
            catch (Exception ex) {
                undoManager.cancel();
                this.canvas.getEditorUserAgent().exceptionHandled();
                this.element.setAttributeNodeNS(attr);
                this.attributeTable.setSelectedAttribute(attr);
                JOptionPane.showMessageDialog(this, ex.getMessage(), this.bundle.getString("MSG_Exception.Title"), 0);
            }
            finally {
                undoManager.end();
            }
        }
    }

    private void editAttribute() {
        Attr attr = this.attributeTable.getSelectedAttribute();
        if (attr == null) {
            JOptionPane.showMessageDialog(this, this.bundle.getString("MSG_NoAttributeSelected.Text"), this.bundle.getString("MSG_NoAttributeSelected.Title"), 0);
            return;
        }
        this.editAttribute(attr);
    }

    private void addAttribute() {
        this.editAttribute(null);
    }

    private void removeAttribute() {
        Attr attr;
        int result = JOptionPane.showConfirmDialog(this, this.bundle.getString("MSG_ConfirmRemove.Text"), this.bundle.getString("MSG_ConfirmRemove.Title"), 0);
        if (result == 0 && (attr = this.attributeTable.getSelectedAttribute()) != null) {
            this.element.removeAttributeNode(attr);
            this.attributeTable.refresh();
        }
    }

    private void validateAttribute(Element element, String ns, String name, String value) throws ParseException {
        TransformListParser parser;
        if (element instanceof SVGRectElement) {
            if (name.equals("x") || name.equals("y") || name.equals("width") || name.equals("height") || name.equals("rx") || name.equals("ry")) {
                DataTypeUtilities.validateLength(value);
            }
        } else if (element instanceof SVGCircleElement) {
            if (name.equals("cx") || name.equals("cy") || name.equals("r")) {
                DataTypeUtilities.validateLength(value);
            }
        } else if (element instanceof SVGEllipseElement) {
            if (name.equals("cx") || name.equals("cy") || name.equals("rx") || name.equals("ry")) {
                DataTypeUtilities.validateLength(value);
            }
        } else if (element instanceof SVGLineElement) {
            if (name.equals("x1") || name.equals("y1") || name.equals("x2") || name.equals("y2")) {
                DataTypeUtilities.validateLength(value);
            }
        } else if (element instanceof SVGImageElement || element instanceof SVGUseElement) {
            if (name.equals("x") || name.equals("y") || name.equals("width") || name.equals("height")) {
                DataTypeUtilities.validateLength(value);
            }
        } else if (element instanceof SVGPolygonElement || element instanceof SVGPolylineElement) {
            if (name.equals("points")) {
                DataTypeUtilities.validatePointList(value);
            }
        } else if (element instanceof SVGPathElement && name.equals("d")) {
            DataTypeUtilities.validatePathData(value);
        }
        if (element instanceof SVGTransformable && name.equals("transform")) {
            try {
                parser = new TransformListParser();
                parser.parse(value);
            }
            catch (Exception ex) {
                throw new ParseException("Invalid transform value", -1);
            }
        }
        if ((element instanceof SVGImageElement || element instanceof SVGUseElement || element instanceof SVGSVGElement || element instanceof SVGForeignObjectElement) && name.equals("preserveAspectRatio")) {
            try {
                parser = new PreserveAspectRatioParser();
                parser.parse(value);
            }
            catch (Exception ex) {
                throw new ParseException("Invalid preserveAspectRatio value", -1);
            }
        }
        if (element instanceof CSSStylableElement) {
            CSSStylableElement cssElement = (CSSStylableElement)element;
            SVGOMDocument svgDoc = (SVGOMDocument)element.getOwnerDocument();
            SVGCSSEngine cssEngine = (SVGCSSEngine)svgDoc.getCSSEngine();
            if (name.equalsIgnoreCase("style")) {
                cssEngine.parseStyleDeclaration(cssElement, value);
            } else if (cssEngine.getPropertyIndex(name) != -1) {
                cssEngine.parsePropertyValue(cssElement, name, value);
            }
        }
    }
}

