/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.DOMUtilities;
import kiyut.sketsa.windows.properties.AbstractGraphicsProperties;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGStylable;

public class FilterProperties
extends AbstractGraphicsProperties {
    private static ResourceBundle bundle = ResourceBundle.getBundle("kiyut.sketsa.windows.properties.FilterProperties");
    private boolean editing = false;
    private boolean refreshing = false;
    private CSSStyleDeclaration computedStyle;
    private JRadioButton filterTypeBlankRadio;
    private ButtonGroup filterTypeButtonGroup;
    private JRadioButton filterTypeNoneRadio;
    private JComboBox filterURICombo;
    private JScrollPane jScrollPane1;
    private JPanel mainPane;

    public FilterProperties() {
        this.initComponents();
        this.initCustomComponents();
    }

    private void initComponents() {
        this.filterTypeButtonGroup = new ButtonGroup();
        this.filterTypeBlankRadio = new JRadioButton();
        this.jScrollPane1 = new JScrollPane();
        this.mainPane = new JPanel();
        JPanel jPanel1 = new JPanel();
        this.filterTypeNoneRadio = new JRadioButton();
        this.filterURICombo = new JComboBox();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel2 = new JLabel();
        JPanel jPanel2 = new JPanel();
        this.filterTypeButtonGroup.add(this.filterTypeBlankRadio);
        this.filterTypeBlankRadio.setText("jRadioButton3");
        this.setLayout(new BorderLayout());
        this.mainPane.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.mainPane.setLayout(new GridBagLayout());
        jPanel1.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(bundle.getString("CTL_Filter.Text")), BorderFactory.createEmptyBorder(6, 12, 12, 12)));
        jPanel1.setLayout(new GridBagLayout());
        this.filterTypeButtonGroup.add(this.filterTypeNoneRadio);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        jPanel1.add((Component)this.filterTypeNoneRadio, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        jPanel1.add((Component)this.filterURICombo, gridBagConstraints);
        jLabel1.setText(bundle.getString("CTL_None.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        jPanel1.add((Component)jLabel1, gridBagConstraints);
        jLabel2.setText(bundle.getString("CTL_URI.Text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 6);
        jPanel1.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.mainPane.add((Component)jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.mainPane.add((Component)jPanel2, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.mainPane);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void initCustomComponents() {
        this.filterTypeNoneRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterProperties.this.filterTypeNoneRadioActionPerformed(evt);
            }
        });
        this.filterURICombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FilterProperties.this.filterURIComboItemStateChanged(e);
            }
        });
        String prototypeDisplayValue = "none";
        this.filterURICombo.setPrototypeDisplayValue(prototypeDisplayValue);
    }

    @Override
    public void refresh() {
        if (this.editing) {
            return;
        }
        if (this.canvas == null) {
            return;
        }
        this.refreshing = true;
        this.refreshURIData();
        String filterURI = null;
        boolean multiFilterURI = false;
        for (int i = 0; i < this.selectionList.size(); ++i) {
            SVGElement element;
            if (!(this.selectionList.get(i) instanceof SVGElement) || !((element = (SVGElement)this.selectionList.get(i)) instanceof SVGStylable)) continue;
            ViewCSS viewCSS = (ViewCSS)((Object)element.getOwnerDocument().getDocumentElement());
            this.computedStyle = viewCSS.getComputedStyle((Element)element, null);
            if (multiFilterURI) continue;
            try {
                String str = this.computedStyle.getPropertyValue("filter");
                if (!str.equals("none")) {
                    int indexOf = str.lastIndexOf("#");
                    str = str.substring(indexOf + 1, str.length() - 1);
                }
                if (filterURI == null) {
                    filterURI = str;
                }
                if (filterURI.equals(str)) continue;
                multiFilterURI = true;
                continue;
            }
            catch (DOMException dex) {
                multiFilterURI = true;
            }
        }
        if (multiFilterURI) {
            this.filterTypeBlankRadio.setSelected(true);
            this.filterURICombo.setSelectedIndex(-1);
        } else if (filterURI.equals("none")) {
            this.filterTypeNoneRadio.setSelected(true);
            this.filterURICombo.setSelectedIndex(-1);
        } else {
            this.filterTypeBlankRadio.setSelected(true);
            this.filterURICombo.setSelectedItem(filterURI);
        }
        this.refreshing = false;
    }

    private void refreshURIData() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.filterURICombo.getModel();
        model.removeAllElements();
        SVGDocument doc = this.canvas.getSVGDocument();
        NodeList nodeList = doc.getElementsByTagNameNS("http://www.w3.org/2000/svg", "filter");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            SVGElement elt = (SVGElement)nodeList.item(i);
            model.addElement(elt.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterTypeNoneRadioActionPerformed(ActionEvent evt) {
        if (this.refreshing) {
            return;
        }
        if (this.canvas == null) {
            return;
        }
        if (this.selectionList.isEmpty()) {
            return;
        }
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change Filter none");
        String attr = "filter";
        try {
            for (int i = 0; i < this.selectionList.size(); ++i) {
                Node node = (Node)this.selectionList.get(i);
                if (!(node instanceof SVGStylable)) continue;
                DOMUtilities.updateProperty((SVGStylable)node, null, attr, "none");
            }
            this.filterURICombo.setSelectedIndex(-1);
        }
        catch (DOMException ex) {
            this.editing = false;
            this.refresh();
        }
        finally {
            undoManager.end();
            this.editing = false;
            if (this.canvas != null) {
                this.canvas.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterURIComboItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            return;
        }
        if (this.refreshing) {
            return;
        }
        if (this.canvas == null) {
            return;
        }
        if (this.selectionList.isEmpty()) {
            return;
        }
        JComboBox combo = (JComboBox)evt.getSource();
        String newUri = (String)combo.getSelectedItem();
        String attr = "filter";
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change Filter URI property");
        try {
            for (int i = 0; i < this.selectionList.size(); ++i) {
                Node node = (Node)this.selectionList.get(i);
                if (!(node instanceof SVGStylable)) continue;
                if (newUri == null) {
                    DOMUtilities.updateProperty((SVGStylable)node, null, attr, null);
                    continue;
                }
                DOMUtilities.updateProperty((SVGStylable)node, null, attr, "url(#" + newUri + ")");
            }
            this.filterTypeBlankRadio.setSelected(true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Value Error", 0);
            this.editing = false;
            this.refresh();
        }
        finally {
            undoManager.end();
            this.editing = false;
            if (this.canvas != null) {
                this.canvas.refresh();
            }
        }
    }
}

