/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.properties.geometry;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.URI;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kiyut.sketsa.io.DefaultFileFilter;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.util.DataTypeUtilities;
import kiyut.sketsa.util.IOUtilities;
import kiyut.sketsa.windows.properties.geometry.ElementGeometryProperties;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGImageElement;
import org.w3c.dom.svg.SVGPreserveAspectRatio;

public class ImageGeometryProperties
extends ElementGeometryProperties {
    private boolean editing = false;
    private boolean refreshing = false;
    private JPanel attributePane;
    private JButton browseButton;
    private JTextField hField;
    private JTextField hrefField;
    private JLabel jLabel7;
    private JComboBox preserveAspectRatioAlignCombo;
    private JComboBox preserveAspectRatioMeetOrSliceCombo;
    private JTextField wField;
    private JTextField xField;
    private JTextField yField;

    public ImageGeometryProperties() {
        this.initComponents();
        this.initCustomComponents();
    }

    private void initComponents() {
        this.attributePane = new JPanel();
        JLabel jLabel2 = new JLabel();
        this.xField = new JTextField();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        this.yField = new JTextField();
        this.wField = new JTextField();
        this.hField = new JTextField();
        JLabel jLabel6 = new JLabel();
        this.hrefField = new JTextField();
        this.browseButton = new JButton();
        this.jLabel7 = new JLabel();
        this.preserveAspectRatioAlignCombo = new JComboBox();
        this.preserveAspectRatioMeetOrSliceCombo = new JComboBox();
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(150, 200));
        this.setPreferredSize(new Dimension(150, 200));
        this.attributePane.setLayout(new GridBagLayout());
        jLabel2.setText("x");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.attributePane.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.attributePane.add((Component)this.xField, gridBagConstraints);
        jLabel3.setText("y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 5);
        this.attributePane.add((Component)jLabel3, gridBagConstraints);
        jLabel4.setText("w");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 5);
        this.attributePane.add((Component)jLabel4, gridBagConstraints);
        jLabel5.setText("h");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 5);
        this.attributePane.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.attributePane.add((Component)this.yField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.attributePane.add((Component)this.wField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.attributePane.add((Component)this.hField, gridBagConstraints);
        jLabel6.setText("href");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 5);
        this.attributePane.add((Component)jLabel6, gridBagConstraints);
        this.hrefField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.attributePane.add((Component)this.hrefField, gridBagConstraints);
        this.browseButton.setText("Browse");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.attributePane.add((Component)this.browseButton, gridBagConstraints);
        this.jLabel7.setText("preserveAspectRatio");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.attributePane.add((Component)this.jLabel7, gridBagConstraints);
        this.preserveAspectRatioAlignCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"none", "xMinYMin", "xMidYMin", "xMaxYMin", "xMinYMid", "xMidYMid", "xMaxYMid", "xMinYMax", "xMidYMax", "xMaxYMax"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.attributePane.add((Component)this.preserveAspectRatioAlignCombo, gridBagConstraints);
        this.preserveAspectRatioMeetOrSliceCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"meet", "slice"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 0, 0);
        this.attributePane.add((Component)this.preserveAspectRatioMeetOrSliceCombo, gridBagConstraints);
        this.add((Component)this.attributePane, "North");
    }

    private void initCustomComponents() {
        ActionListener fieldActionHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageGeometryProperties.this.fieldActionPerformed(e);
            }
        };
        this.xField.addActionListener(fieldActionHandler);
        this.yField.addActionListener(fieldActionHandler);
        this.wField.addActionListener(fieldActionHandler);
        this.hField.addActionListener(fieldActionHandler);
        ActionListener browseActionHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageGeometryProperties.this.browseActionPerformed(evt);
            }
        };
        this.browseButton.addActionListener(browseActionHandler);
        this.preserveAspectRatioAlignCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ImageGeometryProperties.this.preserveAspectRatioItemStateChanged(evt);
            }
        });
        this.preserveAspectRatioMeetOrSliceCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ImageGeometryProperties.this.preserveAspectRatioItemStateChanged(evt);
            }
        });
        this.preserveAspectRatioAlignCombo.setPrototypeDisplayValue("xMaxYMax");
        this.preserveAspectRatioMeetOrSliceCombo.setPrototypeDisplayValue("meet");
    }

    @Override
    public void refreshProperties() {
        if (this.element == null) {
            return;
        }
        if (this.editing) {
            return;
        }
        this.refreshing = true;
        SVGImageElement elt = (SVGImageElement)this.element;
        try {
            this.xField.setText(elt.getAttributeNS(null, "x"));
        }
        catch (Exception ex) {
            this.xField.setText("");
        }
        try {
            this.yField.setText(elt.getAttributeNS(null, "y"));
        }
        catch (Exception ex) {
            this.yField.setText("");
        }
        try {
            this.wField.setText(elt.getAttributeNS(null, "width"));
        }
        catch (Exception ex) {
            this.wField.setText("");
        }
        try {
            this.hField.setText(elt.getAttributeNS(null, "height"));
        }
        catch (Exception ex) {
            this.hField.setText("");
        }
        boolean hrefEnabled = true;
        String href = elt.getHref().getBaseVal();
        if (href.length() >= 50 && (href = href.substring(0, 50).toLowerCase()).startsWith("data:image")) {
            hrefEnabled = false;
        }
        if (hrefEnabled) {
            this.hrefField.setText(elt.getHref().getBaseVal());
        } else {
            int indexOf = href.indexOf(";base64,");
            if (indexOf > 0 && indexOf + 8 <= href.length()) {
                href = href.substring(0, indexOf + 8).toLowerCase();
                this.hrefField.setText(href);
            } else {
                this.hrefField.setText("data:image/...");
            }
        }
        this.hrefField.setEnabled(hrefEnabled);
        int index = -1;
        SVGPreserveAspectRatio preserveAspectRatio = elt.getPreserveAspectRatio().getBaseVal();
        switch (preserveAspectRatio.getAlign()) {
            case 1: {
                index = 0;
                break;
            }
            case 2: {
                index = 1;
                break;
            }
            case 3: {
                index = 2;
                break;
            }
            case 4: {
                index = 3;
                break;
            }
            case 5: {
                index = 4;
                break;
            }
            case 6: {
                index = 5;
                break;
            }
            case 7: {
                index = 6;
                break;
            }
            case 8: {
                index = 7;
                break;
            }
            case 9: {
                index = 8;
                break;
            }
            case 10: {
                index = 9;
            }
        }
        this.preserveAspectRatioAlignCombo.setSelectedIndex(index);
        index = -1;
        switch (preserveAspectRatio.getMeetOrSlice()) {
            case 1: {
                index = 0;
                break;
            }
            case 2: {
                index = 1;
            }
        }
        this.preserveAspectRatioMeetOrSliceCombo.setSelectedIndex(index);
        this.refreshing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fieldActionPerformed(ActionEvent e) {
        if (this.refreshing) {
            return;
        }
        SVGImageElement elt = (SVGImageElement)this.element;
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change Image geometry attributes");
        try {
            String attrName = "x";
            String str = this.xField.getText().trim();
            DataTypeUtilities.validateLength(str);
            elt.setAttributeNS(null, attrName, str);
            attrName = "y";
            str = this.yField.getText().trim();
            DataTypeUtilities.validateLength(str);
            elt.setAttributeNS(null, attrName, str);
            attrName = "width";
            str = this.wField.getText().trim();
            Number number = DataTypeUtilities.validateLength(str);
            if (number.floatValue() < 0.0f) {
                throw new RuntimeException(bundle.getString("MSG_NegativeWidth.Text"));
            }
            elt.setAttributeNS(null, attrName, str);
            attrName = "height";
            str = this.hField.getText().trim();
            number = DataTypeUtilities.validateLength(str);
            if (number.floatValue() < 0.0f) {
                throw new RuntimeException(bundle.getString("MSG_NegativeHeight.Text"));
            }
            elt.setAttributeNS(null, attrName, str);
        }
        catch (Exception ex) {
            this.refreshProperties();
            JOptionPane.showMessageDialog(this, ex.getMessage(), bundle.getString("MSG_Exception.Title"), 0);
        }
        finally {
            undoManager.end();
            this.editing = false;
        }
        if (this.canvas != null) {
            this.canvas.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void browseActionPerformed(ActionEvent evt) {
        if (this.refreshing) {
            return;
        }
        DefaultFileFilter fileFilter = new DefaultFileFilter();
        fileFilter.addExtension("svg");
        fileFilter.addExtension("svgz");
        fileFilter.addExtension("png");
        fileFilter.addExtension("jpg");
        fileFilter.setDescription("Image Files");
        JFileChooser fc = IOUtilities.getFileChooser();
        fc.setFileFilter(fileFilter);
        fc.setFileSelectionMode(0);
        int choice = fc.showOpenDialog(this);
        if (choice != 0) {
            return;
        }
        String href = fc.getSelectedFile().toString();
        SVGImageElement elt = (SVGImageElement)this.element;
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change Image href");
        try {
            File file = new File(href);
            SVGDocument doc = (SVGDocument)elt.getOwnerDocument();
            URI baseUri = new URI(doc.getDocumentURI());
            File baseFile = new File(baseUri);
            String filename = IOUtilities.relativize(baseFile, file);
            String xlinkNS = "http://www.w3.org/1999/xlink";
            elt.setAttributeNS(xlinkNS, "xlink:href", filename);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Value Error", 0);
        }
        finally {
            undoManager.end();
            this.editing = false;
            this.refreshProperties();
        }
        if (this.canvas != null) {
            this.canvas.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preserveAspectRatioItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 2) {
            return;
        }
        if (this.refreshing) {
            return;
        }
        int alignIndex = this.preserveAspectRatioAlignCombo.getSelectedIndex();
        int meetOrSliceIndex = this.preserveAspectRatioMeetOrSliceCombo.getSelectedIndex();
        short align = 6;
        short meetOrSlice = 1;
        switch (alignIndex) {
            case 0: {
                align = 1;
                break;
            }
            case 1: {
                align = 2;
                break;
            }
            case 2: {
                align = 3;
                break;
            }
            case 3: {
                align = 4;
                break;
            }
            case 4: {
                align = 5;
                break;
            }
            case 5: {
                align = 6;
                break;
            }
            case 6: {
                align = 7;
                break;
            }
            case 7: {
                align = 8;
                break;
            }
            case 8: {
                align = 9;
                break;
            }
            case 9: {
                align = 10;
            }
        }
        switch (meetOrSliceIndex) {
            case 0: {
                meetOrSlice = 1;
                break;
            }
            case 1: {
                meetOrSlice = 2;
            }
        }
        boolean isDefault = false;
        if (align == 6 && meetOrSlice == 1) {
            isDefault = true;
        }
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change Image preserveAspectRatio");
        try {
            SVGImageElement elt = (SVGImageElement)this.element;
            SVGPreserveAspectRatio preserveAspectRatio = elt.getPreserveAspectRatio().getBaseVal();
            if (!isDefault) {
                preserveAspectRatio.setAlign(align);
                preserveAspectRatio.setMeetOrSlice(meetOrSlice);
            } else {
                String attrName = "preserveAspectRatio";
                elt.removeAttributeNS(null, attrName);
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Value Error", 0);
        }
        finally {
            this.editing = false;
            undoManager.end();
            this.refreshProperties();
        }
        if (this.canvas != null) {
            this.canvas.refresh();
        }
    }
}

