/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.windows.properties.geometry;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import kiyut.sketsa.undo.DOMUndoManager;
import kiyut.sketsa.windows.properties.geometry.ElementGeometryProperties;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGPointList;
import org.w3c.dom.svg.SVGPolygonElement;

public class PolygonGeometryProperties
extends ElementGeometryProperties {
    private boolean editing;
    private JPanel attributePane;
    private JScrollPane jScrollPane1;
    private JPanel mainPane;
    private JTable pointTable;
    private JTextField xField;
    private JTextField yField;

    public PolygonGeometryProperties() {
        this.initComponents();
        this.initCustomComponents();
        this.editing = false;
    }

    private void initComponents() {
        this.mainPane = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.pointTable = new JTable();
        this.attributePane = new JPanel();
        JLabel jLabel2 = new JLabel();
        this.xField = new JTextField();
        JLabel jLabel3 = new JLabel();
        this.yField = new JTextField();
        this.setLayout(new BorderLayout());
        this.mainPane.setLayout(new GridBagLayout());
        this.jScrollPane1.setPreferredSize(new Dimension(100, 60));
        this.pointTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Point", "Value"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.pointTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.mainPane.add((Component)this.jScrollPane1, gridBagConstraints);
        this.attributePane.setLayout(new GridBagLayout());
        jLabel2.setText("x");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.attributePane.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.attributePane.add((Component)this.xField, gridBagConstraints);
        jLabel3.setText("y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.attributePane.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.attributePane.add((Component)this.yField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.mainPane.add((Component)this.attributePane, gridBagConstraints);
        this.add((Component)this.mainPane, "Center");
    }

    private void initCustomComponents() {
        PointTableModel pointTableModel = new PointTableModel();
        this.pointTable.setModel(pointTableModel);
        TableColumn tableColumn = this.pointTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(34);
        tableColumn.setMaxWidth(100);
        this.pointTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PolygonGeometryProperties.this.selectionValueChanged(e);
            }
        });
        ActionListener fieldActionHandler = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolygonGeometryProperties.this.fieldActionPerformed(e);
            }
        };
        this.xField.addActionListener(fieldActionHandler);
        this.yField.addActionListener(fieldActionHandler);
    }

    @Override
    public void refreshProperties() {
        if (this.element == null) {
            return;
        }
        if (this.editing) {
            return;
        }
        SVGPolygonElement elt = (SVGPolygonElement)this.element;
        SVGPointList svgPointList = elt.getPoints();
        PointTableModel model = (PointTableModel)this.pointTable.getModel();
        model.setSVGPointList(svgPointList);
    }

    private void selectionValueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int index = this.pointTable.getSelectedRow();
        if (index < 0) {
            this.xField.setText("");
            this.yField.setText("");
            return;
        }
        PointTableModel model = (PointTableModel)this.pointTable.getModel();
        SVGPointList svgPointList = model.getSVGPointList();
        SVGPoint svgPoint = svgPointList.getItem(index);
        this.xField.setText(svgPoint.getX() + "");
        this.yField.setText(svgPoint.getY() + "");
    }

    private void fieldActionPerformed(ActionEvent e) {
        float f;
        SVGPolygonElement polyElement = (SVGPolygonElement)this.element;
        ListSelectionModel selectionModel = this.pointTable.getSelectionModel();
        int index = selectionModel.getMaxSelectionIndex();
        PointTableModel model = (PointTableModel)this.pointTable.getModel();
        SVGPointList svgPointList = model.getSVGPointList();
        SVGPoint svgPoint = svgPointList.getItem(index);
        this.editing = true;
        DOMUndoManager undoManager = this.canvas.getUndoManager();
        undoManager.start("Change Polygon Points");
        try {
            f = Float.parseFloat(this.xField.getText());
            svgPoint.setX(f);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            f = Float.parseFloat(this.yField.getText());
            svgPoint.setY(f);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        undoManager.end();
        this.editing = false;
        this.refreshProperties();
        if (this.canvas != null) {
            this.canvas.refresh();
        }
        selectionModel.setSelectionInterval(index, index);
    }

    private class PointTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"Point", "Value"};
        private SVGPointList svgPointList;

        public void setSVGPointList(SVGPointList svgPointList) {
            this.svgPointList = svgPointList;
            this.fireTableDataChanged();
        }

        public SVGPointList getSVGPointList() {
            return this.svgPointList;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.svgPointList == null) {
                return 0;
            }
            return this.svgPointList.getNumberOfItems();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.svgPointList == null) {
                return null;
            }
            if (columnIndex == 0) {
                return new Integer(rowIndex);
            }
            SVGPoint p = this.svgPointList.getItem(rowIndex);
            String str = "[" + p.getX() + ";" + p.getY() + "]";
            return str;
        }
    }
}

