/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.xmleditor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import kiyut.swing.dialog.DialogESC;

public class FindPane
extends JPanel {
    public static final String VALUE_PROPERTY = "value_property";
    public static final int CLOSED_OPTION = -1;
    public static final int FIND_OPTION = 0;
    public static final String CASE_SENSITIVE = "case_sensitive";
    private ResourceBundle bundle = ResourceBundle.getBundle(this.getClass().getName());
    protected int value = -1;
    protected int historySize = 8;
    protected Map<String, Object> optionMap;
    private JPanel buttonPane;
    private JCheckBox caseSenstiveCheck;
    private JButton closeButton;
    private JPanel fillerPane;
    private JButton findButton;
    private JComboBox findTextCombo;
    private JLabel jLabel1;
    private JPanel jPanel1;

    public FindPane() {
        this.initComponents();
        this.optionMap = new HashMap<String, Object>();
        this.optionMap.put(CASE_SENSITIVE, false);
    }

    private void initComponents() {
        this.buttonPane = new JPanel();
        this.findButton = new JButton();
        this.closeButton = new JButton();
        this.fillerPane = new JPanel();
        this.jPanel1 = new JPanel();
        this.caseSenstiveCheck = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.findTextCombo = new JComboBox();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridBagLayout());
        this.buttonPane.setLayout(new GridBagLayout());
        this.findButton.setText(this.bundle.getString("CTL_Find"));
        this.findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindPane.this.findButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.buttonPane.add((Component)this.findButton, gridBagConstraints);
        this.closeButton.setText(this.bundle.getString("CTL_Close"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindPane.this.closeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.buttonPane.add((Component)this.closeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.buttonPane, gridBagConstraints);
        this.fillerPane.setPreferredSize(new Dimension(370, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fillerPane, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.caseSenstiveCheck.setText(this.bundle.getString("CTL_CaseSensitive"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel1.add((Component)this.caseSenstiveCheck, gridBagConstraints);
        this.jLabel1.setText(this.bundle.getString("CTL_FindWhat"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.findTextCombo.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.findTextCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setValue(-1);
    }

    private void findButtonActionPerformed(ActionEvent evt) {
        String text = (String)this.findTextCombo.getSelectedItem();
        if (text != null && text.trim().length() > 0 && !text.equals(this.findTextCombo.getItemAt(0))) {
            this.findTextCombo.insertItemAt(text, 0);
            while (this.findTextCombo.getItemCount() > this.historySize) {
                this.findTextCombo.removeItemAt(this.historySize);
            }
        }
        this.optionMap.put(CASE_SENSITIVE, this.caseSenstiveCheck.isSelected());
        this.setValue(0);
    }

    public int showDialog(Component parentComponent) {
        this.findTextCombo.setSelectedIndex(-1);
        JDialog dialog = this.createDialog(parentComponent, this.bundle.getString("CTL_Title"));
        dialog.setVisible(true);
        dialog.dispose();
        int choice = this.getValue();
        return choice;
    }

    private JDialog createDialog(Component parentComponent, String title) {
        final DialogESC dialog = DialogESC.createDialog(parentComponent, title);
        dialog.setDefaultCloseOperation(2);
        dialog.setContentPane(this);
        dialog.setResizable(false);
        dialog.pack();
        dialog.setLocationRelativeTo(parentComponent);
        JRootPane root = SwingUtilities.getRootPane(this.findButton);
        if (root != null) {
            root.setDefaultButton(this.findButton);
        }
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (dialog.isVisible() && event.getSource() == FindPane.this && event.getPropertyName().equals(FindPane.VALUE_PROPERTY) && event.getNewValue() != null && FindPane.this.value == -1) {
                    dialog.setVisible(false);
                }
            }
        });
        return dialog;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int newValue) {
        this.value = newValue;
        this.firePropertyChange(VALUE_PROPERTY, null, new Integer(newValue));
    }

    public String getFindText() {
        Object obj = this.findTextCombo.getSelectedItem();
        if (obj != null) {
            return (String)obj;
        }
        return null;
    }

    public void setFindText(String text) {
    }

    public void setFindTextHistory(List<String> history) {
        this.findTextCombo.removeAllItems();
        for (String str : history) {
            this.findTextCombo.addItem(str);
        }
    }

    public List<String> getFindTextHistory() {
        int size = this.findTextCombo.getItemCount();
        ArrayList<String> history = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            history.add(this.findTextCombo.getItemAt(i).toString());
        }
        return history;
    }

    public Map<String, Object> getOptionMap() {
        return this.optionMap;
    }
}

