/*
 * Decompiled with CFR 0.152.
 */
package kiyut.sketsa.xmleditor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;

public class LineNumber
extends JPanel {
    protected static final Border OUTER = new MatteBorder(0, 0, 0, 2, Color.GRAY);
    protected static final int PREFS_HEIGHT = Short.MAX_VALUE;
    protected static final String EMPTY_STRING = "";
    protected JTextComponent textComponent;
    protected int borderGap;
    protected Color currentLineForeground;
    protected int alignment;
    protected float alignmentX;
    protected int minimumDisplayDigits;
    protected int lastDigits;
    protected int lastHeight;
    protected int lastLine;

    public LineNumber(JTextComponent component) {
        this(component, 3);
    }

    public LineNumber(JTextComponent component, int minimumDisplayDigits) {
        this.textComponent = component;
        this.setFont(component.getFont());
        this.setBorderGap(5);
        this.setCurrentLineForeground(Color.RED);
        this.setAlignment(4);
        this.setMinimumDisplayDigits(minimumDisplayDigits);
        component.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                LineNumber.this.documentChanged(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                LineNumber.this.documentChanged(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        component.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                LineNumber.this.caretUpdate(e);
            }
        });
    }

    public int getBorderGap() {
        return this.borderGap;
    }

    public void setBorderGap(int borderGap) {
        this.borderGap = borderGap;
        EmptyBorder inner = new EmptyBorder(0, borderGap, 0, borderGap);
        this.setBorder(new CompoundBorder(OUTER, inner));
        this.lastDigits = 0;
        this.setPreferredWidth();
    }

    public Color getCurrentLineForeground() {
        return this.currentLineForeground == null ? this.getForeground() : this.currentLineForeground;
    }

    public void setCurrentLineForeground(Color currentLineForeground) {
        this.currentLineForeground = currentLineForeground;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
        this.alignmentX = alignment == 4 ? 1.0f : (alignment == 2 ? 0.0f : 0.5f);
    }

    public int getMinimumDisplayDigits() {
        return this.minimumDisplayDigits;
    }

    public void setMinimumDisplayDigits(int minimumDisplayDigits) {
        this.minimumDisplayDigits = minimumDisplayDigits;
        this.setPreferredWidth();
    }

    protected void setPreferredWidth() {
        Element root = this.textComponent.getDocument().getDefaultRootElement();
        int lines = root.getElementCount();
        int digits = Math.max(String.valueOf(lines).length(), this.minimumDisplayDigits);
        if (this.lastDigits != digits) {
            this.lastDigits = digits;
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int width = fontMetrics.charWidth('0') * digits;
            Insets insets = this.getInsets();
            int preferredWidth = insets.left + insets.right + width;
            Dimension d = this.getPreferredSize();
            d.setSize(preferredWidth, Short.MAX_VALUE);
            this.setPreferredSize(d);
            this.setSize(d);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        Insets insets = this.getInsets();
        int availableWidth = this.getSize().width - insets.left - insets.right;
        Rectangle clip = g.getClipBounds();
        int lineHeight = fontMetrics.getHeight();
        int startOffset = this.textComponent.getInsets().top + fontMetrics.getAscent();
        int linesToDraw = clip.height / lineHeight + 1;
        int y = clip.y / lineHeight * lineHeight + startOffset;
        Point viewPoint = new Point(0, y);
        int preferredHeight = this.textComponent.getPreferredSize().height;
        for (int i = 0; i <= linesToDraw; ++i) {
            if (this.isCurrentLine(viewPoint)) {
                g2d.setColor(this.getCurrentLineForeground());
            } else {
                g2d.setColor(this.getForeground());
            }
            String lineNumber = this.getTextLineNumber(viewPoint, preferredHeight);
            int stringWidth = fontMetrics.stringWidth(lineNumber);
            int x = this.getOffsetX(availableWidth, stringWidth) + insets.left;
            g2d.drawString(lineNumber, x, y);
            viewPoint.y = y += lineHeight;
            if (y > preferredHeight) break;
        }
    }

    protected boolean isCurrentLine(Point viewPoint) {
        int offset = this.textComponent.viewToModel(viewPoint);
        int caretPosition = this.textComponent.getCaretPosition();
        Element root = this.textComponent.getDocument().getDefaultRootElement();
        return root.getElementIndex(offset) == root.getElementIndex(caretPosition);
    }

    protected String getTextLineNumber(Point viewPoint, int preferredHeight) {
        int index;
        int offset = this.textComponent.viewToModel(viewPoint);
        Element root = this.textComponent.getDocument().getDefaultRootElement();
        Element line = root.getElement(index = root.getElementIndex(offset));
        if (line.getStartOffset() == offset) {
            return String.valueOf(index + 1);
        }
        return EMPTY_STRING;
    }

    protected int getOffsetX(int availableWidth, int stringWidth) {
        return (int)((float)(availableWidth - stringWidth) * this.alignmentX);
    }

    protected void caretUpdate(CaretEvent evt) {
        int caretPosition = this.textComponent.getCaretPosition();
        Element root = this.textComponent.getDocument().getDefaultRootElement();
        int currentLine = root.getElementIndex(caretPosition);
        if (this.lastLine != currentLine) {
            this.repaint();
            this.lastLine = currentLine;
        }
    }

    protected void documentChanged(DocumentEvent evt) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int preferredHeight = LineNumber.this.textComponent.getPreferredSize().height;
                if (LineNumber.this.lastHeight != preferredHeight) {
                    LineNumber.this.setPreferredWidth();
                    LineNumber.this.repaint();
                    LineNumber.this.lastHeight = preferredHeight;
                }
            }
        });
    }
}

