/*
 * Decompiled with CFR 0.152.
 */
package kiyut.swing.combo;

import java.awt.Component;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;

public class SeparatorComboBox
extends JComboBox {
    public static final String DEFAULT_SEPARATOR = "--";
    protected Object separator;

    public SeparatorComboBox() {
        this(DEFAULT_SEPARATOR);
        this.initCustom();
    }

    public SeparatorComboBox(ComboBoxModel aModel) {
        super(aModel);
        this.initCustom();
        this.setSeparator(DEFAULT_SEPARATOR);
    }

    public SeparatorComboBox(Object[] items) {
        super(items);
        this.initCustom();
        this.setSeparator(DEFAULT_SEPARATOR);
    }

    public SeparatorComboBox(Object separator) {
        this.initCustom();
        this.setSeparator(separator);
    }

    protected void initCustom() {
        this.setRenderer(new SeparatorListCellRenderer(this.getRenderer()));
    }

    public void setSeparator(Object separator) {
        this.separator = separator == null ? DEFAULT_SEPARATOR : separator;
    }

    public Object getSeparator() {
        return this.separator;
    }

    @Override
    public void setSelectedIndex(int index) {
        Object obj;
        if (index < this.getItemCount() && index >= 0 && (obj = this.getItemAt(index)).equals(this.separator)) {
            int oldIndex = this.getSelectedIndex();
            if (index < oldIndex) {
                if (index - 1 >= 0) {
                    --index;
                }
            } else if (index > oldIndex && index + 1 < this.getItemCount()) {
                ++index;
            }
        }
        super.setSelectedIndex(index);
    }

    public class SeparatorListCellRenderer
    implements ListCellRenderer {
        protected ListCellRenderer wrapped;
        protected Component separatorComp = new JSeparator();

        public SeparatorListCellRenderer(ListCellRenderer listCellRenderer) {
            this.wrapped = listCellRenderer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value != null && value.equals(SeparatorComboBox.this.separator)) {
                return this.separatorComp;
            }
            return this.wrapped.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }
}

