redis = {}

function redis.get_keywords()
    local keywords0_set = "DEL DUMP EXISTS EXPIRE EXPIREAT KEYS MIGRATE MOVE OBJECT PERSIST PEXPIRE PEXPIREAT PTTL RANDOMKEY RENAME RENAMENX RESTORE SORT TTL TYPE SCAN APPEND BITCOUNT BITOP DECR DECRBY GET GETBIT GETRANGE GETSET INCR INCRBY INCRBYFLOAT MGET MSET MSETNX PSETEX SET SETBIT SETEX SETNX SETRANGE STRLEN HDEL HEXISTS HGET HGETALL HINCRBY HINCRBYFLOAT HKEYS HLEN HMGET HMSET HSET HSETNX HVALS HSCAN BLPOP BRPOP BRPOPLPUSH LINDEX LINSERT LLEN LPOP LPUSH LPUSHX LRANGE LREM LSET LTRIM RPOP RPOPLPUSH RPUSH RPUSHX SADD SCARD SDIFF SDIFFSTORE SINTER SINTERSTORE SISMEMBER SMEMBERS SMOVE SPOP SRANDMEMBER SREM SUNION SUNIONSTORE SSCAN ZADD ZCARD ZCOUNT ZINCRBY ZRANGE ZRANGEBYSCORE ZRANK ZREM ZREMRANGEBYRANK ZREMRANGEBYSCORE ZREVRANGE ZREVRANGEBYSCORE ZREVRANK ZSCORE ZUNIONSTORE ZINTERSTORE ZSCAN PSUBSCRIBE PUBLISH PUBSUB PUNSUBSCRIBE SUBSCRIBE UNSUBSCRIBE DISCARD EXEC MULTI UNWATCH WATCH EVAL EVALSHA SCRIPT EXISTS SCRIPT FLUSH SCRIPT KILL SCRIPT LOAD AUTH ECHO PING QUIT SELECT BGREWRITEAOF BGSAVE CLIENT GETNAME CLIENT KILL CLIENT LIST CLIENT SETNAME CONFIG GET CONFIG RESETSTAT CONFIG REWRITE CONFIG SET DBSIZE DEBUG OBJECT DEBUG SEGFAULT FLUSHALL FLUSHDB INFO LASTSAVE MONITOR PSYNC SAVE SHUTDOWN SLAVEOF SLOWLOG SYNC TIME"
	return keywords0_set
end	

function redis.get_autocomplete()
    local autocomplete_set = "DEL DUMP EXISTS EXPIRE EXPIREAT KEYS MIGRATE MOVE OBJECT PERSIST PEXPIRE PEXPIREAT PTTL RANDOMKEY RENAME RENAMENX RESTORE SORT TTL TYPE SCAN APPEND BITCOUNT BITOP DECR DECRBY GET GETBIT GETRANGE GETSET INCR INCRBY INCRBYFLOAT MGET MSET MSETNX PSETEX SET SETBIT SETEX SETNX SETRANGE STRLEN HDEL HEXISTS HGET HGETALL HINCRBY HINCRBYFLOAT HKEYS HLEN HMGET HMSET HSET HSETNX HVALS HSCAN BLPOP BRPOP BRPOPLPUSH LINDEX LINSERT LLEN LPOP LPUSH LPUSHX LRANGE LREM LSET LTRIM RPOP RPOPLPUSH RPUSH RPUSHX SADD SCARD SDIFF SDIFFSTORE SINTER SINTERSTORE SISMEMBER SMEMBERS SMOVE SPOP SRANDMEMBER SREM SUNION SUNIONSTORE SSCAN ZADD ZCARD ZCOUNT ZINCRBY ZRANGE ZRANGEBYSCORE ZRANK ZREM ZREMRANGEBYRANK ZREMRANGEBYSCORE ZREVRANGE ZREVRANGEBYSCORE ZREVRANK ZSCORE ZUNIONSTORE ZINTERSTORE ZSCAN PSUBSCRIBE PUBLISH PUBSUB PUNSUBSCRIBE SUBSCRIBE UNSUBSCRIBE DISCARD EXEC MULTI UNWATCH WATCH EVAL EVALSHA SCRIPT EXISTS SCRIPT FLUSH SCRIPT KILL SCRIPT LOAD AUTH ECHO PING QUIT SELECT BGREWRITEAOF BGSAVE CLIENT GETNAME CLIENT KILL CLIENT LIST CLIENT SETNAME CONFIG GET CONFIG RESETSTAT CONFIG REWRITE CONFIG SET DBSIZE DEBUG OBJECT DEBUG SEGFAULT FLUSHALL FLUSHDB INFO LASTSAVE MONITOR PSYNC SAVE SHUTDOWN SLAVEOF SLOWLOG SYNC TIME"
	return autocomplete_set
end	

function redis.get_calltip()
    local calltip_add = 
    {
        "DEL|DEL key [key ...]",
        "DUMP|DUMP key",
        "EXISTS|EXISTS key",
        "EXPIRE|EXPIRE key seconds",
        "EXPIREAT|EXPIREAT key timestamp",
        "KEYS|KEYS pattern",
        "MIGRATE|MIGRATE host port key destination-db timeout [COPY] [REPLACE]",
        "MOVE|MOVE key db",
        "OBJECT|OBJECT subcommand [arguments [arguments]]",
        "PERSIST|PERSIST key",
        "PEXPIRE|PEXPIRE key milliseconds",
        "PEXPIREAT|PEXPIREAT key milliseconds-timestamp",
        "PTTL|PTTL key",
        "RANDOMKEY|RANDOMKEY",
        "RENAME|RENAME key newkey",
        "RENAMENX|RENAMENX key newkey",
        "RESTORE|RESTORE key ttl serialized-value",
        "SORT|SORT key [BY pattern] [LIMIT offset count] [GET pattern [GET pattern ...]] [ASC | DESC] [ALPHA] [STORE destination]",
        "TTL|TTL key",
        "TYPE|TYPE key",
        "SCAN|SCAN cursor [MATCH pattern] [COUNT count]",
        "APPEND|APPEND key value",
        "BITCOUNT|BITCOUNT key [start] [end]",
        "BITOP|BITOP operation destkey key [key ...]",
        "DECR|DECR key",
        "DECRBY|DECRBY key decrement",
        "GET|GET key",
        "GETBIT|GETBIT key offset",
        "GETRANGE|GETRANGE key start end",
        "GETSET|GETSET key value",
        "INCR|INCR key",
        "INCRBY|INCRBY key increment",
        "INCRBYFLOAT|INCRBYFLOAT key increment",
        "MGET|MGET key [key ...]",
        "MSET|MSET key value [key value ...]",
        "MSETNX|MSETNX key value [key value ...]",
        "PSETEX|PSETEX key milliseconds value",
        "SET|SET key value [EX seconds] [PX milliseconds] [NX|XX]",
        "SETBIT|SETBIT key offset value",
        "SETEX|SETEX key seconds value",
        "SETNX|SETNX key value",
        "SETRANGE|SETRANGE key offset value",
        "STRLEN|STRLEN key",
        "HDEL|HDEL key field [field ...]",
        "HEXISTS|HEXISTS key field",
        "HGET|HGET key field",
        "HGETALL|HGETALL key",
        "HINCRBY|HINCRBY key field increment",
        "HINCRBYFLOAT|HINCRBYFLOAT key field increment",
        "HKEYS|HKEYS key",
        "HLEN|HLEN key",
        "HMGET|HMGET key field [field ...]",
        "HMSET|HMSET key field value [field value ...]",
        "HSET|HSET key field value",
        "HSETNX|HSETNX key field value",
        "HVALS|HVALS key",
        "HSCAN|HSCAN key cursor [MATCH pattern] [COUNT count]",
        "BLPOP|BLPOP key [key ...] timeout",
        "BRPOP|BRPOP key [key ...] timeout",
        "BRPOPLPUSH|BRPOPLPUSH source destination timeout",
        "LINDEX|LINDEX key index",
        "LINSERT|LINSERT key BEFORE|AFTER pivot value",
        "LLEN|LLEN key",
        "LPOP|LPOP key",
        "LPUSH|LPUSH key value [value ...]",
        "LPUSHX|LPUSHX key value",
        "LRANGE|LRANGE key start stop",
        "LREM|LREM key count value",
        "LSET|LSET key index value",
        "LTRIM|LTRIM key start stop",
        "RPOP|RPOP key",
        "RPOPLPUSH|RPOPLPUSH source destination",
        "RPUSH|RPUSH key value [value ...]",
        "RPUSHX|RPUSHX key value",
        "SADD|SADD key member [member ...]",
        "SCARD|SCARD key",
        "SDIFF|SDIFF key [key ...]",
        "SDIFFSTORE|SDIFFSTORE destination key [key ...]",
        "SINTER|SINTER key [key ...]",
        "SINTERSTORE|SINTERSTORE destination key [key ...]",
        "SISMEMBER|SISMEMBER key member",
        "SMEMBERS|SMEMBERS key",
        "SMOVE|SMOVE source destination member",
        "SPOP|SPOP key",
        "SRANDMEMBER|SRANDMEMBER key [count]",
        "SREM|SREM key member [member ...]",
        "SUNION|SUNION key [key ...]",
        "SUNIONSTORE|SUNIONSTORE destination key [key ...]",
        "SSCAN|SSCAN key cursor [MATCH pattern] [COUNT count]",
        "ZADD|ZADD key score member [[score member] [score member] ...]",
        "ZCARD|ZCARD key",
        "ZCOUNT|ZCOUNT key min max",
        "ZINCRBY|ZINCRBY key increment member",
        "ZRANGE|ZRANGE key start stop [WITHSCORES]",
        "ZRANGEBYSCORE|ZRANGEBYSCORE key min max [WITHSCORES] [LIMIT offset count]",
        "ZRANK|ZRANK key member",
        "ZREM|ZREM key member [member ...]",
        "ZREMRANGEBYRANK|ZREMRANGEBYRANK key start stop",
        "ZREMRANGEBYSCORE|ZREMRANGEBYSCORE key min max",
        "ZREVRANGE|ZREVRANGE key start stop [WITHSCORES]",
        "ZREVRANGEBYSCORE|ZREVRANGEBYSCORE key max min [WITHSCORES] [LIMIT offset count]",
        "ZREVRANK|ZREVRANK key member",
        "ZSCORE|ZSCORE key member",
        "ZUNIONSTORE|ZUNIONSTORE destination numkeys key [key ...] [WEIGHTS weight [weight ...]] [AGGREGATE SUM|MIN|MAX]",
        "ZINTERSTORE|ZINTERSTORE destination numkeys key [key ...] [WEIGHTS weight [weight ...]] [AGGREGATE SUM|MIN|MAX]",
        "ZSCAN|ZSCAN key cursor [MATCH pattern] [COUNT count]",
        "PSUBSCRIBE|PSUBSCRIBE pattern [pattern ...]",
        "PUBLISH|PUBLISH channel message",
        "PUBSUB|PUBSUB <subcommand> [argument [argument ...]]",
        "PUNSUBSCRIBE|PUNSUBSCRIBE [pattern [pattern ...]]",
        "SUBSCRIBE|SUBSCRIBE channel [channel ...]",
        "UNSUBSCRIBE|UNSUBSCRIBE [channel [channel ...]]",
        "DISCARD|DISCARD",
        "EXEC|EXEC",
        "MULTI|MULTI",
        "UNWATCH|UNWATCH",
        "WATCH|WATCH key [key ...]",
        "EVAL|EVAL script numkeys key [key ...] arg [arg ...]",
        "EVALSHA|EVALSHA sha1 numkeys key [key ...] arg [arg ...]",
        "SCRIPT|SCRIPT EXISTS script [script ...]\\nSCRIPT FLUSH\\nSCRIPT KILL\\nSCRIPT LOAD script",
        "AUTH|AUTH password",
        "ECHO|ECHO message",
        "PING|PING",
        "QUIT|QUIT",
        "SELECT|SELECT index",
        "BGREWRITEAOF|BGREWRITEAOF",
        "BGSAVE|BGSAVE",
        "CLIENT|CLIENT GETNAME\\nCLIENT KILL ip:port\\nCLIENT LIST\\nCLIENT SETNAME connection-name",
        "CONFIG|CONFIG GET parameter\\nCONFIG RESETSTAT\\nCONFIG REWRITE\\nCONFIG SET parameter value",
        "DBSIZE|DBSIZE",
        "DEBUG|DEBUG OBJECT key\\nDEBUG SEGFAULT",
        "FLUSHALL|FLUSHALL",
        "FLUSHDB|FLUSHDB",
        "INFO|INFO [section]",
        "LASTSAVE|LASTSAVE",
        "MONITOR|MONITOR",
        "PSYNC|PSYNC <MASTER_RUN_ID> <OFFSET>",
        "SAVE|SAVE",
        "SHUTDOWN|SHUTDOWN",
        "SLAVEOF|SLAVEOF host port",
        "SLOWLOG|SLOWLOG subcommand [argument]",
        "SYNC|SYNC",
        "TIME|TIME"
    }
    return calltip_add
end

return redis
