/*
 * Decompiled with CFR 0.152.
 */
package com.damytec.printplacetag.ui;

import com.damytec.printplacetag.service.GithubService;
import com.damytec.printplacetag.ui.CustomButton;
import com.damytec.printplacetag.ui.GradientPanel;
import com.damytec.printplacetag.ui.MotionPanel;
import java.awt.AWTError;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class BaseWindow
extends JFrame {
    private JPanel basePanel;
    private CustomButton closeButton;
    private CustomButton logoButton;
    private JPanel headerPanel;
    private JPanel footerPanel;
    private ContentForm content;
    private ImageIcon logo;
    private int windowWidth;
    private int windowHeight;
    private static final String DEFAULT_TITLE = "PRINTPLACE TAG";

    public BaseWindow(ContentForm form, Integer windowWidth, Integer windowHeight) {
        this.windowWidth = windowWidth == null ? (int)this.getScreenDimension().getWidth() / 2 : windowWidth;
        this.windowHeight = windowHeight == null ? (int)this.getScreenDimension().getHeight() / 2 : windowHeight;
        this.content = form;
        this.createUI();
        this.buildImages();
        this.buildFrame();
    }

    public BaseWindow(ContentForm form) {
        this(form, null, null);
    }

    private void buildFrame() {
        this.setIconImage(this.logo.getImage());
        this.add(this.basePanel);
        this.setDefaultCloseOperation(3);
        Dimension dim = this.getScreenDimension();
        this.setBounds((dim.width - this.windowWidth) / 2, (dim.height - this.windowHeight) / 2, this.windowWidth, this.windowHeight);
        this.setUndecorated(true);
        this.setVisible(true);
        this.setResizable(false);
    }

    private void buildImages() {
        this.logo = new ImageIcon(BaseWindow.class.getClassLoader().getResource("images/logo.png"));
    }

    private void createUI() {
        this.basePanel = new MotionPanel(this);
        this.closeButton = new CustomButton("images/close.png", new Dimension(32, 32)){

            @Override
            public void actionPerformed() {
                System.exit(0);
            }
        };
        this.logoButton = new CustomButton("images/logomini.png", new Dimension(32, 32)){

            @Override
            public void actionPerformed() {
                GithubService.getInstance().openGithub();
            }
        };
        this.basePanel.setLayout(new BorderLayout(0, 0));
        this.headerPanel = new GradientPanel(new Color(10349305), new Color(7711910));
        this.headerPanel.setLayout(new BorderLayout(0, 0));
        this.basePanel.add((Component)this.headerPanel, "North");
        this.headerPanel.add((Component)this.logoButton, "West");
        JLabel label1 = new JLabel();
        Font label1Font = this.createFont(null, 1, 20, label1.getFont());
        if (label1Font != null) {
            label1.setFont(label1Font);
        }
        label1.setHorizontalAlignment(0);
        label1.setText(this.content.title());
        this.headerPanel.add((Component)label1, "Center");
        JSeparator separator1 = new JSeparator();
        separator1.setOrientation(0);
        this.headerPanel.add((Component)separator1, "South");
        this.headerPanel.add((Component)this.closeButton, "East");
        this.footerPanel = new JPanel();
        this.footerPanel.setLayout(new BorderLayout(0, 0));
        this.footerPanel.setBackground(new Color(-16187308));
        this.basePanel.add((Component)this.footerPanel, "South");
        JLabel label2 = new JLabel();
        label2.setBackground(new Color(-859392));
        Font label2Font = this.createFont(null, -1, 10, label2.getFont());
        if (label2Font != null) {
            label2.setFont(label2Font);
        }
        label2.setForeground(new Color(-859392));
        label2.setText("Damy Tecnologia da Informa\u00e7\u00e3o LTDA");
        this.footerPanel.add((Component)label2, "West");
        JLabel label3 = new JLabel();
        Font label3Font = this.createFont(null, -1, 10, label3.getFont());
        if (label3Font != null) {
            label3.setFont(label3Font);
        }
        label3.setForeground(new Color(-859392));
        label3.setText("30.281.367/0001-91");
        this.footerPanel.add((Component)label3, "East");
        this.basePanel.add((Component)this.content.root(), "Center");
    }

    private Dimension getScreenDimension() {
        try {
            return Toolkit.getDefaultToolkit().getScreenSize();
        }
        catch (AWTError | HeadlessException ex) {
            throw new RuntimeException("O ambiente n\u00e3o suporta nenhuma janela: " + ex.getClass().getSimpleName());
        }
    }

    private Font createFont(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
        return new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
    }

    public static interface ContentForm {
        public JPanel root();

        default public String title() {
            return BaseWindow.DEFAULT_TITLE;
        }
    }
}

