/*
 * Decompiled with CFR 0.152.
 */
package com.damytec.printplacetag.ui;

import com.damytec.printplacetag.util.ImageUtil;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public abstract class CustomButton
extends JLabel {
    private int width;
    private int height;
    private ImageIcon idle;
    private ImageIcon hover;
    private ImageIcon pressed;

    public CustomButton(String idleImage, String hoverImage, String pressedImage, Dimension dimension) {
        super("");
        if (dimension == null) {
            this.retrieveImageDimensions(idleImage);
        } else {
            this.width = (int)dimension.getWidth();
            this.height = (int)dimension.getHeight();
        }
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.changeIcon(this.getImage(idleImage));
        this.clickedAction();
        this.idle = this.getImage(idleImage);
        this.hover = hoverImage != null ? this.getImage(hoverImage) : new ImageIcon(ImageUtil.brightness(this.idle.getImage(), 1.5f));
        this.hoverAction();
        this.pressed = pressedImage != null ? this.getImage(pressedImage) : new ImageIcon(ImageUtil.brightness(this.idle.getImage(), 0.75f));
        this.pressedAction();
    }

    public CustomButton(String idleImage, Dimension dimension) {
        this(idleImage, null, null, dimension);
    }

    public CustomButton(String idleImage) {
        this(idleImage, null, null, null);
    }

    public CustomButton(String idleImage, String hoverImage) {
        this(idleImage, hoverImage, null, null);
    }

    public CustomButton(String idleImage, String hoverImage, String pressedImage) {
        this(idleImage, hoverImage, pressedImage, null);
    }

    public abstract void actionPerformed();

    private void clickedAction() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CustomButton.this.actionPerformed();
            }
        });
    }

    private void hoverAction() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                CustomButton.this.changeIcon(CustomButton.this.hover);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                CustomButton.this.changeIcon(CustomButton.this.idle);
            }
        });
    }

    private void pressedAction() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CustomButton.this.changeIcon(CustomButton.this.pressed);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                CustomButton.this.changeIcon(CustomButton.this.idle);
            }
        });
    }

    private ImageIcon getImage(String resource) {
        try {
            ImageIcon icon = new ImageIcon(CustomButton.class.getClassLoader().getResource(resource));
            if (icon.getIconWidth() != this.width || icon.getIconHeight() != this.height) {
                icon = new ImageIcon(icon.getImage().getScaledInstance(this.width, this.height, 4));
            }
            return icon;
        }
        catch (Exception e) {
            return new ImageIcon(ImageUtil.createPlaceHolder(this.width, this.height));
        }
    }

    private void retrieveImageDimensions(String resource) {
        try {
            ImageIcon icon = new ImageIcon(CustomButton.class.getClassLoader().getResource(resource));
            this.width = icon.getIconWidth();
            this.height = icon.getIconHeight();
        }
        catch (Exception e) {
            this.width = 32;
            this.height = 32;
            e.printStackTrace();
        }
    }

    @Override
    public void setIcon(Icon icon) {
    }

    private void changeIcon(Icon icon) {
        super.setIcon(icon);
    }
}

