/*
 * Decompiled with CFR 0.152.
 */
package com.damytec.printplacetag.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class ImageUtil {
    private ImageUtil() {
    }

    public static Image createPlaceHolder(int width, int height) {
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D g2d = bi.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setPaint(Color.RED);
        g2d.setStroke(new BasicStroke((float)height / 8.0f));
        g2d.drawLine(0, height / 2, width, height / 2);
        g2d.setStroke(new BasicStroke((float)width / 8.0f));
        g2d.drawLine(width / 2, 0, width / 2, height);
        g2d.rotate(Math.toRadians(45.0));
        g2d.dispose();
        return bi;
    }

    public static Image brightness(Image in, float scale) {
        BufferedImage bi = new BufferedImage(in.getWidth(null), in.getHeight(null), 2);
        Graphics bg = bi.getGraphics();
        bg.drawImage(in, 0, 0, null);
        int[] pixel = new int[]{0, 0, 0, 0};
        float[] hsbvals = new float[]{0.0f, 0.0f, 0.0f};
        for (int i = 0; i < bi.getHeight(); ++i) {
            for (int j = 0; j < bi.getWidth(); ++j) {
                bi.getRaster().getPixel(j, i, pixel);
                Color.RGBtoHSB(pixel[0], pixel[1], pixel[2], hsbvals);
                float newBrightness = Math.min(1.0f, hsbvals[2] * scale);
                Color c = new Color(Color.HSBtoRGB(hsbvals[0], hsbvals[1], newBrightness));
                bi.getRaster().setPixel(j, i, new int[]{c.getRed(), c.getGreen(), c.getBlue(), pixel[3]});
            }
        }
        return bi;
    }

    public static Image invertColors(Image in) {
        BufferedImage bi = new BufferedImage(in.getWidth(null), in.getHeight(null), 2);
        Graphics bg = bi.getGraphics();
        bg.drawImage(in, 0, 0, null);
        int[] pixel = new int[]{0, 0, 0, 0};
        float[] hsbvals = new float[]{0.0f, 0.0f, 0.0f};
        for (int i = 0; i < bi.getHeight(); ++i) {
            for (int j = 0; j < bi.getWidth(); ++j) {
                bi.getRaster().getPixel(j, i, pixel);
                bi.getRaster().setPixel(j, i, new int[]{255 - pixel[0], 255 - pixel[1], 255 - pixel[2], pixel[3]});
            }
        }
        return bi;
    }

    public static Image resize(Image img, int maxHeight, int maxWidth) {
        int originalHeight;
        int originalWidth = img.getWidth(null);
        int newHeight = originalHeight = img.getHeight(null);
        int newWidth = originalWidth;
        if (newWidth > maxWidth) {
            newWidth = maxWidth;
            newHeight = newWidth * originalHeight / originalWidth;
        }
        if (newHeight > maxHeight) {
            newHeight = maxHeight;
            newWidth = newHeight * originalWidth / originalHeight;
        }
        return img.getScaledInstance(newWidth, newHeight, 4);
    }
}

