﻿Imports System.Text.RegularExpressions

Public Class Choose9FileSLFunction

    Public Const FunctionName As String = "文件大小"                '您的处理方法名称，这个值将在下拉框中显示

    Public Const HandleType As Integer = 0                  '您的处理方法所属板块，0=筛选器、1=通配更改、1=逻辑替换
    Public Const HandleTarget As Integer = 1                '您的处理方法目标对象，0=全部、1=文件、2=文件夹
    Public Const HandleOption As Integer = 1                '您的处理方法在该板块中的更改类型，详情请见_1

    Public Const PriorityLevel As Integer = 120               '您的处理方法排序优先级，这个值越大，您的方法在下拉框中越靠前

    Private LengthData() As Decimal
    Public Sub New(ByVal Parameter As Object, ByVal OptionParameter As Object)
        '处理过程初始化，Parameter为您SetParameter中返回的参数
        'OptionParameter为程序提供的参数，详情见_2
        LengthData = DirectCast(Parameter, Decimal())
    End Sub

#Region "Choose"
    Public Function HandlingFunction_Choose(ByVal FileNames() As String) As Boolean()
        '全名型筛选器方法
        Dim TickNames(FileNames.Count - 1) As Boolean
        For i = 0 To FileNames.Count - 1
            Dim Length As Decimal = Decimal.Parse(New IO.FileInfo(FileNames(i)).Length)
            If Length >= LengthData(0) AndAlso Length <= LengthData(1) Then
                TickNames(i) = True
            Else
                TickNames(i) = False
            End If
        Next
        Return TickNames
    End Function
#End Region

    '以上几个Handling处理过程只需要写一个且与HandleType标识的板块匹配

    Public Shared Function SetParameter(ByVal PreviosParameter As Object) As Object
        '设置处理参数，在点击下拉框时调用该方法
        MemoryObj = PreviosParameter
        Dim SetD As New FormScopeFileLength
        SetD.ShowDialog()
        Return MemoryObj
    End Function

End Class
'_1：筛选器中：  0：文件名型筛选器
'                1：全名型筛选器
'    通配修改中：该属性不用设置
'    逻辑替换中：0：字符串
'                1：汉字
'                2：数字
'                3：字母
'                4：句子
'                5：数
'                6：单词
'_2：暂无，为空

'如果您需要添加窗体，或者您对此界面不满意，可将此代码复制到Visual Studio里面进行编辑和生成，生成的DLL文件放到程序根目录即可使用。