﻿Public Class DateFileSLFunction

    Public Const FunctionName As String = "日期"                '您的处理方法名称，这个值将在下拉框中显示

    Public Const HandleType As Integer = 1                  '您的处理方法所属板块，0=筛选器、1=通配更改、1=逻辑替换
    Public Const HandleTarget As Integer = 1                '您的处理方法目标对象，0=全部、1=文件、2=文件夹
    Public Const HandleOption As Integer = 0                '您的处理方法在该板块中的更改类型，详情请见_1

    Public Const PriorityLevel As Integer = 180               '您的处理方法排序优先级，这个值越大，您的方法在下拉框中越靠前

    Private ChangeType As DateType
    Public Sub New(ByVal Parameter As Object, ByVal OptionParameter As Object)
        '处理过程初始化，Parameter为您SetParameter中返回的参数
        'OptionParameter为程序提供的参数，详情见_2
        ChangeType = DirectCast(Parameter, DateType)
    End Sub

    Public Function HandlingFunction_Common(ByVal FileName As String) As String
        '处理过程字符过程
        Select Case ChangeType.ChangeType
            Case 0 '创建日期
                Return New IO.FileInfo(FileName).CreationTime
            Case 1 '最后更改日期
                Return New IO.FileInfo(FileName).LastWriteTime
            Case 2 '最后访问日期
                Return New IO.FileInfo(FileName).LastAccessTime
        End Select
    End Function
    '以上几个Handling处理过程只需要写一个且与HandleType标识的板块匹配

    Public Shared Function SetParameter(ByVal PreviosParameter As Object) As Object
        '设置处理参数，在点击下拉框时调用该方法
        MemoryObj = PreviosParameter
        Dim SetD As New ChooseDateType()
        SetD.ShowDialog()
        Return MemoryObj
    End Function

End Class
