﻿Public Class PicConvertSLFunction '类名可自定义，但必须以SLFunction结尾

    Public Const FunctionName As String = "图像转码"                '您的处理方法名称，这个值将在下拉框中显示

    Public Const HandleType As Integer = 3                  '您的处理方法所属板块，-1=范围限定器、0=筛选器、1=通配更改、2=逻辑替换、3=内容更改
    Public Const HandleTarget As Integer = 1                '您的处理方法目标对象，0=全部、1=文件、2=文件夹
    Public Const HandleOption As Integer = 1                '您的处理方法在该板块中的更改类型，详情请见_1

    Public Const PriorityLevel As Integer = 190               '您的处理方法排序优先级，这个值越大，您的方法在下拉框中越靠前

    Private ConvertTo As String
    Private KillMySelf As Boolean
    Public Sub New(ByVal Parameter As Object, ByVal OptionParameter As Object)
        '处理过程初始化，Parameter为您SetParameter中返回的参数
        'OptionParameter为程序提供的参数，详情见_2
        ConvertTo = DirectCast(Parameter, PicConvertInf).Format
        KillMySelf = DirectCast(Parameter, PicConvertInf).KillMySelf
    End Sub

#Region "Content
    Public Const ImagePath As String = "FunctionImages\SLPicConvert.png"
    Public Const Group As String = "图像处理"
    Public Const ExtensionName = "bmp png jpg jpeg gif ico"
    Public Const Description As String = "对常见的图像格式进行转码，以便缩减图像尺寸或供特定设备浏览"
    Public Const RequireFileNames As Boolean = True
    Public Event ReportProgress(ByVal Progress As Integer, ByVal ProgressInfo As String)
    Public Sub HandlingFunction_Content(ByVal FileNames() As String)
        '您的处理方法，如RequireFileNames设为False将不传递FileNames参数
        Dim FileCount As Integer = FileNames.Count
        Dim i As Integer = 0
        Dim OKAll As Boolean = False
        Dim NewName As String
        For Each File As String In FileNames
            i += 1
            RaiseEvent ReportProgress(i / FileCount * 100, "正在处理：" + GetM(File))
            If GetM(File, ".") = ConvertTo Then
                Continue For
            Else
                NewName = GetP(File, ".") + "." + ConvertTo
                If (Not OKAll) AndAlso IO.File.Exists(NewName) Then
                    Dim ShowError As New FormIOError("文件：" + File + "已存在，是否覆盖？")
                    Select Case ShowError.ShowDialog
                        Case DialogResult.Yes '是
                        Case DialogResult.OK '全部选是
                            OKAll = True
                        Case DialogResult.Cancel '取消
                            GoTo CancelExtract
                    End Select
                End If
                Using Pic As System.Drawing.Image = System.Drawing.Bitmap.FromFile(File)
                    Pic.Save(NewName, GetFormat(ConvertTo))
                End Using
                If KillMySelf Then
                    IO.File.Delete(File)
                End If
            End If
        Next
CancelExtract:
    End Sub
#End Region
    '以上几个Handling处理过程只需要写一个且与HandleType和HandleTarget标识的板块匹配

    Public Shared Function SetParameter(ByVal PreviosParameter As Object) As Object
        '设置处理参数，在点击下拉框时调用该方法
        MemoryObj = PreviosParameter
        Dim SetD As New FormPicConvert
        SetD.ShowDialog()
        Return MemoryObj
    End Function

#Region "基础函数"

    Private Function GetFormat(ByVal FormatStr As String) As System.Drawing.Imaging.ImageFormat
        Select Case FormatStr.ToLower
            Case "bmp"
                Return System.Drawing.Imaging.ImageFormat.Bmp
            Case "png"
                Return System.Drawing.Imaging.ImageFormat.Png
            Case "jpeg"
                Return System.Drawing.Imaging.ImageFormat.Jpeg
            Case "jpg"
                Return System.Drawing.Imaging.ImageFormat.Jpeg
            Case "ico"
                Return System.Drawing.Imaging.ImageFormat.Icon
            Case "gif"
                Return System.Drawing.Imaging.ImageFormat.Gif
        End Select
    End Function

#End Region

End Class


'_1：筛选器中：  0：文件名型筛选器
'                1：全名型筛选器
'    通配修改中：该属性不用设置
'    逻辑替换中：0：字符串
'                1：汉字
'                2：数字
'                3：字母
'                4：句子
'                5：数
'                6：单词
'    内容更改中：0：文件名取得范围为单层
'                1：文件名取得范围为多层
'_2：暂无，为空

'如果您需要添加窗体，或者您对此界面不满意，可将此代码复制到Visual Studio里面进行编辑和生成，生成的DLL文件放到程序根目录即可使用。