﻿Public Class IncludeChoose

    Private IsGettingInformation As Boolean = False  '防止载入数据时多出一个combo
    Private Sub FormIncludeChoose_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ComboListChoose.Lines.IntervalValue = 16

        If MemoryObj Is Nothing Then
            ComboListChoose.Lines.Add()
        Else
            IsGettingInformation = True
            IsOnShown = True

            Dim Data As List(Of ChooseData()) = DirectCast(MemoryObj, List(Of ChooseData()))

            Dim Line As ComboLine
            Dim CmbData As ChooseData()
            Dim TmpCom As LimitCombo
            Dim TmpChar() As Char
            Dim TmpDec() As Decimal
            For i = 0 To Data.Count - 1  '循环获取数据
                CmbData = Data(i)
                Line = ComboListChoose.Lines.Add
                For k = 0 To CmbData.Count - 1
                    TmpCom = Line.AddCombo(CmbData(k).Index)

                    Select Case CmbData(k).Index
                        Case -1
                            TmpCom.Text = CmbData(k).Data
                        Case 3
                            TmpCom.Tag = CmbData(k).Data
                            TmpChar = CmbData(k).Data.Data
                            TmpCom.Items(3) = "字母（" + TmpChar(0) + "到" + TmpChar(1) + "）"
                        Case 4
                            TmpCom.Tag = CmbData(k).Data
                            TmpDec = CmbData(k).Data.Data
                            TmpCom.Items(4) = "数字（" + TmpDec(0).ToString + "到" + TmpDec(1).ToString + "）"
                    End Select
                Next
            Next

            IsGettingInformation = False
            IsOnShown = False
        End If
    End Sub

    Private IsOnShown As Boolean = False  '判断是否刚刚打开过对话框
    Private Sub ComboListChoose_Combo_IndexChanged(ByRef sender As ComboList.ComboPos, ByVal e As System.EventArgs) Handles ComboListChoose.Combo_IndexChanged
        If Not IsOnShown Then
            IsOnShown = True

            Select Case sender.Lin.Combos(sender.Ind).SelectedIndex
                Case 3
                    Dim LetScope As New ScopeLetter(sender.Lin.Combos(sender.Ind))
                    LetScope.ShowDialog(Me)
                Case 4
                    Dim NumScope As New ScopeNum(sender.Lin.Combos(sender.Ind))
                    NumScope.ShowDialog(Me)
            End Select

            IsOnShown = False
        End If
    End Sub

    Private Sub ComboListChoose_Line_Add(ByRef sender As ComboLine, ByVal e As System.EventArgs) Handles ComboListChoose.Line_Add
        sender.DefualtForbiddenString = GetForbiddenString() '初始化禁止列表
        sender.EnableAddLineButton = True
        sender.EnableRemoveLineButton = True

        sender.DefaultComboItems.Add("汉字")
        sender.DefaultComboItems.Add("字母")
        sender.DefaultComboItems.Add("数字")
        sender.DefaultComboItems.Add("字母（范围）")
        sender.DefaultComboItems.Add("数字（范围）") '初始化默认项

        If Not IsGettingInformation Then sender.AddCombo()
    End Sub

    Private Sub ComboListChoose_Line_Removing(ByRef sender As ComboLine, ByRef Cancel As Boolean) Handles ComboListChoose.Line_Removing
        If ComboListChoose.Lines.Count = 1 Then
            Cancel = True
        End If
    End Sub

    Private Sub ComboListChoose_Combo_Removing(ByRef sender As ComboList.ComboPos, ByRef Cancel As Boolean) Handles ComboListChoose.Combo_Removing
        If sender.Lin.ComboCount = 1 Then
            Cancel = True
        End If
    End Sub

    '-----------------------------
    Private GetInf As Boolean = False
    Private Sub FormIncludeChoose_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        If Not GetInf Then
            MemoryObj = "exit"
        End If
    End Sub

    Private Sub ButtonOK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonOK.Click
        Dim RtData As New List(Of ChooseData())

        Dim TmpCom As ChooseData()
        For i = 0 To ComboListChoose.Lines.Count - 1   '循环添加数据
            ReDim TmpCom(ComboListChoose.Lines(i).ComboCount - 1)
            For k = 0 To ComboListChoose.Lines(i).ComboCount - 1
                If ComboListChoose.Lines(i).Combos(k).Text = "" Then '空白数据退出
                    MsgBox("列表中含有空白数据！", MsgBoxStyle.OkOnly, "空白数据")
                    Exit Sub
                End If

                Select Case ComboListChoose.Lines(i).Combos(k).SelectedIndex  '填写数据
                    Case -1  '用户指定字符
                        TmpCom(k) = New ChooseData With {.Index = -1, .Data = ComboListChoose.Lines(i).Combos(k).Text}
                    Case 0  '汉字
                        TmpCom(k) = New ChooseData With {.Index = 0, .Data = Nothing}
                    Case 1 '字母
                        TmpCom(k) = New ChooseData With {.Index = 1, .Data = Nothing}
                    Case 2 '数字
                        TmpCom(k) = New ChooseData With {.Index = 2, .Data = Nothing}
                    Case 3  '字母范围
                        TmpCom(k) = New ChooseData With {.Index = 3, .Data = ComboListChoose.Lines(i).Combos(k).Tag}
                    Case 4  '数字范围
                        TmpCom(k) = New ChooseData With {.Index = 4, .Data = ComboListChoose.Lines(i).Combos(k).Tag}
                End Select
            Next
            RtData.Add(TmpCom)
        Next

        TmpCom = Nothing
        MemoryObj = RtData
        GetInf = True
        Me.Close()
    End Sub

End Class