﻿Public Class FormScopeFileLength

    Private Sub FormScopeLength_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        Dim Data(1) As Decimal
        Data(0) = UpDownFrom.Value * (1024 ^ ComboFrom.SelectedIndex)
        Data(1) = UpDownTo.Value * (1024 ^ ComboTo.SelectedIndex)
        MemoryObj = Data
    End Sub

    Private Sub FormScopeLength_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ComboFrom.SelectedIndex = 1
        ComboTo.SelectedIndex = 1

        If MemoryObj Is Nothing Then Exit Sub

        Dim Data() As Decimal = DirectCast(MemoryObj, Decimal())

        Dim Length As Decimal
        Dim n As Byte = 0

        Length = Data(0)
        Do Until Length < 1024
            Length \= 1024
            n += 1
        Loop
        ComboFrom.SelectedIndex = n
        UpDownFrom.Value = Length

        n = 0
        Length = Data(1)
        Do Until Length < 1024
            Length \= 1024
            n += 1
        Loop
        ComboTo.SelectedIndex = n
        UpDownTo.Value = Length
    End Sub

    Private Sub UpDownFrom_ValueChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles UpDownFrom.ValueChanged
        UpDownTo.Minimum = UpDownFrom.Value * (1024 ^ ComboFrom.SelectedIndex) / (1024 ^ ComboTo.SelectedIndex)
    End Sub

    Private Sub Combo_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ComboFrom.SelectedIndexChanged, ComboTo.SelectedIndexChanged
        If ComboFrom.SelectedIndex > -1 And ComboTo.SelectedIndex > -1 Then
            Dim TmpNum As Decimal
            TmpNum = 1024 ^ ComboFrom.SelectedIndex
            UpDownFrom.Maximum = Decimal.MaxValue / TmpNum

            TmpNum = 1024 ^ ComboTo.SelectedIndex
            UpDownTo.Maximum = Decimal.MaxValue / TmpNum

            UpDownFrom_ValueChanged(sender, e)
        End If
    End Sub

End Class