﻿Public Class FormScopeStr


    Private IsGettingInformation As Boolean = False

    Private GetInf As Boolean = False
#Region "载入和存储数据"

    Private Sub FormScopeStr_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ComboFrom.SelectedIndex = 0
        ComboTo.SelectedIndex = 1
        IsGettingInformation = True

        If MemoryObj Is Nothing Then
            GoTo ExitLoad
        End If
        Dim Data() As ChooseData
        Data = DirectCast(MemoryObj, ChooseData())

        ComboFrom.SelectedIndex = Data(0).Index
        Select Case Data(0).Index
            Case 0 '自定义
                UpDownFrom.Value = Decimal.Parse(Data(0).Data)
            Case 2 '字符末端（运算）
                ComboFrom.Tag = New ChooseData With {.Index = ComboFrom.SelectedIndex, .Data = Data(0).Data}
            Case 3, 5 '字符位置
                TextFrom.SelectedIndex = Data(0).Data.Index
                Select Case TextFrom.SelectedIndex
                    Case -1 '自定义字符
                        TextFrom.Text = Data(0).Data.Data
                End Select
            Case 4, 6 '第一个字符位置（运算）
                TextFrom.SelectedIndex = Data(0).Data(0).Index
                Select Case TextFrom.SelectedIndex
                    Case -1 '自定义字符
                        TextFrom.Text = Data(0).Data(0).Data
                End Select
                ComboFrom.Tag = New ChooseData With {.Index = ComboFrom.SelectedIndex, .Data = Data(0).Data(1)}
        End Select

        ComboTo.SelectedIndex = Data(1).Index
        Select Case Data(1).Index
            Case 0 '自定义
                UpDownTo.Value = Data(1).Data
            Case 2 '字符末端（运算）
                ComboTo.Tag = New ChooseData With {.Index = ComboTo.SelectedIndex, .Data = Data(1).Data}
            Case 3, 5 '字符位置
                TextTo.SelectedIndex = Data(1).Data.Index
                Select Case TextTo.SelectedIndex
                    Case -1 '自定义字符
                        TextTo.Text = Data(1).Data.Data
                End Select
            Case 4, 6 '第一个字符位置（运算）
                TextTo.SelectedIndex = Data(1).Data(0).Index
                Select Case TextTo.SelectedIndex
                    Case -1 '自定义字符
                        TextTo.Text = Data(1).Data(0).Data
                End Select
                ComboTo.Tag = New ChooseData With {.Index = ComboTo.SelectedIndex, .Data = Data(1).Data(1)}
        End Select
        MainControler()
ExitLoad:
        IsGettingInformation = False
    End Sub

    Private Sub ButtonOK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonOK.Click
        Select Case ComboFrom.SelectedIndex
            Case 3, 4, 5, 6
                If TextFrom.Text = "" Then
                    MsgBox("字符不能为空！")
                    Exit Sub
                End If
        End Select
        Select Case ComboTo.SelectedIndex
            Case 3, 4, 5, 6
                If TextTo.Text = "" Then
                    MsgBox("字符不能为空！")
                    Exit Sub
                End If
        End Select

        Dim Data(1) As ChooseData

        Data(0).Index = ComboFrom.SelectedIndex
        Select Case ComboFrom.SelectedIndex
            Case 0 '自定义
                Data(0).Data = UpDownFrom.Value
            Case 1 '字符末端
            Case 2 '字符末端（运算）
                Data(0).Data = ComboFrom.Tag.Data
            Case 3, 5 '字符位置
                Dim InfData As New ChooseData With {.Index = TextFrom.SelectedIndex}
                Select Case InfData.Index
                    Case -1 '自定义字符
                        InfData.Data = TextFrom.Text
                    Case Else
                End Select

                Data(0).Data = InfData
            Case 4, 6 '字符位置（运算）
                Dim InfData As New ChooseData With {.Index = TextFrom.SelectedIndex}
                Select Case InfData.Index
                    Case -1 '自定义字符
                        InfData.Data = TextFrom.Text
                    Case Else
                End Select

                Data(0).Data = {InfData, ComboFrom.Tag.Data}
        End Select

        Data(1).Index = ComboTo.SelectedIndex
        Select Case ComboTo.SelectedIndex
            Case 0 '自定义
                Data(1).Data = Integer.Parse(UpDownTo.Value)
            Case 1 '字符末端
            Case 2 '字符末端（运算）
                Data(1).Data = ComboTo.Tag.Data
            Case 3, 5 '字符位置
                Dim InfData As New ChooseData With {.Index = TextTo.SelectedIndex}
                Select Case InfData.Index
                    Case -1 '自定义字符
                        InfData.Data = TextTo.Text
                    Case Else
                End Select

                Data(1).Data = InfData
            Case 4, 6 '字符位置（运算）
                Dim InfData As New ChooseData With {.Index = TextTo.SelectedIndex}
                Select Case InfData.Index
                    Case -1 '自定义字符
                        InfData.Data = TextTo.Text
                    Case Else
                End Select

                Data(1).Data = {InfData, ComboTo.Tag.Data}
        End Select

        MemoryObj = Data
        GetInf = True
        Me.Close()
    End Sub

    Private Sub FormScopeStr_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        If Not GetInf Then
            MemoryObj = "exit"
        End If
    End Sub

#End Region

#Region "控件动作控制"

    Private Sub ComboFrom_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ComboFrom.SelectedIndexChanged
        If Not IsGettingInformation Then
            IsGettingInformation = True

            EnableFrom(True)
            Select Case ComboFrom.SelectedIndex
                Case 0
                    EnableValueFrom(True)
                Case 1 '字符末端
                    EnableFrom(False)
                Case 2 '字符末端（运算）
                    EnableFrom(False)

                    MemoryObj = GetPreviousParameter(ComboFrom)
                    Dim SetD As New FormMath
                    SetD.ShowDialog(Me)
                    ComboFrom.Tag = New ChooseData With {.Index = ComboFrom.SelectedIndex, .Data = MemoryObj}
                Case 3, 5 '字符（无参数）
                    EnableValueFrom(False)
                Case 2, 4, 6 '字符（有参数）
                    EnableValueFrom(False)

                    MemoryObj = GetPreviousParameter(ComboFrom)
                    Dim SetD As New FormMath
                    SetD.ShowDialog(Me)
                    ComboFrom.Tag = New ChooseData With {.Index = ComboFrom.SelectedIndex, .Data = MemoryObj}
            End Select

            IsGettingInformation = False
        End If
    End Sub

    Private Sub ComboTo_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ComboTo.SelectedIndexChanged
        If Not IsGettingInformation Then
            IsGettingInformation = True

            EnableTo(True)
            Select Case ComboTo.SelectedIndex
                Case 0
                    EnableValueTo(True)
                Case 1 '字符末端
                    EnableTo(False)
                Case 2 '字符末端（运算）
                    EnableTo(False)

                    MemoryObj = GetPreviousParameter(ComboTo)
                    Dim SetD As New FormMath
                    SetD.ShowDialog(Me)
                    ComboTo.Tag = New ChooseData With {.Index = ComboTo.SelectedIndex, .Data = MemoryObj}
                Case 3, 5 '字符（无参数）
                    EnableValueTo(False)
                Case 2, 4, 6 '字符（有参数）
                    EnableValueTo(False)

                    MemoryObj = GetPreviousParameter(ComboTo)
                    Dim SetD As New FormMath
                    SetD.ShowDialog(Me)
                    ComboTo.Tag = New ChooseData With {.Index = ComboTo.SelectedIndex, .Data = MemoryObj}
            End Select

            IsGettingInformation = False
        End If
    End Sub

    Private Sub UpDownFrom_ValueChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles UpDownFrom.ValueChanged
        UpDownTo.Minimum = UpDownFrom.Value
    End Sub

#End Region

#Region "控件显示控制"

    Private Sub MainControler()
        EnableFrom(True)
        EnableTo(True)
        Select Case ComboFrom.SelectedIndex
            Case 0
                EnableValueFrom(True)
            Case 1 '字符末端
                EnableFrom(False)
            Case 2 '字符末端（运算）
                EnableFrom(False)
            Case 3, 5 '字符（无参数）
                EnableValueFrom(False)
            Case 2, 4, 6 '字符（有参数）
                EnableValueFrom(False)
        End Select

        Select Case ComboTo.SelectedIndex
            Case 0
                EnableValueTo(True)
            Case 1 '字符末端
                EnableTo(False)
            Case 2 '字符末端（运算）
                EnableTo(False)
            Case 3, 5 '字符（无参数）
                EnableValueTo(False)
            Case 2, 4, 6 '字符（有参数）
                EnableValueTo(False)
        End Select
    End Sub

    Private Sub EnableValueFrom(ByVal Enable As Boolean)
        UpDownFrom.Visible = Enable
        TextFrom.Visible = Not Enable
    End Sub

    Private Sub EnableValueTo(ByVal Enable As Boolean)
        UpDownTo.Visible = Enable
        TextTo.Visible = Not Enable
    End Sub

    Private Sub EnableFrom(ByVal Enable As Boolean)
        UpDownFrom.Enabled = Enable
        TextFrom.Enabled = Enable
    End Sub

    Private Sub EnableTo(ByVal Enable As Boolean)
        UpDownTo.Enabled = Enable
        TextTo.Enabled = Enable
    End Sub

#End Region


End Class