﻿Module Function1

    Friend Structure ChooseData
        Dim Index As Integer
        Dim Data As Object
    End Structure

    Friend Class DateType
        Friend ChangeType As Integer
        Friend DateFormat As String
    End Class
    Friend FormatStr() As String = {"换行符", "任意字符"}

    Friend MemoryObj As Object

#Region "字符处理函数"

    Friend Function GetFormatLength(ByRef Str As String, ByRef StrCount As Integer, ByRef Pos As Integer, ByRef FormatData() As ChooseData) As Integer
        Dim RecentPos As Integer = Pos
        Dim Checking As Boolean = False
        For Each fd As ChooseData In FormatData
Retry:
            If RecentPos > StrCount - 1 Then Return 0
            If Str(RecentPos) = Chr(13) OrElse Str(RecentPos) = Chr(10) Then Return 0
            If Checking Then
                Select Case fd.Index
                    Case -1 '字符串
                        If Not MatchString(Str, StrCount, RecentPos, DirectCast(fd.Data, String)) Then
                            RecentPos += 1
                            GoTo Retry
                        End If
                        RecentPos += DirectCast(fd.Data, String).Count
                        Checking = False
                    Case 0 '换行符
                        If Not (RecentPos < StrCount - 1 AndAlso Str(RecentPos) = Chr(13) AndAlso Str(RecentPos + 1) = Chr(10)) Then
                            RecentPos += 1
                            GoTo Retry
                        End If
                        RecentPos += 2
                        Checking = False
                    Case 1 '任意字符

                End Select
            Else
                Select Case fd.Index
                    Case -1 '字符串
                        If Not MatchString(Str, StrCount, RecentPos, DirectCast(fd.Data, String)) Then Return 0
                        RecentPos += DirectCast(fd.Data, String).Count
                    Case 0 '换行符
                        If Not (RecentPos < StrCount - 1 AndAlso Str(RecentPos) = Chr(13) AndAlso Str(RecentPos + 1) = Chr(10)) Then Return 0
                        RecentPos += 2
                    Case 1 '任意字符
                        Checking = True
                End Select
            End If
        Next
        Return RecentPos - Pos
    End Function

    Friend Function GetFormatLength(ByRef Str As String, ByRef StrCount As Integer, ByRef Pos As Integer, ByRef FormatData() As ChooseData, ByRef SearchLimit As Integer) As Integer
        Dim RecentPos As Integer = Pos
        Dim Checking As Boolean = False
        Dim SearchTime As Integer = 0
        For Each fd As ChooseData In FormatData
Retry:
            If RecentPos > StrCount - 1 Then Return 0
            If Checking Then
                If SearchTime > SearchLimit Then Return 0
                If Str(RecentPos) = Chr(13) OrElse Str(RecentPos) = Chr(10) Then Return 0
                Select Case fd.Index
                    Case -1 '字符串
                        If Not MatchString(Str, StrCount, RecentPos, DirectCast(fd.Data, String)) Then
                            RecentPos += 1
                            SearchTime += 1
                            GoTo Retry
                        End If
                        RecentPos += DirectCast(fd.Data, String).Count
                        SearchTime = 0
                        Checking = False
                    Case 0 '换行符
                        If Not (RecentPos < StrCount - 1 AndAlso Str(RecentPos) = Chr(13) AndAlso Str(RecentPos + 1) = Chr(10)) Then
                            RecentPos += 1
                            SearchTime += 1
                            GoTo Retry
                        End If
                        RecentPos += 2
                        SearchTime = 0
                        Checking = False
                    Case 1 '任意字符

                End Select
            Else
                Select Case fd.Index
                    Case -1 '字符串
                        If Not MatchString(Str, StrCount, RecentPos, DirectCast(fd.Data, String)) Then Return 0
                        RecentPos += DirectCast(fd.Data, String).Count
                    Case 0 '换行符
                        If Not (RecentPos < StrCount - 1 AndAlso Str(RecentPos) = Chr(13) AndAlso Str(RecentPos + 1) = Chr(10)) Then Return 0
                        RecentPos += 2
                    Case 1 '任意字符
                        Checking = True
                End Select
            End If
        Next
        Return RecentPos - Pos
    End Function

    Friend Function GetCorrectString(ByRef Str As String) As String
        Dim NewStr(Str.Count - 1) As Char
        Dim i As Integer = 0
        For Each c As Char In Str
            If Not (AscMatch(c, 0, 31) OrElse AscMatch(c, 127, 255) OrElse AscMatch(c, 34, 34) OrElse AscMatch(c, 42, 42) OrElse AscMatch(c, 47, 47) OrElse AscMatch(c, 58, 58) OrElse AscMatch(c, 60, 60) OrElse AscMatch(c, 62, 63) OrElse AscMatch(c, 92, 92) OrElse AscMatch(c, 124, 124)) Then
                NewStr(i) = c
                i += 1
            End If
        Next
        Array.Resize(NewStr, i)
        Return New String(NewStr)
    End Function
    Friend Function AscMatch(ByVal CheckChar As Char, ByVal FromS As Integer, ByVal ToS As Integer) As Boolean
        If Asc(CheckChar) >= FromS AndAlso Asc(CheckChar) <= ToS Then
            Return True
        Else
            Return False
        End If
    End Function

#End Region

#Region "动作基础函数"

    Friend Function GetForbiddenString() As List(Of Char)
        Dim ForbiddenString As New List(Of Char)
        For Each FStr As String In IO.File.ReadAllText(Application.StartupPath + "\ForbiddenString.txt")
            ForbiddenString.Add(FStr) '初始化禁止列表
        Next
        Return ForbiddenString
    End Function

    Friend Function GetPreviousParameter(ByRef CallCom As ComboBox) As Object
        Dim PreviousParameter As Object
        If CallCom.Tag Is Nothing OrElse DirectCast(CallCom.Tag, ChooseData).Index <> CallCom.SelectedIndex Then
            PreviousParameter = Nothing
        Else
            PreviousParameter = DirectCast(CallCom.Tag, ChooseData).Data
        End If
        Return PreviousParameter
    End Function

#End Region

#Region "文件操作函数"

    Friend Function GetNewName(ByRef OldName As String) As String
        If Not IO.File.Exists(OldName) Then Return OldName
        Dim PStr As String = GetP(OldName, ".")
        Dim BStr As String = GetM(OldName, ".")
        Dim i As Integer = 0
        Do
            Dim TmpStr As String = PStr + i.ToString + "." + BStr
            If Not IO.File.Exists(TmpStr) Then
                Return TmpStr
            End If
            i += 1
        Loop
    End Function

#End Region

End Module
