﻿Module Choose

#Region "和或判断"

    Friend Function MatchAnd(ByRef FileName As String, ByRef Data As ChooseData()) As Boolean
        Dim NumBack As Boolean '记录是否为数字后部
        Dim Correct(Data.Count - 1) As Boolean '记录是否已匹配

        For x = 0 To FileName.Count - 1  '文件名字符循环
            For y = 0 To Correct.Count - 1 '数据第二层
                If Not Correct(y) Then
                    Select Case Data(y).Index
                        Case -1 '匹配字符
                            If MatchString(FileName, x, Data(y).Data) Then Correct(y) = True
                        Case 0 '汉字
                            If IsChinese(FileName(x)) Then Correct(y) = True
                        Case 1 '字母
                            If IsMatch(FileName(x), "a", "z") OrElse IsMatch(FileName(x), "A", "Z") Then Correct(y) = True
                        Case 2 '数字
                            If IsMatch(FileName(x), "0", "9") Then Correct(y) = True
                        Case 3 '字母（范围）
                            If IsMatch(FileName(x), Data(y).Data.Data(0), Data(y).Data.Data(1)) Then Correct(y) = True
                        Case 4 '数字（范围）
                            If IsMatch(FileName(x), "0", "9") Then
                                If Not NumBack Then
                                    NumBack = True
                                    If MatchNum(FileName, x, Data(y).Data.Data(0), Data(y).Data.Data(1)) Then Correct(y) = True
                                End If
                            Else
                                NumBack = False
                            End If
                    End Select
                End If
            Next
        Next

        If IsAllTick(Correct) Then
            Return True
        Else
            Return False
        End If
    End Function

#End Region

#Region "并判断"

    Friend Function MatchConnect(ByRef FileName As String, ByVal pos As Integer, ByRef Data As ChooseData()) As Boolean
        For k = 0 To Data.Count - 1 '数据第二层
            If FileName.Count = pos Then Return False
            Select Case Data(k).Index
                Case -1 '字符串
                    Dim OriginPos As Integer
                    OriginPos = pos
                    For pos = OriginPos To CStr(Data(k).Data).Count + OriginPos - 1
                        If FileName.Count = pos Then Return False
                        If FileName(pos) <> Data(k).Data(pos - OriginPos) Then Return False
                    Next
                Case 0 '汉字
                    If Not IsChinese(FileName(pos)) Then Return False
                    pos += 1
                Case 1 '字母
                    If Not (IsMatch(FileName(pos), "a", "z") Or IsMatch(FileName(pos), "A", "Z")) Then Return False
                    pos += 1
                Case 2 '数字
                    If Not IsMatch(FileName(pos), "0", "9") Then Return False
                    pos += 1
                Case 3 '字母（范围）
                    If Not IsMatch(FileName(pos), Data(k).Data.Data(0), Data(k).Data.Data(1)) Then Return False
                    pos += 1
                Case 4 '数字（范围）
                    Dim OriginPos As Integer
                    Dim TmpStr As String = ""
                    OriginPos = pos
                    For pos = OriginPos To FileName.Count - 1
                        If IsMatch(FileName(pos), "0", "9") Then
                            TmpStr += FileName(pos)
                        Else : Exit For
                        End If
                    Next

                    If TmpStr = "" Then Return False

                    Dim MatchNum As Decimal
                    MatchNum = TmpStr
                    If MatchNum < Data(k).Data.Data(0) Then
                        Return False
                    ElseIf MatchNum > Data(k).Data.Data(1) Then
                        Return False
                    End If
            End Select
        Next

        Return True
    End Function

#End Region

#Region "动作基础函数"

    Private Function IsAllTick(ByRef Correct() As Boolean) As Boolean
        For Each Bo As Boolean In Correct
            If Bo = False Then
                Return False
            End If
        Next
        Return True
    End Function

    Private Sub AllTick(ByRef Correct() As Boolean)
        For i = 0 To Correct.Count - 1
            Correct(i) = True
        Next
    End Sub

#End Region

End Module
