﻿Imports System.CodeDom.Compiler

Public Class CodeBlocks

    Private ResultProgress As System.Reflection.MethodInfo

    Public Sub New(ByVal formula As String, ByVal GenerateMode As Integer)
        Dim CodeBlocks As New Microsoft.VisualBasic.VBCodeProvider
        Dim parameter As CompilerParameters = New CompilerParameters()
        parameter.ReferencedAssemblies.Add("System.dll")
        parameter.GenerateExecutable = False
        parameter.GenerateInMemory = True

        Dim result As CompilerResults
        Select Case GenerateMode
            Case 0 'xMath_int
                result = CodeBlocks.CompileAssemblyFromSource(parameter, GenerateCodeBlocks_xMath_int(formula))
            Case 1 'xMath_deci
                result = CodeBlocks.CompileAssemblyFromSource(parameter, GenerateCodeBlocks_xMath_deci(formula))
        End Select
        If result.Errors.Count > 0 Then
            Err.Raise(513, Me, CreateErrorDescription(result.Errors))
        End If

        ResultProgress = result.CompiledAssembly.GetType("calculation").GetMethod("calculate")
    End Sub

    Public Shared Function TryCompile(ByVal formula As String, ByVal GenerateMode As Integer) As String
        Dim CodeBlocks As New Microsoft.VisualBasic.VBCodeProvider
        Dim parameter As CompilerParameters = New CompilerParameters()
        parameter.ReferencedAssemblies.Add("System.dll")
        parameter.GenerateExecutable = False
        parameter.GenerateInMemory = True

        Dim result As CompilerResults
        Select Case GenerateMode
            Case 0 'xMath
                result = CodeBlocks.CompileAssemblyFromSource(parameter, GenerateCodeBlocks_xMath_int(formula))
        End Select

        Return CreateErrorDescription(result.Errors)
    End Function

    Public Function DoWork(ByVal ParamArray parameters() As Object) As Object
        Return ResultProgress.Invoke(Nothing, parameters)
    End Function

    Private Shared Function CreateErrorDescription(ByRef Errors As System.CodeDom.Compiler.CompilerErrorCollection) As String
        Dim ErrorDescription As String = ""
        For i = 0 To Errors.Count - 1
            ErrorDescription += Errors(i).ErrorText + vbCrLf
        Next
        Return ErrorDescription
    End Function

    Private Shared Function GenerateCodeBlocks_xMath_int(ByVal formula As String) As String
        Dim ReturnFormula = "imports System" + vbCrLf + _
        "Public Class calculation" + vbCrLf + _
        "Public Shared Function calculate(ByVal x as Integer) as Integer" + vbCrLf + _
        "Return " + formula + vbCrLf + _
        "End Function" + vbCrLf + _
        "End Class" + vbCrLf

        Return ReturnFormula
    End Function

    Private Shared Function GenerateCodeBlocks_xMath_deci(ByVal formula As String) As String
        Dim ReturnFormula = "imports System" + vbCrLf + _
        "Public Class calculation" + vbCrLf + _
        "Public Shared Function calculate(ByVal x as Decimal) as Decimal" + vbCrLf + _
        "Return " + formula + vbCrLf + _
        "End Function" + vbCrLf + _
        "End Class" + vbCrLf

        Return ReturnFormula
    End Function

End Class
