﻿Friend Class StrExtract

    Private MathFunction(1) As CodeBlocks
    Private SpInf() As ChooseData

    Friend Sub New(ByVal ExtractInf() As ChooseData)
        For i = 0 To 1
            Select Case ExtractInf(i).Index
                Case 2 '字符末端（运算）
                    MathFunction(i) = New CodeBlocks(ExtractInf(i).Data, 0)
                Case 4, 6 '字符（运算）
                    MathFunction(i) = New CodeBlocks(ExtractInf(i).Data(1), 0)
            End Select
        Next
        SpInf = ExtractInf
    End Sub

    Friend Function DoExtractStr(ByRef Str As String) As String
        Dim TmpStartPos As Integer = GetExtractPos(Str, 0)
        Dim TmpEndPos As Integer = GetExtractPos(Str, 1)
        Dim ToLength As Integer

        If TmpStartPos < 1 OrElse TmpEndPos < 1 Then Return ""

        ToLength = TmpEndPos - TmpStartPos + 1
        If ToLength < 1 Then
            Return ""
        End If

        If Str.Count >= TmpEndPos Then
            Return Mid(Str, TmpStartPos, ToLength)
        Else
            Return ""
        End If
    End Function

    Friend Function GetExtractRange(ByRef Str As String) As Integer()
        Dim RTInt(1) As Integer
        RTInt(0) = GetExtractPos(Str, 0)
        RTInt(1) = GetExtractPos(Str, 1)
        If (RTInt(0) < 1) OrElse (RTInt(1) < 1) OrElse (RTInt(1) - RTInt(0) + 1 < 1) OrElse (RTInt(0) > Str.Count) OrElse (RTInt(1) > Str.Count) Then
            RTInt(0) = 1
            RTInt(1) = 0
        End If
        Return RTInt
    End Function

    Private Function GetExtractPos(ByRef Str As String, ByVal Ind As Integer) As Integer
        Select Case SpInf(Ind).Index
            Case 0
                Return Integer.Parse(SpInf(Ind).Data)
            Case 1 '字符末端
                Return Str.Count
            Case 2 '字符末端（运算）
                Return MathFunction(Ind).DoWork(Str.Count)
            Case 3 '第一个字符位置
                Select Case SpInf(Ind).Data.Index
                    Case -1 '自定义字符
                        For i = 0 To Str.Count - 1
                            If MatchString(Str, i, SpInf(Ind).Data.Data) Then
                                Return i + 1
                            End If
                        Next
                    Case 0 '汉字
                        For i = 0 To Str.Count - 1
                            If IsChinese(Str(i)) Then
                                Return i + 1
                            End If
                        Next
                    Case 1 '数字
                        For i = 0 To Str.Count - 1
                            If IsMatch(Str(i), "0", "9") Then
                                Return i + 1
                            End If
                        Next
                    Case 2 '字母
                        For i = 0 To Str.Count - 1
                            If IsMatch(Str(i), "a", "z") OrElse IsMatch(Str(i), "A", "Z") Then
                                Return i + 1
                            End If
                        Next
                End Select
            Case 4 '第一个字符位置（运算）
                Dim TmpInt As Integer

                Select Case SpInf(Ind).Data(0).Index
                    Case -1 '自定义字符
                        For i = 0 To Str.Count - 1
                            If MatchString(Str, i, DirectCast(SpInf(Ind).Data(0), ChooseData).Data) Then
                                TmpInt = i + 1
                                Exit For
                            End If
                        Next
                    Case 0 '汉字
                        For i = 0 To Str.Count - 1
                            If IsChinese(Str(i)) Then
                                TmpInt = i + 1
                                Exit For
                            End If
                        Next
                    Case 1 '数字
                        For i = 0 To Str.Count - 1
                            If IsMatch(Str(i), "0", "9") Then
                                TmpInt = i + 1
                                Exit For
                            End If
                        Next
                    Case 2 '字母
                        For i = 0 To Str.Count - 1
                            If IsMatch(Str(i), "a", "z") OrElse IsMatch(Str(i), "A", "Z") Then
                                TmpInt = i + 1
                                Exit For
                            End If
                        Next
                End Select

                If TmpInt = 0 Then Return 0
                Return MathFunction(Ind).DoWork(TmpInt)
            Case 5 '最后一个字符位置
                Select Case SpInf(Ind).Data.Index
                    Case -1 '自定义字符
                        For i = Str.Count - 1 To 0 Step -1
                            If MatchString(Str, i, SpInf(Ind).Data.Data) Then
                                Return i + 1
                            End If
                        Next
                    Case 0 '汉字
                        For i = Str.Count - 1 To 0 Step -1
                            If IsChinese(Str(i)) Then
                                Return i + 1
                            End If
                        Next
                    Case 1 '数字
                        For i = Str.Count - 1 To 0 Step -1
                            If IsMatch(Str(i), "0", "9") Then
                                Return i + 1
                            End If
                        Next
                    Case 2 '字母
                        For i = Str.Count - 1 To 0 Step -1
                            If IsMatch(Str(i), "a", "z") OrElse IsMatch(Str(i), "A", "Z") Then
                                Return i + 1
                            End If
                        Next
                End Select
            Case 6 '最后一个字符位置（运算）
                Dim TmpInt As Integer

                Select Case SpInf(Ind).Data(0).Index
                    Case -1 '自定义字符
                        For i = Str.Count - 1 To 0 Step -1
                            If MatchString(Str, i, DirectCast(SpInf(Ind).Data(0), ChooseData).Data) Then
                                TmpInt = i + 1
                                Exit For
                            End If
                        Next
                    Case 0 '汉字
                        For i = Str.Count - 1 To 0 Step -1
                            If IsChinese(Str(i)) Then
                                TmpInt = i + 1
                                Exit For
                            End If
                        Next
                    Case 1 '数字
                        For i = Str.Count - 1 To 0 Step -1
                            If IsMatch(Str(i), "0", "9") Then
                                TmpInt = i + 1
                                Exit For
                            End If
                        Next
                    Case 2 '字母
                        For i = Str.Count - 1 To 0 Step -1
                            If IsMatch(Str(i), "a", "z") OrElse IsMatch(Str(i), "A", "Z") Then
                                TmpInt = i + 1
                                Exit For
                            End If
                        Next
                End Select

                If TmpInt = 0 Then Return 0
                Return MathFunction(Ind).DoWork(TmpInt)
        End Select

        Return 0
    End Function

End Class
