/****** Object:  Table [dbo].[Content]    Script Date: 2013-2-12 11:50:08 ******/
CREATE TABLE [dbo].[Content] (
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
	[Content] [varchar] (400) NOT NULL ,
	[Port] [int] NOT NULL ,
	[IsStop] [char] (4) NOT NULL ,
	[Tel] [varchar] (20) NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[Customer]    Script Date: 2013-2-12 11:50:08 ******/
CREATE TABLE [dbo].[Customer] (
	[CustomerTel] [varchar] (20) NOT NULL ,
	[CustomerName] [varchar] (20) NULL ,
	[Sex] [char] (2) NULL ,
	[company] [varchar] (50) NULL ,
	[birth] [datetime] NULL ,
	[GroupName] [varchar] (20) NULL ,
	[Addr] [nvarchar] (50) NULL ,
	[demo] [nvarchar] (50) NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[Rece]    Script Date: 2013-2-12 11:50:08 ******/
CREATE TABLE [dbo].[Rece] (
	[ID] [bigint] IDENTITY (1, 1) NOT NULL ,
	[ReceMobile] [varchar] (20) NOT NULL ,
	[SendMobile] [varchar] (20) NOT NULL ,
	[Content] [varchar] (400) NOT NULL ,
	[SendTime] [datetime] NOT NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[Send]    Script Date: 2013-2-12 11:50:08 ******/
CREATE TABLE [dbo].[Send] (
	[ID] [bigint] IDENTITY (1, 1) NOT NULL ,
	[ReceMobile] [varchar] (20) NOT NULL ,
	[SendMobile] [varchar] (20) NOT NULL ,
	[Content] [varchar] (400) NOT NULL ,
	[SendTime] [datetime] NOT NULL ,
	[SendCount] [tinyint] NOT NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[SendHis]    Script Date: 2013-2-12 11:50:09 ******/
CREATE TABLE [dbo].[SendHis] (
	[ID] [bigint] NOT NULL ,
	[ReceMobile] [varchar] (20) NOT NULL ,
	[SendMobile] [varchar] (20) NOT NULL ,
	[Content] [varchar] (400) NOT NULL ,
	[SendTime] [datetime] NOT NULL ,
	[SendCount] [tinyint] NOT NULL 
) ON [PRIMARY]
GO

/****** Object:  Table [dbo].[sendFailed]    Script Date: 2013-2-12 11:50:09 ******/
CREATE TABLE [dbo].[sendFailed] (
	[ID] [bigint] NOT NULL ,
	[ReceMobile] [varchar] (20) NOT NULL ,
	[SendMobile] [varchar] (20) NOT NULL ,
	[Content] [varchar] (400) NOT NULL ,
	[SendTime] [datetime] NOT NULL ,
	[SendCount] [tinyint] NOT NULL 
) ON [PRIMARY]
GO

ALTER TABLE [dbo].[Content] WITH NOCHECK ADD 
	CONSTRAINT [PK_Content] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[Customer] WITH NOCHECK ADD 
	CONSTRAINT [PK_Customer] PRIMARY KEY  CLUSTERED 
	(
		[CustomerTel]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[Send] WITH NOCHECK ADD 
	CONSTRAINT [PK_Send] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[SendHis] WITH NOCHECK ADD 
	CONSTRAINT [PK_SendHis] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[sendFailed] WITH NOCHECK ADD 
	CONSTRAINT [PK_sendFailed] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[Content] ADD 
	CONSTRAINT [DF_Content_IsStop] DEFAULT (1) FOR [IsStop]
GO

ALTER TABLE [dbo].[Customer] ADD 
	CONSTRAINT [DF_Customer_age] DEFAULT (0) FOR [birth]
GO

ALTER TABLE [dbo].[Rece] ADD 
	CONSTRAINT [DF_Rece_OprTime] DEFAULT (getdate()) FOR [SendTime]
GO

ALTER TABLE [dbo].[Send] ADD 
	CONSTRAINT [DF_Send_SendTime] DEFAULT (getdate()) FOR [SendTime],
	CONSTRAINT [DF_Send_SendCount] DEFAULT (0) FOR [SendCount]
GO

