/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.tracking;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class FoodInstance {
    public final Item item;
    public final int metadata;

    public FoodInstance(ItemStack itemStack) {
        this(itemStack.func_77973_b(), itemStack.func_77960_j());
    }

    public FoodInstance(Item item, int metadata) {
        this.item = item;
        this.metadata = item.func_77614_k() ? metadata : 0;
    }

    @Nullable
    public static FoodInstance decode(String encoded) {
        String[] parts = encoded.split("@");
        ResourceLocation name = new ResourceLocation(parts[0]);
        int meta = parts.length > 1 ? Integer.decode(parts[1]) : 0;
        return Optional.ofNullable(ForgeRegistries.ITEMS.getValue(name)).map(item -> new FoodInstance((Item)item, meta)).orElse(null);
    }

    @Nullable
    public String encode() {
        return Optional.ofNullable(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.item)).map(location -> location + "@" + this.metadata).orElse(null);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.item == null ? 0 : this.item.hashCode());
        result = 31 * result + this.metadata;
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FoodInstance)) {
            return false;
        }
        FoodInstance other = (FoodInstance)obj;
        return ItemStack.func_77989_b((ItemStack)this.getItemStack(), (ItemStack)other.getItemStack());
    }

    public ItemStack getItemStack() {
        return new ItemStack(this.item, 1, this.metadata);
    }
}

