/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.profiles.pegdown;

import com.vladsch.flexmark.ext.abbreviation.AbbreviationExtension;
import com.vladsch.flexmark.ext.anchorlink.AnchorLinkExtension;
import com.vladsch.flexmark.ext.autolink.AutolinkExtension;
import com.vladsch.flexmark.ext.definition.DefinitionExtension;
import com.vladsch.flexmark.ext.escaped.character.EscapedCharacterExtension;
import com.vladsch.flexmark.ext.footnotes.FootnoteExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughSubscriptExtension;
import com.vladsch.flexmark.ext.gfm.strikethrough.SubscriptExtension;
import com.vladsch.flexmark.ext.gfm.tasklist.TaskListExtension;
import com.vladsch.flexmark.ext.ins.InsExtension;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.ext.toc.SimTocExtension;
import com.vladsch.flexmark.ext.toc.TocExtension;
import com.vladsch.flexmark.ext.toc.internal.TocOptions;
import com.vladsch.flexmark.ext.typographic.TypographicExtension;
import com.vladsch.flexmark.ext.wikilink.WikiLinkExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.parser.ParserEmulationProfile;
import com.vladsch.flexmark.superscript.SuperscriptExtension;
import com.vladsch.flexmark.util.ast.KeepType;
import com.vladsch.flexmark.util.builder.Extension;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKey;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.data.MutableDataSetter;
import java.util.ArrayList;
import java.util.Arrays;

public class PegdownOptionsAdapter {
    public static final DataKey<Integer> PEGDOWN_EXTENSIONS = ParserEmulationProfile.PEGDOWN_EXTENSIONS;
    private final MutableDataSet myOptions;
    private int myPegdownExtensions = 0;
    private boolean myIsUpdateNeeded = false;

    public PegdownOptionsAdapter() {
        this.myOptions = new MutableDataSet();
    }

    public PegdownOptionsAdapter(DataHolder dataSet) {
        this.myOptions = new MutableDataSet(dataSet);
    }

    public PegdownOptionsAdapter(int pegdownExtensions) {
        this.myOptions = new MutableDataSet();
        this.myPegdownExtensions = pegdownExtensions;
        this.myIsUpdateNeeded = true;
    }

    public static DataHolder flexmarkOptions(int pegdownExtensions, Extension ... extensions) {
        return PegdownOptionsAdapter.flexmarkOptions(false, pegdownExtensions, extensions);
    }

    public static DataHolder flexmarkOptions(boolean strictHtml, int pegdownExtensions, Extension ... extensions) {
        PegdownOptionsAdapter optionsAdapter = new PegdownOptionsAdapter(pegdownExtensions);
        return optionsAdapter.getFlexmarkOptions(strictHtml, extensions);
    }

    @Deprecated
    public boolean haveExtensions(int mask) {
        return this.haveAnyExtensions(mask);
    }

    @Deprecated
    public boolean allExtensions(int mask) {
        return this.haveAllExtensions(mask);
    }

    public boolean haveAnyExtensions(int mask) {
        return ParserEmulationProfile.haveAny((int)this.myPegdownExtensions, (int)mask);
    }

    public boolean haveAllExtensions(int mask) {
        return ParserEmulationProfile.haveAll((int)this.myPegdownExtensions, (int)mask);
    }

    public DataHolder getFlexmarkOptions(Extension ... additionalExtensions) {
        return this.getFlexmarkOptions(false, additionalExtensions);
    }

    public DataHolder getFlexmarkOptions(boolean strictHtml, Extension ... additionalExtensions) {
        if (this.myIsUpdateNeeded) {
            this.myIsUpdateNeeded = false;
            MutableDataSet options = this.myOptions;
            ArrayList<Extension> extensions = new ArrayList<Extension>(Arrays.asList(additionalExtensions));
            options.clear();
            options.set(ParserEmulationProfile.PEGDOWN_EXTENSIONS, (Object)this.myPegdownExtensions);
            options.setFrom((MutableDataSetter)(strictHtml ? ParserEmulationProfile.PEGDOWN_STRICT : ParserEmulationProfile.PEGDOWN));
            options.set(HtmlRenderer.SUPPRESS_HTML_BLOCKS, (Object)this.haveExtensions(65536));
            options.set(HtmlRenderer.SUPPRESS_INLINE_HTML, (Object)this.haveExtensions(131072));
            extensions.add(EscapedCharacterExtension.create());
            if (this.haveExtensions(4)) {
                extensions.add(AbbreviationExtension.create());
                options.set(AbbreviationExtension.ABBREVIATIONS_KEEP, (Object)KeepType.LAST);
            }
            if (this.haveExtensions(0x400400)) {
                options.set(HtmlRenderer.RENDER_HEADER_ID, (Object)false);
                extensions.add(AnchorLinkExtension.create());
                if (this.haveExtensions(0x400000)) {
                    options.set(AnchorLinkExtension.ANCHORLINKS_WRAP_TEXT, (Object)false);
                } else if (this.haveExtensions(1024)) {
                    options.set(AnchorLinkExtension.ANCHORLINKS_WRAP_TEXT, (Object)true);
                }
            }
            if (this.haveExtensions(16)) {
                extensions.add(AutolinkExtension.create());
            }
            if (this.haveExtensions(64)) {
                extensions.add(DefinitionExtension.create());
            }
            if (!this.haveExtensions(128)) {
                options.set(Parser.FENCED_CODE_BLOCK_PARSER, (Object)false);
            } else {
                options.set(Parser.MATCH_CLOSING_FENCE_CHARACTERS, (Object)false);
            }
            if (this.haveExtensions(0x10000000)) {
                options.set(Parser.LISTS_LOOSE_WHEN_HAS_NON_LIST_CHILDREN, (Object)true);
            }
            if (this.haveExtensions(8)) {
                options.set(HtmlRenderer.SOFT_BREAK, (Object)"<br />\n");
                options.set(HtmlRenderer.HARD_BREAK, (Object)"<br />\n");
            }
            if (!this.haveExtensions(262144)) {
                options.set(Parser.HEADING_NO_ATX_SPACE, (Object)true);
            }
            if (this.haveExtensions(3)) {
                extensions.add(TypographicExtension.create());
                options.set(TypographicExtension.ENABLE_SMARTS, (Object)this.haveExtensions(1));
                options.set(TypographicExtension.ENABLE_QUOTES, (Object)this.haveExtensions(2));
            }
            if (!this.haveExtensions(0x100000)) {
                options.set(Parser.THEMATIC_BREAK_RELAXED_START, (Object)false);
            }
            if (this.haveExtensions(32)) {
                extensions.add(TablesExtension.create());
                options.set(TablesExtension.TRIM_CELL_WHITESPACE, (Object)false);
                options.set(TablesExtension.HEADER_SEPARATOR_COLUMN_MATCH, (Object)false);
            }
            if (this.haveExtensions(0x200000)) {
                extensions.add(TaskListExtension.create());
            }
            if (this.haveExtensions(256)) {
                extensions.add(WikiLinkExtension.create());
                options.set(WikiLinkExtension.LINK_FIRST_SYNTAX, (Object)false);
            }
            if (this.haveExtensions(524288) && this.haveExtensions(512)) {
                extensions.add(StrikethroughSubscriptExtension.create());
            } else if (this.haveExtensions(512)) {
                extensions.add(StrikethroughExtension.create());
            } else if (this.haveExtensions(524288)) {
                extensions.add(SubscriptExtension.create());
            }
            if (this.haveExtensions(0x8000000)) {
                extensions.add(SuperscriptExtension.create());
            }
            if (this.haveExtensions(0x40000000)) {
                extensions.add(InsExtension.create());
            }
            if (this.haveExtensions(0x2000000)) {
                extensions.add(SimTocExtension.create());
                options.set(TocExtension.BLANK_LINE_SPACER, (Object)true);
                extensions.add(TocExtension.create());
                options.set(TocExtension.LEVELS, (Object)TocOptions.getLevels((int[])new int[]{2, 3}));
            }
            if (this.haveExtensions(0x4000000)) {
                options.set(Parser.PARSE_MULTI_LINE_IMAGE_URLS, (Object)true);
            }
            if (this.haveExtensions(0x1000000)) {
                extensions.add(FootnoteExtension.create());
                options.set(FootnoteExtension.FOOTNOTES_KEEP, (Object)KeepType.LAST);
            }
            this.myOptions.set(Parser.EXTENSIONS, extensions);
        }
        return this.myOptions.toImmutable();
    }

    public PegdownOptionsAdapter setPegdownExtensions(int pegdownExtensions) {
        this.myPegdownExtensions = pegdownExtensions;
        this.myIsUpdateNeeded = true;
        return this;
    }

    public PegdownOptionsAdapter addPegdownExtensions(int pegdownExtensions) {
        this.myPegdownExtensions |= pegdownExtensions;
        this.myIsUpdateNeeded = true;
        return this;
    }

    public PegdownOptionsAdapter removePegdownExtensions(int pegdownExtensions) {
        this.myPegdownExtensions &= ~pegdownExtensions;
        this.myIsUpdateNeeded = true;
        return this;
    }
}

