/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.http.Cookie;
import org.b3log.latke.http.Dispatcher;
import org.b3log.latke.http.RequestContext;
import org.b3log.latke.http.handler.ContextHandlerMeta;
import org.b3log.latke.http.renderer.AbstractResponseRenderer;
import org.b3log.latke.ioc.BeanManager;

public class Response {
    private static final Logger LOGGER = LogManager.getLogger(Response.class);
    ChannelHandlerContext ctx;
    RequestContext context;
    private HttpResponse res;
    private boolean commited;
    private boolean keepAlive;
    private byte[] content;
    private Set<Cookie> cookies;

    public Response(ChannelHandlerContext ctx, HttpResponse res) {
        this.ctx = ctx;
        this.res = res;
        this.cookies = new HashSet<Cookie>();
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isCommitted() {
        return this.commited;
    }

    public String getHeader(String name) {
        return this.res.headers().get(name);
    }

    public void addHeader(String name, String value) {
        this.res.headers().add(name, (Object)value);
    }

    public void setHeader(String name, String value) {
        this.res.headers().set(name, (Object)value);
    }

    public void setStatus(int status) {
        this.res.setStatus(HttpResponseStatus.valueOf((int)status));
    }

    public String getContentType() {
        return this.res.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
    }

    public void setContentType(String contentType) {
        this.res.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
    }

    public Iterator<String> getHeaderNames() {
        return this.res.headers().names().iterator();
    }

    public void addCookie(Cookie cookie) {
        String name = cookie.getName();
        this.cookies.removeIf(c -> c.getName().equals(cookie.getName()));
        this.cookies.add(cookie);
    }

    public Set<Cookie> getCookies() {
        return this.cookies;
    }

    public void setCookies(Set<Cookie> cookies) {
        this.cookies = cookies;
    }

    public String getString() {
        return StringUtils.newStringUtf8((byte[])this.content);
    }

    public byte[] getBytes() {
        return this.content;
    }

    public void sendError0(int status) {
        this.setStatus(status);
        this.writeResponse();
    }

    public void sendError(int status) {
        this.sendError(status, null);
    }

    public void sendError(int status, Map<String, Object> dataModel) {
        this.setStatus(status);
        if (null != Dispatcher.errorHandleRouter) {
            try {
                this.context.attr("ERROR_CODE", status);
                ContextHandlerMeta contextHandlerMeta = Dispatcher.errorHandleRouter.toContextHandlerMeta();
                Method invokeHolder = contextHandlerMeta.getInvokeHolder();
                BeanManager beanManager = BeanManager.getInstance();
                Object classHolder = beanManager.getReference(invokeHolder.getDeclaringClass());
                this.context.pathVar("statusCode", String.valueOf(status));
                this.context.attr("dataModel", dataModel);
                invokeHolder.invoke(classHolder, this.context);
                AbstractResponseRenderer renderer = this.context.getRenderer();
                renderer.render(this.context);
                return;
            }
            catch (Exception e) {
                LOGGER.log(Level.ERROR, "Use error handler failed", (Throwable)e);
            }
        }
        this.writeResponse();
    }

    public void sendRedirect(String location) {
        this.setHeader(HttpHeaderNames.LOCATION.toString(), location);
        this.setStatus(HttpResponseStatus.FOUND.code());
        this.writeResponse();
    }

    public void sendBytes(byte[] bytes) {
        this.content = bytes;
        this.writeResponse();
    }

    public void sendString(String string) {
        this.content = StringUtils.getBytesUtf8((String)string);
        this.writeResponse();
    }

    public void send() {
        this.writeResponse();
    }

    private void writeResponse() {
        ByteBuf contentBuf = null != this.content ? Unpooled.copiedBuffer((byte[])this.content) : Unpooled.EMPTY_BUFFER;
        this.res = ((FullHttpResponse)this.res).replace(contentBuf);
        if (this.keepAlive) {
            this.res.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, ((FullHttpResponse)this.res).content().readableBytes());
            this.res.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        for (Cookie cookie : this.cookies) {
            this.res.headers().add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)ServerCookieEncoder.STRICT.encode(cookie.cookie));
        }
        this.commited = true;
        if (null != this.ctx) {
            this.ctx.write((Object)this.res);
            if (!this.keepAlive) {
                this.ctx.write((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
            this.ctx.flush();
        }
    }
}

