/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.ioc;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.ioc.BeanManager;
import org.b3log.latke.ioc.Configurator;
import org.b3log.latke.ioc.FieldInjectionPoint;
import org.b3log.latke.ioc.Inject;
import org.b3log.latke.ioc.JavassistMethodHandler;
import org.b3log.latke.ioc.annotated.AnnotatedField;
import org.b3log.latke.ioc.annotated.AnnotatedType;
import org.b3log.latke.ioc.annotated.AnnotatedTypeImpl;
import org.b3log.latke.util.Reflections;

public class Bean<T> {
    private static final Logger LOGGER = LogManager.getLogger(Bean.class);
    private final Set<Class<? extends Annotation>> stereotypes;
    private final BeanManager beanManager;
    private final Configurator configurator;
    private final String name;
    private final Class<T> beanClass;
    private final Class<T> proxyClass;
    private final JavassistMethodHandler javassistMethodHandler;
    private final Set<Type> types;
    private final AnnotatedType<T> annotatedType;
    private final Set<FieldInjectionPoint> fieldInjectionPoints;

    public Bean(BeanManager beanManager, String name, Class<T> beanClass, Set<Type> types, Set<Class<? extends Annotation>> stereotypes) {
        this.beanManager = beanManager;
        this.name = name;
        this.beanClass = beanClass;
        this.types = types;
        this.stereotypes = stereotypes;
        this.configurator = beanManager.getConfigurator();
        this.javassistMethodHandler = new JavassistMethodHandler(beanManager);
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setSuperclass(beanClass);
        proxyFactory.setFilter(this.javassistMethodHandler.getMethodFilter());
        this.proxyClass = proxyFactory.createClass();
        this.annotatedType = new AnnotatedTypeImpl<T>(beanClass);
        this.fieldInjectionPoints = new HashSet<FieldInjectionPoint>();
        this.initFieldInjectionPoints();
    }

    private void resolveDependencies(Object reference) {
        Class<?> superclass = reference.getClass().getSuperclass().getSuperclass();
        this.resolveSuperclassFieldDependencies(reference, superclass);
        this.resolveCurrentclassFieldDependencies(reference);
    }

    private T instantiateReference() throws Exception {
        T ret = this.proxyClass.newInstance();
        ((ProxyObject)ret).setHandler((MethodHandler)this.javassistMethodHandler);
        LOGGER.log(Level.TRACE, "Uses Javassist method handler for bean [class={}]", (Object)this.beanClass.getName());
        return ret;
    }

    private void resolveCurrentclassFieldDependencies(Object reference) {
        for (FieldInjectionPoint injectionPoint : this.fieldInjectionPoints) {
            Object injection = this.beanManager.getInjectableReference(injectionPoint);
            Field field = injectionPoint.getAnnotated().getJavaMember();
            try {
                Field declaredField = this.proxyClass.getDeclaredField(field.getName());
                if (!declaredField.isAnnotationPresent(Inject.class)) continue;
                try {
                    declaredField.set(reference, injection);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            catch (NoSuchFieldException ex) {
                try {
                    field.set(reference, injection);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void resolveSuperclassFieldDependencies(Object reference, Class<?> clazz) {
        if (clazz.equals(Object.class)) {
            return;
        }
        Class<?> superclass = clazz.getSuperclass();
        this.resolveSuperclassFieldDependencies(reference, superclass);
        if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) {
            return;
        }
        Bean<?> bean = this.beanManager.getBean(clazz);
        Set<FieldInjectionPoint> injectionPoints = bean.fieldInjectionPoints;
        for (FieldInjectionPoint injectionPoint : injectionPoints) {
            Object injection = this.beanManager.getInjectableReference(injectionPoint);
            Field field = injectionPoint.getAnnotated().getJavaMember();
            try {
                Field declaredField = this.proxyClass.getDeclaredField(field.getName());
                if (Reflections.matchInheritance(declaredField, field)) continue;
                try {
                    field.set(reference, injection);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            catch (NoSuchFieldException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return this.stereotypes;
    }

    public void destroy(T instance) {
        LOGGER.log(Level.DEBUG, "Destroyed bean [name={}]", (Object)this.name);
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public String getName() {
        return this.name;
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public T create() {
        T ret = null;
        try {
            ret = this.instantiateReference();
            this.resolveDependencies(ret);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Creates bean [name=" + this.name + "] failed", (Throwable)e);
        }
        return ret;
    }

    public String toString() {
        return "[name=" + this.name + ", class=" + this.beanClass.getName() + ", types=" + this.types + "]";
    }

    private void initFieldInjectionPoints() {
        Set<AnnotatedField<T>> annotatedFields = this.annotatedType.getFields();
        for (AnnotatedField<T> annotatedField : annotatedFields) {
            FieldInjectionPoint fieldInjectionPoint = new FieldInjectionPoint(this, annotatedField);
            this.fieldInjectionPoints.add(fieldInjectionPoint);
        }
    }
}

