/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.ioc;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.b3log.latke.ioc.Bean;

public final class SingletonContext {
    private final Map<Bean<?>, Object> beanReferences = new HashMap();

    public <T> void add(Bean<T> bean, T reference) {
        this.beanReferences.put(bean, reference);
    }

    public <T> T get(Bean<T> bean) {
        return this.getReference(bean);
    }

    private <T> T getReference(Bean<T> bean) {
        Object ret = this.beanReferences.get(bean);
        if (null != ret) {
            return (T)ret;
        }
        ret = bean.create();
        if (null != ret) {
            this.beanReferences.put(bean, ret);
            return (T)ret;
        }
        throw new RuntimeException("Can't create reference for bean [" + bean + "]");
    }

    public <T> void destroy() {
        Set<Map.Entry<Bean<?>, Object>> beanSet = this.beanReferences.entrySet();
        Iterator<Map.Entry<Bean<?>, Object>> i = beanSet.iterator();
        while (i.hasNext()) {
            Bean<?> bean = i.next().getKey();
            Object instance = this.beanReferences.get(bean);
            this.destroyReference(bean, instance);
        }
        this.beanReferences.clear();
    }

    private <T> void destroyReference(Bean<T> bean, T beanInstance) {
        bean.destroy(beanInstance);
    }
}

