/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.b3log.latke.repository.Filter;
import org.b3log.latke.repository.Projection;
import org.b3log.latke.repository.SortDirection;

public final class Query {
    private int currentPageNum = 1;
    private Integer pageCount;
    private int pageSize = Integer.MAX_VALUE;
    private final Map<String, SortDirection> sorts = new LinkedHashMap<String, SortDirection>();
    private Filter filter;
    private final List<Projection> projections = new ArrayList<Projection>();
    private boolean debug;

    public Query setPage(int currentPageNum, int pageSize) {
        this.setCurrentPageNum(currentPageNum);
        this.setPageSize(pageSize);
        return this;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public Query setDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public Query select(String propertyName, String ... propertyNames) {
        this.projections.add(new Projection(propertyName));
        if (null != propertyNames && 0 < propertyNames.length) {
            for (String name : propertyNames) {
                this.projections.add(new Projection(name));
            }
        }
        return this;
    }

    public List<Projection> getProjections() {
        return Collections.unmodifiableList(this.projections);
    }

    public Query addSort(String propertyName, SortDirection sortDirection) {
        this.sorts.put(propertyName, sortDirection);
        return this;
    }

    public Query setFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public int getCurrentPageNum() {
        return this.currentPageNum;
    }

    public Query setCurrentPageNum(int currentPageNum) {
        this.currentPageNum = currentPageNum;
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Query setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public Map<String, SortDirection> getSorts() {
        return Collections.unmodifiableMap(this.sorts);
    }

    public Integer getPageCount() {
        return this.pageCount;
    }

    public Query setPageCount(int pageCount) {
        this.pageCount = pageCount;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query = (Query)o;
        return this.currentPageNum == query.currentPageNum && this.pageSize == query.pageSize && this.debug == query.debug && Objects.equals(this.pageCount, query.pageCount) && Objects.equals(this.sorts, query.sorts) && Objects.equals(this.filter, query.filter) && Objects.equals(this.projections, query.projections);
    }

    public int hashCode() {
        return Objects.hash(this.currentPageNum, this.pageCount, this.pageSize, this.sorts, this.filter, this.projections, this.debug);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("currentPageNum=").append(this.currentPageNum).append(", pageSize=").append(this.pageSize).append(", pageCount=").append(this.pageCount).append(", sorts=[");
        Set<Map.Entry<String, SortDirection>> entrySet = this.sorts.entrySet();
        Iterator<Map.Entry<String, SortDirection>> sortsIterator = entrySet.iterator();
        while (sortsIterator.hasNext()) {
            Map.Entry<String, SortDirection> sort = sortsIterator.next();
            stringBuilder.append("[key=").append(sort.getKey()).append(", direction=").append(sort.getValue().name()).append("]");
            if (!sortsIterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        if (null != this.filter) {
            stringBuilder.append(", filter=[").append(this.filter.toString()).append("]");
        }
        stringBuilder.append(", projections=[");
        Iterator<Projection> projectionsIterator = this.projections.iterator();
        while (projectionsIterator.hasNext()) {
            Projection projection = projectionsIterator.next();
            stringBuilder.append('[').append(projection.toString()).append(']');
            if (!projectionsIterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

