/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository.jdbc;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.Latkes;
import org.b3log.latke.repository.jdbc.AbstractJdbcDatabaseSolution;
import org.b3log.latke.repository.jdbc.JdbcDatabase;
import org.b3log.latke.repository.jdbc.JdbcRepository;
import org.b3log.latke.repository.jdbc.util.RepositoryDefinition;

public final class JdbcFactory
implements JdbcDatabase {
    private static final Logger LOGGER = LogManager.getLogger(JdbcRepository.class);
    private AbstractJdbcDatabaseSolution databaseSolution;
    private static final Map<Latkes.RuntimeDatabase, String> SOLUTIONS = new HashMap<Latkes.RuntimeDatabase, String>();
    private static final JdbcFactory INSTANCE;

    @Override
    public boolean existTable(String tableName) {
        return this.databaseSolution.existTable(tableName);
    }

    @Override
    public boolean createTable(RepositoryDefinition repositoryDefinition) throws SQLException {
        return this.databaseSolution.createTable(repositoryDefinition);
    }

    public static JdbcFactory getInstance() {
        return INSTANCE;
    }

    private JdbcFactory() {
        String databaseSolutionClassName = SOLUTIONS.get((Object)Latkes.getRuntimeDatabase());
        try {
            this.databaseSolution = (AbstractJdbcDatabaseSolution)Class.forName(databaseSolutionClassName).newInstance();
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Init JdbcDatabaseSolution [" + databaseSolutionClassName + "] instance failed", (Throwable)e);
        }
    }

    @Override
    public String queryPage(int start, int end, String selectSql, String filterSql, String orderBySql, String tableName) {
        return this.databaseSolution.queryPage(start, end, selectSql, filterSql, orderBySql, tableName);
    }

    @Override
    public String getRandomlySql(String tableName, int fetchSize) {
        return this.databaseSolution.getRandomlySql(tableName, fetchSize);
    }

    static {
        SOLUTIONS.put(Latkes.RuntimeDatabase.MYSQL, "org.b3log.latke.repository.mysql.MySQLJdbcDatabaseSolution");
        SOLUTIONS.put(Latkes.RuntimeDatabase.H2, "org.b3log.latke.repository.h2.H2JdbcDatabaseSolution");
        INSTANCE = new JdbcFactory();
    }
}

