/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository.jdbc;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.Keys;
import org.b3log.latke.Latkes;
import org.b3log.latke.repository.CompositeFilter;
import org.b3log.latke.repository.CompositeFilterOperator;
import org.b3log.latke.repository.DBKeyGenerator;
import org.b3log.latke.repository.Filter;
import org.b3log.latke.repository.FilterOperator;
import org.b3log.latke.repository.KeyGenerator;
import org.b3log.latke.repository.Projection;
import org.b3log.latke.repository.PropertyFilter;
import org.b3log.latke.repository.Query;
import org.b3log.latke.repository.Repositories;
import org.b3log.latke.repository.Repository;
import org.b3log.latke.repository.RepositoryException;
import org.b3log.latke.repository.SortDirection;
import org.b3log.latke.repository.TimeMillisKeyGenerator;
import org.b3log.latke.repository.Transaction;
import org.b3log.latke.repository.jdbc.JdbcFactory;
import org.b3log.latke.repository.jdbc.JdbcTransaction;
import org.b3log.latke.repository.jdbc.util.Connections;
import org.b3log.latke.repository.jdbc.util.JdbcRepositories;
import org.b3log.latke.repository.jdbc.util.JdbcUtil;
import org.json.JSONObject;

public final class JdbcRepository
implements Repository {
    private static final Logger LOGGER = LogManager.getLogger(JdbcRepository.class);
    public static final ThreadLocal<JdbcTransaction> TX = new ThreadLocal();
    public static final ThreadLocal<Connection> CONN = new ThreadLocal();
    private static final KeyGenerator<?> KEY_GEN;
    private final String name;
    private boolean writable = true;
    private boolean debug;

    public JdbcRepository(String name) {
        this.name = name;
    }

    public static void dispose() {
        Connection connection;
        JdbcTransaction jdbcTransaction = TX.get();
        if (null != jdbcTransaction && jdbcTransaction.getConnection() != null) {
            jdbcTransaction.dispose();
        }
        if (null != (connection = CONN.get())) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                throw new RuntimeException("Close connection failed", e);
            }
            finally {
                CONN.remove();
            }
        }
    }

    @Override
    public String add(JSONObject jsonObject) throws RepositoryException {
        String ret;
        JdbcTransaction currentTransaction = TX.get();
        if (null == currentTransaction) {
            throw new RepositoryException("Invoking add() outside a transaction");
        }
        Connection connection = this.getConnection();
        ArrayList<Object> paramList = new ArrayList<Object>();
        StringBuilder sqlBuilder = new StringBuilder();
        try {
            ret = this.buildAddSql(jsonObject, paramList, sqlBuilder);
            JdbcUtil.executeSql(sqlBuilder.toString(), paramList, connection, this.debug);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Adds a record failed", (Throwable)e);
            throw new RepositoryException(e);
        }
        return ret;
    }

    private String buildAddSql(JSONObject jsonObject, List<Object> paramList, StringBuilder sqlBuilder) {
        String ret = null;
        if (!jsonObject.has(Keys.OBJECT_ID)) {
            if (!(KEY_GEN instanceof DBKeyGenerator)) {
                ret = (String)KEY_GEN.gen();
                jsonObject.put(Keys.OBJECT_ID, ret);
            }
        } else {
            ret = jsonObject.getString(Keys.OBJECT_ID);
        }
        Iterator<String> keys = jsonObject.keys();
        StringBuilder paraBuilder = new StringBuilder();
        StringBuilder argBuilder = new StringBuilder();
        boolean isFirst = true;
        while (keys.hasNext()) {
            String key = keys.next();
            if (isFirst) {
                paraBuilder.append("(`").append(key).append("`");
                argBuilder.append("(?");
                isFirst = false;
            } else {
                paraBuilder.append(",`").append(key).append("`");
                argBuilder.append(",?");
            }
            Object value = jsonObject.get(key);
            paramList.add(value);
            if (keys.hasNext()) continue;
            if (Repositories.isSoftDelete()) {
                paraBuilder.append(", `").append(JdbcRepositories.softDeleteFieldName).append("`");
                argBuilder.append(", 0");
            }
            paraBuilder.append(")");
            argBuilder.append(")");
        }
        sqlBuilder.append("INSERT INTO ").append("`").append(this.getName()).append("`").append((CharSequence)paraBuilder).append(" VALUES ").append((CharSequence)argBuilder);
        return ret;
    }

    @Override
    public void update(String id, JSONObject jsonObject, String ... propertyNames) throws RepositoryException {
        if (StringUtils.isBlank((String)id)) {
            return;
        }
        JdbcTransaction currentTransaction = TX.get();
        if (null == currentTransaction) {
            throw new RepositoryException("Invoking update() outside a transaction");
        }
        Connection connection = this.getConnection();
        ArrayList<Object> paramList = new ArrayList<Object>();
        StringBuilder sqlBuilder = new StringBuilder();
        try {
            JSONObject oldJsonObject = this.get(id);
            this.buildUpdate(id, oldJsonObject, jsonObject, paramList, sqlBuilder, propertyNames);
            String sql = sqlBuilder.toString();
            if (StringUtils.isBlank((String)sql)) {
                return;
            }
            JdbcUtil.executeSql(sql, paramList, connection, this.debug);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Updates a record [id=" + id + "] failed", (Throwable)e);
            throw new RepositoryException(e);
        }
    }

    private void buildUpdate(String id, JSONObject oldJsonObject, JSONObject jsonObject, List<Object> paramList, StringBuilder sqlBuilder, String ... propertyNames) {
        JSONObject needUpdateJsonObject = this.getDiff(oldJsonObject, jsonObject, propertyNames);
        if (0 == needUpdateJsonObject.length()) {
            LOGGER.log(Level.TRACE, "Nothing to update [{}] for repository [{}]", (Object)id, (Object)this.getName());
            return;
        }
        Iterator<String> keys = needUpdateJsonObject.keys();
        boolean isFirst = true;
        StringBuilder propertyBuilder = new StringBuilder();
        while (keys.hasNext()) {
            String key = keys.next();
            if (isFirst) {
                propertyBuilder.append(" SET `").append(key).append("` = ?");
                isFirst = false;
            } else {
                propertyBuilder.append(", `").append(key).append("` = ?");
            }
            paramList.add(needUpdateJsonObject.get(key));
        }
        sqlBuilder.append("UPDATE ").append("`").append(this.getName()).append("`").append((CharSequence)propertyBuilder).append(" WHERE ").append(JdbcRepositories.keyName).append(" = ?");
        paramList.add(id);
    }

    private JSONObject getDiff(JSONObject oldJsonObject, JSONObject jsonObject, String ... propertyNames) {
        if (null == oldJsonObject) {
            return jsonObject;
        }
        JSONObject ret = new JSONObject();
        HashSet<String> keys = new HashSet<String>();
        if (0 < ArrayUtils.getLength((Object)propertyNames)) {
            keys.addAll(Arrays.asList(propertyNames));
        } else {
            keys.addAll(jsonObject.keySet());
        }
        for (String key : keys) {
            Object oldVal = oldJsonObject.get(key);
            Object val = jsonObject.get(key);
            if (null == val && null == oldVal) {
                ret.put(key, val);
                continue;
            }
            if (jsonObject.optString(key).equals(oldJsonObject.optString(key))) continue;
            ret.put(key, val);
        }
        return ret;
    }

    @Override
    public void remove(String id) throws RepositoryException {
        if (StringUtils.isBlank((String)id)) {
            return;
        }
        JdbcTransaction currentTransaction = TX.get();
        if (null == currentTransaction) {
            throw new RepositoryException("Invoking remove() outside a transaction");
        }
        StringBuilder sqlBuilder = new StringBuilder();
        Connection connection = this.getConnection();
        try {
            if (Repositories.isSoftDelete()) {
                sqlBuilder.append("UPDATE ").append(this.getName()).append(" SET `").append(JdbcRepositories.softDeleteFieldName).append("` = 1").append(" WHERE ").append(JdbcRepositories.keyName).append(" = '").append(id).append("'");
            } else {
                sqlBuilder.append("DELETE FROM ").append("`").append(this.getName()).append("`").append(" WHERE ").append(JdbcRepositories.keyName).append(" = '").append(id).append("'");
            }
            JdbcUtil.executeSql(sqlBuilder.toString(), connection, this.debug);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Removes a record [id=" + id + "] failed", (Throwable)e);
            throw new RepositoryException(e);
        }
    }

    @Override
    public void remove(Query query) throws RepositoryException {
        JdbcTransaction currentTransaction = TX.get();
        if (null == currentTransaction) {
            throw new RepositoryException("Invoking remove() outside a transaction");
        }
        StringBuilder deleteSQLBuilder = new StringBuilder("DELETE FROM ").append("`").append(this.getName()).append("`");
        ArrayList<Object> paramList = new ArrayList<Object>();
        StringBuilder filterSqlBuilder = new StringBuilder();
        this.buildWhere(filterSqlBuilder, paramList, query.getFilter());
        if (StringUtils.isNotBlank((String)filterSqlBuilder.toString())) {
            deleteSQLBuilder.append(" WHERE ").append((CharSequence)filterSqlBuilder);
        }
        Connection connection = this.getConnection();
        try {
            JdbcUtil.executeSql(deleteSQLBuilder.toString(), paramList, connection, this.debug);
        }
        catch (SQLException e) {
            LOGGER.log(Level.ERROR, "Remove failed", (Throwable)e);
            throw new RepositoryException(e);
        }
    }

    @Override
    public JSONObject get(String id) throws RepositoryException {
        JSONObject ret;
        StringBuilder sqlBuilder = new StringBuilder();
        Connection connection = this.getConnection();
        try {
            sqlBuilder.append("SELECT * FROM ").append("`").append(this.getName()).append("`").append(" WHERE ").append(JdbcRepositories.keyName).append(" = ?");
            if (Repositories.isSoftDelete()) {
                sqlBuilder.append(" AND `").append(JdbcRepositories.softDeleteFieldName).append("` = 0");
            }
            ArrayList<Object> paramList = new ArrayList<Object>();
            paramList.add(id);
            ret = JdbcUtil.queryJsonObject(sqlBuilder.toString(), paramList, connection, this.getName(), this.debug);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Gets a record [id=" + id + "] failed", (Throwable)e);
            throw new RepositoryException(e);
        }
        return ret;
    }

    @Override
    public Map<String, JSONObject> get(Iterable<String> ids) throws RepositoryException {
        HashMap<String, JSONObject> ret = new HashMap<String, JSONObject>();
        for (String id : ids) {
            JSONObject jsonObject = this.get(id);
            ret.put(jsonObject.optString(JdbcRepositories.keyName), jsonObject);
        }
        return ret;
    }

    @Override
    public boolean has(String id) throws RepositoryException {
        return null != this.get(id);
    }

    @Override
    public JSONObject get(Query query) throws RepositoryException {
        JSONObject ret = new JSONObject();
        int currentPageNum = query.getCurrentPageNum();
        int pageSize = query.getPageSize();
        int pageCount = -1;
        if (null != query.getPageCount()) {
            pageCount = query.getPageCount();
        }
        StringBuilder sqlBuilder = new StringBuilder();
        Connection connection = this.getConnection();
        ArrayList<Object> paramList = new ArrayList<Object>();
        try {
            Map<String, Object> paginationCnt = this.buildSQLCount(currentPageNum, pageSize, pageCount, query, sqlBuilder, paramList);
            JSONObject pagination = new JSONObject();
            int pageCnt = (Integer)paginationCnt.get("paginationPageCount");
            pagination.put("paginationPageCount", pageCnt);
            pagination.put("paginationRecordCount", paginationCnt.get("paginationRecordCount"));
            ret.put("pagination", pagination);
            if (0 == pageCnt) {
                ret.put("rslts", (Object)new ArrayList());
                return ret;
            }
            List<JSONObject> list = JdbcUtil.queryListJson(sqlBuilder.toString(), paramList, connection, this.getName(), query.isDebug());
            ret.put("rslts", list);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Query failed", (Throwable)e);
            throw new RepositoryException(e);
        }
        return ret;
    }

    @Override
    public List<JSONObject> select(String statement, Object ... params) throws RepositoryException {
        Connection connection = this.getConnection();
        try {
            List<JSONObject> ret = ArrayUtils.isEmpty((Object[])params) ? JdbcUtil.queryListJson(statement, Collections.emptyList(), connection, this.getName(), this.debug) : JdbcUtil.queryListJson(statement, Arrays.asList(params), connection, this.getName(), this.debug);
            return ret;
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Select failed", (Throwable)e);
            throw new RepositoryException(e);
        }
    }

    private Map<String, Object> buildSQLCount(int currentPageNum, int pageSize, int pageCount, Query query, StringBuilder sqlBuilder, List<Object> paramList) throws RepositoryException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        int pageCnt = pageCount;
        int recordCnt = 0;
        StringBuilder selectBuilder = new StringBuilder();
        StringBuilder whereBuilder = new StringBuilder();
        StringBuilder orderByBuilder = new StringBuilder();
        this.buildSelect(selectBuilder, query.getProjections());
        this.buildWhere(whereBuilder, paramList, query.getFilter());
        this.buildOrderBy(orderByBuilder, query.getSorts());
        if (-1 == pageCount) {
            StringBuilder countBuilder = new StringBuilder("SELECT COUNT(" + JdbcRepositories.keyName + ") FROM ").append("`").append(this.getName()).append("`");
            if (StringUtils.isNotBlank((String)whereBuilder.toString())) {
                countBuilder.append(" WHERE ").append((CharSequence)whereBuilder);
            }
            if (0 == (recordCnt = (int)this.count(countBuilder, paramList))) {
                ret.put("paginationPageCount", 0);
                ret.put("paginationRecordCount", 0);
                return ret;
            }
            pageCnt = (int)Math.ceil((double)recordCnt / (double)pageSize);
        }
        ret.put("paginationPageCount", pageCnt);
        ret.put("paginationRecordCount", recordCnt);
        int start = (currentPageNum - 1) * pageSize;
        int end = start + pageSize;
        sqlBuilder.append(JdbcFactory.getInstance().queryPage(start, end, selectBuilder.toString(), whereBuilder.toString(), orderByBuilder.toString(), this.getName()));
        return ret;
    }

    private void buildSelect(StringBuilder selectBuilder, List<Projection> projections) {
        selectBuilder.append("SELECT ");
        if (null == projections || projections.isEmpty()) {
            selectBuilder.append(" * ");
            return;
        }
        selectBuilder.append(projections.stream().map(Projection::getKey).collect(Collectors.joining(", ")));
    }

    private void buildWhere(StringBuilder whereBuilder, List<Object> paramList, Filter filter) throws RepositoryException {
        Filter whereFilter = Repositories.isSoftDelete() ? (null != filter ? CompositeFilterOperator.and(filter, new PropertyFilter(JdbcRepositories.softDeleteFieldName, FilterOperator.EQUAL, 0)) : new PropertyFilter(JdbcRepositories.softDeleteFieldName, FilterOperator.EQUAL, 0)) : filter;
        if (null == whereFilter) {
            return;
        }
        if (whereFilter instanceof PropertyFilter) {
            this.processPropertyFilter(whereBuilder, paramList, (PropertyFilter)whereFilter);
        } else {
            this.processCompositeFilter(whereBuilder, paramList, (CompositeFilter)whereFilter);
        }
    }

    private void buildOrderBy(StringBuilder orderByBuilder, Map<String, SortDirection> sorts) {
        boolean isFirst = true;
        for (Map.Entry<String, SortDirection> sort : sorts.entrySet()) {
            if (isFirst) {
                orderByBuilder.append(" ORDER BY ");
                isFirst = false;
            } else {
                orderByBuilder.append(", ");
            }
            String querySortDirection = sort.getValue().equals((Object)SortDirection.ASCENDING) ? "ASC" : "DESC";
            orderByBuilder.append(sort.getKey()).append(" ").append(querySortDirection);
        }
    }

    @Override
    public List<JSONObject> getRandomly(int fetchSize) throws RepositoryException {
        Connection connection = this.getConnection();
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(JdbcFactory.getInstance().getRandomlySql(this.getName(), fetchSize));
        try {
            return JdbcUtil.queryListJson(sqlBuilder.toString(), new ArrayList<Object>(), connection, this.getName(), this.debug);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Get list randomly failed", (Throwable)e);
            throw new RepositoryException(e);
        }
    }

    @Override
    public long count() throws RepositoryException {
        StringBuilder sqlBuilder = new StringBuilder("SELECT COUNT(" + JdbcRepositories.keyName + ") FROM ").append("`").append(this.getName()).append("`");
        return this.count(sqlBuilder, new ArrayList<Object>());
    }

    @Override
    public long count(Query query) throws RepositoryException {
        StringBuilder countSqlBuilder = new StringBuilder("SELECT COUNT(" + JdbcRepositories.keyName + ") FROM ").append("`").append(this.getName()).append("`");
        ArrayList<Object> paramList = new ArrayList<Object>();
        StringBuilder filterSqlBuilder = new StringBuilder();
        this.buildWhere(filterSqlBuilder, paramList, query.getFilter());
        if (StringUtils.isNotBlank((String)filterSqlBuilder.toString())) {
            countSqlBuilder.append(" WHERE ").append((CharSequence)filterSqlBuilder);
        }
        return (int)this.count(countSqlBuilder, paramList);
    }

    private long count(StringBuilder sql, List<Object> paramList) throws RepositoryException {
        long count;
        Connection connection = this.getConnection();
        try {
            JSONObject jsonObject = JdbcUtil.queryJsonObject(sql.toString(), paramList, connection, this.getName(), this.debug);
            count = jsonObject.getLong(jsonObject.keys().next());
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Count failed", (Throwable)e);
            throw new RepositoryException(e);
        }
        return count;
    }

    @Override
    public String getName() {
        String tableNamePrefix = StringUtils.isNotBlank((String)Latkes.getLocalProperty("jdbc.tablePrefix")) ? Latkes.getLocalProperty("jdbc.tablePrefix") + "_" : "";
        return tableNamePrefix + this.name;
    }

    @Override
    public Transaction beginTransaction() {
        JdbcTransaction ret = TX.get();
        if (null != ret && ret.isActive()) {
            return TX.get();
        }
        try {
            ret = new JdbcTransaction();
        }
        catch (SQLException e) {
            LOGGER.log(Level.ERROR, "Failed to initialize JDBC transaction", (Throwable)e);
            throw new IllegalStateException("Begin a transaction failed");
        }
        TX.set(ret);
        return ret;
    }

    @Override
    public boolean hasTransactionBegun() {
        return null != TX.get();
    }

    @Override
    public boolean isWritable() {
        return this.writable;
    }

    @Override
    public void setWritable(boolean writable) {
        this.writable = writable;
    }

    @Override
    public void setDebug(boolean debugEnabled) {
        this.debug = debugEnabled;
    }

    private Connection getConnection() {
        JdbcTransaction jdbcTransaction = TX.get();
        if (null != jdbcTransaction && jdbcTransaction.isActive()) {
            return jdbcTransaction.getConnection();
        }
        Connection ret = CONN.get();
        try {
            if (null != ret && !ret.isClosed()) {
                return ret;
            }
            ret = Connections.getConnection();
        }
        catch (SQLException e) {
            LOGGER.log(Level.ERROR, "Gets a connection failed", (Throwable)e);
        }
        CONN.set(ret);
        return ret;
    }

    private void processPropertyFilter(StringBuilder whereBuilder, List<Object> paramList, PropertyFilter propertyFilter) throws RepositoryException {
        String filterOperator;
        FilterOperator operator = propertyFilter.getOperator();
        switch (operator) {
            case EQUAL: {
                filterOperator = "=";
                break;
            }
            case GREATER_THAN: {
                filterOperator = ">";
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                filterOperator = ">=";
                break;
            }
            case LESS_THAN: {
                filterOperator = "<";
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                filterOperator = "<=";
                break;
            }
            case NOT_EQUAL: {
                filterOperator = "!=";
                break;
            }
            case IN: {
                filterOperator = "IN";
                break;
            }
            case NOT_IN: {
                filterOperator = "NOT IN";
                break;
            }
            case LIKE: {
                filterOperator = "LIKE";
                break;
            }
            case NOT_LIKE: {
                filterOperator = "NOT LIKE";
                break;
            }
            default: {
                throw new RepositoryException("Unsupported filter operator [" + (Object)((Object)operator) + "]");
            }
        }
        if (FilterOperator.IN != operator && FilterOperator.NOT_IN != operator) {
            whereBuilder.append(propertyFilter.getKey()).append(" ").append(filterOperator).append(" ?");
            paramList.add(propertyFilter.getValue());
        } else {
            Collection objects = (Collection)propertyFilter.getValue();
            if (null != objects && !objects.isEmpty()) {
                whereBuilder.append(propertyFilter.getKey());
                if (FilterOperator.IN == operator) {
                    whereBuilder.append(" IN ");
                } else {
                    whereBuilder.append(" NOT IN ");
                }
                boolean isSubFist = true;
                Iterator obs = objects.iterator();
                while (obs.hasNext()) {
                    if (isSubFist) {
                        whereBuilder.append("(");
                        isSubFist = false;
                    } else {
                        whereBuilder.append(",");
                    }
                    whereBuilder.append("?");
                    paramList.add(obs.next());
                    if (obs.hasNext()) continue;
                    whereBuilder.append(") ");
                }
            } else if (FilterOperator.IN == operator) {
                whereBuilder.append("1 != 1");
            } else {
                whereBuilder.append("1 = 1");
            }
        }
    }

    private void processCompositeFilter(StringBuilder whereBuilder, List<Object> paramList, CompositeFilter compositeFilter) throws RepositoryException {
        List<Filter> subFilters = compositeFilter.getSubFilters();
        if (2 > subFilters.size()) {
            throw new RepositoryException("At least two sub filters in a composite filter");
        }
        whereBuilder.append("(");
        Iterator<Filter> iterator = subFilters.iterator();
        block4: while (iterator.hasNext()) {
            Filter filter = iterator.next();
            if (filter instanceof PropertyFilter) {
                this.processPropertyFilter(whereBuilder, paramList, (PropertyFilter)filter);
            } else {
                this.processCompositeFilter(whereBuilder, paramList, (CompositeFilter)filter);
            }
            if (!iterator.hasNext()) continue;
            switch (compositeFilter.getOperator()) {
                case AND: {
                    whereBuilder.append(" AND ");
                    continue block4;
                }
                case OR: {
                    whereBuilder.append(" OR ");
                    continue block4;
                }
            }
            throw new RepositoryException("Unsupported composite filter [operator=" + (Object)((Object)compositeFilter.getOperator()) + "]");
        }
        whereBuilder.append(")");
    }

    static {
        String value = Latkes.getLocalProperty("keyGen");
        if (StringUtils.isBlank((String)value) || "org.b3log.latke.repository.TimeMillisKeyGenerator".equals(value)) {
            KEY_GEN = new TimeMillisKeyGenerator();
        } else if ("DB".equals(value)) {
            KEY_GEN = new DBKeyGenerator();
        } else {
            try {
                Class<?> keyGenClass = Class.forName(value);
                Constructor<?> constructor = keyGenClass.getConstructor(new Class[0]);
                KEY_GEN = (KeyGenerator)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Can not load key generator with the specified class name [" + value + ']', e);
            }
        }
    }
}

