/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.repository.jdbc.mapping;

import org.b3log.latke.repository.jdbc.mapping.Mapping;
import org.b3log.latke.repository.jdbc.util.FieldDefinition;

public class StringMapping
implements Mapping {
    @Override
    public String toDataBaseString(FieldDefinition definition) {
        Integer length;
        StringBuilder sqlBuilder = new StringBuilder("`" + definition.getName() + "`");
        if (null == definition.getLength()) {
            definition.setLength(0);
        }
        if (255 < (length = definition.getLength())) {
            if (0xFFFFFF < length) {
                sqlBuilder.append(" LONGTEXT");
            } else if (65535 < length) {
                sqlBuilder.append(" MEDIUMTEXT");
            } else {
                sqlBuilder.append(" TEXT");
            }
        } else {
            sqlBuilder.append(" VARCHAR(").append(length < 1 ? 255 : length);
            sqlBuilder.append(")");
        }
        if (!definition.getNullable().booleanValue()) {
            sqlBuilder.append(" NOT NULL");
        }
        return sqlBuilder.toString();
    }
}

