/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.util;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Execs {
    private static final Logger LOGGER = LogManager.getLogger(Execs.class);

    public static String exec(String cmd, long timeout) {
        StringTokenizer st = new StringTokenizer(cmd);
        String[] cmds = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmds[i] = st.nextToken();
            ++i;
        }
        return Execs.exec(cmds, timeout);
    }

    public static String exec(String[] cmds, long timeout) {
        try {
            Process process = new ProcessBuilder(cmds).redirectErrorStream(true).start();
            StringWriter writer = new StringWriter();
            new Thread(() -> {
                try {
                    IOUtils.copy((InputStream)process.getInputStream(), (Writer)writer, (String)"UTF-8");
                }
                catch (Exception e) {
                    LOGGER.log(Level.ERROR, "Reads input stream failed: " + e.getMessage());
                }
            }).start();
            if (!process.waitFor(timeout, TimeUnit.MILLISECONDS)) {
                LOGGER.log(Level.WARN, "Executes commands [" + Arrays.toString(cmds) + "] timeout");
                process.destroy();
            }
            return writer.toString();
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, "Executes commands [" + Arrays.toString(cmds) + "] failed", (Throwable)e);
            return null;
        }
    }

    private Execs() {
    }
}

