/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.MethodInfo;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.ioc.Stereotype;
import org.b3log.latke.util.CollectionUtils;

public final class Reflections {
    private static final Logger LOGGER = LogManager.getLogger(Reflections.class);
    private static final ClassPool CLASS_POOL = ClassPool.getDefault();

    private Reflections() {
    }

    public static Set<Class<? extends Annotation>> getStereotypes(Class<?> clazz) {
        HashSet<Class<? extends Annotation>> ret = new HashSet<Class<? extends Annotation>>();
        Set<Annotation> annotations = Reflections.getAnnotations(clazz.getAnnotations(), Stereotype.class);
        if (annotations.isEmpty()) {
            return ret;
        }
        for (Annotation annotation : annotations) {
            ret.add(annotation.annotationType());
        }
        return ret;
    }

    public static <T> Set<Type> getBeanTypes(Class<T> beanClass) {
        HashSet<Type> ret = new HashSet<Type>();
        ret.add(beanClass);
        Type genericSuperclass = beanClass;
        while (genericSuperclass != Object.class) {
            Type[] genericInterfaces = null;
            if (genericSuperclass instanceof Class) {
                genericInterfaces = genericSuperclass.getGenericInterfaces();
                genericSuperclass = genericSuperclass.getGenericSuperclass();
            } else if (genericSuperclass instanceof ParameterizedType) {
                Type rawType = ((ParameterizedType)genericSuperclass).getRawType();
                genericInterfaces = ((Class)rawType).getGenericInterfaces();
                genericSuperclass = ((Class)rawType).getGenericSuperclass();
            }
            if (genericSuperclass != Object.class) {
                ret.add(genericSuperclass);
            }
            if (null == genericInterfaces || 0 == genericInterfaces.length) continue;
            for (Type genericInterface : genericInterfaces) {
                ret.add(genericInterface);
                ret.addAll(Reflections.getInterfaces((Class)genericInterface));
            }
        }
        return ret;
    }

    private static <T> Set<Type> getInterfaces(Class<T> interfaceClass) {
        HashSet<Type> ret = new HashSet<Type>();
        Class<?>[] interfaces = interfaceClass.getInterfaces();
        if (0 == interfaces.length) {
            return ret;
        }
        for (Class<?> i : interfaces) {
            ret.add(i);
            ret.addAll(Reflections.getInterfaces(i));
        }
        return ret;
    }

    private static Set<Annotation> getAnnotations(Annotation[] annotations, Class<? extends Annotation> neededAnnotationType) {
        HashSet<Annotation> ret = new HashSet<Annotation>();
        for (Annotation annotation : annotations) {
            Annotation[] metaAnnotations;
            annotation.annotationType().getAnnotations();
            for (Annotation metaAnnotation : metaAnnotations = annotation.annotationType().getAnnotations()) {
                if (!metaAnnotation.annotationType().equals(neededAnnotationType)) continue;
                ret.add(annotation);
            }
        }
        return ret;
    }

    public static String[] getMethodVariableNames(Class<?> clazz, String targetMethodName, Class<?>[] types) {
        CtMethod cm = null;
        try {
            if (null == CLASS_POOL.find(clazz.getName())) {
                CLASS_POOL.insertClassPath((ClassPath)new ClassClassPath(clazz));
            }
            CtClass cc = CLASS_POOL.get(clazz.getName());
            CtClass[] ptypes = new CtClass[types.length];
            for (int i = 0; i < ptypes.length; ++i) {
                ptypes[i] = CLASS_POOL.get(types[i].getName());
            }
            cm = cc.getDeclaredMethod(targetMethodName, ptypes);
        }
        catch (NotFoundException e) {
            LOGGER.log(Level.ERROR, "Get method variable names failed", (Throwable)e);
        }
        if (null == cm) {
            return new String[types.length];
        }
        MethodInfo methodInfo = cm.getMethodInfo();
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        LocalVariableAttribute attr = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
        String[] variableNames = new String[]{};
        try {
            variableNames = new String[cm.getParameterTypes().length];
        }
        catch (NotFoundException e) {
            LOGGER.log(Level.ERROR, "Get method variable names failed", (Throwable)e);
        }
        int j = -1;
        String variableName = null;
        Boolean ifkill = false;
        while (!"this".equals(variableName)) {
            variableName = attr.variableName(++j);
            if (j <= 99) continue;
            LOGGER.log(Level.WARN, "Maybe resolve to VariableNames error [class=" + clazz.getName() + ", targetMethodName=" + targetMethodName + ']');
            ifkill = true;
            break;
        }
        if (!ifkill.booleanValue()) {
            for (int i = 0; i < variableNames.length; ++i) {
                variableNames[i] = attr.variableName(++j);
            }
        }
        return variableNames;
    }

    public static boolean isConcrete(Type type) {
        return Reflections.isConcrete((Class)type);
    }

    public static boolean isConcrete(Class<?> clazz) {
        int modifiers = clazz.getModifiers();
        return !Modifier.isAbstract(modifiers) && !Modifier.isInterface(modifiers);
    }

    public static boolean isInterface(Class<?> clazz) {
        return Modifier.isInterface(clazz.getModifiers());
    }

    public static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isAccessable(Package subclassPackage, Package superclassPackage, int superMemberModifiers) {
        if (subclassPackage.equals(superclassPackage)) {
            switch (superMemberModifiers) {
                case 2: {
                    return false;
                }
                case 4: {
                    return true;
                }
                case 1: {
                    return true;
                }
            }
            return true;
        }
        switch (superMemberModifiers) {
            case 2: {
                return false;
            }
            case 4: {
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public static Set<Field> getInheritedFields(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        Set<Field> declaredFieldSet = CollectionUtils.arrayToSet(fields);
        HashSet<Field> ret = new HashSet<Field>(declaredFieldSet);
        for (Class<?> currentClass = clazz.getSuperclass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] superFields;
            for (Field superField : superFields = currentClass.getDeclaredFields()) {
                if (Modifier.isPrivate(superField.getModifiers()) || Modifier.isStatic(superField.getModifiers()) || Reflections.containField(ret, superField)) continue;
                ret.add(superField);
            }
        }
        ret.removeAll(declaredFieldSet);
        return ret;
    }

    public static Set<Field> getHiddenFields(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        Set<Field> declaredFieldSet = CollectionUtils.arrayToSet(fields);
        HashSet<Field> ret = new HashSet<Field>();
        for (Class<?> currentClass = clazz.getSuperclass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] superFields;
            for (Field superField : superFields = currentClass.getDeclaredFields()) {
                Field match = Reflections.getMatch(declaredFieldSet, superField);
                if (Modifier.isPrivate(superField.getModifiers()) || Modifier.isStatic(superField.getModifiers()) || match == null) continue;
                ret.add(match);
            }
        }
        return ret;
    }

    public static Set<Field> getOwnFields(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        Set<Field> declaredFieldSet = CollectionUtils.arrayToSet(fields);
        HashSet<Field> ret = new HashSet<Field>();
        Set<Field> inheritedFields = Reflections.getInheritedFields(clazz);
        Set<Field> overriddenFields = Reflections.getHiddenFields(clazz);
        for (Field declaredField : declaredFieldSet) {
            if (Reflections.containField(inheritedFields, declaredField) || Reflections.containField(overriddenFields, declaredField)) continue;
            ret.add(declaredField);
        }
        return ret;
    }

    public static Set<Method> getOwnMethods(Class<?> clazz) {
        Method[] methods = clazz.getDeclaredMethods();
        Set<Method> declaredMethodSet = CollectionUtils.arrayToSet(methods);
        HashSet<Method> ret = new HashSet<Method>();
        Set<Method> inheritedMethods = Reflections.getInheritedMethods(clazz);
        Set<Method> overriddenMethods = Reflections.getOverriddenMethods(clazz);
        for (Method declaredMethod : declaredMethodSet) {
            if (Reflections.containMethod(inheritedMethods, declaredMethod) || Reflections.containMethod(overriddenMethods, declaredMethod)) continue;
            ret.add(declaredMethod);
        }
        return ret;
    }

    public static Set<Method> getInheritedMethods(Class<?> clazz) {
        Method[] methods = clazz.getDeclaredMethods();
        Set<Method> declaredMethodSet = CollectionUtils.arrayToSet(methods);
        HashSet<Method> ret = new HashSet<Method>(declaredMethodSet);
        for (Class<?> currentClass = clazz.getSuperclass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            Method[] superMethods;
            for (Method superMethod : superMethods = currentClass.getDeclaredMethods()) {
                if (Modifier.isPrivate(superMethod.getModifiers()) || Modifier.isStatic(superMethod.getModifiers()) || Reflections.containMethod(ret, superMethod)) continue;
                ret.add(superMethod);
            }
        }
        ret.removeAll(declaredMethodSet);
        return ret;
    }

    public static Set<Method> getOverriddenMethods(Class<?> clazz) {
        Method[] methods = clazz.getDeclaredMethods();
        Set<Method> declaredMethodSet = CollectionUtils.arrayToSet(methods);
        HashSet<Method> ret = new HashSet<Method>();
        for (Class<?> currentClass = clazz.getSuperclass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
            Method[] superclassMethods;
            for (Method superclassMethod : superclassMethods = currentClass.getDeclaredMethods()) {
                Method match = Reflections.getMatch(declaredMethodSet, superclassMethod, true);
                if (match == null) continue;
                ret.add(match);
            }
        }
        return ret;
    }

    public static boolean containField(Set<Field> fields, Field field) {
        for (Field f : fields) {
            if (!f.getName().equals(field.getName()) || !f.getType().equals(field.getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean containMethod(Set<Method> methods, Method method) {
        for (Method m : methods) {
            if (!Reflections.matchSignature(m, method) || !Reflections.matchModifier(m, method)) continue;
            return true;
        }
        return false;
    }

    public static Field getMatch(Set<Field> fields, Field field) {
        for (Field f : fields) {
            if (!Reflections.match(f, field)) continue;
            return f;
        }
        return null;
    }

    public static Method getMatch(Set<Method> methods, Method maybeSuperclassMethod, boolean matchInheritance) {
        for (Method m : methods) {
            if (!(!matchInheritance ? Reflections.matchModifier(m, maybeSuperclassMethod) && Reflections.matchSignature(m, maybeSuperclassMethod) : Reflections.matchInheritance(m, maybeSuperclassMethod))) continue;
            return m;
        }
        return null;
    }

    public static boolean match(Field field1, Field field2) {
        return field1.getName().equals(field2.getName()) && field1.getType().equals(field2.getType());
    }

    public static boolean matchInheritance(Field subclassField, Field superclassField) {
        if (Modifier.isStatic(superclassField.getModifiers()) || subclassField.equals(superclassField)) {
            return false;
        }
        Package subclassPackage = superclassField.getDeclaringClass().getPackage();
        Package superclassPackage = superclassField.getDeclaringClass().getPackage();
        int superFieldModifiers = superclassField.getModifiers();
        return Reflections.isAccessable(subclassPackage, superclassPackage, superFieldModifiers);
    }

    public static boolean matchInheritance(Method subclassMethod, Method superclassMethod) {
        if (Modifier.isStatic(superclassMethod.getModifiers()) || subclassMethod.equals(superclassMethod)) {
            return false;
        }
        if (Reflections.matchSignature(subclassMethod, superclassMethod)) {
            Package subclassPackage = subclassMethod.getDeclaringClass().getPackage();
            Package superclassPackage = superclassMethod.getDeclaringClass().getPackage();
            int superMethodModifiers = superclassMethod.getModifiers();
            return Reflections.isAccessable(subclassPackage, superclassPackage, superMethodModifiers);
        }
        return false;
    }

    public static boolean matchModifier(Method method1, Method method2) {
        return method1.getModifiers() == method2.getModifiers();
    }

    public static boolean matchSignature(Method method1, Method method2) {
        return method1.getName().equals(method2.getName()) && method1.getReturnType().equals(method2.getReturnType()) && Reflections.hasSameParameterTypes(method1, method2);
    }

    public static boolean hasSameParameterTypes(Method method1, Method method2) {
        Class<?>[] parameterTypes2;
        Class<?>[] parameterTypes1 = method1.getParameterTypes();
        if (parameterTypes1.length == (parameterTypes2 = method2.getParameterTypes()).length) {
            for (int i = 0; i < parameterTypes1.length; ++i) {
                if (parameterTypes1[i].equals(parameterTypes2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Field getHideField(Field superclassField, Class<?> subclass) {
        Class<?> superclass = superclassField.getDeclaringClass();
        Class<?> currentClass = subclass;
        if (!superclass.isAssignableFrom(subclass)) {
            throw new RuntimeException("Class[" + subclass + "] is not superclass of class[" + subclass + "]");
        }
        while (!currentClass.equals(superclass)) {
            try {
                Field m = currentClass.getDeclaredField(superclassField.getName());
                if (Reflections.matchInheritance(m, superclassField)) {
                    return m;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            currentClass = currentClass.getSuperclass();
        }
        return superclassField;
    }

    public static Method getOverrideMethod(Method superclassMethod, Class<?> subclass) {
        Class<?> superclass = superclassMethod.getDeclaringClass();
        Class<?> currentClass = subclass;
        if (!superclass.isAssignableFrom(subclass)) {
            throw new RuntimeException("Class[" + subclass + "] is not superclass of class[" + subclass + "]");
        }
        while (!currentClass.equals(superclass)) {
            try {
                Method m = currentClass.getDeclaredMethod(superclassMethod.getName(), superclassMethod.getParameterTypes());
                if (Reflections.matchInheritance(m, superclassMethod)) {
                    return m;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            currentClass = currentClass.getSuperclass();
        }
        return superclassMethod;
    }

    static {
        CLASS_POOL.insertClassPath((ClassPath)new ClassClassPath(Reflections.class));
    }
}

