/*
 * Decompiled with CFR 0.152.
 */
package org.b3log.latke.util;

import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.b3log.latke.http.Request;
import org.b3log.latke.http.RequestContext;
import org.b3log.latke.util.Strings;

public final class Requests {
    public static void log(Request request, Level level, Logger logger) {
        if (!logger.isEnabled(level)) {
            return;
        }
        logger.log(level, Requests.getLog(request));
    }

    public static String getLog(Request request) {
        if (null == request) {
            return "request is null";
        }
        String indents = "    ";
        StringBuilder logBuilder = new StringBuilder("Request [").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("method=").append(request.getMethod()).append(",").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("URI=").append(request.getRequestURI()).append(",").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("contentType=").append(request.getContentType()).append(",").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("remoteAddr=").append(Requests.getRemoteAddr(request)).append(",").append(Strings.LINE_SEPARATOR);
        logBuilder.append("    ").append("headers=[");
        Iterator<String> headerNames = request.getHeaderNames();
        StringBuilder headerLogBuilder = new StringBuilder();
        logBuilder.append(Strings.LINE_SEPARATOR);
        while (headerNames.hasNext()) {
            String name = headerNames.next();
            String value = request.getHeader(name);
            headerLogBuilder.append("    ").append("    ").append(name).append("=").append(value);
            headerLogBuilder.append(Strings.LINE_SEPARATOR);
        }
        headerLogBuilder.append("    ");
        headerLogBuilder.append("]");
        logBuilder.append(headerLogBuilder.toString());
        logBuilder.append(Strings.LINE_SEPARATOR).append("]");
        return logBuilder.toString();
    }

    public static String getRemoteAddr(Request request) {
        String ret = request.getHeader("X-Forwarded-For");
        if (StringUtils.isBlank((String)ret) && StringUtils.isBlank((String)(ret = request.getHeader("X-Real-IP")))) {
            return request.getRemoteAddr();
        }
        return ret.split(",")[0];
    }

    public static String getRemoteAddr(RequestContext context) {
        return Requests.getRemoteAddr(context.getRequest());
    }

    public static String getServerScheme(Request request) {
        String ret = request.getHeader("X-Forwarded-Scheme");
        if (StringUtils.isBlank((String)ret) && StringUtils.isBlank((String)(ret = request.getHeader("X-Forwarded-Proto")))) {
            return request.getScheme();
        }
        return ret;
    }

    public static String getServerName(Request request) {
        String ret = request.getHeader("X-Forwarded-Host");
        if (StringUtils.isBlank((String)ret)) {
            return request.getServerName();
        }
        return ret;
    }

    private Requests() {
    }
}

