﻿using System;
using System.Linq;
using RimWorld;
using Verse;
using HarmonyLib;
using SoftWarmBeds;

namespace SoftWarmBedsRebalanced
{
    [HarmonyPatch]
    public static class HarmonyPatches
    {
        [HarmonyPatch(typeof(SoftWarmBeds_SpecialInjector), "CalculateSoftness")]
        public static bool Prefix(ref float __result, ThingDef def)
        {
            float armor = def.statBases.GetStatValueFromList(StatDefOf.StuffPower_Armor_Sharp, 0f);
            float heat = def.statBases.GetStatValueFromList(StatDefOf.StuffPower_Insulation_Heat, 0f);
            float cold = def.statBases.GetStatValueFromList(StatDefOf.StuffPower_Insulation_Cold, 0f);
            __result = (Math.Min(heat, cold) * Math.Min(armor, 2.0f) * .6f + Math.Max(heat, cold) - 1.5f) / 100;
            return false;
        }

    }
}
