# -*- coding:utf-8 -*-

# Speedflow Add-on
# Copyright (C) 2018 Cedric Lepiller aka Pitiwazou & Legigan Jeremy AKA Pistiwique and Stephen Leger
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# <pep8 compliant>

bl_info = {
    "name": "SpeedFlow",
    "description": "Improve your workflow with speedflow",
    "author": "cedric lepiller (pitiwazou), Jeremy Legigan (pistiwique), Stephen Leger (Stephen-I)",
    "version": (0, 0, 20),
    "blender": (2, 80, 0),
    "location": "View3D",
    "wiki_url": "",
    "category": "Object" }

# Import des modules
if "bpy" in locals():
    import importlib
    reloadable_modules = [
        "utils",
        "ui",
        "array",
        "bevel",
        "boolean",
        "displace",
        "mirror",
        "screw",
        "solidify",
        "subsurf",
        "weighted_normal",
        "decimate",
        "triangulate",
        "tubify",
        "edge_split",
        "shrinkwrap",
        "simple_deform",
        "wireframe",
        "curve",
        "corrective_smooth",
        "mod_visibility",
        "cutter",
        "skin"
    ]
    for module in reloadable_modules:
        if module in locals():
            importlib.reload(locals()[module])

from . import (utils,
               ui,
               array,
               bevel,
               boolean,
               displace,
               mirror,
               screw,
               solidify,
               subsurf,
               weighted_normal,
               decimate,
               triangulate,
               tubify,
               edge_split,
               shrinkwrap,
               simple_deform,
               wireframe,
               curve,
               corrective_smooth,
               mod_visibility,
               cutter,
               skin
               )

import bpy
from bpy.types import PropertyGroup
from bpy.props import (StringProperty, 
                       BoolProperty,
                       PointerProperty,
                       FloatVectorProperty,
                       FloatProperty,
                       EnumProperty,
                       IntProperty,
                       BoolVectorProperty)
import rna_keymap_ui
from .icon.icons import load_icons



########################################
# UPDATE UI
########################################
keymaps_items_dict = {  "Speedflow Pie Menu":['wm.call_menu_pie', 'SPEEDFLOW_MT_pie_menu',
                                      '3D View Generic', 'VIEW_3D', 'WINDOW',
                                       'SPACE', 'PRESS', False, False, False
                                      ],

                        "Speedflow Normal Menu":['wm.call_menu', 'SPEEDFLOW_MT_simple_menu',
                                      '3D View Generic', 'VIEW_3D', 'WINDOW',
                                       'SPACE', 'PRESS', False, False, False
                                      ],
                        }

def update_pie_bl_label(self, context):
    SF = context.window_manager.SF
    # prefs = bpy.context.preferences.addons[__name__].preferences

    # check for update and edit bl_label
    if hasattr(bpy.types, "SPEEDFLOW_MT_pie_menu"):
        try:
            bpy.utils.unregister_class(ui.SPEEDFLOW_MT_pie_menu)
        except:
            pass

    if SF.update_available and self.show_update:
        ui.SPEEDFLOW_MT_pie_menu.bl_label = "An Update is available!"
    else:
        # if prefs.beginner_mode:
        #     ui.SPEEDFLOW_MT_pie_menu.bl_label = "Slowflow"
        # else:
        ui.SPEEDFLOW_MT_pie_menu.bl_label = "Speedflow"

    bpy.utils.register_class(ui.SPEEDFLOW_MT_pie_menu)

def update_menu_type(self, context):
    remove_hotkey()
    if self.choose_menu_type == "pie":
        if hasattr(bpy.types, "SPEEDFLOW_MT_simple_menu"):
            try:
                bpy.utils.unregister_class(ui.SPEEDFLOW_MT_simple_menu)
            except:
                pass

        bpy.utils.register_class(ui.SPEEDFLOW_MT_pie_menu)
        update_pie_bl_label(self, context)
        add_hotkey("Speedflow Pie Menu")
    else:
        if hasattr(bpy.types, "SPEEDFLOW_MT_pie_menu"):
            try:
                bpy.utils.unregister_class(ui.SPEEDFLOW_MT_pie_menu)
            except:
                pass

        bpy.utils.register_class(ui.SPEEDFLOW_MT_simple_menu)
        add_hotkey("Speedflow Normal Menu")

# def update_menu_type(self, context):
#     remove_hotkey()
#     if self.choose_menu_type == "pie":
#         if hasattr(bpy.types, "SPEEDFLOW_MT_simple_menu"):
#             try:
#                 bpy.utils.unregister_class(ui.SPEEDFLOW_MT_simple_menu)
#             except:
#                 pass
#
#         update_pie_bl_label(self, context)
#
#     else:
#         if hasattr(bpy.types, "SPEEDFLOW_MT_pie_menu"):
#             try:
#                 bpy.utils.unregister_class(ui.SPEEDFLOW_MT_pie_menu)
#             except:
#                 pass
#
#         bpy.utils.register_class(ui.SPEEDFLOW_MT_simple_menu)
#
#     add_hotkey()

def check_for_update(self, context):
    if self.show_update:
        utils.updater.async_check_update(True)

    update_menu_type(self, context)


def update_speedflow_ui(self, context):
    is_panel = hasattr(bpy.types, 'SPEEDFLOW_PT_panel')

    if self.enabled_panel:
        if is_panel:
            try:
                bpy.utils.unregister_class(bpy.types.SPEEDFLOW_PT_panel)
            except:
                pass
        ui.SPEEDFLOW_PT_panel.bl_category = self.category
        bpy.utils.register_class(ui.SPEEDFLOW_PT_panel)

    else:
        if is_panel:
            try:
                bpy.utils.unregister_class(bpy.types.SPEEDFLOW_PT_panel)
            except:
                pass

def update_speedflow_help_panel(self, context):
    is_help_panel = hasattr(bpy.types, 'SPEEDFLOW_PT_property_panel_help')
    is_help_keymap = hasattr(bpy.types, 'SPEEDFLOW_PT_property_panel_keymaps')

    if self.show_help:
        if is_help_panel and is_help_keymap:
            try:
                bpy.utils.unregister_class(bpy.types.SPEEDFLOW_PT_property_panel_help)
                bpy.utils.unregister_class(bpy.types.SPEEDFLOW_PT_property_panel_keymaps)

            except:
                pass
        # ui.SPEEDFLOW_PT_property_panel_help.bl_category = self.category
        bpy.utils.register_class(ui.SPEEDFLOW_PT_property_panel_help)
        bpy.utils.register_class(ui.SPEEDFLOW_PT_property_panel_keymaps)

    else:
        if is_help_panel and is_help_keymap:
            try:
                bpy.utils.unregister_class(bpy.types.SPEEDFLOW_PT_property_panel_help)
                bpy.utils.unregister_class(bpy.types.SPEEDFLOW_PT_property_panel_keymaps)
            except:
                pass

class PrefsArray(PropertyGroup):
    count: IntProperty(name="", default=2, min=1, max=1000)
    use_relative_offset: BoolProperty(default=True)
    use_constant_offset: BoolProperty(default=True)
    use_object_offset: BoolProperty(default=True)
    relative_offset_displace: FloatVectorProperty(name="",default=(1.0, 0.0, 0.0),min=0, max=1000, size=3,)
    constant_offset_displace: FloatVectorProperty(name="",default=(0.0, 0.0, 0.0),min=0, max=1000, size=3,)
    use_merge_vertices: BoolProperty(name="", default=False)
    use_merge_vertices_cap: BoolProperty(name="", default=False)
    merge_threshold: FloatProperty(name="",default=0.01,min=0.0, max=1)

    show_options_array: BoolProperty(default=False)

    def draw(self, layout):
        box = layout.box()
        split = box.split()
        row = split.row(align=True)

        icons = load_icons()
        icon = icons.get("icon_array")
        row.scale_y = 1.5
        row.label(text="", icon_value=icon.icon_id)
        row.prop(self, "show_options_array", text="ARRAY",
                    icon='TRIA_UP' if self.show_options_array else 'TRIA_RIGHT')
        if self.show_options_array:
            split = box.split()
            col = split.column()
            col.label(text="Count:")
            col = split.column(align=True)
            col.prop(self, 'count', expand=True)

            split = box.split()
            col = split.column()
            col.label(text="Relative Offset Axis:")
            col = split.column(align=True)
            col.prop(self, 'relative_offset_displace', expand=True)

            split = box.split()
            col = split.column()
            col.label(text="Constant Offset Axis:")
            col = split.column(align=True)
            col.prop(self, 'constant_offset_displace', expand=True)

            row = box.row(align=True)
            row.label(text="Use Merge Vertices")
            row.prop(self, "use_merge_vertices", text="      ")

            if self.use_merge_vertices :
                row = box.row(align=True)
                row.label(text="First Last")
                row.prop(self, "use_merge_vertices_cap", text="      ")

                split = box.split()
                col = split.column()
                col.label(text="Merge Threshold:")
                col = split.column(align=True)
                col.prop(self, 'merge_threshold', expand=True)


class PrefsBevel(PropertyGroup):

    destructive_mode : BoolProperty(default=True)
    width : FloatProperty(name="",default=0.04)
    segments : IntProperty(name="",default=4,min=1, max=13)
    use_only_vertices: BoolProperty(name="",default=False,description="Use Only vertices")
    profile : FloatProperty(name="",default=0.5,min=0.0, max=1.0)
    use_clamp_overlap: BoolProperty(name="", default=False, description="Use Clamp overlab")
    loop_slide: BoolProperty(name="", default=True, description="Loop Slide")
    mark_seam: BoolProperty(name="", default=False, description="Mark Seams")
    mark_sharp: BoolProperty(name="", default=False, description="Mark Sharp")
    harden_normals: BoolProperty(name="", default=False, description="Harden Normals")
    auto_update: BoolProperty(name="", default=True, description="Auto update the bevel weight")
    nosubdiv_width: FloatProperty(name="", default=0.01)
    nosubdiv_segments: IntProperty(name="", default=4, min=1, max=13)
    nosubdiv_profile: FloatProperty(name="", default=0.6, min=0.0, max=1.0)

    miter_outer : EnumProperty(
        items=(('MITER_SHARP', "Sharp", ""),
               ('MITER_PATCH', "Patch", ""),
               ('MITER_ARC', "Arc", ""),),
        default='MITER_ARC')

    miter_inner: EnumProperty(
        items=(('MITER_SHARP', "Sharp", ""),
               ('MITER_PATCH', "Patch", ""),
               ('MITER_ARC', "Arc", ""),),
        default='MITER_SHARP')

    face_strength_mode: EnumProperty(
        items=(('FSTR_NONE', "NONE", ""),
               ('FSTR_NEW', "NEW", ""),
               ('FSTR_AFFECTED', "AFFECTED", ""),
               ('FSTR_ALL', "ALL", ""),),
        default='FSTR_NONE')

    width_method : EnumProperty(
        items=(('OFFSET', "Offset", ""),
               ('WIDTH', "Width", ""),
               ('DEPTH', "Depth", ""),
               ('PERCENT', "Percent", "")),
        default='WIDTH')

    limit_method: EnumProperty(
        items=(('NONE', "none", ""),
               ('ANGLE', "angle", ""),
               ('WEIGHT', "weight", ""),
               ('VGROUP', "vgroup", "")),
        default='ANGLE')

    show_options_bevel: BoolProperty(default=False)

    def draw(self, layout):
        box = layout.box()
        row = box.row(align=True)
        icons = load_icons()
        icon = icons.get("icon_bevel")
        row.scale_y = 1.5
        row.label(text="", icon_value=icon.icon_id)
        row.prop(self, "show_options_bevel", text="BEVEL",
                 icon='TRIA_UP' if self.show_options_bevel else 'TRIA_RIGHT')
        if self.show_options_bevel:
            split = box.split()
            col = split.column()
            col.label(text="Bevel Mode:")
            col = split.column(align=True)
            col.prop(self, 'destructive_mode',text = "Non-Destructive", expand=True)

            row = box.row(align=True)
            row.label(text="Non-Destructive Mode Options --------------------------------")

            row = box.row(align=True)
            row.label(text="         - Bevel Width")
            row.prop(self, "width")

            row = box.row(align=True)
            row.label(text="         - Segments")
            row.prop(self, "segments")

            row = box.row(align=True)
            row.label(text="         -  Profile")
            row.prop(self, "profile")

            row = box.row()
            row.separator()

            row = box.row(align=True)
            row.label(text="Destructive Mode Options -----------------------------")
            row = box.row(align=True)
            row.label(text="         - Bevel Width")
            row.prop(self, "nosubdiv_width")

            row = box.row(align=True)
            row.label(text="         - Segments")
            row.prop(self, "nosubdiv_segments")

            row = box.row(align=True)
            row.label(text="         - Profile")
            row.prop(self, "nosubdiv_profile")

            row = box.row(align=True)
            row.label(text="Auto update bevel weight")
            row.prop(self, "auto_update", text="      ")

            # row = box.row(align=True)
            # row.label(text="Use Only Vertices")
            # row.prop(self, "use_only_vertices", text="      ")

            row = box.row(align=True)
            row.label(text="Clamp verlap")
            row.prop(self, "use_clamp_overlap", text="      ")

            # row = box.row(align=True)
            # row.label(text="Loop Slide")
            # row.prop(self, "loop_slide", text="      ")

            row = box.row(align=True)
            row.label(text="Mark Seams")
            row.prop(self, "mark_seam", text="      ")

            row = box.row(align=True)
            row.label(text="Mark Sharp")
            row.prop(self, "mark_sharp", text="      ")

            row = box.row(align=True)
            row.label(text="Harden Normals")
            row.prop(self, "harden_normals", text="      ")

            # row = box.row(align=True)
            # row.label(text="Limit Method")
            # row.prop(self, "limit_method", text="")

            # row = box.row(align=True)
            # row.label(text="Width Method")
            # row.prop(self, "width_method", text="")

            row = box.row(align=True)
            row.label(text="Set Face Strength Mode")
            row.prop(self, "face_strength_mode", text="")

            row = box.row(align=True)
            row.label(text="Miter Patterns")

            row = box.row(align=True)
            row.label(text="Miter Outer")
            row.prop(self, "miter_outer", text="")

            row = box.row(align=True)
            row.label(text="Miter Inner")
            row.prop(self, "miter_inner", text="")

class PrefsBoolean(PropertyGroup):
    booleans_color: FloatVectorProperty(name="", default=(0, 0.648912, 1, 0.05), min=0, max=1, size=4,subtype='COLOR_GAMMA')
    parent_bool_objects: BoolProperty(name="", default=False, description="Parent the bool_objects")
    use_bound:BoolProperty(name="",default=True,description="Use Bound as visibility option for bool objects")
    delete_bool_obj : BoolProperty(name="",default=False,description="Delete the mesh after the boolean")

    show_options_boolean: BoolProperty(default=False)

    def draw(self, layout):
        box = layout.box()
        row = box.row(align=True)

        icons = load_icons()
        icon = icons.get("icon_boolean")
        row.scale_y = 1.5
        row.label(text="", icon_value=icon.icon_id)
        row.prop(self, "show_options_boolean", text="BOOLEAN",
                 icon='TRIA_UP' if self.show_options_boolean else 'TRIA_RIGHT')
        if self.show_options_boolean:
            row = box.row(align=True)
            row.label(text="Delete Boolean object:")
            row.prop(self, 'delete_bool_obj', text="      ")

            row = box.row(align=True)
            row.label(text="Use Bound")
            row.prop(self, "use_bound", text="      ")

            row = box.row(align=True)
            row.label(text="Bool Objects Color:")
            row.prop(self, "booleans_color")

            row = box.row(align=True)
            row.label(text="Parent Bool Objects")
            row.prop(self, "parent_bool_objects", text="      ")


class PrefsCorrective_Smooth(PropertyGroup):
    iterations: FloatProperty(name="",default=0,min=0, max=200)
    factor: FloatProperty(name="",default=0.5,min=0, max=1)
    use_only_smooth: BoolProperty(name="",default=True,description="Use Only Smooth")
    use_pin_boundary: BoolProperty(name="",default=False,description="Use Pin Boundary")

    smooth_type: EnumProperty(
        items=(('SIMPLE', "SIMPLE", ""),
               ("LENGTH_WEIGHTED", "LENGTH_WEIGHTED", "")),
        default='SIMPLE')

    rest_source: EnumProperty(
        items=(('ORCO', "ORCO", ""),
               ("BIND", "BIND", "")),
        default='ORCO')

    def draw(self, layout):
        box = layout.box()
        row = box.row(align=True)

        icons = load_icons()
        icon = icons.get("icon_corrective_smooth")
        row.label(text="CORRECTIVE SMOOTH OPTIONS", icon_value=icon.icon_id)

        row = box.row(align=True)
        row.label(text="Repeat")
        row.prop(self, "iterations")

        row = box.row(align=True)
        row.label(text="Factor")
        row.prop(self, "factor")

        row = box.row(align=True)
        row.label(text="Smooth Type:")
        row.prop(self, "smooth_type", text="")

        row = box.row(align=True)
        row.label(text="Only Smooth")
        row.prop(self, "use_only_smooth", text="      ")

        row = box.row(align=True)
        row.label(text="Pin Boundaries")
        row.prop(self, "use_pin_boundary", text="      ")

        row = box.row(align=True)
        row.label(text="Rest Source:")
        row.prop(self, "rest_source", text="")


class PrefsCurve(PropertyGroup):
    deform_axis: EnumProperty(
        items=(('POS_X', "POS_X", ""),
               ("POS_Y", "POS_Y", ""),
               ("POS_Z", "POS_Z", ""),
               ('NEG_X', "NEG_X", ""),
               ("NEG_Y", "NEG_Y", ""),
               ("NEG_Z", "NEG_Z", "")),
        default='POS_X')

    show_options_curve: BoolProperty(default=False)

    def draw(self, layout):
        box = layout.box()
        row = box.row(align=True)

        icons = load_icons()
        icon = icons.get("icon_curve")
        row.scale_y = 1.5
        row.label(text="", icon_value=icon.icon_id)
        row.prop(self, "show_options_curve", text="CURVE",
                 icon='TRIA_UP' if self.show_options_curve else 'TRIA_RIGHT')
        if self.show_options_curve:
            row = box.row(align=True)
            row.label(text="Axis:")
            row.prop(self, "deform_axis", text="")

class PrefsDecimate(PropertyGroup):
    angle_limit: FloatProperty(name="Angle Limit", default=0.01, description="Angle Limit")
    ratio: FloatProperty(name="Ratio", default=1, description="Ratio")
    keep_custom_normals: BoolProperty(name="", default=False, description="Keep Normals")
    iterations: IntProperty(name="", default=0, min=0, max=100)
    use_collapse_triangulate: BoolProperty(name="", default=False, description="Triangulate")

    decimate_type: EnumProperty(
        items=(('COLLAPSE', "COLLAPSE", ""),
               ('UNSUBDIV', "UNSUBDIV", ""),
               ('DISSOLVE', "DISSOLVE", "")),
        default='DISSOLVE')

    show_options_decimate: BoolProperty(default=False)

    def draw(self, layout):
        box = layout.box()
        row = box.row(align=True)

        icons = load_icons()
        icon = icons.get("icon_decimate")
        row.scale_y = 1.5
        row.label(text="", icon_value=icon.icon_id)
        row.prop(self, "show_options_decimate", text="DECIMATE",
                 icon='TRIA_UP' if self.show_options_decimate else 'TRIA_RIGHT')
        if self.show_options_decimate:
            row = box.row(align=True)
            row.label(text="Decimate Type")
            row.prop(self, "decimate_type", text="")

            if self.decimate_type == 'DISSOLVE':
                row = box.row(align=True)
                row.label(text="Angle Limit")
                row.prop(self, "angle_limit", text="")

            elif self.decimate_type == 'UNSUBDIV':
                row = box.row(align=True)
                row.label(text="Iterations")
                row.prop(self, "iterations", text="")

            elif self.decimate_type == 'COLLAPSE':
                row = box.row(align=True)
                row.label(text="Ratio")
                row.prop(self, "ratio", text="")

                row = box.row(align=True)
                row.label(text="Triangulate")
                row.prop(self, "use_collapse_triangulate", text="      ")


class PrefsDisplace(PropertyGroup):
    strength: FloatProperty(name="Displace Strength",default=0.5,description="Displace Strength")
    mid_level: FloatProperty(name="Displace Mid Level",default=0,description="Displace Mid Level")

    direction: EnumProperty(
        items=(('X', "X", ""),
               ('Y', "Y", ""),
               ('Z', "Z", ""),
               ('RGB_TO_XYZ', "RGB_TO_XYZ", ""),
               ('CUSTOM_NORMAL', "CUSTOM_NORMAL", ""),
               ('NORMAL', "NORMAL", ""),
               ),
        default='X')

    show_options_displace: BoolProperty(default=False)

    def draw(self, layout):
        box = layout.box()
        row = box.row(align=True)

        icons = load_icons()
        icon = icons.get("icon_displace")
        row.scale_y = 1.5
        row.label(text="", icon_value=icon.icon_id)
        row.prop(self, "show_options_displace", text="DISPLACE",
                 icon='TRIA_UP' if self.show_options_displace else 'TRIA_RIGHT')
        if self.show_options_displace:
            row = box.row(align=True)
            row.label(text="Strength")
            row.prop(self, "strength", text="")

            row = box.row(align=True)
            row.label(text="Mid Level")
            row.prop(self, "mid_level", text="")

            row = box.row(align=True)
            row.label(text="Direction")
            row.prop(self, "direction", text="")

class PrefsEdge_Split(PropertyGroup):
    split_angle : FloatProperty(name="Split Angle",default=0.575959,description="Split Angle")
    use_edge_sharp: BoolProperty(name="",default=True,description="Use sharp to cut")
    use_edge_angle: BoolProperty(name="",default=True,description="Use Angle to cut")

    show_options_edge_split: BoolProperty(default=False)

    def draw(self, layout):
        box = layout.box()
        row = box.row(align=True)

        icons = load_icons()
        icon = icons.get("icon_edge_split")
        row.scale_y = 1.5
        row.label(text="", icon_value=icon.icon_id)
        row.prop(self, "show_options_edge_split", text="EDGE SPLIT",
                 icon='TRIA_UP' if self.show_options_edge_split else 'TRIA_RIGHT')
        if self.show_options_edge_split:
            row = box.row(align=True)
            row.label(text="Split Angle")
            row.prop(self, "split_angle", text="")

            row = box.row(align=True)
            row.label(text="Use Edge Angle")
            row.prop(self, "use_edge_angle", text="      ")

            row = box.row(align=True)
            row.label(text="Use Edge Sharp")
            row.prop(self, "use_edge_sharp", text="      ")

class PrefsMirror(PropertyGroup):
    use_axis: BoolVectorProperty(default=[True, False, False], size=3)
    use_bisect_axis: BoolVectorProperty(default=[False, False, False], size=3)
    use_bisect_flip_axis: BoolVectorProperty(default=[False, False, False], size=3)
    use_clip: BoolProperty(name="",default=True,description="Use Clip")
    use_mirror_merge: BoolProperty(name="",default=True,description="Use Mirror Merge")
    merge_threshold: FloatProperty(name="Merge Threshold", default=0.001)
    use_mirror_vertex_groups: BoolProperty(name="",default=True,description="Use Mirror Vertex Group")
    use_mirror_u: BoolProperty(name="",default=True,description="flip U")
    use_mirror_v: BoolProperty(name="",default=False,description="flip V")
    center_empty_ref: BoolProperty(name="", default=False, description="Center the Empty to the scene origin")

    show_options_mirror: BoolProperty(default=False)

    def draw(self, layout):
        box = layout.box()
        row = box.row(align=True)

        icons = load_icons()
        icon = icons.get("icon_mirror")
        row.scale_y = 1.5
        row.label(text="", icon_value=icon.icon_id)
        row.prop(self, "show_options_mirror", text="MIRROR",
                 icon='TRIA_UP' if self.show_options_mirror else 'TRIA_RIGHT')
        if self.show_options_mirror:
            split = box.split()
            col = split.column()
            col.label(text="Axis:")
            col = split.column(align=True)
            col.prop(self, 'use_axis', expand=True)

            row = box.row(align=True)
            row.label(text="Clipping")
            row.prop(self, "use_clip", text="      ")

            row = box.row(align=True)
            row.label(text="Flip U")
            row.prop(self, "use_mirror_u", text="      ")

            row = box.row(align=True)
            row.label(text="Flip V")
            row.prop(self, "use_mirror_v", text="      ")

            row = box.row(align=True)
            row.label(text="Merge Threshold")
            row.prop(self, "merge_threshold")

            row = box.row(align=True)
            row.label(text="Center Empty Ref")
            row.prop(self, "center_empty_ref", text="      ")

class PrefsMod_visibility(PropertyGroup):

    def draw(self, layout):
        box = layout.box()


class PrefsScrew(PropertyGroup):
    steps : IntProperty(name="",default=24,min=2, max=512)
    render_steps : IntProperty(name="",default=24,min=2, max=512)
    use_smooth_shade : BoolProperty(name="",default=True,description="Smooth Shading")
    use_normal_flip : BoolProperty(name="",default=True,description="Flip Normals")
    use_merge_vertices: BoolProperty(name="",default=True,description="Merge Vertices")
    use_normal_calculate: BoolProperty(name="",default=True,description="Merge Vertices")

    show_options_screw: BoolProperty(default=False)
    def draw(self, layout):
        box = layout.box()
        row = box.row(align=True)

        icons = load_icons()
        icon = icons.get("icon_screw")
        row.scale_y = 1.5
        row.label(text="", icon_value=icon.icon_id)
        row.prop(self, "show_options_screw", text="SCREW",
                 icon='TRIA_UP' if self.show_options_screw else 'TRIA_RIGHT')
        if self.show_options_screw:
            row = box.row(align=True)
            row.label(text="Steps")
            row.prop(self, "steps")

            row = box.row(align=True)
            row.label(text="Flip Normals")
            row.prop(self, "use_normal_flip", text="      ")

            row = box.row(align=True)
            row.label(text="Smooth Shading")
            row.prop(self, "use_smooth_shade", text="      ")

            row = box.row(align=True)
            row.label(text="Calc Order")
            row.prop(self, "use_normal_calculate", text="      ")


            row = box.row(align=True)
            row.label(text="Merge Vertices")
            row.prop(self, "use_merge_vertices", text="      ")

class PrefsShrinkwrap(PropertyGroup):
    offset : FloatProperty(name="Offset",default=0.03,description="Offset")

    wrap_method : EnumProperty(
        items=(('NEAREST_SURFACEPOINT', "NEAREST_SURFACEPOINT", ""),
               ('PROJECT', "PROJECT", ""),
               ('NEAREST_VERTEX', "NEAREST_VERTEX", ""),
               ('TARGET_PROJECT', "TARGET_PROJECT", "")),
        default='NEAREST_SURFACEPOINT')

    wrap_mode: EnumProperty(
        items=(('ON_SURFACE', "ON_SURFACE", ""),
               ("INSIDE", "INSIDE", ""),
               ("OUTSIDE", "OUTSIDE", ""),
               ("OUTSIDE_SURFACE", "OUTSIDE_SURFACE", ""),
               ("ABOVE_SURFACE", "ABOVE_SURFACE", "")),
        default='OUTSIDE')

    subsurf_levels: FloatProperty(name="Subsurf Levels",default=0,description="Subsurf Levels")
    project_limit: FloatProperty(name="Project Limit",default=0,description="Project Limit")
    use_project_x: BoolProperty(name="Use Project X",default=False,description="Use Project X")
    use_project_y: BoolProperty(name="Use Project Y",default=False,description="Use Project Y")
    use_project_z: BoolProperty(name="Use Project Z",default=False,description="Use Project Z")
    use_negative_direction: BoolProperty(name="Negative",default=True,description="Negative")
    use_positive_direction: BoolProperty(name="Positive",default=True,description="Positive")
    use_invert_cull: BoolProperty(name="Invert Cull",default=False,description="Invert Cull")
    auto_add_mirror: BoolProperty(name="Auto Add Mirror", default=True)
    use_in_front: BoolProperty(name="Use In Front Setting", default=False)
    use_wireframe: BoolProperty(name="Use Wireframe", default=True)
    obj_color: FloatVectorProperty(name="", default=(0, 0.65, 1, 0.5), min=0, max=1, size=4, subtype='COLOR_GAMMA')
    mirror_axis: BoolVectorProperty(default=[True, False, False], size=3, name="")

    cull_face: EnumProperty(
        items=(('OFF', "OFF", ""),
               ("FRONT", "FRONT", ""),
               ("BACK", "BACK", "")),
        default='OFF')

    start_from: EnumProperty(
        items=(('BSURFACE', "BSurface", ""),
               ('VERTEX', "Vertex", ""),
               ('POLYBUILD', "Polybuild", ""),
               ('POLYQUILT',"PolyQuilt", "")),
        default='VERTEX')

    show_options_shrinkwrap: BoolProperty(default=False)

    def draw(self, layout):
        box = layout.box()
        row = box.row(align=True)

        icons = load_icons()
        icon = icons.get("icon_shrinkwrap")
        row.scale_y = 1.5
        row.label(text="", icon_value=icon.icon_id)
        row.prop(self, "show_options_shrinkwrap", text="SHRINKWRAP",
                 icon='TRIA_UP' if self.show_options_shrinkwrap else 'TRIA_RIGHT')
        if self.show_options_shrinkwrap:
            split = box.split()
            col = split.column()
            col.label(text="Offset:")
            col = split.column(align=True)
            col.prop(self, 'offset', expand=True)

            row = box.row(align=True)
            row.label(text="Wrap Method")
            row.prop(self, "wrap_method", text="")

            if self.wrap_method in {'NEAREST_SURFACEPOINT', 'TARGET_PROJECT'}:
                row = box.row(align=True)
                row.label(text="Wrap Mode")
                row.prop(self, "wrap_mode", text="")

            if self.wrap_method == 'PROJECT':
                split = box.split()
                col = split.column()
                col.label(text="Subsurf Levels:")
                col = split.column(align=True)
                col.prop(self, 'subsurf_levels', expand=True)

                split = box.split()
                col = split.column()
                col.label(text="Project Limit:")
                col = split.column(align=True)
                col.prop(self, 'project_limit', expand=True)

                row = box.row(align=True)
                row.label(text="Use Project X")
                row.prop(self, "use_project_x", text="      ")

                row = box.row(align=True)
                row.label(text="Use Project Y")
                row.prop(self, "use_project_y", text="      ")

                row = box.row(align=True)
                row.label(text="Use Project Z")
                row.prop(self, "use_project_z", text="      ")

                row = box.row(align=True)
                row.label(text="Negative")
                row.prop(self, "use_negative_direction", text="      ")

                row = box.row(align=True)
                row.label(text="Positive")
                row.prop(self, "use_positive_direction", text="      ")

                row = box.row(align=True)
                row.label(text="Invert Cull")
                row.prop(self, "use_invert_cull", text="      ")

                row = box.row(align=True)
                row.label(text="Cull Faces:")
                row.prop(self, "cull_face", text="")

            row = box.row(align=True)
            row.separator()
            row = box.row(align=True)
            row.label(text="RETOPO SETTINGS")


            row = box.row(align=True)
            row.label(text="Start Retopo From")
            row.prop(self, "start_from", text="")

            row = box.row(align=True)
            row.label(text="Auto Add Mirror")
            row.prop(self, "auto_add_mirror", text="      ")

            if self.auto_add_mirror:
                split = box.split()
                col = split.column()
                col.label(text="Mirror Axis:")
                col = split.column(align=True)
                col.prop(self, 'mirror_axis', expand=True)

            row = box.row(align=True)
            row.label(text="Use Wireframe")
            row.prop(self, "use_wireframe", text="      ")

            row = box.row(align=True)
            row.label(text="Use In Front")
            row.prop(self, "use_in_front", text="      ")

            row = box.row(align=True)
            row.label(text="Color")
            row.prop(self, "obj_color")

class PrefsSimple_Deform(PropertyGroup):
    angle : FloatProperty(name="Angle",default=0.575959,description="Angle")
    factor : FloatProperty(name="Taper Factor",default=0.575959,description="Taper Factor")
    lock_x: BoolProperty(name="", default=False, description="Lock X")
    lock_y: BoolProperty(name="", default=False, description="Lock Y")
    lock_z: BoolProperty(name="", default=False, description="Lock Z")

    deform_method: EnumProperty(
        items=(('TWIST', "TWIST", ""),
               ("BEND", "BEND", ""),
               ("TAPER", "TAPER", ""),
               ("STRETCH", "STRETCH", "")),
        default='BEND')

    deform_axis: EnumProperty(
        items=(('X', "X", ""),
               ("Y", "Y", ""),
               ("Z", "Z", "")),
        default='Z')

    show_options_simple_deform: BoolProperty(default=False)

    def draw(self, layout):
        box = layout.box()
        row = box.row(align=True)

        icons = load_icons()
        icon = icons.get("icon_simple_deform")
        row.scale_y = 1.5
        row.label(text="", icon_value=icon.icon_id)
        row.prop(self, "show_options_simple_deform", text="SIMPLE DEFORM",
                 icon='TRIA_UP' if self.show_options_simple_deform else 'TRIA_RIGHT')
        if self.show_options_simple_deform:
            split = box.split()
            box = split.column()
            row = box.row(align=True)
            row.label(text="Method:")
            row.prop(self, "deform_method", text="")

            if self.deform_method in {'TAPER', 'STRETCH'}:
                row = box.row(align=True)
                row.label(text="Taper Factor")
                row.prop(self, "factor", text="")
            else:
                row = box.row(align=True)
                row.label(text="Angle")
                row.prop(self, "angle", text="")

            row = box.row(align=True)
            row.label(text="Axis:")
            row.prop(self, "deform_axis", text="")

            if self.deform_method in {'TWIST', 'TAPER', 'STRETCH'}:
                if self.deform_axis == 'X':
                    row = box.row(align=True)
                    row.label(text="Lock Y")
                    row.prop(self, "lock_y", text="      ")

                    row = box.row(align=True)
                    row.label(text="Lock Z")
                    row.prop(self, "lock_z", text="      ")
                elif self.deform_axis == 'Y':
                    row = box.row(align=True)
                    row.label(text="Lock X")
                    row.prop(self, "lock_x", text="      ")

                    row = box.row(align=True)
                    row.label(text="Lock Z")
                    row.prop(self, "lock_z", text="      ")
                else:
                    row = box.row(align=True)
                    row.label(text="Lock X")
                    row.prop(self, "lock_x", text="      ")

                    row = box.row(align=True)
                    row.label(text="Lock Y")
                    row.prop(self, "lock_y", text="      ")

class PrefsSkin(PropertyGroup):
    use_smooth_shade: BoolProperty(name="",default=True,description="Smooth Shading")
    use_x_symmetry: BoolProperty(name="",default=True,description="Symmetry Axis X")
    use_y_symmetry: BoolProperty(name="",default=False,description="Symmetry Axis Y")
    use_z_symmetry: BoolProperty(name="",default=False,description="Symmetry Axis Z")
    branch_smoothing: FloatProperty(name="Branch Smoothing",default=0,min=0,max=1)

    show_options_skin: BoolProperty(default=False)

    def draw(self, layout):
        box = layout.box()
        row = box.row(align=True)

        icons = load_icons()
        icon = icons.get("icon_skin")
        row.scale_y = 1.5
        row.label(text="", icon_value=icon.icon_id)
        row.prop(self, "show_options_skin", text="SKIN",
                 icon='TRIA_UP' if self.show_options_skin else 'TRIA_RIGHT')
        if self.show_options_skin:
            split = box.split()
            row = split.column()
            row = box.row(align=True)
            row.label(text="Smooth Sahing")
            row.prop(self, "use_smooth_shade", text="      ")

            row = box.row(align=True)
            row.label(text="Symmetry Axis X")
            row.prop(self, "use_x_symmetry", text="      ")

            row = box.row(align=True)
            row.label(text="Symmetry Axis Y")
            row.prop(self, "use_y_symmetry", text="      ")

            row = box.row(align=True)
            row.label(text="Symmetry Axis Z")
            row.prop(self, "use_z_symmetry", text="      ")

            row = box.row(align=True)
            row.label(text="Branch Smoothing")
            row.prop(self, "branch_smoothing")

class PrefsSolidify(PropertyGroup):
    offset : FloatProperty(name="",default=0,min=-1.0, max=1.0)
    thickness : FloatProperty(name="",default=0.1,min=0.0, max=100)
    use_even_offset : BoolProperty(name="",default=True,description="Use Even Thickness")
    use_quality_normals : BoolProperty(name="",default=True,description="High quality normals")
    use_flip_normals: BoolProperty(name="",default=False,description="Flip normals")
    use_rim: BoolProperty(name="",default=True,description="Use Rim")
    use_rim_only: BoolProperty(name="",default=False,description="Use Rim Only")

    show_options_solidify: BoolProperty(default=False)

    def draw(self, layout):
        box = layout.box()
        row = box.row(align=True)

        icons = load_icons()
        icon = icons.get("icon_solidify")
        row.scale_y = 1.5
        row.label(text="", icon_value=icon.icon_id)
        row.prop(self, "show_options_solidify", text="SOLIDIFY",
                 icon='TRIA_UP' if self.show_options_solidify else 'TRIA_RIGHT')
        if self.show_options_solidify:
            row = box.row(align=True)
            row.label(text="Thickness")
            row.prop(self, "thickness")

            row = box.row(align=True)
            row.label(text="Offset")
            row.prop(self, "offset")

            row = box.row(align=True)
            row.label(text="Flip Normals")
            row.prop(self, "use_flip_normals", text="      ")

            row = box.row(align=True)
            row.label(text="Even Thickness")
            row.prop(self, "use_even_offset", text="      ")

            row = box.row(align=True)
            row.label(text="High Quality Normals")
            row.prop(self, "use_quality_normals", text="      ")

            row = box.row(align=True)
            row.label(text="Fill Rim")
            row.prop(self, "use_rim", text="      ")

            row = box.row(align=True)
            row.label(text="Only Rim")
            row.prop(self, "use_rim_only", text="      ")

class PrefsSubsurf(PropertyGroup):
    levels : IntProperty(name="",default=2,min=0, max=10)
    render_levels : IntProperty(name="",default=2,min=0, max=10)
    quality: IntProperty(name="",default=3,min=0, max=10)
    show_only_control_edges: BoolProperty(name="", default=True, description="Use Optimal Display")

    subdivision_type : EnumProperty(
        items=(('CATMULL_CLARK', "CATMULL_CLARK", ""),
               ('SIMPLE', "SIMPLE", "")),
        default='CATMULL_CLARK'
    )

    uv_smooth: EnumProperty(
        items=(('NONE', "NONE", ""),
               ('PRESERVE_CORNERS', "PRESERVE_CORNERS", "")),
        default='NONE'
    )

    show_options_subsurf: BoolProperty(default=False)

    direct_mode: BoolProperty(default=False)

    def draw(self, layout):
        box = layout.box()
        row = box.row(align=True)

        icons = load_icons()
        icon = icons.get("icon_subsurf")
        row.scale_y = 1.5
        row.label(text="", icon_value=icon.icon_id)
        row.prop(self, "show_options_subsurf", text="SUBSURF",
                 icon='TRIA_UP' if self.show_options_subsurf else 'TRIA_RIGHT')
        if self.show_options_subsurf:
            row = box.row(align=True)
            row.label(text="Subdivision Type")
            row.prop(self, "subdivision_type", text="")

            row = box.row(align=True)
            row.label(text="Levels")
            row.prop(self, "levels")

            row = box.row(align=True)
            row.label(text="Quality")
            row.prop(self, "quality")

            row = box.row(align=True)
            row.label(text="Optimal display")
            row.prop(self, "show_only_control_edges", text="      ")

            row = box.row(align=True)
            row.label(text="UV Smooth")
            row.prop(self, "uv_smooth", text="")

            row = box.row(align=True)
            row.label(text="Direct Mode")
            row.prop(self, "direct_mode", text="      ")


class PrefsTriangulate(PropertyGroup):
    min_vertices: IntProperty(name="", default=5, min=1, max=1000)
    keep_custom_normals: BoolProperty(name="",default=True,description="Keep Normals")

    quad_method : EnumProperty(
        items=(('BEAUTY', "BEAUTY", ""),
               ('FIXED', "FIXED", ""),
               ('FIXED_ALTERNATE', "FIXED_ALTERNATE", ""),
               ('SHORTEST_DIAGONAL', "SHORTEST_DIAGONAL", "")),
        default='BEAUTY'
    )

    ngon_method: EnumProperty(
        items=(('BEAUTY', "BEAUTY", ""),
               ("CLIP", "CLIP", "")),
        default='BEAUTY'
    )
    show_options_triangulate: BoolProperty(default=False)

    def draw(self, layout):
        box = layout.box()
        row = box.row(align=True)

        icons = load_icons()
        icon = icons.get("icon_triangulate")
        row.scale_y = 1.5
        row.label(text="", icon_value=icon.icon_id)
        row.prop(self, "show_options_triangulate", text="TRIANGULATE",
                 icon='TRIA_UP' if self.show_options_triangulate else 'TRIA_RIGHT')
        if self.show_options_triangulate:
            row = box.row(align=True)
            row.label(text="Quad Method")
            row.prop(self, "quad_method", text="")

            row = box.row(align=True)
            row.label(text="Ngon Method")
            row.prop(self, "ngon_method", text="")

            split = box.split()
            col = split.column()
            col.label(text="Minimum Vertices:")
            col = split.column(align=True)
            col.prop(self, 'min_vertices', expand=True)

            row = box.row(align=True)
            row.label(text="Keep Normals")
            row.prop(self, "keep_custom_normals", text="      ")

class PrefsTubify(PropertyGroup):
    bevel_resolution : IntProperty(name="Resolution V", default=4, min=0, max=1000)
    resolution_u : IntProperty(name="Resolution U", default=32, min=1, max=1000)
    bevel_depth: FloatProperty(name="Bevel Depth",default=0.1,description="Bevel Depth")
    offset : FloatProperty(name="Offset",default=0,description="Offset")
    extrude : FloatProperty(name="Extrude",default=0,description="Extrude")

    fill_mode : EnumProperty(
        items=(('FULL', "FULL", ""),
               ('BACK', "BACK", ""),
               ('FRONT', "FRONT", ""),
               ('HALF', "HALF", "")),
        default='FULL'
    )

    show_options_tubify: BoolProperty(default=False)

    def draw(self, layout):
        box = layout.box()
        row = box.row(align=True)

        icons = load_icons()
        icon = icons.get("icon_tubify")
        row.scale_y = 1.5
        row.label(text="", icon_value=icon.icon_id)
        row.prop(self, "show_options_tubify", text="TUBIFY",
                 icon='TRIA_UP' if self.show_options_tubify else 'TRIA_RIGHT')
        if self.show_options_tubify:
            row = box.row(align=True)
            row.label(text="Fill Mode")
            row.prop(self, "fill_mode", text="")

            split = box.split()
            col = split.column()
            col.label(text="Resolution U:")
            col = split.column(align=True)
            col.prop(self, 'resolution_u', expand=True)

            split = box.split()
            col = split.column()
            col.label(text="Resolution V:")
            col = split.column(align=True)
            col.prop(self, 'bevel_resolution', expand=True)

            row = box.row(align=True)
            row.label(text="Offset")
            row.prop(self, "offset")

            row = box.row(align=True)
            row.label(text="Extrude")
            row.prop(self, "extrude")

class PrefsWeighted_normal(PropertyGroup):
    weight: IntProperty(name="", default=50, min=1, max=100)
    tresh : FloatProperty(name="",default=0.01,min=0, max=10)
    keep_sharp : BoolProperty(name="",default=True,description="Use Only Smooth")
    face_influence: BoolProperty(name="",default=False,description="Use Pin Boundary")

    mode: EnumProperty(
        items=(('FACE_AREA', "FACE AREA", ""),
               ("CORNER_ANGLE", "CORNER ANGLE", ""),
               ("FACE_AREA_WITH_ANGLE", "FACE AREA WITH ANGLE", "")),
        default='FACE_AREA')

    show_options_weighted_normal: BoolProperty(default=False)

    def draw(self, layout):
        box = layout.box()
        row = box.row(align=True)

        icons = load_icons()
        icon = icons.get("icon_weighted_normal")
        row.scale_y = 1.5
        row.label(text="", icon_value=icon.icon_id)
        row.prop(self, "show_options_weighted_normal", text="WEIGHTED NORMAL",
                 icon='TRIA_UP' if self.show_options_weighted_normal else 'TRIA_RIGHT')
        if self.show_options_weighted_normal:
            row = box.row(align=True)
            row.label(text="Weighting Mode:")
            row.prop(self, "mode", text="")

            row = box.row(align=True)
            row.label(text="Weight")
            row.prop(self, "weight")

            row = box.row(align=True)
            row.label(text="Treshold")
            row.prop(self, "tresh")

            row = box.row(align=True)
            row.label(text="Keep Sharp")
            row.prop(self, "keep_sharp", text="      ")

            row = box.row(align=True)
            row.label(text="Face Influence")
            row.prop(self, "face_influence", text="      ")

class PrefsWireframe(PropertyGroup):
    offset : FloatProperty(name="",default=0,min=-1.0, max=1.0)
    thickness : FloatProperty(name="",default=0.1,min=0.0, max=100)
    use_even_offset : BoolProperty(name="",default=True,description="Use Even Thickness")
    use_relative_offset: BoolProperty(name="",default=False,description="Use Relative Offset")
    use_boundary: BoolProperty(name="",default=True,description="Use Boundary")
    use_replace: BoolProperty(name="",default=True,description="Use Replace")

    show_options_wireframe: BoolProperty(default=False)

    def draw(self, layout):
        box = layout.box()
        row = box.row(align=True)

        icons = load_icons()
        icon = icons.get("icon_wireframe")
        row.scale_y = 1.5
        row.label(text="", icon_value=icon.icon_id)
        row.prop(self, "show_options_wireframe", text="WIREFRAME",
                 icon='TRIA_UP' if self.show_options_wireframe else 'TRIA_RIGHT')
        if self.show_options_wireframe:

            row = box.row(align=True)
            row.label(text="Thickness")
            row.prop(self, "thickness")

            row = box.row(align=True)
            row.label(text="Offset")
            row.prop(self, "offset")

            row = box.row(align=True)
            row.label(text="Even Thickness")
            row.prop(self, "use_even_offset", text="      ")

            row = box.row(align=True)
            row.label(text="Relative Thickness")
            row.prop(self, "use_relative_offset", text="      ")

            row = box.row(align=True)
            row.label(text="Boundary")
            row.prop(self, "use_boundary", text="      ")

            row = box.row(align=True)
            row.label(text="Replace Original")
            row.prop(self, "use_replace", text="      ")

class PrefsCutter(PropertyGroup):
    cutter_face_color: FloatVectorProperty(name="", default=(0, 0.65, 1, 0.25), min=0, max=1, size=4,
                                        subtype='COLOR_GAMMA')

    cutter_lines_color: FloatVectorProperty(name="", default=(0, 0.65, 1, 1), min=0, max=1, size=4,
                                            subtype='COLOR_GAMMA')
    cutter_screw_steps : IntProperty(name="", default=32, min=1, max=1000)

    show_options_cutter: BoolProperty(default=False)

    def draw(self, layout):
        box = layout.box()
        row = box.row(align=True)

        icons = load_icons()
        icon = icons.get("icon_cutter")
        row.scale_y = 1.5
        row.label(text="", icon_value=icon.icon_id)
        row.prop(self, "show_options_cutter", text="CUTTER",
                 icon='TRIA_UP' if self.show_options_cutter else 'TRIA_RIGHT')
        if self.show_options_cutter:
            row = box.row(align=True)
            row.label(text="Screw Steps")
            row.prop(self, "cutter_screw_steps")

            row = box.row(align=True)
            row.label(text="Cutter Face Color")
            row.prop(self, "cutter_face_color")

            row = box.row(align=True)
            row.label(text="Cutter Lines Color")
            row.prop(self, "cutter_lines_color")


###### --------------------------------------------------------------------------
###### --------------------------------------------------------------------------
class SPEEDFLOW_MT_addon_prefs(bpy.types.AddonPreferences):
    bl_idname = __name__

    prefs_tabs : EnumProperty(
        items=(('ui', "UI", "UI"),
               ('modals', "Modals", "Modals"),
               ('texts_color', "Texts Color", "Texts Color"),
               ('keymaps', "Keymaps", "Keymaps"),
               ('tutorials', "Tutorials", "Tutorials"),
               ('addons', "Addons", "Addons"),
               ('links', "Links", "Links")),
               default='ui')
                                                                                                      
    work_tool : EnumProperty(
        items=(('mouse', "Mouse", ""),
            ('pen', "Graphic tablet", "")),
            default='pen')

    show_update: BoolProperty(name="Show update",description="Display info when update is available",default=True,update=check_for_update)
    check_for_updates: BoolProperty(name="",default=False,description="Check for updates of the addon")
        # update = 'sf_check_update')

    modal_items = [('array', "Array", "Array"),
                   ('bevel', "Bevel", "Bevel"),
                   ('subsurf', "Subsurf", "Subsurf"),
                   ('mirror', "Mirror", "Mirror"),
                   ('solidify', "Solidify", "Solidify"),
                   ('booleans', "Booleans", "Booleans"),
                   ('screw', "Screw", "Screw"),
                   ('displace', "Displace", "Displace"),
                   ('decimate', "Decimate", "Decimate"),
                   ('triangulate', "Triangulate", "Triangulate"),
                   ('tubify', "Tubify", "Tubify"),
                   ('edge_split', "Edge Split", "Edge Split"),
                   ('shrinkwrap', "Shrinkwrap", "Shrinkwrap"),
                   ('simple_deform', "Simple Deform", "Simple Deform"),
                   ('wireframe', "Wireframe", "Wireframe"),
                   ('curve', "Curve", "Curve"),
                   ('corrective_smooth', "Corrective Smooth", "Corrective Smooth"),
                   ('mod_visibility', "Mod Visibility", "Mod Visibility"),
                   ('cutter', "Cutter", "Cutter"),
                   ('weighted_normal', "Weighted Normal", "Weighted Normal"),
                   ('skin', "Skin", "Skin"),
                   ('none', "None", "None"),]

    enum_modals_1: EnumProperty(items=(modal_items),default='screw')
    enum_modals_2: EnumProperty(items=(modal_items),default='displace')
    enum_modals_3: EnumProperty(items=(modal_items),default='mirror')
    enum_modals_4: EnumProperty(items=(modal_items),default='cutter')
    enum_modals_5: EnumProperty(items=(modal_items),default='bevel')
    enum_modals_6: EnumProperty(items=(modal_items),default='solidify')
    enum_modals_7: EnumProperty(items=(modal_items),default='array')
    enum_modals_8: EnumProperty(items=(modal_items),default='booleans')
    enum_modals_9: EnumProperty(items=(modal_items),default='subsurf')
    enum_modals_10: EnumProperty(items=(modal_items),default='decimate')
    enum_modals_11: EnumProperty(items=(modal_items),default='tubify')
    enum_modals_12: EnumProperty(items=(modal_items),default='curve')
    enum_modals_13: EnumProperty(items=(modal_items),default='shrinkwrap')
    enum_modals_14: EnumProperty(items=(modal_items),default='simple_deform')
    enum_modals_15: EnumProperty(items=(modal_items),default='wireframe')
    enum_modals_16: EnumProperty(items=(modal_items),default='edge_split')
    enum_modals_17: EnumProperty(items=(modal_items),default='triangulate')
    enum_modals_18: EnumProperty(items=(modal_items),default='skin')
    enum_modals_19: EnumProperty(items=(modal_items),default='weighted_normal')
    enum_modals_20: EnumProperty(items=(modal_items),default='mod_visibility')

    # --MODAL OPTION
    modal_speed : FloatProperty(name="",default=1.0,min=0.001, max=1000)
    default_modal_action : BoolProperty(name="",default=True,description="Free Navigation as Default action for modals")
    
# --UI OPTIONS
    show_help : BoolProperty(name="",default=True,description="Show the help in the Tool Panel",update=update_speedflow_help_panel)
    enabled_panel : BoolProperty(default=False,update=update_speedflow_ui)
    category : StringProperty(description="Choose a name for the category of the panel",default="Tools",update=update_speedflow_ui)

    choose_menu_type : EnumProperty(
        items=(('pie', "Pie", ""),
               ('menu', "Menu", "")),
               default='pie',
               update=update_menu_type)

    valid : EnumProperty(
        items=(('LEFTSELECT', "Left mouse", "Validate with LMB"),
               ('RIGHTSELECT', "Right mouse", "Validate with RMB"),
               ('AUTO', "Auto", "Cancel with mouse select button")),
               default='AUTO')

    show_expanded : BoolProperty(default=False)
    keep_wire : BoolProperty(name="",default=True,description="Keep the wire coming out of the Screw modal")
    show_wire_in_modal : BoolProperty(default=True,description="Show the wire in the bevel modal")
    buttons_size : FloatProperty(name="",default=1,min=0.25, max=2)

    # --MODIFIERS OPTIONS
    array : PointerProperty(type=PrefsArray)
    bevel : PointerProperty(type=PrefsBevel)
    boolean : PointerProperty(type=PrefsBoolean)
    curve: PointerProperty(type=PrefsCurve)
    cutter: PointerProperty(type=PrefsCutter)
    decimate: PointerProperty(type=PrefsDecimate)
    displace : PointerProperty(type=PrefsDisplace)
    edge_split: PointerProperty(type=PrefsEdge_Split)
    mirror: PointerProperty(type=PrefsMirror)
    screw : PointerProperty(type=PrefsScrew)
    shrinkwrap: PointerProperty(type=PrefsShrinkwrap)
    simple_deform: PointerProperty(type=PrefsSimple_Deform)
    skin: PointerProperty(type=PrefsSkin)
    solidify : PointerProperty(type=PrefsSolidify)
    subsurf : PointerProperty(type=PrefsSubsurf)
    triangulate: PointerProperty(type=PrefsTriangulate)
    tubify : PointerProperty(type=PrefsTubify)
    weighted_normal: PointerProperty(type=PrefsWeighted_normal)
    wireframe: PointerProperty(type=PrefsWireframe)
    corrective_smooth: PointerProperty(type=PrefsCorrective_Smooth)
    # rotate : PointerProperty(type=PrefsRotate)

    beginner_mode : BoolProperty(name="",default=False,description="Simple mode for beginners")
    add_weighted_normal : BoolProperty(name="",default=True,description="Add Weighted Normal Modifier")
    shading_smooth : BoolProperty(default=True,description="Use Smooth Shading")
    auto_apply_scale : BoolProperty(default=True,description="Auto Apply The scale to avoid deformations")
    auto_smooth_value : IntProperty(default=31,min=0, max=180)
    use_bound : BoolProperty(default=True,description="Use Bound as visibility option for bool objects")
    booleans_color: FloatVectorProperty(default=(0, 0.648912, 1, 0.05),min=0, max=1, size=4,subtype='COLOR_GAMMA')
    auto_rename_modifiers : BoolProperty(default=True,description="Auto rename the modifiers")
    add_bool_objects_to_collection : BoolProperty(default=True,description="Add to Bool Objects Collection")
# --TEXT OPTIONS

    display_keymaps : BoolProperty(default=True)
    display_texts : BoolProperty(default=True)
    text_color : FloatVectorProperty(name="", default=(1, 1, 1, 1),min=0, max=1, size=4,subtype='COLOR_GAMMA')
    text_color_1 : FloatVectorProperty(default=(0.5, 1, 0, 1),min=0, max=1, size=4,subtype='COLOR_GAMMA')
    text_color_2 : FloatVectorProperty(default=(0, 0.7, 1, 1),min=0, max=1, size=4,subtype='COLOR_GAMMA')
    text_color_on : FloatVectorProperty(default=(0, 1, 1, 1),min=0, max=1, size=4,subtype='COLOR_GAMMA')
    text_color_off : FloatVectorProperty(default=(0, 0, 0, 1),min=0, max=1, size=4,subtype='COLOR_GAMMA')
    text_size : IntProperty(default=20,min=10, max=50)
    keys_size : IntProperty(default=20,min=10, max=50)
    text_shadow : BoolProperty(default=True)
    shadow_color : FloatVectorProperty(default=(0, 0, 0, 1),min=0, max=1, size=4,subtype='COLOR_GAMMA')
    offset_shadow_x : IntProperty(default=2,min=-5, max=5)
    offset_shadow_y : IntProperty(default=-2,min=-5, max=5)
    text_pos_x : IntProperty(subtype='PERCENTAGE',default=50,min=1, max=100)
    text_pos_y : IntProperty(subtype='PERCENTAGE',default=25,min=1, max=100,description="Position of the Keymaps in X")
    keys_text_pos_x: IntProperty(subtype='PERCENTAGE',default=1,min=0, max=100,description="Position of the Keymaps in X")
    keys_text_pos_y: IntProperty(default=30,min=0, max=3000,description="Position of the Keymaps in Y")

    show_options_pie_order : BoolProperty(default=False)
    show_options_modals_options: BoolProperty(default=False)
    show_options_mouse_pen: BoolProperty(default=False)
    show_options_menus: BoolProperty(default=False)

    def release_note_layout(self, box):
        for line in utils.updater.release_note.split("\r"):
            box.label(text=line.split("\n")[-1])

    def draw(self, context):
        layout = self.layout
        SF = bpy.context.window_manager.SF

        icons = ui.load_icons()

        box = layout.box()
        row = box.row(align=True)
        row.label(text="Check For Updates")
        row.prop(self, "show_update", text="      ")

        if SF.update_available and self.show_update:
                box.label(text="Speedflow have been updated", icon='ERROR')
                # box.label(text= f"NEW VERSION: {SF.sf_update_new_version}", icon='ERROR')

                self.release_note_layout(box)

                box.label(text="Please download the last version and intall it")
                row = box.row()
                icon = icons.get("icon_gumroad")
                row.operator("wm.url_open",text="GUMROAD", icon_value=icon.icon_id).url = "https://gumroad.com/l/speedflow"
                icon = icons.get("icon_market")
                row.operator("wm.url_open", text="BLENDER MARKET", icon_value=icon.icon_id).url = "https://blendermarket.com/products/speedflow"
                icon = icons.get("icon_artstation")
                row.operator("wm.url_open", text="ARTSTATION",icon_value=icon.icon_id).url = "https://www.artstation.com/pitiwazou/store/0xb/speedflow"
                box.separator()
                box.label(text="HOW TO UPDATE:", icon='FILE_REFRESH')
                box.label(text="- Uninstall previous version with the REMOVE Button")
                box.label(text="- Click on INSTALL FROM FILE")
                box.label(text="- Select the Zip")
                box.label(text="- Click OK")
                box.label(text="- Activate it")
                box.label(text="- Click on SAVE PREFERENCES")
                box.label(text="- Restart Blender")

        box = layout.box()
        box.label(text="Keymap > SPACE")


        if context.window_manager.keyconfigs.active.name == "blender":
            box.separator()
            box.label(text="To use SPACE, you need to change the SPACEBAR Action to TOOLS or SEARCH")
            box.label(text="If you want to keep PLAY (Animation), change Speedlow keymaps in the keymap tab,")
            box.label(text="or change the animation key")

            prefs_blender = context.window_manager.keyconfigs['blender'].preferences
            split = box.split()
            col = split.column()
            col.label(text="Spacebar Action:")
            col = split.column(align=True)
            col.prop(prefs_blender, 'spacebar_action', expand=True)
            # box.label(text="Spacebar Action:")
            # row = box.row()
            # row.scale_y = 2
            # row.prop(prefs_blender, "spacebar_action")

        row= layout.row(align=True)
        row.prop(self, "prefs_tabs", expand=True)
        if self.prefs_tabs == 'ui':
# ----------Mouse/pen options
            box = layout.box()
            row = box.row(align=True)
            row.scale_y = 1.5
            row.label(text="", icon='MOUSE_MMB')
            row.prop(self, "show_options_mouse_pen", text="Mouse/PEN OPTIONS",
                 icon='TRIA_UP' if self.show_options_mouse_pen else 'TRIA_RIGHT')
            if self.show_options_mouse_pen:
                split = box.split()
                col = split.column()
                col.label(text="Modifiers settings adjustments:")
                col = split.column(align=True)
                col.prop(self, 'work_tool', expand=True)
                row = box.row(align=True)
                row.label(text="Note:")
                row = box.row(align=True)
                row.label(text="If you choose the Mouse, you will edit the settings with the Wheelmouse")
                row = box.row(align=True)
                row.label(text="If you choose the Pen, you will edit the settings by moving the Pen from Left to Right")

# ----------Menu Type
            box = layout.box()
            row = box.row(align=True)
            row.scale_y = 1.5
            row.label(text="", icon='MENU_PANEL')
            row.prop(self, "show_options_menus", text="MENUS OPTIONS",
                 icon='TRIA_UP' if self.show_options_menus else 'TRIA_RIGHT')

            if self.show_options_menus:
                split = box.split()
                col = split.column()
                col.label(text="Choose Menu type")
                col = split.column(align=True)
                col.prop(self, 'choose_menu_type', expand=True)



    # ----------Valid
                if context.window_manager.keyconfigs[0].preferences.select_mouse == 'RIGHT':
                    row = box.row(align=True)
                    row.label(text="Valid with")
                    row.prop(self, 'valid', text="    ")

    # ----------Panel
                row = box.row(align=True)
                row.label(text="Enable Panel")
                row.prop(self, 'enabled_panel', text="    ")

                if self.enabled_panel:
                    row = box.row(align=True)
                    row.label(text="Panel Category:")
                    row.prop(self, "category", text="")

                split = box.split()
                col = split.column()
                row = col.row(align=True)
                row.label(text="Show Help in Tool Panel")
                row.prop(self, "show_help", text="      ")

                row = box.row(align=True)
                row.label(text="Buttons Size Y")
                row.prop(self, "buttons_size")

                row = box.row(align=True)
                row.label(text="Beginner Mode")
                row.prop(self, "beginner_mode", text="      ")

                row = box.row(align=True)
                row.label(text="Display Keymap")
                row.prop(self, "display_keymaps", text="      ")

                # row = box.row(align=True)
                # row.label(text="Show icons")
                # row.prop(self, "show_icons", text="      ")


# ----------Pie Order
            box = layout.box()
            row = box.row(align=True)
            row.scale_y = 1.5
            row.label(text="", icon='COLLAPSEMENU')
            row.prop(self, "show_options_pie_order", text="PIE MENUS ORDER BUTTONS",
                     icon='TRIA_UP' if self.show_options_pie_order else 'TRIA_RIGHT')
            if self.show_options_pie_order:
                labels =[("1", "Bottom Left"),
                         ("2", "Bottom 1"),
                         ("9", "Bottom 2"),
                         ("10", "Bottom 3"),
                         ("11", "Bottom 4"),
                         ("12", "Bottom 5"),
                         ("13", "Bottom 6"),
                         ("14", "Bottom 7"),
                         ("15", "Bottom 8"),
                         ("16", "Bottom 9"),
                         ("17", "Bottom 10"),
                         ("18", "Bottom 11"),
                         ("19", "Bottom 12"),
                         ("20", "Bottom 13"),
                         ("3", "Bottom Right"),
                         ("4", "Left"),
                         ("5", "Right"),
                         ("6", "Top Left"),
                         ("7", "Top"),
                         ("8", "Top Right"),]

                for idx, attr in enumerate(labels):
                    enum_idx, position = attr
                    split = box.split()
                    col = split.column()
                    col.label(text="%s - pie = %s:" %(str(idx + 1), position))
                    col = split.column(align=True)
                    col.prop(self, 'enum_modals_%s' %enum_idx, text="")
           
            
# ----------Keymap settings
        if self.prefs_tabs == 'keymaps':
            wm = bpy.context.window_manager
            draw_keymap_items(self, wm, layout)



            # box = layout.box()
            # split = box.split()
            # col = split.column()
            # if self.choose_menu_type == 'pie':
            #     col.label(text='Setup Pie menu Hotkey')
            # elif self.choose_menu_type == 'menu':
            #     col.label(text='Setup Normal menu Hotkey')
            # col.separator()
            # wm = bpy.context.window_manager
            # kc = wm.keyconfigs.user
            # km = kc.keymaps['3D View Generic']
            #
            # if self.choose_menu_type == 'pie':
            #     self.kmi = get_hotkey_entry_item(km, 'wm.call_menu_pie', 'SPEEDFLOW_MT_pie_menu')
            # elif self.choose_menu_type == 'menu':
            #     self.kmi = get_hotkey_entry_item(km, 'wm.call_menu', 'SPEEDFLOW_MT_simple_menu')
            #
            # km = kc.keymaps['Object Mode']
            # self.kmi = get_hotkey_entry_item(km, 'None', 'speedflow.cutter')
            #
            # if self.kmi:
            #     col.context_pointer_set("keymap", km)
            #     rna_keymap_ui.draw_kmi([], kc, km, self.kmi, col, 0)
            # else:
            #     col.label(text="No hotkey entry found")
            #     col.operator(SPEEDFLOW_OT_add_hotkey.bl_idname, text = "Add hotkey entry", icon = 'ADD')

            # box = layout.box()
            # split = box.split()
            # col = split.column()
            # col.prop(self, "per_modal_keymap", text="Per modal Keymaps",
            #          icon='TRIA_UP' if self.per_modal_keymap else 'TRIA_DOWN')

# ----------MODALS
        if self.prefs_tabs == 'modals':

# ----------MODAL OPTION
            box = layout.box()
            row = box.row(align=True)
            row.scale_y = 1.5
            row.label(text="", icon='PIVOT_CURSOR')
            row.prop(self, "show_options_modals_options", text="MODALS OPTIONS",
                 icon='TRIA_UP' if self.show_options_modals_options else 'TRIA_RIGHT')
            if self.show_options_modals_options:
                box = layout.box()
                row = box.row(align=True)
                row.label(text="Modal Speed")
                row.prop(self, "modal_speed")

                row = box.row(align=True)
                row.label(text="Free Navigation as Default action for modals")
                row.prop(self, "default_modal_action", text="      ")

                row = box.row(align=True)
                row.label(text="Expand Modifiers Settings")
                row.prop(self, "show_expanded", text="      ")

                row = box.row()
                row.separator()

                row = box.row(align=True)
                row.label(text="Keep Wire visible after exiting the Modal")
                row.prop(self, "keep_wire", text="      ")

                row = box.row(align=True)
                row.label(text="Show the Wire in the Modal")
                row.prop(self, "show_wire_in_modal", text="      ")


                row = box.row(align=True)
                row.label(text="Auto Apply Scale")
                row.prop(self, "auto_apply_scale", text="      ")

                row = box.row(align=True)
                row.label(text="Use Auto Smooth")
                row.prop(self, "shading_smooth", text="      ")

                if self.shading_smooth:
                    row = box.row(align=True)
                    row.label(text="Auto Smooth")
                    row.prop(self, "auto_smooth_value")

                row = box.row(align=True)
                row.label(text="Auto Add Weighted Normal Modifier")
                row.prop(self, "add_weighted_normal", text="      ")

                row = box.row(align=True)
                row.label(text="Auto Rename Modifiers")
                row.prop(self, "auto_rename_modifiers", text="      ")

                row = box.row(align=True)
                row.label(text="Add Bool Objects to Collection")
                row.prop(self, "add_bool_objects_to_collection", text="      ")


            # print(self.bevel)
# ----------Modifiers options

            self.array.draw(layout)
            self.bevel.draw(layout)
            self.boolean.draw(layout)
            self.curve.draw(layout)
            self.cutter.draw(layout)
            self.decimate.draw(layout)
            self.displace.draw(layout)
            self.edge_split.draw(layout)
            self.mirror.draw(layout)
            self.screw.draw(layout)
            self.shrinkwrap.draw(layout)
            self.simple_deform.draw(layout)
            self.skin.draw(layout)
            self.solidify.draw(layout)
            self.subsurf.draw(layout)
            self.triangulate.draw(layout)
            self.tubify.draw(layout)
            self.weighted_normal.draw(layout)
            self.wireframe.draw(layout)
            # self.corrective_smooth.draw(layout)
            # self.rotate.draw(layout)

# ----------UI OPTIONS
        if self.prefs_tabs == 'texts_color':                              
# ----------Texts
            box = layout.box()
            row = box.row(align=True)
            row.label(text="Text Color")
            row.prop(self, "text_color")
            
            row = box.row(align=True)
            row.label(text="Text Color 1")
            row.prop(self, "text_color_1")
            
            row = box.row(align=True)
            row.label(text="Text Color 2")
            row.prop(self, "text_color_2")
            
            row = box.row(align=True)
            row.label(text="Text Size")
            row.prop(self, "text_size")
            
            row = box.row(align=True)
            row.label(text="Text X position")
            row.prop(self, "text_pos_x")
            
            row = box.row(align=True)
            row.label(text="Text Y position")
            row.prop(self, "text_pos_y")
            
            row = box.row(align=True)
            row.label(text="Keys Size")
            row.prop(self, "keys_size")


            row = box.row(align=True)
            row.label(text="Keymaps X position")
            row.prop(self, "keys_text_pos_x")

            row = box.row(align=True)
            row.label(text="Keymaps Y position")
            row.prop(self, "keys_text_pos_y")
            
            row = box.row()
            row.separator()
            
# ----------Shadows
            row = box.row(align=True)
            row.label(text="SHADOWS")

            row = box.row(align=True)
            row.label(text="Activate Shadows")
            row.prop(self, "text_shadow", text="      ")
            
            if self.text_shadow:
                row = box.row(align=True)
                row.label(text="Shadows Color")
                row.prop(self, "shadow_color")
                
                # row = box.row(align=True)
                # row.label(text="Shadows Transparency")
                # row.prop(self, "shadow_alpha")
                
                row = box.row(align=True)
                row.label(text="Offset Shadows X")
                row.prop(self, "offset_shadow_x")
                
                row = box.row(align=True)
                row.label(text="Offset Shadows Y")
                row.prop(self, "offset_shadow_y")

        # ------TUTORIALS
        if self.prefs_tabs == 'tutorials':
            box = layout.box()
            box.label(text="Free Tutorials:", icon='COMMUNITY')
            box.operator("wm.url_open", text="Youtube Channel").url = "https://www.youtube.com/user/pitiwazou"
            box.label(text="Paid Tutorials:", icon='HAND')
            box.operator("wm.url_open",
                         text="Sony BSP10 Non - Destructive Workflow").url = "https://gumroad.com/l/sony_bsp10_non_destructive_tutorial"
            box.operator("wm.url_open",
                         text="Non - Destructive Workflow Tutorial 1").url = "https://gumroad.com/l/Non-Destructive_Workflow_Tutorial_1"
            box.operator("wm.url_open",
                         text="Non - Destructive Workflow Tutorial 2").url = "https://gumroad.com/l/Non-Destructive_Workflow_Tutorial_2"
            box.operator("wm.url_open",
                         text="Non - Destructive Workflow Tutorial 3").url = "https://gumroad.com/l/Non-Destructive_Workflow_Tutorial_3"
            box.operator("wm.url_open",
                         text="Hydrant Modeling Tutorial").url = "https://gumroad.com/l/hydrant_modeling_tutorial"
            box.operator("wm.url_open",
                         text="Hydrant Unwrapping Tutorial").url = "https://gumroad.com/l/hydrant_unwrapping_tutorial"
            box.operator("wm.url_open",
                         text="Furry Warfare Plane Modeling Tutorial").url = "https://gumroad.com/l/furry_warfare_plane_modeling_tutorial"

        # Addons
        if self.prefs_tabs == 'addons':
            box = layout.box()
            box.operator("wm.url_open", text="Addon's Discord").url = "https://discord.gg/ctQAdbY"
            box.separator()
            box.operator("wm.url_open", text="Asset Management").url = "https://gumroad.com/l/asset_management"
            box.operator("wm.url_open", text="Speedflow").url = "https://gumroad.com/l/speedflow"
            box.operator("wm.url_open", text="SpeedSculpt").url = "https://gumroad.com/l/SpeedSculpt"
            box.operator("wm.url_open", text="SpeedRetopo").url = "https://gumroad.com/l/speedretopo"
            box.operator("wm.url_open", text="Easyref").url = "https://gumroad.com/l/easyref"
            box.operator("wm.url_open", text="RMB Pie Menu").url = "https://gumroad.com/l/wazou_rmb_pie_menu_v2"
            box.operator("wm.url_open", text="Wazou's Pie Menu").url = "https://gumroad.com/l/wazou_pie_menus"
            box.operator("wm.url_open", text="Smart Cursor").url = "https://gumroad.com/l/smart_cursor"
            box.label(text="Archipack", icon='BLENDER')
            box.operator("wm.url_open", text="Archi Pack").url = "https://blender-archipack.org"
            box.operator("wm.url_open",
                         text="My 2.8 Theme").url = "https://www.dropbox.com/s/s95wj828l5mw8nf/wazou_red_280_001.xml?dl=0"
            
# ------URls
        if self.prefs_tabs == 'links':
            box = layout.box()
            box.label(text="Support me:", icon='HAND')
            box.operator("wm.url_open", text="Patreon").url = "https://www.patreon.com/pitiwazou"
            box.operator("wm.url_open", text="Tipeee").url = "https://www.tipeee.com/blenderlounge"

            box.separator()
            box.label(text="Web:", icon='WORLD')
            box.operator("wm.url_open", text="Pitiwazou.com").url = "http://www.pitiwazou.com/"
            box.separator()
            box.label(text="Youtube:", icon='SEQUENCE')
            box.operator("wm.url_open", text="Youtube - Pitiwazou").url = "https://www.youtube.com/user/pitiwazou"
            box.operator("wm.url_open",
                         text="Youtube - Blenderlounge").url = "https://www.youtube.com/channel/UCaA3_WSE5A0H6YrS1SDfAQw/videos"
            box.separator()
            box.label(text="Social:", icon='USER')
            box.operator("wm.url_open", text="Artstation").url = "https://www.artstation.com/artist/pitiwazou"
            box.operator("wm.url_open", text="Twitter").url = "https://twitter.com/#!/pitiwazou"
            box.operator("wm.url_open",
                         text="Facebook").url = "https://www.facebook.com/Pitiwazou-C%C3%A9dric-Lepiller-120591657966584/"
            box.operator("wm.url_open", text="Google+").url = "https://plus.google.com/u/0/116916824325428422972"
            box.operator("wm.url_open", text="Blenderlounge's Discord").url = "https://discord.gg/MBDphac"
        

# -----------------------------------------------------------------------------
#    Keymap
# -----------------------------------------------------------------------------
addon_keymaps = []

def draw_keymap_items(self, wm, layout):
    kc = wm.keyconfigs.user

    if self.choose_menu_type == "pie":
        menu_type = "Speedflow Pie Menu"
    else:
        menu_type = "Speedflow Normal Menu"

    # for name, items in keymaps_items_dict.items():
    kmi_name, kmi_value, km_name = keymaps_items_dict[menu_type][:3]
    box = layout.box()
    split = box.split()
    col = split.column()
    col.label(text=menu_type)
    # col.label(text=name)
    col.separator()
    km = kc.keymaps[km_name]
    get_hotkey_entry_item(kc, km, kmi_name, kmi_value, col)


def get_hotkey_entry_item(kc, km, kmi_name, kmi_value, col):

    # for menus and pie_menu
    if kmi_value:
        for km_item in km.keymap_items:
            if km_item.idname == kmi_name and km_item.properties.name == kmi_value:
                col.context_pointer_set('keymap', km)
                rna_keymap_ui.draw_kmi([], kc, km, km_item, col, 0)
                return

        col.label(text=f"No hotkey entry found for {kmi_value}")
        col.operator(SPEEDFLOW_OT_add_hotkey.bl_idname, icon='ADD')

    # for operators
    else:
        if km.keymap_items.get(kmi_name):
            col.context_pointer_set('keymap', km)
            rna_keymap_ui.draw_kmi(
                    [], kc, km, km.keymap_items[kmi_name], col, 0)
        else:
            col.label(text=f"No hotkey entry found for {kmi_name}")
            col.operator(SPEEDFLOW_OT_add_hotkey.bl_idname, icon='ADD')


class SPEEDFLOW_OT_add_hotkey(bpy.types.Operator):
    ''' Add hotkey entry '''
    bl_idname = "template.add_hotkey"
    bl_label = "Add Hotkeys"
    bl_options = {'REGISTER', 'INTERNAL'}

    def execute(self, context):
        SPEEDFLOW_OT_add_hotkey()

        self.report({'INFO'},
                    "Hotkey added in User Preferences -> Input -> Screen -> Screen (Global)")
        return {'FINISHED'}

def add_hotkey(menu_type):
    wm = bpy.context.window_manager
    kc = wm.keyconfigs.addon

    if not kc:
        return

    kmi_name, kmi_value, km_name, space_type, region_type = keymaps_items_dict[menu_type][:5]
    eventType, eventValue, ctrl, shift, alt = keymaps_items_dict[menu_type][5:]
    km = kc.keymaps.new(name=km_name, space_type=space_type,
                        region_type=region_type)

    kmi = km.keymap_items.new(kmi_name, eventType,
                              eventValue, ctrl=ctrl, shift=shift,
                              alt=alt

                              )
    if kmi_value:
        kmi.properties.name = kmi_value

    kmi.active = True
    # for items in keymaps_items_dict.values():
    #     kmi_name, kmi_value, km_name, space_type, region_type = items[:5]
    #     eventType, eventValue, ctrl, shift, alt = items[5:]
    #     km = kc.keymaps.new(name = km_name, space_type = space_type,
    #                         region_type=region_type)
    #
    #     kmi = km.keymap_items.new(kmi_name, eventType,
    #                               eventValue, ctrl = ctrl, shift = shift,
    #                               alt = alt
    #
    #                               )
    #     if kmi_value:
    #         kmi.properties.name = kmi_value
    #
    #     kmi.active = True

    addon_keymaps.append((km, kmi))


def remove_hotkey():
    ''' clears all addon level keymap hotkeys stored in addon_keymaps '''

    kmi_values = [item[1] for item in keymaps_items_dict.values() if item]
    kmi_names = [item[0] for item in keymaps_items_dict.values() if item not in ['wm.call_menu', 'wm.call_menu_pie']]

    for km, kmi in addon_keymaps:
        # remove addon keymap for menu and pie menu
        if hasattr(kmi.properties, 'name'):
            if kmi_values:
                if kmi.properties.name in kmi_values:
                    km.keymap_items.remove(kmi)

        # remove addon_keymap for operators
        else:
            if kmi_names:
                if kmi.name in kmi_names:
                    km.keymap_items.remove(kmi)

    addon_keymaps.clear()


# # -----------------------------------------------------------------------------
# #    Keymap
# # -----------------------------------------------------------------------------
# addon_keymaps = []
#
# def get_hotkey_entry_item(km, kmi_name, kmi_value):
#     '''
#     returns hotkey of specific type, with specific properties.name (keymap is not a dict, so referencing by keys is not enough
#     if there are multiple hotkeys!)
#     '''
#     for i, km_item in enumerate(km.keymap_items):
#         if km.keymap_items.keys()[i] == kmi_name:
#             if km.keymap_items[i].properties.name == kmi_value:
#                 return km_item
#     return None
#
#
# def add_hotkey():
#     prefs = bpy.context.preferences.addons[__name__].preferences
#
#     wm = bpy.context.window_manager
#     kc = wm.keyconfigs.addon
#     if not kc:
#         return
#
#     km = kc.keymaps.new(name="3D View Generic", space_type='VIEW_3D', region_type = 'WINDOW')
#
#     if prefs.choose_menu_type == 'pie':
#         kmi = km.keymap_items.new("wm.call_menu_pie", 'SPACE', 'PRESS', shift= False, ctrl= False)
#         kmi.properties.name = "SPEEDFLOW_MT_pie_menu"
#         kmi.active = True
#         addon_keymaps.append((km, kmi))
#
#     elif prefs.choose_menu_type == 'menu':
#         kmi = km.keymap_items.new("wm.call_menu", 'SPACE', 'PRESS', shift= False, ctrl= False)
#         kmi.properties.name = "SPEEDFLOW_MT_simple_menu"
#         kmi.active = True
#         addon_keymaps.append((km, kmi))
#
#
#     # Cutter
#     kmi = km.keymap_items.new("speedflow.cutter", 'ONE', 'PRESS', shift=True, ctrl=False)
#     # kmi.properties.name = "SPEEDFLOW_OT_cutter"
#     kmi.active = True
#     addon_keymaps.append((km, kmi))
#
#     # mode = None
#     # action = None
#     # if bpy.context.window_manager.keyconfigs.active.preferences.spacebar_action == 'PLAY':
#     #     mode = 'Frames'
#     #     action = 'screen.animation_play'
#     # elif bpy.context.window_manager.keyconfigs.active.preferences.spacebar_action == 'TOOL':
#     #     mode = 'Window'
#     #     action = 'wm.toolbar'
#     # elif bpy.context.window_manager.keyconfigs.active.preferences.spacebar_action == 'Search':
#     #     mode = 'Window'
#     #     action = 'wm.search_menu'
#     #
#     #     # Disable
#     # bpy.context.window_manager.keyconfigs.active.keymaps[mode].keymap_items[action].active = False
#     #
#     # # Add New
#     # km = bpy.context.window_manager.keyconfigs.addon.keymaps.new("3D View", space_type="VIEW_3D")
#     # kmi = km.keymap_items.new(action, 'SPACE', 'PRESS', alt=True)
#     # # Disable Current keymap and replace it
#     # if bpy.context.window_manager.keyconfigs.active.preferences.spacebar_action == 'PLAY':
#     #     bpy.context.window_manager.keyconfigs.active.keymaps['Frames'].keymap_items[
#     #         'screen.animation_play'].active = False
#     #
#     #     # Add New
#     #     km = bpy.context.window_manager.keyconfigs.addon.keymaps.new("3D View", space_type="VIEW_3D")
#     #     kmi = km.keymap_items.new('screen.animation_play', 'SPACE', 'DOUBLE_CLICK')
#     #     kmi.active = True
#     #     addon_keymaps.append((km, kmi))
#     #
#     # elif bpy.context.window_manager.keyconfigs.active.preferences.spacebar_action == 'TOOL':
#     #     bpy.context.window_manager.keyconfigs.active.keymaps['Window'].keymap_items['wm.toolbar'].active = False
#     #
#     #     # Add New
#     #     km = bpy.context.window_manager.keyconfigs.addon.keymaps.new("3D View", space_type="VIEW_3D")
#     #     kmi = km.keymap_items.new('wm.toolbar', 'SPACE', 'DOUBLE_CLICK')
#     #     kmi.active = True
#     #     addon_keymaps.append((km, kmi))
#     #
#     # elif bpy.context.window_manager.keyconfigs.active.preferences.spacebar_action == 'Search':
#     #     bpy.context.window_manager.keyconfigs.active.keymaps['Window'].keymap_items['wm.search_menu'].active = False
#     #
#     #     # Add New
#     #     km = bpy.context.window_manager.keyconfigs.addon.keymaps.new("3D View", space_type="VIEW_3D")
#     #     kmi = km.keymap_items.new('wm.search_menu', 'SPACE', 'DOUBLE_CLICK')
#     #     kmi.active = True
#     #     addon_keymaps.append((km, kmi))
#
# class SPEEDFLOW_OT_add_hotkey(bpy.types.Operator):
#     ''' Add hotkey entry '''
#     bl_idname = "speedflow.add_hotkey"
#     bl_label = "Add Hotckey"
#     bl_options = {'REGISTER', 'INTERNAL'}
#
#     def execute(self, context):
#         add_hotkey()
#
#         self.report({'INFO'}, "Hotkey added in User Preferences -> Input -> Screen -> Screen (Global)")
#         return {'FINISHED'}
#
#
# def remove_hotkey():
#     ''' clears addon keymap hotkeys stored in addon_keymaps '''
#     wm = bpy.context.window_manager
#     kc = wm.keyconfigs.addon
#
#     if not kc:
#         return
#
#     km = kc.keymaps.new(name="3D View Generic", space_type='VIEW_3D', region_type='WINDOW')
#
#     for km, kmi in addon_keymaps:
#         if hasattr(kmi.properties, 'name'):
#             if kmi.properties.name in ['SPEEDFLOW_MT_pie_menu', 'SPEEDFLOW_MT_simple_menu']:
#                 km.keymap_items.remove(kmi)
#
#     addon_keymaps.clear()


##################################
# register
##################################


CLASSES = [PrefsDisplace,
           PrefsBoolean,
           PrefsArray,
           PrefsMirror,
           PrefsSolidify,
           PrefsBevel,
           PrefsSubsurf,
           PrefsScrew,
           PrefsDecimate,
           PrefsTriangulate,
           PrefsTubify,
           PrefsEdge_Split,
           PrefsShrinkwrap,
           PrefsSimple_Deform,
           PrefsWireframe,
           PrefsCurve,
           PrefsCorrective_Smooth,
           PrefsWeighted_normal,
           SPEEDFLOW_OT_add_hotkey,
           PrefsMod_visibility,
           PrefsSkin,
           PrefsCutter,
           SPEEDFLOW_MT_addon_prefs]

# Register
def register():

    utils.register()
    ui.register()
    array.register()
    bevel.register()
    boolean.register()
    displace.register()
    mirror.register()
    screw.register()
    solidify.register()
    subsurf.register()
    decimate.register()
    triangulate.register()
    tubify.register()
    edge_split.register()
    shrinkwrap.register()
    simple_deform.register()
    weighted_normal.register()
    wireframe.register()
    curve.register()
    corrective_smooth.register()
    mod_visibility.register()
    cutter.register()
    skin.register()

    for cls in CLASSES:
        try:
            bpy.utils.register_class(cls)
        except:
            print(f"{cls.__name__} already registred")

    context = bpy.context
    prefs = context.preferences.addons[__name__].preferences

    # Check the addon version on Github
    update_speedflow_ui(prefs, context)
    update_speedflow_help_panel(prefs, context)

    # Speedflow_update_panel_category(None, bpy.context)
    check_for_update(prefs, context)

    # hotkey setup
    # if prefs.choose_menu_type == "pie":
    #     menu_type = "Speedflow Pie Menu"
    # else:
    #     menu_type = "Speedflow Normal Menu"
    # add_hotkey(menu_type)

# Unregister
def unregister():
    utils.unregister()
    ui.unregister()
    array.unregister()
    bevel.unregister()
    boolean.unregister()
    displace.unregister()
    mirror.unregister()
    screw.unregister()
    solidify.unregister()
    subsurf.unregister()
    decimate.unregister()
    triangulate.unregister()
    tubify.unregister()
    edge_split.unregister()
    shrinkwrap.unregister()
    simple_deform.unregister()
    weighted_normal.unregister()
    wireframe.unregister()
    curve.unregister()
    corrective_smooth.unregister()
    mod_visibility.unregister()
    cutter.unregister()
    skin.unregister()



    for cls in CLASSES:
        bpy.utils.unregister_class(cls)

    # hotkey cleanup
    remove_hotkey()

