# -*- coding:utf-8 -*-

# Speedflow Add-on
# Copyright (C) 2018 Cedric Lepiller aka Pitiwazou & Legigan Jeremy AKA Pistiwique and Stephen Leger
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# <pep8 compliant>

import bpy
import bmesh
from bpy.types import Operator
from bpy.props import (StringProperty,
                       IntProperty,
                       FloatProperty,
                       BoolProperty,
                       FloatVectorProperty,
                       EnumProperty
                       )
from .utils.text_to_draw import *
from .utils.functions import *


# class SPEEDFLOW_OT_tubify(SpeedApi, Operator):
#     """
#     TUBIFY
#
#     CLICK - Add and adjust
#     SHIFT - Convert
#     CTRL  - Remove
#     """
#     bl_idname = "speedflow.tubify"
#     bl_label = "Tubify"
#     bl_options = {'REGISTER', 'UNDO', 'GRAB_CURSOR', 'BLOCKING'}
#
#     choose_profile : BoolProperty(default=False)
#     bevel_depth : FloatProperty()
#     reso_u : IntProperty()
#     reso_v : IntProperty()
#     profile : BoolProperty(default=False)
#     profile_reso : IntProperty()
#     extrude : FloatProperty()
#     offset : FloatProperty()
#     profile_scale : FloatVectorProperty(default=(1, 1, 1))
#
#     #
#     choose_taper : BoolProperty(default=False)
#     taper : BoolProperty(default=False)
#
#     modal_action : EnumProperty(
#         items=(('depth', "depth", ""),
#                ('reso_u', "reso_u", ""),
#                ('reso_v', "reso_v", ""),
#                ('extrude', "extrude", ""),
#                ('offset', "offset", ""),
#                ('free', "free", "")),
#         default='depth'
#     )
#     poly_bezier : EnumProperty(
#         items=(('poly', "poly", ""),
#                ('bezier', "bezier", "")),
#         default='bezier'
#     )
#
#     tubify_value : FloatProperty()
#
#     def __init__(self):
#         SpeedApi.__init__(self)
#
#     # ----------------------------------------------------------------------------------------------
#     #
#     # ----------------------------------------------------------------------------------------------
#
#     def convert_as_curve(self, obj):
#         bpy.context.view_layer.objects.active = obj
#         bpy.ops.object.convert(target='CURVE')
#         bpy.ops.object.mode_set(mode='EDIT')
#         bpy.ops.curve.select_all(action='SELECT')
#         bpy.ops.curve.spline_type_set(type='BEZIER')
#         bpy.ops.curve.handle_type_set(type='AUTOMATIC')
#         bpy.ops.object.mode_set(mode='OBJECT')
#
#     # ----------------------------------------------------------------------------------------------
#     #
#     # ----------------------------------------------------------------------------------------------
#
#     def check_mesh_validity(self):
#         objs = []
#         for obj in bpy.context.selected_objects:
#             if obj.type == 'CURVE':
#                 objs.append(obj)
#             elif obj.type == 'MESH':
#                 faces = [face for face in obj.data.polygons]
#
#                 if not faces:
#                     objs.append(obj)
#
#         return objs
#
#     # ----------------------------------------------------------------------------------------------
#     #
#     # ----------------------------------------------------------------------------------------------
#
#     def apply_input(self):
#         if self.modal_action == 'depth':
#             if self.profile:
#                 for i in range(3):
#                     self.act_obj.data.bevel_object.scale[i] = self.profile_scale[i] * (
#                                 float(self.input) / self.profile_scale[i])
#                     self.profile_scale[i] = self.profile_scale[i] * (float(self.input) / self.profile_scale[i])
#             else:
#                 for obj in bpy.context.selected_objects:
#                     obj.data.bevel_depth = float(self.input)
#
#                 self.bevel_depth = float(self.input)
#
#         elif self.modal_action == 'reso_u':
#             if int(self.input) < 1:
#                 self.input = "1"
#
#             if self.profile:
#                 self.act_obj.data.resolution_u = int(self.input)
#
#             else:
#                 for obj in bpy.context.selected_objects:
#                     obj.data.resolution_u = int(self.input)
#
#             self.reso_u = int(self.input)
#
#         elif self.modal_action == 'reso_v':
#             if int(self.input) < 1:
#                 self.input = "1"
#
#             if self.profile:
#                 self.act_obj.data.bevel_object.data.resolution_u = int(self.input)
#                 self.profile_reso = int(self.input)
#
#             else:
#                 for obj in bpy.context.selected_objects:
#                     obj.data.bevel_resolution = int(self.input)
#                 self.reso_v = int(self.input)
#
#         elif self.modal_action == 'extrude':
#             for obj in bpy.context.selected_objects:
#                 obj.data.extrude = int(self.input)
#             self.extrude = int(self.input)
#
#         elif self.modal_action == 'offset':
#             for obj in bpy.context.selected_objects:
#                 obj.data.offset = int(self.input)
#             self.offset = int(self.input)
#
#     # ----------------------------------------------------------------------------------------------
#     #
#     # ----------------------------------------------------------------------------------------------
#
#     def update_properties(self):
#         if self.modal_action == 'depth':
#             if self.profile:
#                 for i in range(3):
#                     self.profile_scale[i] = self.act_obj.data.bevel_object.scale[i]
#             else:
#                 self.bevel_depth = self.act_obj.data.bevel_depth
#
#         elif self.modal_action == 'reso_u':
#             self.reso_u = self.act_obj.data.resolution_u
#
#         elif self.modal_action == 'reso_v':
#             if self.profile:
#                 self.profile_reso = self.act_obj.data.bevel_object.data.resolution_u
#             else:
#                 self.reso_v = self.act_obj.data.bevel_resolution
#
#         elif self.modal_action == 'extrude':
#             self.extrude = self.act_obj.data.extrude
#
#         elif self.modal_action == 'offset':
#             self.offset = self.act_obj.data.offset
#
#     # ----------------------------------------------------------------------------------------------
#     #
#     # ----------------------------------------------------------------------------------------------
#
#     def update_values(self):
#         if self.modal_action == 'depth':
#             if self.profile:
#                 for i in range(3):
#                     self.act_obj.data.bevel_object.scale[i] = self.profile_scale[i]
#             else:
#                 for obj in bpy.context.selected_objects:
#                     obj.data.bevel_depth = self.bevel_depth
#
#         elif self.modal_action == 'reso_u':
#             for obj in bpy.context.selected_objects:
#                 obj.data.resolution_u = self.reso_u
#
#         elif self.modal_action == 'reso_v':
#             if self.profile:
#                 self.act_obj.data.bevel_object.data.resolution_u = self.profile_reso
#             else:
#                 for obj in bpy.context.selected_objects:
#                     obj.data.bevel_resolution = self.reso_v
#
#         elif self.modal_action == 'extrude':
#             for obj in bpy.context.selected_objects:
#                 obj.data.extrude = self.extrude
#
#         elif self.modal_action == 'offset':
#             for obj in bpy.context.selected_objects:
#                 obj.data.offset = self.offset
#
#
#     # ----------------------------------------------------------------------------------------------
#     #
#     # ----------------------------------------------------------------------------------------------
#
#     def modal(self, context, event):
#         context.area.tag_redraw()
#         MPM = context.window_manager.MPM
#
#         if event.unicode in self.input_list and self.modal_action != 'free':
#             get_input_value(self, event.unicode)
#
#         # ---------------------------------
#         # Mode Input
#         # ---------------------------------
#         if self.input:
#             if event.type in {'RET', 'NUMPAD_ENTER', self.key_confirm, 'SPACE'} and event.value == 'PRESS':
#                 self.apply_input()
#
#                 self.input = ""
#                 self.modal_action = 'free'
#                 self.mouse_x = event.mouse_x
#
#
#         elif event.type in {'RET', 'NUMPAD_ENTER', self.key_confirm, 'SPACE'} and event.value == 'PRESS':
#             if self.choose_profile:
#                 return {'PASS_THROUGH'}
#
#             if self.choose_taper:
#                 return {'PASS_THROUGH'}
#
#             else:
#                 if self.modal_action in {'depth', 'reso_u', 'reso_v', 'extrude', 'offset'}:
#                     self.update_properties()
#                     self.modal_action = 'free'
#                     self.mouse_x = event.mouse_x
#                 else:
#                     if not self.wire:
#                         bpy.context.active_object.show_wire = False
#                         bpy.context.active_object.show_all_edges = False
#
#                     self.profile = False
#                     bpy.types.SpaceView3D.draw_handler_remove(self._draw_handler, 'WINDOW')
#                     return {'CANCELLED'}
#
#         if event.type in {'MIDDLEMOUSE'}:
#             return {'PASS_THROUGH'}
#
#         # ---------------------------------
#         # Mode Depth
#         # ---------------------------------
#         if event.type == 'S' and event.value == 'PRESS':
#             if self.input:
#                 self.apply_input()
#                 self.input = ""
#             else:
#                 self.update_properties()
#             self.modal_action = 'depth'
#             self.mouse_x = event.mouse_x
#
#         # ---------------------------------
#         # Mode Reso_U
#         # ---------------------------------
#         if event.type == 'D' and event.value == 'PRESS':
#             if self.input:
#                 self.apply_input()
#                 self.input = ""
#             else:
#                 self.update_properties()
#             self.modal_action = 'reso_u'
#             self.mouse_x = event.mouse_x
#
#         # ---------------------------------
#         # Mode Reso_V
#         # ---------------------------------
#         if event.type == 'F' and event.value == 'PRESS':
#             if self.input:
#                 self.apply_input()
#                 self.input = ""
#             else:
#                 self.update_properties()
#             self.modal_action = 'reso_v'
#             self.mouse_x = event.mouse_x
#
#         # ---------------------------------
#         # Mode Extrude
#         # ---------------------------------
#         if event.type == 'H' and event.value == 'PRESS':
#             if self.input:
#                 self.apply_input()
#                 self.input = ""
#             else:
#                 self.update_properties()
#             self.modal_action = 'extrude'
#             self.mouse_x = event.mouse_x
#
#         # ---------------------------------
#         # Mode Offset
#         # ---------------------------------
#         if event.type == 'J' and event.value == 'PRESS':
#             if self.input:
#                 self.apply_input()
#                 self.input = ""
#             else:
#                 self.update_properties()
#             self.modal_action = 'offset'
#             self.mouse_x = event.mouse_x
#
#         # ---------------------------------
#         # Setup Values
#         # ---------------------------------
#         if self.work_tool == 'pen':
#             if event.type in {'WHEELUPMOUSE', 'WHEELDOWNMOUSE'}:
#                 return {'PASS_THROUGH'}
#
#             if event.type == 'LEFT_SHIFT' or event.type == 'RIGHT_SHIFT':
#                 if event.value == 'PRESS':
#                     if not self.slow_down:
#                         self.mouse_x = event.mouse_x
#                         self.update_properties()
#                         self.slow_down = True
#
#                 elif event.value == 'RELEASE':
#                     self.mouse_x = event.mouse_x
#                     self.update_properties()
#                     self.slow_down = False
#
#             if event.type == 'MOUSEMOVE' and not self.input:
#                 if self.choose_profile:
#                     obj = context.active_object
#                     if obj.type != 'CURVE':
#                         return {'PASS_THROUGH'}
#                     else:
#                         if obj != self.act_obj:
#                             # bpy.context.scene.objects.active = self.act_obj
#                             bpy.context.view_layer.objects.active = self.act_obj
#                             self.act_obj.select_set(state=True)
#                             # self.act_obj.select = True
#                             self.profile_scale = obj.scale
#                             self.mouse_x = event.mouse_x
#                             self.act_obj.data.bevel_object = obj
#                             self.choose_profile = False
#                             self.modal_action = 'free'
#                             self.profile = True
#                 #
#                 elif self.choose_taper:
#                     obj = context.active_object
#                     if obj.type != 'CURVE':
#                         return {'PASS_THROUGH'}
#                     else:
#                         if obj != self.act_obj:
#                             bpy.context.view_layer.objects.active = self.act_obj
#                             self.act_obj.select_set(state=True)
#                             # bpy.context.scene.objects.active = self.act_obj
#                             # self.act_obj.select = True
#                             #                            self.profile_scale = obj.scale
#                             #                            self.mouse_x = event.mouse_x
#                             self.act_obj.data.taper_object = obj
#                             self.choose_taper = False
#                             self.modal_action = 'free'
#                             self.taper = True
#
#                 else:
#                     delta = (
#                                         self.mouse_x - event.mouse_x) / 8 if event.shift else self.mouse_x - event.mouse_x
#
#                     if self.modal_action == 'depth':
#                         if self.profile:
#                             for i in range(3):
#                                 self.act_obj.data.bevel_object.scale[i] = self.profile_scale[i] + min(10, -(
#                                             delta / 500) * self.modal_speed)
#                         else:
#                             for obj in context.selected_objects:
#                                 obj.data.bevel_depth = self.bevel_depth + min(10, -(delta / 500) * self.modal_speed)
#
#                     elif self.modal_action == 'reso_u':
#                         if self.profile:
#                             self.act_obj.data.resolution_u = self.reso_u + min(50, -(delta / 60) * self.modal_speed)
#                         else:
#                             for obj in context.selected_objects:
#                                 obj.data.resolution_u = self.reso_u + min(50, -(delta / 60) * self.modal_speed)
#
#                     elif self.modal_action == 'reso_v':
#                         if self.profile:
#                             self.act_obj.data.bevel_object.data.resolution_u = self.profile_reso + min(50, -(
#                                         delta / 60) * self.modal_speed)
#                         else:
#                             for obj in context.selected_objects:
#                                 obj.data.bevel_resolution = self.reso_v + min(50, -(delta / 60) * self.modal_speed)
#
#                     elif self.modal_action == 'extrude':
#                         for obj in context.selected_objects:
#                             obj.data.extrude = self.extrude + min(50, -(delta / 100) * self.modal_speed)
#
#                     elif self.modal_action == 'offset':
#                         for obj in context.selected_objects:
#                             obj.data.offset = self.offset + min(50, -(delta / 100) * self.modal_speed)
#
#         elif self.work_tool == 'mouse':
#             if self.modal_action == 'free' and event.type in {'WHEELUPMOUSE', 'WHEELDOWNMOUSE'}:
#                 return {'PASS_THROUGH'}
#
#             elif event.type == 'MOUSEMOVE' and self.choose_profile:
#                 obj = context.active_object
#                 if obj.type != 'CURVE':
#                     return {'PASS_THROUGH'}
#                 else:
#                     if obj != self.act_obj:
#                         bpy.context.view_layer.objects.active = self.act_obj
#                         self.act_obj.select_set(state=True)
#                         self.profile_scale = obj.scale
#                         self.mouse_x = event.mouse_x
#                         self.act_obj.data.bevel_object = obj
#                         self.choose_profile = False
#                         self.modal_action = 'free'
#                         self.profile = True
#
#             #
#             elif event.type == 'MOUSEMOVE' and self.choose_taper:
#                 obj = context.active_object
#                 if obj.type != 'CURVE':
#                     return {'PASS_THROUGH'}
#                 else:
#                     if obj != self.act_obj:
#                         bpy.context.view_layer.objects.active = self.act_obj
#                         self.act_obj.select_set(state=True)
#                         self.act_obj.data.taper_object = obj
#                         self.choose_taper = False
#                         self.modal_action = 'free'
#                         self.taper = True
#
#             else:
#                 value = 0
#                 if event.type == 'WHEELUPMOUSE':
#                     if self.modal_action == 'depth':
#                         value = 0.01 if event.shift else 0.1
#                     else:
#                         value = 1
#                 elif event.type == 'WHEELDOWNMOUSE':
#                     if self.modal_action == 'depth':
#                         value = -0.01 if event.shift else -0.1
#                     else:
#                         value = -1
#
#                 if self.modal_action == 'depth':
#                     if self.profile:
#                         for i in range(3):
#                             self.act_obj.data.bevel_object.scale[i] += value
#                     else:
#                         for obj in context.selected_objects:
#                             obj.data.bevel_depth += value
#
#                 elif self.modal_action == 'reso_u':
#                     if self.profile:
#                         self.act_obj.data.resolution_u += value
#                     else:
#                         for obj in context.selected_objects:
#                             obj.data.resolution_u += value
#
#                 elif self.modal_action == 'reso_v':
#                     if self.profile:
#                         self.act_obj.data.bevel_object.data.resolution_u += value
#                     else:
#                         for obj in context.selected_objects:
#                             obj.data.bevel_resolution += value
#
#                 elif self.modal_action == 'extrude':
#                     if self.profile:
#                         self.act_obj.data.extrude += value
#                     else:
#                         for obj in context.selected_objects:
#                             obj.data.extrude += value
#
#                 elif self.modal_action == 'offset':
#                     if self.profile:
#                         self.act_obj.data.offset += value
#                     else:
#                         for obj in context.selected_objects:
#                             obj.data.offset += value
#         # ---------------------------------
#         # Use Cyclic
#         # ---------------------------------
#         if event.type == 'Q' and event.value == 'PRESS':
#             if self.profile:
#                 self.act_obj.data.splines[0].use_cyclic_u = False if self.act_obj.data.splines[0].use_cyclic_u else True
#             else:
#                 for obj in context.selected_objects:
#                     obj.data.splines[0].use_cyclic_u = False if obj.data.splines[0].use_cyclic_u else True
#
#         # ---------------------------------
#         # 2D-3D
#         # ---------------------------------
#         if event.type == 'K' and event.value == 'PRESS':
#             # for obj in context.selected_objects:
#             bpy.ops.object.origin_set(type='ORIGIN_GEOMETRY')
#
#             if context.object.data.dimensions == '3D':
#                 context.object.data.dimensions = '2D'
#             elif context.object.data.dimensions == '2D':
#                 context.object.data.dimensions = '3D'
#
#         # ---------------------------------
#         # Mode Select Bevel Object
#         # ---------------------------------
#         if event.type == 'Z' and event.value == 'PRESS':
#             self.choose_profile = not self.choose_profile
#
#         # ---------------------------------
#         # Remove The Bevel Object
#         # ---------------------------------
#         if event.type == 'X' and event.value == 'PRESS':
#             if self.profile:
#                 context.object.data.dimensions = '3D'
#                 # if self.modal_action == 'free':
#                 bevelobject = self.act_obj.data.bevel_object
#                 self.act_obj.data.bevel_object = None
#                 bevelobject.select_set(state=False)
#
#         # ---------------------------------
#         # Mode Select Taper
#         # ---------------------------------
#         if event.type == 'T' and event.value == 'PRESS':
#             self.choose_taper = not self.choose_taper
#
#         # ---------------------------------
#         # Remove The Taper Object
#         # ---------------------------------
#         if event.type == 'C' and event.value == 'PRESS':
#             if self.modal_action == 'free':
#                 taperobject = self.act_obj.data.taper_object
#                 if taperobject:
#                     self.act_obj.data.taper_object = None
#                     taperobject.select_set(state=False)
#                     context.object.data.dimensions = '3D'
#
#         # ---------------------------------
#         # Convert Curve To Mesh
#         # ---------------------------------
#         if event.type == 'A':
#             self.extrude = False
#
#             if self.profile:
#                 bpy.ops.object.mode_set(mode='OBJECT')
#                 bpy.ops.object.convert(target='MESH')
#             else:
#                 for obj in context.selected_objects:
#                     bpy.context.view_layer.objects.active = obj
#
#                     if obj.data.extrude > 0:
#                         self.extrude = True
#
#                     bpy.ops.object.mode_set(mode='OBJECT')
#                     bpy.ops.object.convert(target='MESH')
#
#                     # remove double
#                     if self.extrude:
#                         bpy.ops.object.mode_set(mode='EDIT')
#                         bpy.ops.mesh.select_all(action='SELECT')
#                         bpy.ops.mesh.remove_doubles()
#                         bpy.ops.object.mode_set(mode='OBJECT')
#
#                 bpy.context.view_layer.objects.active = self.act_obj
#
#             if not self.wire:
#                 context.active_object.show_wire = False
#                 context.active_object.show_all_edges = False
#
#             bpy.types.SpaceView3D.draw_handler_remove(self._draw_handler, 'WINDOW')
#             return {'FINISHED'}
#
#         # ---------------------------------
#         # Add Edge Split Modifier
#         # ---------------------------------
#         if event.type == 'E' and event.value == 'PRESS':
#             if self.profile:
#                 edge_split = False
#                 for mod in self.act_obj.modifiers:
#                     if mod.type == 'EDGE_SPLIT':
#                         edge_split = True
#                 if edge_split:
#                     bpy.ops.object.modifier_remove(modifier="EdgeSplit")
#
#                 else:
#                     self.act_obj.modifiers.new("EdgeSplit", "EDGE_SPLIT")
#                     self.act_obj.modifiers["EdgeSplit"].split_angle = 1.0472
#             else:
#                 for obj in context.selected_objects:
#                     edge_split = False
#                     for mod in obj.modifiers:
#                         if mod.type == 'EDGE_SPLIT':
#                             edge_split = True
#                     if edge_split:
#                         bpy.context.view_layer.objects.active = obj
#                         bpy.ops.object.modifier_remove(modifier="EdgeSplit")
#
#                     else:
#                         obj.modifiers.new("EdgeSplit", "EDGE_SPLIT")
#                         obj.modifiers["EdgeSplit"].split_angle = 1.0472
#                 bpy.context.view_layer.objects.active = self.act_obj
#
#         # ---------------------------------
#         # Toggle Show Wire
#         # ---------------------------------
#         if event.type == 'G' and event.value == 'PRESS':
#             if self.wire:
#                 get_addon_preferences().keep_wire = False
#                 self.wire = False
#             else:
#                 get_addon_preferences().keep_wire = True
#                 self.wire = True
#
#         # ---------------------------------
#         # Toggle Spline Type Poly/Bezier
#         # ---------------------------------
#         if event.type == 'R' and event.value == 'PRESS':
#             if self.profile:
#                 bpy.ops.object.mode_set(mode='EDIT')
#                 bpy.ops.curve.select_all(action='SELECT')
#                 if self.poly_bezier == 'poly':
#                     bpy.ops.curve.spline_type_set(type='BEZIER')
#                     bpy.ops.curve.handle_type_set(type='AUTOMATIC')
#                 else:
#                     bpy.ops.curve.spline_type_set(type='POLY')
#                 bpy.ops.object.mode_set(mode='OBJECT')
#
#             else:
#                 for obj in context.selected_objects:
#                     bpy.context.view_layer.objects.active = obj
#                     bpy.ops.object.mode_set(mode='EDIT')
#                     bpy.ops.curve.select_all(action='SELECT')
#                     if self.poly_bezier == 'poly':
#                         bpy.ops.curve.spline_type_set(type='BEZIER')
#                         bpy.ops.curve.handle_type_set(type='AUTOMATIC')
#                     else:
#                         bpy.ops.curve.spline_type_set(type='POLY')
#                     bpy.ops.object.mode_set(mode='OBJECT')
#
#                 bpy.context.view_layer.objects.active = self.act_obj
#
#             self.poly_bezier = 'poly' if self.poly_bezier == 'bezier' else 'bezier'
#
#         # ---------------------------------
#         # Restart Speedflow
#         # ---------------------------------
#         if event.type == 'TAB' and event.value == 'PRESS':
#             bpy.ops.object.mode_set(mode='OBJECT')
#             bpy.types.SpaceView3D.draw_handler_remove(self._draw_handler, 'WINDOW')
#             bpy.ops.wm.call_menu_pie('INVOKE_DEFAULT', name="view3d.speedflow_ui_menu")
#             return {'FINISHED'}
#
#
#         if event.type in {self.key_cancel, 'ESC'} and event.value == 'PRESS':
#             if self.input:
#                 self.input = ""
#                 self.modal_action = 'free'
#
#             elif self.modal_action in {'depth', 'reso_u', 'reso_v', 'extrude', 'offset'}:
#                 self.update_values()
#                 self.modal_action = 'free'
#
            # elif self.profile and self.choose_profile:
            #     # si l'objet actif n'est plus le meme quand in clique sur rmb ou esc, on remet les objets precedents
            #     if context.active_object != self.act_obj:
            #         context.active_object.select_set(state=False)
            #         self.act_obj.select_set(state=True)
            #         bpy.context.view_layer.objects.active = self.act_obj
            #         self.act_obj.data.bevel_object.select_set(state=True)
            #     self.choose_profile = False
#
#             #
#             elif self.profile and self.choose_taper:
#                 # si l'objet actif n'est plus le meme quand in clique sur rmb ou esc, on remet les objets precedents
#                 if context.active_object != self.act_obj:
#                     context.active_object.select_set(state=False)
#                     self.act_obj.select_set(state=True)
#                     bpy.context.view_layer.objects.active = self.act_obj
#                     self.act_obj.data.bevel_object.select_set(state=True)
#                 self.choose_taper = False
#
#             else:
#                 if not self.wire:
#                     context.active_object.show_wire = False
#                     context.active_object.show_all_edges = False
#
#                 self.profile = False
#                 bpy.types.SpaceView3D.draw_handler_remove(self._draw_handler, 'WINDOW')
#                 return {'CANCELLED'}
#
#         if event.type in {'DEL', 'BACK_SPACE'} and event.value == 'PRESS':
#             if event.type == 'BACK_SPACE' and self.input:
#                 self.input = self.input[:-1]
#             else:
#                 if self.profile:
#                     self.act_obj.data.fill_mode = 'HALF'
#                     self.act_obj.data.bevel_depth = 0
#                     self.act_obj.data.bevel_resolution = 0
#                     self.act_obj.data.bevel_object = None
#                     self.act_obj.data.extrude = 0
#
#                 else:
#                     for obj in context.selected_objects:
#                         obj.data.fill_mode = 'HALF'
#                         obj.data.bevel_depth = 0
#                         obj.data.bevel_resolution = 0
#                         obj.data.extrude = 0
#
#                 if not self.wire:
#                     context.active_object.show_wire = False
#                     context.active_object.show_all_edges = False
#
#                 self.profile = False
#                 bpy.types.SpaceView3D.draw_handler_remove(self._draw_handler, 'WINDOW')
#                 return {'FINISHED'}
#
#         return {'RUNNING_MODAL'}
#
#     # ----------------------------------------------------------------------------------------------
#     #
#     # ----------------------------------------------------------------------------------------------
#
#     def invoke(self, context, event):
#         if context.area.type == 'VIEW_3D':
#             # MPM = context.window_manager.MPM
#             self.act_obj = context.object
#
#             depth_value = get_addon_preferences().depth_value
#             reso_u = get_addon_preferences().reso_u
#             reso_v = get_addon_preferences().reso_v
#             extrude = get_addon_preferences().extrude
#
#
#             if context.preferences.inputs.select_mouse == "LEFT":
#                 self.key_confirm = "LEFTMOUSE"
#
#             edit_mode = False
#             if event.shift or event.ctrl or event.alt:
#                 for obj in context.selected_objects:
#                     bpy.context.view_layer.objects.active = obj
#                     if obj.type == 'CURVE':
#
#                         # If Edit
#                         if context.object.mode == "EDIT":
#                             edit_mode = True
#                             bpy.ops.object.mode_set(mode='OBJECT')
#
#                         # SHIFT
#                         if event.shift:
#                             if obj.data.users > 1:
#                                 bpy.ops.object.make_single_user(type='SELECTED_OBJECTS', object=True, obdata=True,
#                                                                 material=False, texture=False, animation=False)
#
#                             self.extrude = False
#                             if obj.data.extrude > 0:
#                                 self.extrude = True
#
#                             bpy.ops.object.convert(target='MESH')
#
#                             # remove double
#                             if self.extrude:
#                                 bpy.ops.object.mode_set(mode='EDIT')
#                                 bpy.ops.mesh.select_all(action='SELECT')
#                                 bpy.ops.mesh.remove_doubles()
#                                 bpy.ops.object.mode_set(mode='OBJECT')
#
#                         # CTRL
#                         if event.ctrl:
#                             context.object.data.bevel_depth = 0
#                             #                            if bpy.context.object.data.bevel_object == True :
#                             context.object.data.bevel_object = None
#                             context.object.data.taper_object = None
#
#                 # Comeback in Edit Mode
#                 if edit_mode == True:
#                     bpy.ops.object.mode_set(mode='EDIT')
#
#                 return {'FINISHED'}
#
#             else:
#                 if self.act_obj.type == 'MESH':
#                     if context.object.mode == 'EDIT':
#                         self.act_obj.update_from_editmode()
#                         edges = [e for e in self.act_obj.data.edges if e.select]
#                         if edges:
#                             bpy.ops.object.mode_set(mode='OBJECT')
#                             bpy.ops.object.select_all(action='DESELECT')
#
#                             self.act_obj.select_set(state=True)
#                             bpy.ops.object.duplicate_move()
#                             prefix = self.act_obj.name
#                             self.act_obj = context.active_object
#                             self.act_obj.update_from_editmode()
#                             self.act_obj.name = prefix + " - tubify"
#                             bpy.ops.object.mode_set(mode='EDIT')
#                             if len(self.act_obj.data.edges) != len(edges):
#                                 bpy.ops.mesh.select_all(action='INVERT')
#                                 bpy.ops.mesh.delete(type='EDGE')
#                                 bpy.ops.mesh.select_all(action='SELECT')
#                             bpy.ops.mesh.delete(type='ONLY_FACE')
#                             bpy.ops.object.mode_set(mode='OBJECT')
#
#                     self.convert_as_curve(self.act_obj)
#
#                 if len([obj for obj in context.selected_objects if obj.type == 'CURVE']) == 2:
#                     obj_profile = context.selected_objects[0] if context.selected_objects[1] == self.act_obj else \
#                     context.selected_objects[1]
#                     self.act_obj.data.show_normal_face = False
#
#                     # Show Wire
#                     self.act_obj.show_wire = True
#                     self.act_obj.show_all_edges = True
#
#                     if not self.act_obj.data.bevel_resolution:
#                         self.act_obj.data.bevel_depth = depth_value
#                         self.act_obj.data.resolution_u = reso_u
#                         self.act_obj.data.bevel_resolution = reso_v
#                         self.act_obj.data.extrude = extrude
#                     self.act_obj.data.splines[0].tilt_interpolation = 'BSPLINE'
#                     self.act_obj.data.splines[0].radius_interpolation = 'BSPLINE'
#
#                     self.act_obj.data.bevel_object = obj_profile
#
#                     self.act_obj = self.act_obj if self.act_obj.select else context.selected_objects[-1]
#
#                     bpy.context.view_layer.objects.active = self.act_obj
#
#                     args = (self, context, 'TUBIFY')
#
#                     self._draw_handler = bpy.types.SpaceView3D.draw_handler_add(draw_text_callback_mpm, args, 'WINDOW',
#                                                                                  'POST_PIXEL')
#
#                     self.mouse_x = event.mouse_x
#                     self.bevel_depth = self.act_obj.data.bevel_depth
#                     self.reso_u = self.act_obj.data.resolution_u
#                     self.reso = self.act_obj.data.bevel_resolution
#                     self.extrude = self.act_obj.data.extrude
#                     self.profile = True
#                     self.profile_reso = obj_profile.data.resolution_u
#                     self.offset = self.act_obj.data.offset
#                     self.profile_scale = obj_profile.scale
#                     context.window_manager.modal_handler_add(self)
#
#                     return {'RUNNING_MODAL'}
#
#                 elif self.check_mesh_validity():
#                     for obj in context.selected_objects:
#                         if obj not in self.check_mesh_validity():
#                             obj.select_set(state=False)
#                             pass
#                         else:
#                             if obj.type == 'MESH':
#                                 self.convert_as_curve(obj)
#
#                             if context.object.data.dimensions == '3D':  ###### NEW
#                                 obj.data.fill_mode = 'FULL'
#                                 obj.data.show_normal_face = False
#
#                             # Show Wire
#                             obj.show_wire = True
#                             obj.show_all_edges = True
#
#                         if not obj.data.bevel_resolution:
#                             obj.data.bevel_depth = depth_value
#                             obj.data.resolution_u = reso_u
#                             obj.data.bevel_resolution = reso_v
#                             obj.data.extrude = extrude
#                             # obj.data.offset = offset
#
#                         obj.data.splines[0].tilt_interpolation = 'BSPLINE'
#                         obj.data.splines[0].radius_interpolation = 'BSPLINE'
#
#                     if self.act_obj.data.bevel_object:
#                         self.profile = True
#                         self.profile_scale = self.act_obj.data.bevel_object.scale
#                         self.act_obj.data.bevel_object.select_set(state=True)
#
#                     self.act_obj = self.act_obj if self.act_obj.select else context.selected_objects[-1]
#
#                     bpy.context.view_layer.objects.active = self.act_obj
#
#                     args = (self, context, 'TUBIFY')
#
#                     self._draw_handler = bpy.types.SpaceView3D.draw_handler_add(draw_text_callback_mpm, args, 'WINDOW',
#                                                                                  'POST_PIXEL')
#
#                     self.mouse_x = event.mouse_x
#                     self.bevel_depth = self.act_obj.data.bevel_depth
#                     self.reso_u = self.act_obj.data.resolution_u
#                     self.reso = self.act_obj.data.bevel_resolution
#                     self.extrude = self.act_obj.data.extrude
#                     self.offset = self.act_obj.data.offset
#
#                     context.window_manager.modal_handler_add(self)
#
#                     return {'RUNNING_MODAL'}
#
#                 else:
#                     self.report({'WARNING'}, "Active object is not a Mesh or a Curve")
#                     return {'CANCELLED'}
#
#         else:
#             self.report({'WARNING'}, "View3D not found, cannot run operator")
#             return {'CANCELLED'}

from .utils.functions import SpeedApi, set_and_restore_active

last_selection = ""
last_profile = ""
store_meshes = []

class SPEEDFLOW_OT_tubify(SpeedApi, Operator):
    """
    TUBIFY

    CLICK - Add and adjust
    SHIFT - Add Curve
    SHIFT+PROFILE - Curve with Profile
    CTRL  - Curve objects
    ALT    - Add object in Ram
    CTRL+ALT = Remove Object from Ram

    """
    bl_idname = "speedflow.tubify"
    bl_label = "Modal Tubify"
    bl_options = {'REGISTER', 'UNDO', 'GRAB_CURSOR', 'BLOCKING'}

    modal_action : StringProperty(default='bevel_depth')

    @classmethod
    def poll(cls, context):
        # return SpeedApi.can_add_modifier(context.object, types={'MESH', 'CURVE'})

        return True

    def __init__(self):

        SpeedApi.__init__(self)

        # NOTE: les valeurs par défaut sont définies dans les addon prefs
        # idéalement dans un propertyGroup pour chaque modifier
        # et set à la volée à la création du modifier seulement



        # xxx_action dicts here make an abstraction level between key and action
        # this way we may change keys without changing code !!
        # keys may contains modifiers in definition like CTRL+ALT+SHIFT+key
        # action_name should be exact modifier parameters names
        # No space allowed between modifiers+key
        # {[CTRL+|ALT+|SHIFT+]key: action_name}

        # Mouse action list (float and int values), allow keyboard values input
        self.mouse_actions = {
            'S': 'bevel_depth',
            'D': 'resolution_u', # = render_resolution_u
            'F': 'bevel_resolution',
            'G': 'extrude',
            'J': 'offset',
            'C': 'bevel_factor_start',
            'V': 'bevel_factor_end',


        }

        # Generic modifier toggle action list (boolean vars)
        self.toggle_actions = self.setup_modal_keymap({


        })

        # "special actions" not changing modifier attributes in a regular way (mouse/toggle)
        self.special_actions = self.setup_modal_keymap({
            'K': 'fill_mode',
            'Q': 'use_cyclic_u',
            'T': 'poly_bezier',
            'F1': 'set_origin',
            'SHIFT+F1': 'set_origin_1',
            'Z': 'use_smooth',
            'W': 'use_fill_caps',
            'R': 'switch_direction',
            'L': 'square',
            'SHIFT+RIGHT_ARROW': 'show_modifier',
            'SHIFT+LEFT_ARROW': 'hide_modifier',
            'QUOTE': 'show_hide_all_modifiers',
            'NUMPAD_SLASH': 'localview',



        })

        # Pick/remove objects
        self.pick_actions = self.setup_modal_keymap({
            'O': 'bevel_object',
            'P': 'taper_object'
        })

        # default actions available for all modifiers based modals
        # default actions available for all modifiers based modals
        self.default_actions = self.setup_modal_keymap({
            # {[CTRL+|ALT+|SHIFT+]key: action_name}
            'A': 'apply_modifier',
            'SHIFT+SPACE': 'add_modifier',
            'DEL': 'remove_modifier',
            'BACK_SPACE': 'remove_modifier',

            'H': 'show_viewport',
            'CTRL+H': 'show_hide_keymap',
            'SHIFT+H': 'beginner_mode',

            # 'UP_ARROW': 'move_modifier_up',
            # 'DOWN_ARROW': 'move_modifier_down',

            # 'GRLESS': 'same_modifier_up',
            # 'RIGHT_ARROW': 'same_modifier_up',
            # 'SHIFT+GRLESS': 'same_modifier_down',
            # 'LEFT_ARROW': 'same_modifier_down',

            # 'CTRL+GRLESS': 'next_modifier_up',
            # 'CTRL+RIGHT_ARROW': 'next_modifier_up',
            # 'CTRL+SHIFT+GRLESS': 'next_modifier_down',
            # 'CTRL+LEFT_ARROW': 'next_modifier_down',

            'SPACE': 'call_pie',
            'ONE': 'keep_wire',
            'TWO': 'show_wire_in_modal',
            'THREE': 'set_xray',
            'FOUR': 'shading_mode',
            'FIVE': 'random',
            'SIX': 'overlays',
            'SEVEN': 'face_orientation',
            'EIGHT' : 'hide_grid',
            'NINE': 'bool_mode',
            'F2': 'active_snap',
            'F3': 'snap_vertex',
            'F4': 'snap_face',
            'F5': 'snap_grid',
            'F6': 'origin_to_selection',
            'F7': 'apply_location',

            'ESC': 'cancel',
            self.key_cancel: 'cancel',
            'SHIFT+%s' % self.key_cancel: 'cancel',
            'CTRL+SHIFT+%s' % self.key_cancel: 'cancel',
            'CTRL+%s' % self.key_cancel: 'cancel',

            'RET': 'confirm',
            'NUMPAD_ENTER': 'confirm',

            self.key_confirm: 'confirm',
            'SHIFT+%s' % self.key_confirm: 'confirm',
            'CTRL+SHIFT+%s' % self.key_confirm: 'confirm',
            'CTRL+%s' % self.key_confirm: 'confirm',

            # 'SPACE': 'confirm'
        })

    # ----------------------------------------------------------------------------------------------
    #
    # ----------------------------------------------------------------------------------------------
    def add_curve(self, context):

        sel = [o for o in context.selected_objects if o.type == 'CURVE']

        bpy.ops.curve.primitive_bezier_curve_add(radius=1, enter_editmode=False, location=(0, 0, 0))
        bpy.ops.object.mode_set(mode='EDIT')
        bpy.ops.curve.delete(type='VERT')
        bpy.ops.object.mode_set(mode='OBJECT')
        bpy.ops.object.transform_apply(location=True, rotation=True, scale=True)
        bpy.ops.object.mode_set(mode='EDIT')
        curve = bpy.context.active_object
        curve.data.bevel_resolution = 2
        bpy.context.space_data.overlay.show_curve_normals = True
        bpy.context.space_data.overlay.show_curve_normals = False
        bpy.ops.object.mode_set(mode='OBJECT')

        # bpy.ops.object.select_all(action='DESELECT')

        for obj in sel:
            new_curve = obj.modifiers.new("Curve", 'CURVE')
            new_curve.deform_axis = 'POS_X'
            new_curve.object = curve

        curve.select_set(state=True)
        bpy.context.view_layer.objects.active = curve
        bpy.ops.object.mode_set(mode='EDIT')

    def add_array_and_curve(self, context, curve):
        self.start = False
        self.end = False

        for o in self.sel:
            if o.name.startswith("start"):
                self.start = True
                o.select_set(state=True)
                bpy.context.view_layer.objects.active = o
                self.mesh_start = o
                self.mesh_start.select_set(state=False)

        for x in self.sel:
            if x.name.startswith("end"):
                self.end = True
                x.select_set(state=True)
                bpy.context.view_layer.objects.active = x
                self.mesh_end = x
                self.mesh_end.select_set(state=False)

        # if len([o for o in context.selected_objects]) == 1:
        #     print("OUIIII")

        # for obj in context.selected_objects:
        #
        #     if start:
        #         obj.select_set(state=True)
        #         bpy.context.view_layer.objects.active = obj
        #         self.start = obj
        #         self.start.select_set(state=False)
        #     if end:
        #         obj.select_set(state=True)
        #         bpy.context.view_layer.objects.active = obj
        #         self.end = obj
        #         self.end.select_set(state=False)
        #
        # for obj in context.selected_objects:
        #     obj.select_set(state=True)
        #     bpy.context.view_layer.objects.active = obj

        base = context.object
        base.select_set(state=True)
        bpy.context.view_layer.objects.active = base
        bpy.ops.object.duplicate_move()
        bpy.ops.view3d.snap_selected_to_cursor(use_offset=False)

        new_array = base.modifiers.new("Array", 'ARRAY')
        new_array.relative_offset_displace[0] = 0
        new_array.relative_offset_displace[2] = 1
        new_array.fit_type = 'FIT_CURVE'
        new_array.curve = curve
        new_array.use_merge_vertices = True

        # if self.start:
        #     new_array.start_cap = self.mesh_start
        # if self.end:
        #     new_array.end_cap = self.mesh_end

        new_curve = base.modifiers.new("Curve", 'CURVE')
        new_curve.deform_axis = 'POS_Z'
        new_curve.object = curve




    # ----------------------------------------------------------------------------------------------
    #
    # ----------------------------------------------------------------------------------------------

    def array_curve_from_stored_mesh(self, context, curve):

        bpy.ops.object.duplicate_move()
        act_obj = context.active_object
        bpy.ops.view3d.snap_selected_to_cursor(use_offset=False)

        new_array = act_obj.modifiers.new("Array", 'ARRAY')
        new_array.relative_offset_displace[0] = 0
        new_array.relative_offset_displace[2] = 1
        new_array.fit_type = 'FIT_CURVE'
        new_array.curve = curve
        new_array.use_merge_vertices = True

        new_curve = act_obj.modifiers.new("Curve", 'CURVE')
        new_curve.deform_axis = 'POS_Z'
        new_curve.object = curve



    # ----------------------------------------------------------------------------------------------
    #
    # ----------------------------------------------------------------------------------------------

    def array_curve_from_draw(self, context):
        bpy.context.scene.tool_settings.curve_paint_settings.depth_mode = 'CURSOR'

        sel = [o for o in context.selected_objects if o.type == 'MESH']

        start = False
        end = False
        act_obj = context.active_object
        # print(act_obj.name)

        if act_obj.type == 'MESH' or (act_obj.type == 'CURVE' and self.screw):
            global last_selection
            last_selection = act_obj.name

        # print(last_selection)
        # if len([o for o in context.selected_objects]) == 1:
        self.array = False
        self.curve = False
        for obj in sel:
            if obj.modifiers:
                for mod in obj.modifiers:
                    if mod.type == 'ARRAY':
                        self.array = True
                        self.old_array = mod
                    if mod.type == 'CURVE':
                        self.curve = True
                        self.old_curve = mod

        # Start and End
        for o in sel:
            o.select_set(state=True)
            bpy.context.view_layer.objects.active = o
            if o.name.startswith("start"):
                start = True
                self.mesh_start = context.active_object
                self.mesh_start.select_set(state=False)

        for x in sel:
            x.select_set(state=True)
            bpy.context.view_layer.objects.active = x
            if x.name.startswith("end"):
                end = True
                self.mesh_end = context.active_object


        for b in sel:
            if b.name.startswith("end"):
                self.mesh_end.select_set(state=False)



        base = context.active_object

        if len([o for o in context.selected_objects]) == 1:
            base = context.active_object
            start = False
            end = False

        bpy.ops.object.duplicate_move()
        bpy.ops.object.location_clear(clear_delta=False)



        sel.append(act_obj)


        bpy.ops.curve.primitive_bezier_curve_add(radius=1, enter_editmode=False, location=(0, 0, 0))
        bpy.ops.object.mode_set(mode='EDIT')
        bpy.ops.curve.delete(type='VERT')
        bpy.ops.object.mode_set(mode='OBJECT')
        bpy.ops.object.transform_apply(location=True, rotation=True, scale=True)
        bpy.ops.object.mode_set(mode='EDIT')
        curve = bpy.context.active_object
        curve.data.bevel_resolution = 2
        bpy.context.space_data.overlay.show_curve_normals = True
        bpy.context.space_data.overlay.show_curve_normals = False
        bpy.ops.object.mode_set(mode='OBJECT')

        bpy.ops.object.select_all(action='DESELECT')

        base.select_set(state=True)
        bpy.context.view_layer.objects.active = base



        if self.array and self.curve:
            self.old_array.curve = curve
            self.old_curve.object = curve

        else:
            new_array = base.modifiers.new("Array", 'ARRAY')
            new_array.relative_offset_displace[0] = 0
            new_array.relative_offset_displace[2] = 1
            new_array.fit_type = 'FIT_CURVE'
            new_array.curve = curve
            new_array.use_merge_vertices = True

            new_curve = base.modifiers.new("Curve", 'CURVE')
            new_curve.deform_axis = 'POS_Z'
            new_curve.object = curve

            if start:
                new_array.start_cap = self.mesh_start
            if end:
                new_array.end_cap = self.mesh_end

        bpy.ops.object.select_all(action='DESELECT')

        curve.select_set(state=True)
        bpy.context.view_layer.objects.active = curve
        bpy.ops.object.mode_set(mode='EDIT')

    # ----------------------------------------------------------------------------------------------
    #
    # ----------------------------------------------------------------------------------------------

    def create_curve(self, profile):
        bpy.ops.object.select_all(action='DESELECT')
        bpy.ops.curve.primitive_bezier_curve_add(radius=1, enter_editmode=False, location=(0, 0, 0))
        bpy.ops.object.mode_set(mode='EDIT')
        bpy.ops.curve.delete(type='VERT')
        bpy.ops.object.mode_set(mode='OBJECT')
        bpy.ops.object.transform_apply(location=True, rotation=True, scale=True)
        bpy.ops.object.mode_set(mode='EDIT')
        self.curve = bpy.context.active_object
        bpy.context.space_data.overlay.show_curve_normals = False
        self.curve.data.fill_mode = 'FULL'
        self.curve.data.bevel_depth = 0.2
        self.curve.data.bevel_resolution = 2
        self.curve.data.use_fill_caps = False
        bpy.context.space_data.overlay.show_curve_normals = True
        bpy.context.space_data.overlay.show_curve_normals = False

        if profile:
            self.curve.data.bevel_object = profile

        return self.curve

# ----------------------------------------------------------------------------------------------
#
# ----------------------------------------------------------------------------------------------

    def apply_tubify(self, context):
        self.extrude = act_obj = context.active_object.data.extrude
        self.profile = act_obj = context.active_object.data.bevel_object
        self.taper = act_obj = context.active_object.data.taper_object

        for obj in self.same_modifs.keys():
            with set_and_restore_active(context, obj):


                if self.profile:
                    bpy.ops.object.mode_set(mode='OBJECT')
                    bpy.ops.object.convert(target='MESH')
                else:
                    if obj.data.extrude > 0:
                        self.extrude = True

                    bpy.ops.object.mode_set(mode='OBJECT')
                    bpy.ops.object.convert(target='MESH')

                    # remove double
                    if self.extrude:
                        bpy.ops.object.mode_set(mode='EDIT')
                        bpy.ops.mesh.select_all(action='SELECT')
                        bpy.ops.mesh.remove_doubles(threshold=0.001)
                        bpy.ops.object.mode_set(mode='OBJECT')

                # bpy.context.scene.objects.active = self.act_obj



# ----------------------------------------------------------------------------------------------
#
# ----------------------------------------------------------------------------------------------

    def toggle_bezier_poly(self, context):

        bpy.ops.object.select_all(action='DESELECT')
        for obj in self.sel:
            context.view_layer.objects.active = obj
            obj.select_set(state=True)
            bpy.ops.object.mode_set(mode='EDIT')
            bpy.ops.curve.select_all(action='SELECT')

            if obj.data.splines[0].type == 'BEZIER':
                bpy.ops.curve.spline_type_set(type='POLY')
            else:
                bpy.ops.curve.spline_type_set(type='BEZIER')
                bpy.ops.curve.handle_type_set(type='AUTOMATIC')

            bpy.ops.object.mode_set(mode='OBJECT')

        context.view_layer.objects.active = self.act_obj
        self.act_obj.select_set(state=True)
# ----------------------------------------------------------------------------------------------
#
# ----------------------------------------------------------------------------------------------

    def remove_tubify(self, context):
        for obj in self.same_modifs.keys():
            obj.data.resolution_u = \
            obj.data.bevel_resolution = \
            obj.data.extrude = \
            obj.data.bevel_depth = \
            obj.data.offset = 0
            obj.data.bevel_object = None
            obj.data.taper_object = None

# ----------------------------------------------------------------------------------------------
#
# ----------------------------------------------------------------------------------------------

    def convert_as_curve(self):
        sel = bpy.context.selected_objects[:]

        for obj in sel:

            if obj.mode == "OBJECT":
                bpy.ops.object.duplicate_move()

                prefix = obj.name
                obj = bpy.context.active_object
                obj.name = prefix + " - tubify"

                # Remove modifiers
                if obj.modifiers:
                    for mod in obj.modifiers:
                        bpy.ops.object.modifier_apply(apply_as = 'DATA', modifier = mod.name)

                bpy.ops.object.mode_set(mode='EDIT')
                bpy.ops.mesh.select_all(action='SELECT')
                bpy.ops.mesh.delete(type='ONLY_FACE')

            elif obj.mode == "EDIT":

                me = obj.data
                bm = bmesh.from_edit_mesh(me)

                bpy.ops.mesh.select_mode(use_extend=False, use_expand=False, type='EDGE')

                if any([e.select for e in bm.edges]):
                    bpy.ops.object.mode_set(mode='OBJECT')
                    bpy.ops.object.select_all(action='DESELECT')
                    obj.select_set(state=True)
                    bpy.ops.object.duplicate_move()
                    prefix = obj.name
                    obj = bpy.context.active_object
                    obj.name = prefix + " - tubify"

                    # Remove modifiers
                    if obj.modifiers:
                        for mod in obj.modifiers:
                            obj.modifiers.remove(mod)

                    bpy.ops.object.mode_set(mode='EDIT')

                    bpy.ops.mesh.select_all(action='INVERT')
                    bpy.ops.mesh.delete(type='EDGE')
                    bpy.ops.mesh.select_all(action='SELECT')

                    bpy.ops.mesh.delete(type='ONLY_FACE')

            bpy.ops.object.mode_set(mode='OBJECT')
            bpy.ops.object.convert(target='CURVE')
            bpy.ops.object.mode_set(mode='EDIT')
            bpy.ops.curve.select_all(action='SELECT')
            bpy.ops.curve.spline_type_set(type='BEZIER')
            bpy.ops.curve.handle_type_set(type='AUTOMATIC')
            bpy.ops.object.mode_set(mode='OBJECT')

            if self.prefs.show_wire_in_modal:
                obj.show_wire = True

            self.from_mesh = True

            res = []
            res.append(bpy.context.active_object)

            # for obj in res:
            #     bpy.context.view_layer.objects.active = obj
            #     obj.select_set(state=True)

            return res

    # ----------------------------------------------------------------------------------------------
    #
    # ----------------------------------------------------------------------------------------------

    def deselect_curve(self, context, obj):

        # si plusieurs objets et l'acto est courbe on draw avec les objets
        if len([o for o in context.selected_objects if obj.type == 'CURVE']) > 1:
            bpy.ops.object.mode_set(mode='OBJECT')
            obj.select_set(state=False)

            del (store_meshes[:])

        for obj in context.selected_objects:
            store_meshes.append(obj)
            bpy.context.view_layer.objects.active = obj
            obj.select_set(state=True)

    # ----------------------------------------------------------------------------------------------
    #
    # ----------------------------------------------------------------------------------------------
    def create_square(self, context):
        bpy.ops.mesh.primitive_plane_add(size=1, enter_editmode=True, location=(0, 0, 0))
        bpy.ops.mesh.delete(type='ONLY_FACE')
        bpy.ops.object.mode_set(mode='OBJECT')
        bpy.ops.object.convert(target='CURVE')
        bpy.ops.object.mode_set(mode='EDIT')
        bpy.ops.curve.switch_direction()
        bpy.ops.object.mode_set(mode='OBJECT')
        self.square = context.active_object
        self.square.name = "Profile_Square"
        bpy.ops.object.select_all(action='DESELECT')
        self.act_obj.select_set(state=True)
        bpy.context.view_layer.objects.active = self.act_obj

        return self.square
# ----------------------------------------------------------------------------------------------
# OVERRIDE - NE PAS EFFACER
# ----------------------------------------------------------------------------------------------

    def store_init_value(self, event, action, index=None):
        """ Store initial value when starting mouse_action
        Override this method when attributes are not all from modifier
        :param event: modal event
        :param action: action name, modifier parameter name
        :param index: index of iterable properties
        :return:
        """
        value = self.get_property_value(self.act_obj.data, action, index)
        self.last_value = value
        self.init_value = value
        self.mouse_x = event.mouse_x
        self.wheel_delta = 0

    # ----------------------------------------------------------------------------------------------
    #
    # ----------------------------------------------------------------------------------------------

    def modal(self, context, event):
        # print("modal", event)

        context.area.tag_redraw()

        modal_action = self.modal_action
        act_obj = self.act_obj
        act_data = self.act_obj.data

        if modal_action == 'free':
            if event.type in {'NUMPAD_1','NUMPAD_3','NUMPAD_7','NUMPAD_5'} or event.ctrl and event.type in {'NUMPAD_1','NUMPAD_3','NUMPAD_7','NUMPAD_5'}:
                return {'PASS_THROUGH'}

        if event.alt:
            return {'PASS_THROUGH'}

        if modal_action == 'free':
            if event.alt and event.type in {'LEFTMOUSE','RIGHTMOUSE','MIDDLEMOUSE'}:
                return {'PASS_THROUGH'}


        if event.type in { 'A', 'B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T',
                           'U','V','W','X','Y','Z' 'SHIFT', 'LEFTMOUSE', 'RIGHTMOUSE','CTRL','ALT', 'ONE', 'TWO'
                           'SLASH'} and act_obj.mode == 'EDIT':
            return {'PASS_THROUGH'}


        if event.type == 'TAB' and event.ctrl and event.value == 'PRESS':
            bpy.ops.wm.tool_set_by_id('INVOKE_DEFAULT',name="builtin.draw", cycle=False, space_type='VIEW_3D')
            bpy.ops.wm.tool_set_by_id('INVOKE_DEFAULT',name="builtin.draw", cycle=False, space_type='VIEW_3D')
            obj_mode = any([obj.mode == 'OBJECT' for obj in self.sel])
            if obj_mode:
                bpy.ops.object.mode_set(mode='EDIT')
                if self.act_obj.type == 'MESH':
                    context.scene.tool_settings.use_mesh_automerge = False
            else:
                bpy.ops.object.mode_set(mode='OBJECT')
                return {'RUNNING_MODAL'}
            self.mode = self.act_obj.mode

        elif event.type == 'TAB' and event.value == 'PRESS':
            bpy.ops.wm.tool_set_by_id('INVOKE_DEFAULT',name="builtin.select", cycle=False, space_type='VIEW_3D')
            bpy.ops.wm.tool_set_by_id('INVOKE_DEFAULT',name="builtin.select", cycle=False, space_type='VIEW_3D')
            # bpy.ops.wm.tool_set_by_id(name="builtin.draw", cycle=False, space_type='VIEW_3D')
            obj_mode = any([obj.mode == 'OBJECT' for obj in self.sel])
            if obj_mode:
                bpy.ops.object.mode_set(mode='EDIT')
                if self.act_obj.type == 'MESH':
                    context.scene.tool_settings.use_mesh_automerge = False
            else:
                bpy.ops.object.mode_set(mode='OBJECT')
                return {'RUNNING_MODAL'}
            self.mode = self.act_obj.mode



        # pass through events
        if event.type == 'MIDDLEMOUSE' or (
                # allow zoom in free mode and for pen mode
                (modal_action == 'free' or self.work_tool != 'mouse') and
                event.type in {'WHEELUPMOUSE', 'WHEELDOWNMOUSE'}):
            return {'PASS_THROUGH'}

        # event ctrl/shift/alt state last time a key was pressed
        event_alt = self.event_alt

        # ---------------------------------
        # Mouse actions
        # ---------------------------------

        if modal_action in self.mouse_actions.values():

            if event.unicode in self.input_list:
                self.get_input_value(event.unicode)
                # No need to go further
                return {'RUNNING_MODAL'}

            # mouse action enabled
            if event.type in {'LEFT_SHIFT', 'RIGHT_SHIFT'}:

                # Sauve la dernière valeur pour modifier les steps
                value = self.get_property_value(act_data, modal_action, index=None)
                # print("Store", value)

                # disallow slow_down for integer values
                slow_down = type(value).__name__ != 'int'

                if slow_down:
                    if event.value == 'PRESS':
                        if not self.slow_down:
                            self.mouse_x = event.mouse_x
                            self.last_value = value
                            self.slow_down = True

                    elif event.value == 'RELEASE':
                        self.mouse_x = event.mouse_x
                        self.last_value = value
                        self.slow_down = False

            if event.type in {'MOUSEMOVE', 'WHEELUPMOUSE', 'WHEELDOWNMOUSE'}:
                # print("mouveeeeeeee")
                if event.type == 'MOUSEMOVE':

                    # prevent mouse move in 'mouse' mode (we could allow mouse in both modes)
                    if self.work_tool == 'mouse':
                        return {'PASS_THROUGH'}

                    # relative diff between last action and current
                    delta = event.mouse_x - self.mouse_x

                else:

                    # absolute delta for this step
                    wheel_delta = 1
                    if event.type == 'WHEELDOWNMOUSE':
                        wheel_delta = -wheel_delta

                    # relative diff between last action and current
                    self.wheel_delta += wheel_delta

                    delta = self.wheel_delta * 40 * self.modal_speed

                if self.slow_down:
                    delta /= 8
                # print("Delta:", delta)

                pixels = self.get_pixels_from_rna(act_data, modal_action)
                # limit to min / max for property


                if modal_action in {'bevel_factor_start', 'bevel_factor_end'}:
                    value = self.limit_value(self.last_value + delta / 100 / pixels, act_data, modal_action )

                elif modal_action == 'bevel_depth':
                        value = min(10000, max(0.001, self.limit_value(self.last_value + delta / pixels * 4, self.act_mod,
                                                                modal_action)))
                else:
                    value = self.limit_value(self.last_value + delta / pixels, act_data, modal_action)

                if act_data.bevel_object is not None and modal_action == 'bevel_depth':
                    profile_scale = act_data.bevel_object.scale
                    for i in range(3):
                        act_data.bevel_object.scale[i] = profile_scale[i] * (float(value) / profile_scale[i])

                if act_data.bevel_object is not None and modal_action == 'bevel_resolution':
                    act_data.bevel_object.data.resolution_u = value

                self.set_same_objects_data_value(modal_action, value)

                if modal_action == 'resolution_u':
                    self.set_same_objects_data_value("render_resolution_u", value)

        # ---------------------------------
        # Objects picking
        # ---------------------------------

        if modal_action in self.pick_actions[event_alt].values():

            bpy.ops.wm.tool_set_by_id(name="builtin.select", cycle=False, space_type='VIEW_3D')

            if event.type == self.key_select:

                if event.value == 'PRESS':
                    # allow to pick objects by selecting through regular blender select key
                    return {'PASS_THROUGH'}

                # Use RELEASE event to get selected object
                # Unlike ray cast method we are able to select curves too !!
                if event.value == 'RELEASE':
                    obj = context.active_object

                    if obj is not None:
                        obj.select_set(state=False)
                        context.view_layer.objects.active = self.act_obj

                    if obj != self.act_obj:
                        # filter obj by type and action to avoid errors on set ?
                        # self.set_same_modifiers_value(modal_action, obj)
                        self.set_same_objects_data_value(modal_action, obj)
                        self.modal_action = 'free'

                act_obj.select_set(state=True)

            if event.type == 'MOUSEMOVE':
                return {'PASS_THROUGH'}
        # ---------------------------------
        # Select another object while modal running
        # ---------------------------------
        # event_alt = (event.ctrl, event.shift, event.alt)
        #
        # if modal_action == "free" and event.type == self.key_select and any(event_alt):
        #     if event.shift:
        #         return self.copy_modifier_if_missing(context, event, types={'MESH'})
        #     elif event.ctrl:
        #         return self.remove_same_modifier(context, event)
        #     else:
        #         action = 'free'
        #         return self.run_modal_with_another_object(context, event, action, types={'MESH'})

        # ---------------------------------
        # Keyboard events, check PRESS state once
        # ---------------------------------

        if event.value == 'PRESS':

            # Store event alternatives
            self.event_alt = event_alt = (event.ctrl, event.shift, event.alt)

            # set default value for action
            action = 'free'

            # ---------------------------------
            # Step 1 : Process events : turn events into actions
            # ---------------------------------

            # ---------------------------------
            # Mouse actions (startup - store current values)
            # ---------------------------------

            if event.type in self.mouse_actions.keys() and not self.input:

                # Mouse actions
                action = self.mouse_actions[event.type]
                self.store_init_value(event, action)

                # next modal run will handle this action so store action name
                self.modal_action = action

                return {'RUNNING_MODAL'}



            # ---------------------------------
            # Pick / Remove Objects
            # ---------------------------------

            elif event.type in self.pick_actions[event_alt].keys():
                action = self.pick_actions[event_alt][event.type]
                if self.get_property_value(act_data, action) is not None:
                    self.set_same_objects_data_value(action, None)
                else:
                    # next modal run will handle this action so store action
                    self.modal_action = action
                # No need to process action

                return {'RUNNING_MODAL'}

            # ---------------------------------
            # Default actions
            # ---------------------------------

            elif event.type in self.default_actions[event_alt].keys():
                action = self.default_actions[event_alt][event.type]
                # let process actions below once

            # ---------------------------------
            # Special actions
            # ---------------------------------

            elif event.type in self.special_actions[event_alt].keys():
                action = self.special_actions[event_alt][event.type]
                # let process actions below once

            elif event.type == 'BACK_SPACE' and self.input:
                self.input = self.input[:-1]
                # No need to process action
                return {'RUNNING_MODAL'}

            # ---------------------------------
            # Toggle actions
            # ---------------------------------

            elif event.type in self.toggle_actions[event_alt].keys():
                action = self.toggle_actions[event_alt][event.type]
                self.toggle_same_objects_data_value(act_obj, action)
                # No need to process action
                return {'RUNNING_MODAL'}

            # ---------------------------------
            # Step 2 : Process actions
            # ---------------------------------

            # ---------------------------------
            # Confirm (Generic)
            # ---------------------------------

            if action == 'confirm':

                if self.input:

                    value = self.input_as_value(act_obj, modal_action)
                    self.set_same_objects_data_value(modal_action, value)

                    self.input = ""

                if modal_action == 'free':
                    self.exit(context)
                    return {'FINISHED'}

                self.modal_action = 'free'

            # ---------------------------------
            # Cancel (Generic)
            # ---------------------------------

            elif action == 'cancel':

                if self.input:
                    self.input = ""

                if modal_action in self.mouse_actions.values():
                    self.set_same_objects_data_value(modal_action, self.init_value)

                if modal_action == 'free':
                    self.exit(context)
                    return {'CANCELLED'}

                self.modal_action = 'free'

            # ---------------------------------
            # Apply Modifier
            # ---------------------------------

            elif action == 'apply_modifier':

                self.apply_tubify(context)

                if len(act_obj.modifiers) > 0:
                    mod = act_obj.modifiers[-1]
                    if self.run_modal(act_obj, mod, modal_action='free', call_from_pie=False):
                        self.exit(context)

                return {'FINISHED'}

            # ---------------------------------
            # Remove Modifier (Generic)
            # ---------------------------------

            elif action == 'remove_modifier':

                self.remove_tubify(context)

                # next = self.next_supported_modifier(act_obj, self.act_mod)
                # next = self.next_supported_modifier_down(act_obj, self.act_mod)

                # self.run_modal(act_obj, next)
                self.exit(context)
                return {'FINISHED'}

            # ---------------------------------
            # Switch Between modifiers (Generic)
            # ---------------------------------

            elif action == 'next_modifier_up':
                res = self.run_modal_up(act_obj, self.act_mod)
                if res:
                    self.exit(context)
                    return {'FINISHED'}

            elif action == 'next_modifier_down':
                res = self.run_modal_down(act_obj, self.act_mod)
                if res:
                    self.exit(context)
                    return {'FINISHED'}


            # ---------------------------------
            # Call pie menu (Generic)
            # ---------------------------------

            elif action == 'call_pie':
                self.exit(context)
                if self.prefs.choose_menu_type == 'pie':
                    bpy.ops.wm.call_menu_pie('INVOKE_DEFAULT', name="SPEEDFLOW_MT_pie_menu")
                else:
                    bpy.ops.wm.call_menu('INVOKE_DEFAULT', name="SPEEDFLOW_MT_simple_menu")
                return {'FINISHED'}

            # ---------------------------------
            # Toggle Keymaps (Generic)
            # ---------------------------------

            elif action == 'show_hide_keymap':
                self.prefs.display_keymaps = not self.prefs.display_keymaps

            # ---------------------------------
            # SHIFT + H Toggle Beginner Mode
            # ---------------------------------
            elif action == 'beginner_mode':
                self.prefs.beginner_mode = not self.prefs.beginner_mode

            # -------------------------------------
            # Toggle Show / Hide Modifier (Generic)
            # -------------------------------------

            # elif action == 'show_viewport':
            #     # same modifiers
            #
            #     self.toggle_same_modifiers_value('show_viewport')

# ---------------------------------
# Special actions
# ---------------------------------
            elif action == 'square':
                profile = context.object.data.bevel_object
                self.create_square(context)
                print(profile)
                for obj in self.sel:
                    # if profile is None:
                    obj.data.bevel_object = self.square

                    # elif profile is not None:
                    #     if not profile.name.startswith("Profile_square"):
                    #         obj.data.bevel_object = self.square
                    #     else:
                    #         obj.data.bevel_object = profile



            # ---------------------------------
            # Toggle local view in Modal
            # ---------------------------------
            elif action == 'localview':
                bpy.ops.view3d.localview()

            # ---------------------------------
            # Toggle Hide all modifiers
            # ---------------------------------
            elif action == 'show_hide_all_modifiers':
                self.show_hide_all_modifiers(act_obj, self.act_mod)

            # ---------------------------------
            # Change Fill Mode
            # ---------------------------------
            elif action == 'fill_mode':
                value = self.get_next_enum(act_data, action)
                self.set_same_objects_data_value(action, value)

            # ---------------------------------
            # Use Cyclic Mode
            # ---------------------------------

            elif action == 'use_cyclic_u':
                for obj in context.selected_objects:
                    obj.data.splines[0].use_cyclic_u = False if obj.data.splines[0].use_cyclic_u else True

            # ---------------------------------
            # Poly / Bezier Mode
            # ---------------------------------

            elif action == 'poly_bezier':
                self.toggle_bezier_poly(context)

            # ---------------------------------
            # Use Smooth
            # ---------------------------------

            elif action == 'use_smooth':
                for obj in context.selected_objects:
                    obj.data.splines[0].use_smooth = False if obj.data.splines[0].use_smooth else True

            # ---------------------------------
            # Use Fill Cap
            # ---------------------------------

            elif action == 'use_fill_caps':
                for obj in context.selected_objects:
                    obj.data.use_fill_caps = False if obj.data.use_fill_caps else True

            # ---------------------------------
            # Use Fill Cap
            # ---------------------------------

            elif action == 'switch_direction':
                # for obj in context.selected_objects:
                bpy.ops.object.mode_set(mode='EDIT')
                bpy.ops.curve.switch_direction()
                bpy.ops.object.mode_set(mode='OBJECT')

            # ---------------------------------
            # Show modifiers
            # ---------------------------------
            elif action == 'show_modifier':
                for obj in context.selected_objects:
                    to_show = self.get_first_modifier_by_dict(obj, {'show_viewport' : False})
                    if to_show is not None:
                        to_show.show_viewport = True

            # ---------------------------------
            # Hide modifiers
            # ---------------------------------
            elif action == 'hide_modifier':
                for obj in context.selected_objects:
                    to_show = self.get_last_modifier_by_dict(obj, {'show_viewport' : True})
                    if to_show is not None:
                        to_show.show_viewport = False




            # # ---------------------------------
            # # Add/Edit Empty as Ref Object
            # # ---------------------------------
            #
            # elif action == 'bevel_object':
            #     bevel_obj = act_data.data.bevel_object
            #
            #     if bevel_obj is None:
            #         bpy.ops.object.empty_add(type='PLAIN_AXES', align='WORLD')
            #         obj = context.active_object
            #         obj.name = "Mirror_Ref_Object"
            #         if self.acto_rot:
            #             context.active_object.rotation_euler = self.act_obj_rot
            #
            #         # obj = self.create_empty(context, "Mirror_Object")
            #
            #     # ajoute l'empty en ref
            #     # print(self.act_mod.name)
            #     self.set_same_modifiers_value("mirror_object", obj)


    # ---------------------------------
    # Shading / Snap
    # ---------------------------------

            # ---------------------------------------
            # 1 - Toggle Keep Wire in Modal
            # ---------------------------------------
            elif action == 'keep_wire':
                self.prefs.keep_wire = not self.prefs.keep_wire

            # --------------------------------------
            # 2 - Toggle wire in the modal
            # --------------------------------------
            elif action == 'show_wire_in_modal':
                self.shading_wire_in_modal(context, self)

            # ---------------------------------
            # 3 - Toggle XRAY
            # ---------------------------------
            elif action == 'set_xray':
                self.shading_xray(context, self)

            # ---------------------------------
            # 4 - Toggle shading mode type
            # ---------------------------------
            elif action == 'shading_mode':
                self.shading_mode_type(context, self)

            # ---------------------------------
            # 5 - Toggle Random Mode
            # ---------------------------------
            elif action == 'random':
                self.shading_random_mode(context, self)

            # ---------------------------------
            # 6 - Toggle OVERLAYS
            # ---------------------------------
            elif action == 'overlays':
                self.shading_overlays(context, self)

            # ---------------------------------
            # 7 - Toggle FACE ORIENTATION
            # ---------------------------------
            elif action == 'face_orientation':
                self.shading_face_orientation(context, self)

            # ---------------------------------
            # 8 - Toggle Hide Grid
            # ---------------------------------
            elif action == 'hide_grid':
                self.shading_hide_grid(context, self)

            # ---------------------------------
            # 9 - Toggle Bool Shading Mode
            # ---------------------------------
            elif action == 'bool_mode':
                self.shading_bool_mode(context, self)

            # ---------------------------------
            # F2 - Toggle Activate Snap
            # ---------------------------------
            elif action == 'active_snap':
                self.snap_activate_snap(context, self)

            # ---------------------------------
            # F3 - Toggle Snap Vertex
            # ---------------------------------
            elif action == 'snap_vertex':
                self.snap_vertex(context, self)

            # ---------------------------------
            # F4 - Toggle Snap Face
            # ---------------------------------
            elif action == 'snap_face':
                self.snap_face(context, self)

            # ---------------------------------
            # F5 - Toggle Snap Grid
            # ---------------------------------
            elif action == 'snap_grid':
                self.snap_grid(context, self)

            # ---------------------------------
            # F6 - Origin to selection
            # ---------------------------------
            elif action == 'origin_to_selection':
                self.snap_origin_to_selection(context)

            # ---------------------------------
            # F7 - Toggle Apply Origin
            # ---------------------------------
            elif action == 'apply_location':
                self.snap_origin_to_grid(context)

            # ---------------------------------
            # START Origin
            # ---------------------------------
            if action == 'set_origin':
                # self.act_mod.show_viewport = False

                bpy.ops.wm.tool_set_by_id(name="builtin.select", cycle=False, space_type='VIEW_3D')

                self.mode_snap = self.act_obj.mode
                context.scene.tool_settings.use_snap = True
                # context.scene.tool_settings.snap_elements = {'VERTEX'}
                context.scene.tool_settings.use_snap_align_rotation = False

                bpy.ops.view3d.snap_cursor_to_selected()

                if act_obj.mode != 'OBJECT':
                    bpy.ops.object.mode_set(mode='OBJECT')

                bpy.ops.transform.translate('INVOKE_DEFAULT', cursor_transform=True)

                self.modal_action = 'origin'

            if action == 'set_origin_1':
                # self.act_mod.show_viewport = False

                self.mode_snap = self.act_obj.mode
                context.scene.tool_settings.use_snap = True
                context.scene.tool_settings.snap_elements = {'INCREMENT'}
                context.scene.tool_settings.use_snap_grid_absolute = True

                bpy.ops.view3d.snap_cursor_to_selected()

                if act_obj.mode != 'OBJECT':
                    bpy.ops.object.mode_set(mode='OBJECT')

                bpy.ops.transform.translate('INVOKE_DEFAULT', cursor_transform=True)

                self.modal_action = 'origin'

            # ---------------------------------
            # END ORIGIN
            # ---------------------------------
            if modal_action == 'origin':
                bpy.ops.object.origin_set(type='ORIGIN_CURSOR')
                # self.act_mod.show_viewport = True

                bpy.ops.object.mode_set(mode=self.mode_snap)
                self.modal_action = 'free'

        return {'RUNNING_MODAL'}

    # ----------------------------------------------------------------------------------------------
    #
    # ----------------------------------------------------------------------------------------------

    def invoke(self, context, event):

        if context.area and context.area.type == 'VIEW_3D':
            bpy.ops.wm.tool_set_by_id(name="builtin.select", cycle=False, space_type='VIEW_3D')
            # Get modifier type from modal class name
            mod_type = self.mod_type

            # retrieve addon prefs
            prefs = self.prefs

            act_obj = context.object

            # filter objects from selection, act_obj is part of sel
            sel = self.filter_objects_by_type(context.selected_objects, {'MESH', 'CURVE'})

            self.screw = False
            self.from_mesh = False  # check si on part d'un mesh
            self.profile = None  # check si courbe selected
            self.taper = None
            self.mesh_stored = None
            # store context mode, selected and active
            if act_obj:
                self.mode = act_obj.mode
                self.screw = self.get_modifiers_by_type(act_obj, 'SCREW')

            self.act_obj = act_obj
            self.sel = sel
            self.shading_viewport_type = context.space_data.shading.type
            self.overlay_state = context.space_data.overlay.show_overlays
            self.overlay_wire_state = context.space_data.overlay.show_wireframes

            # if act_obj and act_obj.mode != 'OBJECT':
            #     bpy.ops.object.mode_set(mode="OBJECT")


            # flag indicate call method, through pie menu or object selection change or <-> with specified modifier
            call_through_pie = self.call_from_pie
            # flag when call through selection change using alt key, prevent special actions
            allow_special_actions = True

            # Find if we do have a modifier of this modal type
            has_mod = True





            if has_mod and call_through_pie and self.work_tool == 'pen' and prefs.default_modal_action:
                self.modal_action = 'free'


            global last_selection
            global last_profile
            global store_mesh




            # IF CONTEXT OBJECT IS NONE > CURVE
            if context.object is None:
                if bpy.context.object:
                    bpy.ops.object.mode_set(mode='OBJECT')
                    bpy.ops.object.select_all(action='DESELECT')

                del (sel[:])
                self.profile = False
                self.create_curve(self.profile)
                bpy.ops.wm.tool_set_by_id(name="builtin.draw", cycle=False, space_type='VIEW_3D')

                bpy.ops.curve.draw('INVOKE_DEFAULT')
                return {'FINISHED'}

            # CURVE ET PROFILE
            elif event.shift :


                if len([obj for obj in context.selected_objects if obj.type == 'CURVE']) == 1:


                    self.profile = True
                    self.profile = act_obj
                    self.create_curve(self.profile)
                    bpy.ops.wm.tool_set_by_id(name="builtin.draw", cycle=False, space_type='VIEW_3D')
                    bpy.ops.curve.draw('INVOKE_DEFAULT')
                    return {'FINISHED'}

                elif len([obj for obj in context.selected_objects if obj.type == 'CURVE']) == 2:

                    self.profile = True

                    # if act_obj.data.splines[0].use_cyclic_u == True:
                    #     self.profile = act_obj
                    # elif


                    # for obj in context.selected_objects:
                    #     if any([obj.data.splines[0].use_cyclic_u]) == True:
                    #         self.taper = True
                    #         self.curve_taper = obj
                    #         obj.select_set(state=False)
                    #
                    #
                    # for obj in context.selected_objects:
                    #     context.view_layer.objects.active = obj


                    self.profile = act_obj
                    self.create_curve(self.profile)
                    bpy.ops.wm.tool_set_by_id(name="builtin.draw", cycle=False, space_type='VIEW_3D')
                    bpy.ops.curve.draw('INVOKE_DEFAULT')
                    return {'FINISHED'}

                else:
                    if bpy.context.object:
                        bpy.ops.object.mode_set(mode='OBJECT')
                        bpy.ops.object.select_all(action='DESELECT')

                    del (sel[:])
                    self.profile = False
                    self.create_curve(self.profile)
                    bpy.ops.wm.tool_set_by_id(name="builtin.draw", cycle=False, space_type='VIEW_3D')

                    bpy.ops.curve.draw('INVOKE_DEFAULT')
                    return {'FINISHED'}

            # CURVE ET EDIT
            elif act_obj.type == 'CURVE' and not self.screw and last_selection is None:
                    last_selection = ""
                    self.sel = self.filter_objects_by_type(context.selected_objects, {'CURVE'})
                    act_obj = self.act_obj = self.sel[0]
                    bpy.context.view_layer.objects.active = act_obj

                    for obj in self.sel:
                        if act_obj.data.bevel_depth and act_obj.data.extrude == 0:
                            self.setup_object_data_from_prefs(obj, mod_type)
                            if self.from_mesh:
                                obj.data.resolution_u = 1


            # MESH ET CONVERT
            elif act_obj and act_obj.type == 'MESH' and not event.ctrl and not event.alt and not event.shift:

                # if store_mesh:
                #     print(store_mesh)
                #
                #     # On convertis et on deselectionns
                #     self.sel = self.convert_as_curve()
                #     bpy.ops.view3d.snap_cursor_to_selected()
                #     curve = context.object
                #     curve.select_set(state = False)
                #
                #     # On recup le mesh store pour le dupliquer
                #     # et ajouter des modifierset la courbe
                #     act_obj = context.scene.objects.get(store_mesh)
                #     if act_obj:
                #         bpy.context.view_layer.objects.active = act_obj
                #         act_obj.select_set(state=True)
                #
                #         self.array_curve_from_stored_mesh(context, curve, act_obj)
                #     return {'FINISHED'}
                #
                # else:
            # elif act_obj.mode == 'EDIT':
                self.sel = self.convert_as_curve()
                act_obj = self.act_obj = self.sel[0]
                bpy.context.view_layer.objects.active = act_obj

                for obj in self.sel:
                    if act_obj.data.bevel_depth and act_obj.data.extrude == 0:
                        self.setup_object_data_from_prefs(obj, mod_type)
                        if self.from_mesh:
                            obj.data.resolution_u = 1
                            if self.prefs.shading_smooth:
                                obj.data.splines[0].use_smooth = True


            elif event.ctrl:

                if len([o for o in context.selected_objects if o.type == 'CURVE' and not self.screw]) >= 2:
                    bpy.ops.object.mode_set(mode='OBJECT')
                    self.add_curve(context)

                elif act_obj.type == 'CURVE' and act_obj.mode == 'EDIT':
                    bpy.ops.object.mode_set(mode='OBJECT')
                    bpy.ops.object.select_all(action='DESELECT')
                    self.array_curve_from_draw(context)

                elif not (act_obj.type == 'MESH' or (act_obj.type == 'CURVE' and self.screw)):
                    act_obj = context.scene.objects.get(last_selection)
                    self.array_curve_from_draw(context)


                elif act_obj:
                    bpy.context.view_layer.objects.active = act_obj
                    act_obj.select_set(state=True)
                    self.array_curve_from_draw(context)


                bpy.ops.wm.tool_set_by_id(name="builtin.select", cycle=False, space_type='VIEW_3D')
                bpy.ops.curve.draw('INVOKE_DEFAULT')
                return {'FINISHED'}

            elif event.alt:
                store_mesh = act_obj.name
                self.report({'WARNING'}, "Mesh Stored, good luck!")

            elif event.ctrl and event.alt:
                store_mesh = ""
                self.report({'WARNING'}, "Mesh Stored Removed!")


            for obj in context.selected_objects:
                if obj.type == 'CURVE':
                    self.curve = obj
                    if self.prefs.shading_smooth:
                        self.curve.data.splines[0].use_smooth = True

            bpy.ops.object.mode_set(mode='OBJECT')


            if self.prefs.default_modal_action:
                self.modal_action = 'free'
            else:
                if act_obj.data.bevel_depth > 0:
                    self.modal_action = 'bevel_depth'
                elif act_obj.data.extrude > 0:
                    self.modal_action = 'extrude'
                else:
                    self.modal_action = 'free'


            # store initial value for mouse action to restore on exit and last to change mouse steps on the fly
            if self.modal_action in self.mouse_actions.values():
                self.store_init_value(event, self.modal_action)

            self.same_modifs = {o : o for o in context.selected_objects}

            # Setup display of objects
            display_type = None
            if prefs.show_wire_in_modal and act_obj.display_type == 'BOUNDS':
                display_type = 'WIRE'

            self.setup_display(display_type)

            # setup draw handler
            self.setup_draw_handler(context)

            context.window_manager.modal_handler_add(self)

            return {'RUNNING_MODAL'}

        else:
            self.report({'WARNING'}, "View3D not found, cannot run operator")
            return {'CANCELLED'}

def register():
    try:
        bpy.utils.register_class(SPEEDFLOW_OT_tubify)
    except:
        print("Tubify already registred")

def unregister():
    bpy.utils.unregister_class(SPEEDFLOW_OT_tubify)